//
// CMyBot.CPP
//
// A simple Battle.net greeter bot. He does nothing but sit in his home
// channel and greet people as they come in.
//
// by Scott Coleman 3/31/98
//
// - OK, now he does even less. I removed most of the handler code; put it
// back in if you want. Now, it prints incoming messages to the window.
#include <stdio.h>
#include <string.h>
#include <afx.h>
#include "pch.h"
#include "mybot.h"
#include <afxwin.h>
#include "winbotdoc.h"
#pragma hdrstop


/*****************************************************************************
*
* Virtual Event Handlers
*
******/
CMyBot::CMyBot(CDocument * pD)
{ 
	pDoc = pD; 
}

int CMyBot::OnTalk(char *szSpeaker, u_long uFlags, char *szEventText)
{	
	BnBot::OnTalk(szSpeaker, uFlags, szEventText);

	PutLine("%s: %s", szSpeaker, szEventText);

	return 1;
}

int CMyBot::OnInfo(char *szSpeaker, u_long uFlags, char *szEventText)
{
	BnBot::OnInfo(szSpeaker, uFlags, szEventText);

	PutLine("*** %s", szEventText);
	return 1;

}

int CMyBot::OnBroadcast(char *szSpeaker, u_long uFlags, char *szEventText)
{
	BnBot::OnInfo(szSpeaker, uFlags, szEventText);

	PutLine("*** %s", szEventText);
	return 1;

}

int CMyBot::OnWhisper(char *szSpeaker, u_long uFlags, char *szEventText)
{
	BnBot::OnWhisper(szSpeaker, uFlags, szEventText);
	PutLine("(whispered from) %s: %s", szSpeaker, szEventText);

	return 1;
}

int CMyBot::OnError(char *szSpeaker, u_long uFlags, char *szEventText)
{
	BnBot::OnError(szSpeaker, uFlags, szEventText);
	PutLine("*** ERROR: %s", szEventText);

	return 1;
}


int __cdecl CMyBot::PutLine(char *lpszFmt, ...) {
  char szOutStr[512];
  va_list argptr;

  va_start(argptr, lpszFmt);
  vsprintf(szOutStr, lpszFmt, argptr);
  va_end(argptr);

	((CWinbotDoc*)(pDoc))->PutLine(szOutStr);

  return 1;
}
