//
// BNBOT.H
//
// Virtual base class for Battle.net bots.
//
// by Scott Coleman 3/31/98
//

#ifndef _BNBOT_H_
#define _BNBOT_H_

extern const unsigned int SOCKET_MESSAGE;
#define MAXSTRINGLENGTH         128
#define MAXTEXTLENGTH           256
#define BUFSIZE         4096

class BnBot {
private:
  FILE *log;
	char m_stageBuf[BUFSIZE];
	int m_nBufLen;
	int m_nBufPos;

protected:
  int s;
  char szLoginName[MAXSTRINGLENGTH];
  char szUniqueName[MAXSTRINGLENGTH];
  char szPassword[MAXSTRINGLENGTH];
  char szServerAddr[MAXSTRINGLENGTH];
  char szHomeChannel[MAXSTRINGLENGTH];
  char szCurrentChannel[MAXSTRINGLENGTH];
  short nServerPort;

public:
  BnBot();
  ~BnBot();

  int LogOpen(char *lpszFileName);
  int __cdecl LogWrite(char *lpszFmt, ...);
  void LogClose();
  void SetLogonInfo(char *szUserName,
                    char *szUserPass,
                    char *szServer,
                    short nPort=6112);
  void SetHomeChannel(char *szNewChannel);
  int Reconnect(HWND hWnd);
  int Connect(HWND hWnd);
  int Logon();
  void Disconnect();
  int __cdecl Send(char *szFmt, ...);
  int ParseEvent(char *pszEvent, int *pnEventId, char *pszSpeaker,
                 u_long *puFlags, char *pszEventText);
  int Dispatch(char *szMsg);
  int MsgLoop();

  virtual void IdleHook() { };

  virtual int OnShowUser(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnJoin(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnUserFlags(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnLeave(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnTalk(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnBroadcast(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnChannel(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnWhisper(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnWhisperSent(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnEmote(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnChannelFull(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnChannelDoesNotExist(char *szSpeaker, u_long uFlags,
                                    char *szEventText);
  virtual int OnChannelRestricted(char *szSpeaker, u_long uFlags,
                                  char *szEventText);
  virtual int OnInfo(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnError(char *szSpeaker, u_long uFlags, char *szEventText);
  virtual int OnUniqueName(char *szSpeaker, u_long uFlags, char *szEventText);
};

#endif
