/*

  Implementation for storm.h on MPQ extracting.

  1998/8/29 (brainspin@hanmail.net)
	- Translated to C, classed routine and cracked storm for LoadLibrary.
	- Everything here is only for EDUCATIONAL and NONCOMMERCIAL USE.
	- I an NOT responsible for any trouble on using this software may cause.
	- Please give me a note on upgrades or modifications :)

  Thanks to Sean Mims'(smims@hotmail.com) for the Pascal version.
  another thanx to Ted Lyngmo(ted@lyncon.se) for the mailing list.

*/

#include <windows.h>
#include "storm.h"

CStorm::CStorm()
{
	InitStorm();
}

CStorm::~CStorm()
{
	UninitStorm();
}

BOOL CStorm::InitStorm()
{
	m_valid = false;
	lstrcpy(m_dataFile + GetCurrentDirectory(300, m_dataFile), "\\sc_data.txt\0");

	// load the library dynamically and get the addresses of the functions
	hInstStorm = LoadLibrary("storm.dll");
	if(!hInstStorm)	return FALSE;

	SFOpenArchive = GetProcAddress(hInstStorm, (LPCSTR)0x010a);
	if (!SFOpenArchive) return FALSE;

	SFOpenFileEx = GetProcAddress(hInstStorm, (LPCSTR)0x010c);
	if (!SFOpenFileEx) return FALSE;

	SFGetFileSize = GetProcAddress(hInstStorm, (LPCSTR)0x0109);
	if (!SFGetFileSize) return FALSE;

	SFReadFile = GetProcAddress(hInstStorm, (LPCSTR)0x010d);
	if (!SFReadFile) return FALSE;

	SFCloseFile = GetProcAddress(hInstStorm, (LPCSTR)0x00fd);
	if (!SFCloseFile) return FALSE;

	SFCloseArchive = GetProcAddress(hInstStorm, (LPCSTR)0x00fc);
	if (!SFCloseArchive) return FALSE;

	return TRUE;
}


BOOL CStorm::OpenArchive(char *filename)
{
	BOOL retval;
	HANDLE hListFile, hMListFile;
	char *lpListBuf, tmpBuf[300], *tmpBufPtr;
	DWORD dwBufSize;
	int i;
	PSTORMLISTITEM tmpItem;

	if (filename != NULL)
		lstrcpy(m_archiveFile, filename);
	fileCount = 0;

	CloseArchive();

	hMPQ = (PSTORMLISTITEM*)malloc(sizeof(PSTORMLISTITEM));
	hFile = (PSTORMLISTITEM*)malloc(sizeof(PSTORMLISTITEM));

	retval = (*(BOOL (__stdcall *)(char*, DWORD, DWORD, PSTORMLISTITEM*))SFOpenArchive)(m_archiveFile, 0, 0, hMPQ);
	if (!retval) return FALSE;

	hListFile = CreateFile(m_dataFile, GENERIC_READ, NULL, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hListFile == INVALID_HANDLE_VALUE) {
		DWORD err = GetLastError();
		return FALSE;
	}

	hMListFile = CreateFileMapping(hListFile, NULL, NULL, 0, 0, NULL);
	if (hMListFile == NULL) {
		CloseHandle(hListFile);
		return FALSE;
	}

	lpListBuf = (char *)MapViewOfFile(hMListFile, FILE_MAP_READ, 0, 0, 0);
	if (lpListBuf == 0) {
		CloseHandle(hMListFile);
		CloseHandle(hListFile);
		return FALSE;
	}

	dwBufSize = ::GetFileSize(hListFile, NULL);

	tmpBufPtr = tmpBuf;
	tmpItem = NULL;
	for(i = 0; i < dwBufSize; i++) {
		if ((lpListBuf[i] != '\r') && (lpListBuf[i] != '\n'))
			*(tmpBufPtr++) = lpListBuf[i];
		if (lpListBuf[i] == '\n') {
			*tmpBufPtr = '\0';
			retval = (*(BOOL (__stdcall *)(PSTORMLISTITEM, char *, DWORD, PSTORMLISTITEM*))
				SFOpenFileEx)(*hMPQ, tmpBuf, 0, hFile);
			if (retval) {
				tmpItem = *hFile;
				fileCount++;
			}
			tmpBufPtr = tmpBuf;
		}
	}
	*hFile = tmpItem;

	//delete lpListBuf;
	UnmapViewOfFile(lpListBuf);
	CloseHandle(hMListFile);
	CloseHandle(hListFile);
	m_valid = true;
	return retval;
}


DWORD CStorm::GetFileSize(PSTORMLISTITEM hInFile)
{
	return (*(DWORD (__stdcall *)(PSTORMLISTITEM, DWORD))SFGetFileSize)(hInFile, 0);
}

DWORD CStorm::ReadFile(PSTORMLISTITEM hInFile, char *buffer, DWORD size)
{
	DWORD dwSize;
	DWORD retval;

	retval = (*(DWORD (__stdcall *)(PSTORMLISTITEM, char *, DWORD, DWORD*, DWORD))SFReadFile)(hInFile, buffer, size, &dwSize, 0);
	
	if (retval)
		return dwSize;

	return 0;
}

void CStorm::CloseArchive()
{
	BOOL retval;
	PSTORMLISTITEM tmpFile;

	if (m_valid) {
		tmpFile = *hFile;
		for(;fileCount > 0; fileCount--) {
			// i don't know whether this part is correct
			retval = (*(BOOL (__stdcall *)(PSTORMLISTITEM))SFCloseFile)(tmpFile);
			//tmpFile = tmpFile->next;
		}

		retval = (*(BOOL (__stdcall *)(PSTORMLISTITEM))SFCloseArchive)(*hMPQ);

		free(hMPQ);
		free(hFile);
	}
	m_valid = false;
}

void CStorm::UninitStorm()
{
	CloseArchive();
	FreeLibrary(hInstStorm);
}
