const DAY_IN_MS= 86400000;
// Number of milliseconds in a day. Used for
// midnight timer correction.

var g_Window = LoadWindowStyle("glob.rws");
var g_Font = LoadFont("verdana.rfn");
// Data used for text boxes and text.

var g_TalkTriggered = false;
// Flag to use UpdateMapEngine() without the
// side effect of an infinite loop on the
// talk event.

var fps_box = 0;
var realtime = 0;
// ^ Used to make the map engine run at a normal speed.


/*
 * function _textBox(ws, fnt, ix, iy, x, y, w, h, str)
 *
 * Displays a window showing a message letter by letter.
 *First shows the text box emerging. Then shows each
 *letter of each line appearing. Finally, shows the text
 *box going away.
 * 
 * ws - window style. The window style to be used as a
 *background to the scrolling text.
 * fnt - font. The graphical font to be used to display
 *the text itself.
 * ix - number. The x value from which the text emerges
 *and to which it disappears.
 * iy - number. The y value from which the text emerges
 *and to which it disappears.
 * x - number. The x value (left) of the text box.
 * y - number. The y value (top) of the text box.
 * w - number. The width of the text box.
 * h - number. The height of the text box.
 * str - string. The actual message to be displayed.
 *
 */
function _textBox(ws, fnt, ix, iy, x, y, w, h, str)
{

// VARIABLES

var words = new Array();
// ^ Holds the words extracted by the split function.
var lines = new Array();
// ^ Contains the text lines, arranged so they don't
//"jump" to the beginning of the next line as they
//wrap.
var visiblelines = 0;
// ^ Number of lines ever visible at a time. Calculated from
//the font height and the height of the text box.


// VALIDATE DATA

// Check types of the passed parameters.
{
var error = "";
if((typeof ws) != "object")
error = error.concat("ws ");
if((typeof fnt) != "object")
error = error.concat("fnt ");
if((typeof ix) != "number")
error = error.concat("ix ");
if((typeof iy) != "number")
error = error.concat("iy ");
if((typeof x) != "number")
error = error.concat("x ");
if((typeof y) != "number")
error = error.concat("y ");
if((typeof w) != "number")
error = error.concat("w ");
if((typeof h) != "number")
error = error.concat("h ");
if((typeof str) != "string")
error = error.concat("str");
// Display an error if applicable
if(error.length > 0)
{
error = error.concat("_textBox: The following are of the wrong type:\n");
Abort(error);
}
}

if(w < 8)
Abort("_textBox: w must be at least 8.");
if(h < 8)
Abort("_textBox: h must be at least 8");

// PREPARE DATA

words = str.split(" ");
if(words.length < 1)
Abort("_textBox: You need at least one word in str.");
visiblelines = Math.floor((h + 2) / fnt.getHeight());


// SET lines[] ARRAY
{
var _line = 0;
// ^ Current index of lines[] array.
/*
 * Cycles through each word. It tries to add it to the current
 * line, and does so unless it cannot fit. In that case, it
 * shifts down a line and attempts to fit on that one. If it
 * does, all is good and well. If not, the word is cycled
 * through systematically until the longest possible string that
 * can fit on a line is created. That word portion is set, the
 * entry line is shifted down again, and the word is sorted
 * into the lines. This last scenario is very rare, but it would
 * be poor practice of me to not accomodate for all situations.
 *
 */
for(var i = 0; i < words.length; i++)
{
// Initialise the string if it hasn't already been done.
if(lines[_line] == undefined)
{
lines[_line] = "";
}
// Check whether the new word fits or not.
if(fnt.getStringWidth(lines[_line].concat(" ", words[i])) + 2 < w)
{
// Add the word.
if(lines[_line] == "")
{
lines[_line] = words[i];
}
else
{
lines[_line] = lines[_line].concat(" ", words[i]);
}
}
else
{
// Go to the next line and try again.
_line++;
if(fnt.getStringWidth(words[i]) + 2 < w)
{
lines[_line] = words[i];
}
else
{
// Word doesn't even fit on a single line.
// Split it into manageable chunks and add
// to subsequent lines.
for(var j = -1; ; j--)
{
// Shouldn't happen, but you never know...
if(words[i].length + j < 1)
{
Abort("_textBox: Your box is too narrow to accommodate even a letter!");
}
// Word portions that end up fitting on a line
// are caught by this.
if(j == 0)
{
if(fnt.getStringWidth(words[i]) + 2 < w)
{
// Haha! We are done! Time to hit the road!
// Oh yeah, those other words...
lines[_line] = words[i];
break;
}
}
else
{
if(fnt.getStringWidth(words[i].slice(0, j)) + 2 < w)
{
// Add word portion and process the characters remaining
// by setting the word to what's left.
lines[_line] = words[i].slice(0, j);
_line++;
words[i] = words[i].slice(j);
j = 1;
}
}
}
}
}
}
}

fps_box = GetMapEngineFrameRate();

// REVEAL TEXT BOX
{
var _x = 0, _y = 0;
var _w = 0, _h = 0;
var _stage = 0;
var _time = GetTime();
var _endtime = GetTime() + 250;

realtime = GetTime();

if(_endtime < DAY_IN_MS)
{
// Normal display.
while(_time < _endtime)
{
_time = GetTime();
_stage = 1 - ((_endtime - _time) / 250);
if(_stage > 1) _stage = 1;
UpdateMapEngine();
RenderMap();
_x = ix + Math.round((x - ix) * _stage);
_y = iy + Math.round((y - iy) * _stage);
_w = Math.round(_stage * w);
_h = Math.round(_stage * h);
ws.drawWindow(_x, _y, _w, _h);
FlipScreen();
}
}
else
{
// Special catering for midnight hours.
while(_time < (_endtime % DAY_IN_MS))
{
_time = GetTime();
_stage = 1 - ((_endTime - (_time - DAY_IN_MS)) / 250);
if(_stage > 1) _stage = 1;
UpdateMapEngine();
RenderMap();
_x = ix + Math.round((x - ix) * _stage);
_y = iy + Math.round((y - iy) * _stage);
_w = Math.round(_stage * w);
_h = Math.round(_stage * h);
ws.drawWindow(_x, _y, _w, _h);
FlipScreen();
}
}
}


// SHOW THE TEXT BOX
{
var textboxlines = new Array(visiblelines);
// ^ The actual lines seen in the text box. This will be
//used a lot, trust me.
var workingline = 0;
// ^ Index in textboxlines[] array that the char-by-char
//line is. Used with lineoffset, it can also find that
//line in the lines[] array. Stays at textboxlines.length
//once the initial lines are shown.
var lineoffset = 0;
// ^ The number of lines the top line of the visible text
//box is in relation to the actual lines[] array.
var charoffset = 0;
// ^ The number of characters of the current line being
//shown.
var done = false;
// ^ This is set to true once the entire string is shown.
var inkey = GetTalkActivationKey();
// ^ The key we use to progress in text.
var _startchar = GetTime();
var _endchar = 0;
// ^ Hopefully, I can get these to work together to produce
//text that appears at an even speed...

/*
 * The basic idea is as follows:
 * 1. Set the textboxlines[] array to what will be displayed.
 * 2. Set the current line to the corresponding lines[] array
 *entry with the help of char offset.
 * 3. Scroll a bit if scrolloffset is not 0.
 * 4. Draw the window and text.
 * 5. Wait a bit.
 * 6. Repeat until we're all out of text.
 *
 * Time to cross our fingers and hope for the best.
 *
 */

// //////////////////////////////////////////
// Function in a function. Used to draw text.
// Javascript really does shine.
function draw_text()
{
for(var i = (GetTime() - realtime) * fps_box / 1000; i >= 0; i--)
{
UpdateMapEngine();
RenderMap();
}
realtime = GetTime();
ws.drawWindow(x, y, w, h);
for(var i = 0; i < textboxlines.length; i++)
{
if(textboxlines[i] != undefined)
{
fnt.drawText(x + 1, y + fnt.getHeight() * i + 1, textboxlines[i]);
}
}
FlipScreen();
}
// End our function in a function.
// //////////////////////////////////////////

// Display while the box is not done.
while(!done)
{
realtime = GetTime();
// Two variables controlling the text speed.
_endchar = GetTime();
// A little speedup thing.
if(IsKeyPressed(inkey))
{
_endchar += (_endchar - _startchar) * 2;
}
charoffset += (_endchar - _startchar) / (1000 / 30);
if(lines[lineoffset + workingline] == undefined)
{
lines[lineoffset + workingline] = "";
}
if(charoffset > lines[lineoffset + workingline].length + 1)
{
charoffset = lines[lineoffset + workingline].length + 1;
}
_startchar = GetTime();
while(AreKeysLeft()) GetKey();
// Time to fill in the textboxlines[] array.
for(var i = 0; i < workingline; i++)
{
textboxlines[i] = lines[lineoffset + i];
}
// Fill in the working line.
textboxlines[workingline] = lines[lineoffset + workingline].slice(0, charoffset);
// Show our beautiful text box.
draw_text();
// Check to see if we've reached the end of a line.
if(charoffset > lines[lineoffset + workingline].length)
{
charoffset = 0;
workingline++;
// Check to see workingline is valid in textboxlines[]
if(workingline >= textboxlines.length)
{
lineoffset++;
workingline--;
// We aren't at the end of the text, are we?
if((lineoffset + workingline) >= lines.length)
{
while(IsKeyPressed(inkey))
{
draw_text();
if(AreKeysLeft())
{
GetKey();
}
}
while(AreKeysLeft() ? GetKey() != inkey : true)
{
draw_text();
}
_startchar = GetTime();
done = true;
continue;
}
// Wait every few lines for a keypress before continuing.
if(((lineoffset + workingline) % visiblelines) == 0)
{
while(IsKeyPressed(inkey))
{
draw_text();
if(AreKeysLeft())
{
GetKey();
}
}
while(AreKeysLeft() ? GetKey() != inkey : true)
{
draw_text();
}
_startchar = GetTime();
}
}
}
}
}


// CONCEAL TEXT BOX
{
var _x = 0, _y = 0;
var _w = 0, _h = 0;
var _stage = 0;
var _time = GetTime();
var _endtime = GetTime() + 250;
if(_endtime < DAY_IN_MS)
{
// Normal display.
while(_time < _endtime)
{
_time = GetTime();
_stage = (_endtime - _time) / 250;
if(_stage < 0) _stage = 0;
UpdateMapEngine();
RenderMap();
_x = ix + Math.round((x - ix) * _stage);
_y = iy + Math.round((y - iy) * _stage);
_w = Math.round(_stage * w);
_h = Math.round(_stage * h);
ws.drawWindow(_x, _y, _w, _h);
FlipScreen();
}
}
else
{
// Special catering for midnight hours.
while(_time < (_endtime % DAY_IN_MS))
{
_time = GetTime();
_stage = (_endtime - (_time - DAY_IN_MS)) / 250;
if(_stage < 0) _stage = 0;
UpdateMapEngine();
RenderMap();
_x = ix + Math.round((x - ix) * _stage);
_y = iy + Math.round((y - iy) * _stage);
_w = Math.round(_stage * w);
_h = Math.round(_stage * h);
ws.drawWindow(_x, _y, _w, _h);
FlipScreen();
}
}
}

// HAPPY ENDING

return 0;

}
/*
 * End function _textBox(ws, fnt, ix, iy, x, y, w, h, str)
 *
 */

/* 
 * function _talk(who, mystring)
 * 
 * A little macro-type function that makes writing the
 *script a lot less tedious. It automatically sets the
 *initial X and Y values of the _textBox() function,
 *and positions the box so that it is always visible.
 * 
 * who - string, person. The person where the box will
 *appear from.
 * mystring - string. The string to be said.
 * 
 */
function _talk(who, mystring)
{

var screen_x = 0;
var screen_y = 0;

if(GetCameraX() < GetScreenWidth() / 2)
{
screen_x = 0;
}
else if(GetCameraX() < GetLayerWidth(0) - GetScreenWidth() / 2)
{
screen_x = GetCameraX() - GetScreenWidth() / 2;
}
else
{
screen_x = GetLayerWidth(0) - GetScreenWidth();
}

if(GetCameraY() < GetScreenHeight() / 2)
{
screen_y = 0;
}
else if(GetCameraY() < GetLayerHeight(0) - GetScreenHeight() / 2)
{
screen_y = GetCameraY() - GetScreenHeight() / 2;
}
else
{
screen_y = GetLayerHeight(0) - GetScreenHeight();
}

var _ix = MapToScreenX(0, GetPersonX(who));
var _iy = MapToScreenY(0, GetPersonY(who));
var _w = 120;
var _h = g_Font.getHeight() * 3 + 2;
var _x = 0;
var _y = 0;

if(_iy - _h - 16 < screen_y)
{
// Position to bottom of person.
_y = _iy + 16;
if(_ix - _w - 16 < screen_x)
{
// Position to right of person.
_x = _ix + 16;
}
else
{
// Position to left of person.
_x = _ix - _w - 16;
}
}
else
{
// Position to top of person.
_y = _iy - _h - 16;
if(_ix - _w - 16 < screen_x)
{
// Position to right of person.
_x = _ix + 16;
}
else
{
// Position to left of person.
_x = _ix - _w - 16;
}
}

_textBox(g_Window, g_Font, _ix, _iy, _x, _y, _w, _h, mystring);

}
/* 
 * End function _talk(who, mystring)
 * 
 */

/*
 * function _facePerson(p1, p2)
 *
 * A rather simple function. It returns a string indicating
 *the direction of p2 from p1.
 *
 * p1 - person, string. The name of the person that the
 *function will return the direction to turn to.
 * p2 - person, string. The name of the person that will
 *be faced towards.
 *
 */
function _facePerson(p1, p2)
{
var dir = "";
var p1x = GetPersonX(p1);
var p1y = GetPersonY(p1);
var p2x = GetPersonX(p2);
var p2y = GetPersonY(p2);
// Check position of p2 relative to p1.
if(Math.abs(p1x - p2x) > Math.abs(p1y - p2y))
{
// The people are lined along the X axis, more or less.
if(p1x > p2x)
{
// p2 is west of p1.
dir = "west";
}
else
{
// p2 is east of p1.
dir = "east";
}
}
else
{
// The people are lined along the Y axis, more or less.
if(p1y > p2y)
{
// p2 is north of p1.
dir = "north";
}
else
{
// p2 is south of p1.
dir = "south";
}
}
return dir;
}
/*
 * End function _facePerson(p1, p2)
 *
 */

/*
 * function _waitFor(p)
 *
 * Used in the scripts and NPC actions, it can be used to run
 *queued commands for NPCs and have the map engine wait until
 *they're done before continuing. Essential for a game like
 *mine.
 *
 * This function just waits for a person to run out of queue
 *commands before resuming.
 *
 * p - person, string. The person to wait for.
 *
 */
function _waitFor(p)
{
while(!IsCommandQueueEmpty(p))
{
UpdateMapEngine();
RenderMap();
FlipScreen();
}
return;
}
/*
 * End function _waitFor(p)
 *
 */

/*
 * function _randomText()
 * 
 * Obtains a random argument from its list (any length)
 *and simply returns it.
 * 
 * This function accepts as many arguments as you wish
 *to use.
 * 
 */
function _randomText()
{
var me = _randomText.arguments;
return me[Math.floor(Math.random() * me.length)];
}
/*
 * End function _randomText()
 *
 */

/* 
 * function PersonSpeech(text)
 * 
 */
function PersonSpeech(person, text)
{
return person + ":  \"" + text + "\""
}
/* 
 * function PersonSpeech(text)
 * 
 */

/*
 * Random movement script
 *
 * A little something I can set for that
 * oh-so-typical NPC dummy movement that you see
 * all over the place. Set this to a person's
 * SCRIPT_COMMAND_GENERATOR script, and presto!
 * Instant dummy movement.
 *
 */

function _randomMove()
{

var p = GetCurrentPerson();
var px = GetPersonX(p);
var py = GetPersonY(p);
var duration = Math.floor(Math.random() * 8) + 16;
var rnd = Math.floor(Math.random() * 12);

switch(rnd)
{

case 0: // Move north
QueuePersonCommand(p, COMMAND_FACE_NORTH, false);
for(var i = 1; i <= duration; i++)
{
if(IsPersonObstructed(p, px, py - i)) break;
QueuePersonCommand(p, COMMAND_MOVE_NORTH, false);
}
break;

case 1: // Move east
QueuePersonCommand(p, COMMAND_FACE_EAST, false);
for(var i = 1; i <= duration; i++)
{
if(IsPersonObstructed(p, px + i, py)) break;
QueuePersonCommand(p, COMMAND_MOVE_EAST, false);
}
break;

case 2: // Move south
QueuePersonCommand(p, COMMAND_FACE_SOUTH, false);
for(var i = 1; i <= duration; i++)
{
if(IsPersonObstructed(p, px, py + i)) break;
QueuePersonCommand(p, COMMAND_MOVE_SOUTH, false);
}
break;

case 3: // Move west
QueuePersonCommand(p, COMMAND_FACE_WEST, false);
for(var i = 1; i <= duration; i++)
{
if(IsPersonObstructed(p, px - i, py)) break;
QueuePersonCommand(p, COMMAND_MOVE_WEST, false);
}
break;

default: // Wait
for(var i = 0; i < duration; i++)
{
QueuePersonCommand(p, COMMAND_WAIT, false);
}

}
}
