/*
 * GAME SCRIPT
 *
 * This pretty much stores all of the speech, movement,
 * and cut-scenes of the entire game. You know, the creators
 * behind Sphere should have put a little more effort into
 * protecting games from modification. Oh well, what are you
 * going to do? Besides, it's nice to muck around with other
 * people's work... I'm rambling. Have fun with this!
 *
 * This just contains one massive function: _script. It
 * channels data based on where any given character is, and
 * what has yet to be done in the story.
 *
 */

function _script()
{
var person;
if(!g_TalkTriggered)
{

g_TalkTriggered = true;

var location = GetCurrentMap();
switch(location)
{

case "test.rmp":
person = GetCurrentPerson();
switch(person)
{

case "Blorb":
{

// Stop the person's random movement.
SetPersonScript(person, SCRIPT_COMMAND_GENERATOR, "");
ClearPersonCommands(person);

// Person faces Glob.
SetPersonDirection(person, _facePerson(person, "Glob"));

// And speaks.
_talk(
person,
_randomText(
PersonSpeech(person, "I may be stating the obvious, but Tunginobi really needs to take some classes in level coherency. Just look at all these tiles!"),
PersonSpeech(person, "Tunginobi was so cheap, he gave both of us the same sprite! Not only that, but the sprite is the lowly template!"),
PersonSpeech(person, "This game is going to be excellent! Loads and loads of nonsensical storyline events... ahh."),
PersonSpeech(person, "This game doesn't deserve any credit. You do realise a lot of the game is going to be like this...")
)
);

_talk(person, PersonSpeech(person, "Don't forget to visit http://www.flatface.net/tunginobi/globtheblob/ for updates and stuff about Glob The Blob."))

_talk("Glob", PersonSpeech("Glob", "Wow. A whole game centred around... me."));

// Reinstate person's random movement.
SetPersonScript(person, SCRIPT_COMMAND_GENERATOR, "_randomMove();");

break;

}

case "Flobippo":
{

// Stop the NPC from moving around.
SetPersonScript(person, SCRIPT_COMMAND_GENERATOR, "");
ClearPersonCommands(person);

// Face Glob.
SetPersonDirection(person, _facePerson(person, "Glob"));

// And speak.
_talk(
person,
_randomText(
PersonSpeech(person, "This isn't like any CRPG you've ever played before."),
PersonSpeech(person, "Some things are dumb, eg. HOLE IN THE GROUND, but some are just outright stupid, eg. DEHYDRATED ANVIL."),
PersonSpeech(person, "I'm just a demonstration of how multiple NPCs can coexist. It's really cool!"),
PersonSpeech(person, "Did you know if you read out CRPG, it sounds like 'cr*p game'? Just a thought... unassociated with the quality of this game.")
)
);

// Reinstate NPC's movement.
SetPersonScript(person, SCRIPT_COMMAND_GENERATOR, "_randomMove();");

break;

}

case "door":
{

// The door is locked permanently, so comment.
_talk(
"Glob",
_randomText(
"Glob : \"... it's locked up pretty tight.\"",
"Glob : \"Stupid inhabitants won't even let me in.\"",
"Glob : \"GRAAAGGHHHH............................. ugh. It's no use. I bet there isn't even anything behind there anyway.\""
)
);

break;

}

default:
{
Abort("What the?! Who is \"" + person + "\"?");
}

}
break;

default:
Abort("There really should be a map, you know...");
}

g_TalkTriggered = false;

}
}
