unit UniPrestigeScript;

interface

Uses DNDClasses, SysUtils, Dialogs, Forms, Windows, Classes, Messages, Controls;

Type TPrestigeScript = Class(TObject)
 Function Process(fClass : TBaseClass) : Boolean;
End;

implementation

Uses FrmMain;

{ special <text>         -  Displays text with a 'Ok/Cancel' Selector.  }
{ arcane <#>             -  Must be able to cast level # arcane spells or above }
{ divine <#>             -  Must be able to cast level # divine spells or above }
{ druid <#>              -  A druid, able to cast level # divine spells or above }
{ sneak <#>              -  Must be capable of dishing out #d6 sneak attack damage. }
{ spell <text>           -  Must have the specified spell in their spellbook/reportiore }
{ rage                   -  Must have the ability to rage }
{ favored                -  Must have a 'favored enemy', like a ranger }

Function OneArgument(Var Source : String) : String;
Var A : Integer;
Begin
 A := Pos(' ', Source);
 If ( A > 0 ) THen BEgin
  Result := Copy(Source,1,A-1);
  Source := Copy(Source,A+1,Length(Source)-A);
 End Else Begin
  Result := Source;
  Source := '';
 End;
End;

Function TPrestigeScript.Process(fClass : TBaseClass) : Boolean;
Var Command, Line : String;
    I,J,K : Integer;
    MinLevel,MinVal : Integer;
    Found : Boolean;
    Txt : String;
Begin
 REsult := False;

 If (fClass.PrestigeRaces <> '' ) and
    (Main.Character.fRace <> nil ) and
    (Pos(Lowercase(Main.Character.fRace.Name)+',',lowercase(fClass.PrestigeRaces))=0) Then Begin
   ShowMessage('Unable to select this class: Your race must be one of the following: ('+fClass.PrestigeRaces+')');
   Result := True;
   exit;
 End;

 For I := 0 To fClass.PrestigeScript.Count-1 Do Begin
   Line := fClass.PrestigeScript[I];
   Command := Lowercase(OneArgument(Line));

   If Command='special' Then If MessageDlg(Line, mtConfirmation, [mbOk, mbCancel], 0) = mrCancel Then Begin
     Result := True;
     Exit;
   End;
   If Command='arcane' Then Begin
     MinLevel := StrToIntDef(Line,0);
     Found := False;
     For J := 0 To Main.Character.Classes.Count-1 Do Begin
       If ( Main.Character.Classes[J].BaseClass.SpellsDivine = False ) And
          ( Main.Character.Classes[J].HighestCastLevel >= MinLevel ) Then Begin
        Found := True;
        Break;
       End;
     End;

     if not Found Then begin
       ShowMessage('Unable to select this class: You must be able to cast level '+IntToStr(MinLevel)+' arcane spells.');
       Result := True;
       exit;
     End;
   End;
   If Command='divine' Then Begin
     MinLevel := StrToIntDef(Line,0);
     Found := False;
     For J := 0 To Main.Character.Classes.Count-1 Do Begin
       If ( Main.Character.Classes[J].BaseClass.SpellsDivine = True ) And
          ( Main.Character.Classes[J].HighestCastLevel >= MinLevel ) Then Begin
        Found := True;
        Break;
       End;
     End;

     if not Found Then begin
       ShowMessage('Unable to select this class: You must be able to cast level '+IntToStr(MinLevel)+' divine spells.');
       Result := True;
       exit;
     End;
   End;
   If Command='druid' Then Begin
     MinLevel := StrToIntDef(Line,0);
     Found := False;
     For J := 0 To Main.Character.Classes.Count-1 Do Begin
       If ( Lowercase(Main.Character.Classes[J].BaseClass.Name) <> 'druid' ) Then Continue;
       If ( Main.Character.Classes[J].HighestCastLevel >= MinLevel ) Then Begin
        Found := True;
        Break;
       End;
     End;

     if not Found Then begin
       ShowMessage('Unable to select this class: You must be druid, and able to cast level '+IntToStr(MinLevel)+' druid spells.');
       Result := True;
       exit;
     End;
   End;
   If Command='spell' Then Begin
     Found := False;
     Line := Trim(Lowercase(Line));
     For J := 0 To Main.Character.Classes.Count-1 Do Begin
       For K := 0 To Main.Character.Classes[J].LearnedSpells.Count-1 Do Begin
         If LowerCase(Trim(Main.Character.Classes[J].LearnedSpells[K].Name)) = Line Then Begin
           Found := True;
           Break;
         End;
       End;
     End;

     if not Found Then begin
       ShowMessage('Unable to select this class: You must be able to cast the spell '''+Line+''' ');
       Result := True;
       exit;
     End;
   End;
   If Command='sneak' Then Begin
     MinVal := StrToIntDef(Line,0);
     Found := False;
     For J := 0 To Main.Character.Classes.Count-1 Do Begin

       for K := 0 To Main.Character.Classes[J].FreeClassAbilities.Count-1 Do Begin
         Txt := lowercase(Main.Character.Classes[J].FreeClassAbilities[K].Name);
         If Pos('sneak',Txt)<>0 Then Begin
          Txt := Copy(Txt,Pos('+',Txt)+1,10); { Cut out the X from the +XD6 text }
          Txt := Copy(txt,1,Pos('d',Txt)-1);
          If StrToIntDef(Txt,0) >= MinVal  Then Begin
            Found := True;
            Break;
          End;
         End;
       End;
     End;

     if not Found Then begin
       ShowMessage('Unable to select this class: You need to be able to do a sneak attack of at least +'+IntToStr(MinVal)+'d6.');
       Result := True;
       exit;
     End;
   End;
   If Command='rage' Then Begin
     Found := False;
     For J := 0 To Main.Character.Classes.Count-1 Do Begin

       for K := 0 To Main.Character.Classes[J].FreeClassAbilities.Count-1 Do Begin
         Txt := lowercase(Main.Character.Classes[J].FreeClassAbilities[K].Name);
         If Pos('rage',Txt)<>0 Then Begin
          Found := True;
          Break;
         End;
       End;
     End;

     if not Found Then begin
       ShowMessage('Unable to select this class: You need the barbarian ''rage'' ability.');
       Result := True;
       exit;
     End;
   End;
   If Command='favored' Then Begin
     Found := False;
     For J := 0 To Main.Character.Classes.Count-1 Do Begin

       for K := 0 To Main.Character.Classes[J].FreeClassAbilities.Count-1 Do Begin
         Txt := lowercase(Main.Character.Classes[J].FreeClassAbilities[K].Name);
         If Pos('favored enemy',Txt)<>0 Then Begin
          Found := True;
          Break;
         End;
       End;
     End;

     if not Found Then begin
       ShowMessage('Unable to select this class: You need a favored enemy, like the ranger.');
       Result := True;
       exit;
     End;
   End;

 End;
End;

end.
