unit UniDndListbox;

interface

Uses contNrs, Windows, Classes, Controls, Graphics, StdCtrls, SysUtils, Forms, Dialogs, Messages;

 type TDNDButton = Record
    Highlighted : Boolean;
 End;

 TPrimalDNDObject = Class
 Protected
   fVersion     : Integer;
   fValue       : Real;
   fName        : String;
   fDescription : String;
   Procedure SetValue(NewValue : Real); Virtual;
   Procedure SetName(NewName : String); Virtual;
   Procedure SetDescription(NewDescription : String); Virtual;
   Function GetValue : Real; Virtual;
   Function GetName : String; Virtual;
   FUnction GetDescription : String; Virtual;
 Public
   fGroup       : Integer;
   Step         : Real;
   Min, Max     : Real;
   fDisabled    : Boolean;
   Function DisplayValue : Real; Virtual;
   Procedure Increase; Virtual;
   Procedure Decrease; Virtual;
   Function HasPrerequisites : Boolean; Virtual;
   Function AtMax : Boolean; Virtual;
   Function AtMin : Boolean; Virtual;
   Constructor Create; Virtual;
   Destructor  Destroy; override;
   Property Value : Real Read GetValue Write SetValue;
   Property Name : String Read GetName write SetName;
   Property Description : String Read GetDescription write SetDescription;
 End;

 TPrimalDNDList = Class(TObjectList)
  function    GetObject(Index: Integer): TPrimalDNDObject;
  procedure   SetObject(Index: Integer; AObject: TPrimalDNDObject);
  property    Items[Index: Integer]: TPrimalDNDObject Read GetObject Write SetObject; default;
  Constructor Create;
 End;

 TItemEvent = procedure(Control: TWinControl; Item : TPrimalDNDObject) of object;
 TItemMaxEvent = procedure(Control: TWinControl; Item : TPrimalDNDObject; Var AtMax : Boolean) of object;
 TMouseMoveDNDEvent = procedure(Sender: TObject; Shift: TShiftState; X, Y: Integer; Item : TPrimalDNDObject) of object;
 TDNDOnPaint = procedure(Sender: TObject; R : TRect; Item : TPrimalDNDObject) of object;
 TDNDOnShouldShow = procedure(Sender: TObject; Item : TPrimalDNDObject; Var ShouldShow : Boolean) of object;

type
 TDNDListBox = Class(TCustomControl{TGraphicControl})
 protected
   FScrollBar: TScrollbar;
   PageBottom: Integer;
   bm : Tbitmap;
   FrameTop:integer;
   FrameBottom:integer;
   fItemHeight  : Integer;
   fShowNumberColumn : boolean;
   fButtonWidth : Integer;
   fNumberWidth : Integer;
   fButtons     : Boolean;
   fButton      : Array of TDNDButton;
   FOnSelect    : TItemEvent;
   FOnDecrease  : TItemEvent;
   FOnIncrease  : TItemEvent;
   FAfterDecrease  : TItemEvent;
   FAfterIncrease  : TItemEvent;
   FONMax : TItemMaxEvent;
   FOnMouseMove: TMouseMoveDNDEvent;
   FOnPaint : TDNDOnPaint;
   fButtonCount : Integer;
   fList : TPrimalDNDList;
   fGroup : Integer;
   procedure Scrollviewer(sender: TObject);
   Procedure SetNumberColumn(Enabled : Boolean);
   Procedure DrawButton(I : Integer);
   Procedure HighLightButton(ButtonID : Integer);
   Procedure SetList(NewList : TPrimalDNDList);
   procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
   procedure CreateWnd; override;
   procedure WndProc(var Message: TMessage); override;
 Public
   constructor create(AOwner: TComponent); Override;
   destructor Destroy; override;
   Procedure PreparePaint;
   Procedure Paint; Override;
   Property List : TPrimalDNDList read fList write SetList;
   Function GetCanvas : TCanvas;
   Procedure SetGroup(I : Integer);
 Published
   Property ShowNumberColumn : Boolean read fShowNumberColumn Write SetNumberColumn;
   Property ShowButtons : Boolean read fButtons Write fButtons;
   property OnSelect: TItemEvent read FOnSelect write FOnSelect;
   property OnDecrease: TItemEvent read FOnDecrease write FOnDecrease;
   property OnIncrease: TItemEvent read FOnIncrease write FOnIncrease;
   property AfterDecrease: TItemEvent read FAfterDecrease write FAfterDecrease;
   property AfterIncrease: TItemEvent read FAfterIncrease write FAfterIncrease;
   property OnMax: TItemMaxEvent read FOnMax write FOnMax;
   property OnMouseMove: TMouseMoveDNDEvent read FOnMouseMove write FOnMouseMove;
   property OnPaint: TDNDOnPaint read FOnPaint write FOnPaint;
   property Canvass : TCanvas read GetCanvas;
   Property Name;
   Property Group : Integer read fGroup write SetGroup;

 End;

 Procedure Register;

implementation

  Function TPrimalDNDObject.GetValue : Real;
  Begin
   Result := fValue;
  End;

  Function TPrimalDNDObject.GetName : String;
  Begin
   Result := fName;
  End;

  FUnction TPrimalDNDObject.GetDescription : String;
  Begin
   Result := fDescription;
  End;

  Function TPrimalDNDObject.DisplayValue : Real;
  Begin
   Result := GetValue;
  End;

  Procedure TPrimalDNDObject.SetValue(NewValue : Real);
  Begin
   fValue := NewValue;
  End;

  Procedure TPrimalDNDObject.SetName(NewName : String);
  Begin
   fName := NewName;
  End;

  Procedure TPrimalDNDObject.SetDescription(NewDescription : String);
  Begin
   fDescription := NewDescription;
  End;
   Function TPrimalDNDObject.HasPrerequisites : Boolean;
   // If the prerequisites for this object are reached, return
   // true, if not, return false.
   Begin
    Result :=  True;
   End;

   Function TPrimalDNDObject.AtMax : Boolean;
   Begin
    Result := (Value >= Max);
   End;

   Function TPrimalDNDObject.AtMin : Boolean;
   Begin
    Result := (Value <= Min);
   End;

   Procedure TPrimalDNDObject.Increase;
   Begin
     Value := Value + Step;
     If Value > Max tHen VAlue := Max;
   End;

   Procedure TPrimalDNDObject.Decrease;
   Begin
     Value := Value - Step;
     If Value < Min Then VAlue := Min;
   End;

   Constructor TPrimalDNDObject.Create;
   Begin
     fVersion := 0;
     Min   := 0;
     Max   := 100;
     Step  := 1;
   End;

   Destructor TPrimalDNDObject.Destroy;
   Begin
   End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  function TPrimalDNDList.GetObject(Index: Integer): TPrimalDNDObject;
  Begin
    Result := TPrimalDNDObject(GetItem(Index));
  End;

 Constructor TPrimalDNDList.Create;
 Begin
   Inherited;
   OwnsObjects := False;
 End;

  procedure TPrimalDNDList.SetObject(Index: Integer; AObject: TPrimalDNDObject);
  Begin
    SetItem(index,AObject);
  End;

Function URANGE(A,B,C : Integer) : Integer;
Begin
  If B < A Then B := A;
  If B > C Then B := C;
  Result := B;
End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

Function TDNDListBox.GetCanvas : TCanvas;
Begin
 If ( Assigned(Bm) ) Then Result := Bm.Canvas Else Result := Nil;
End;

procedure TDNDListBox.MouseMove(Shift: TShiftState; X, Y: Integer);
Var ButtonID : Integer;
    item : TPrimalDNDObject;
begin
  Item := Nil;
  if FList <> Nil Then Begin
  If fList.Count > 0 Then Begin
    ButtonID := (Y Div fItemHeight) mod 100;
    Item := TPrimalDNDObject(fList[URANGE(0,ButtonID+fScrollBar.Position,fList.Count-1)]);
  End;
  if Assigned(FOnMouseMove) then FOnMouseMove(Self, Shift, X, Y, Item);
  End;

end;

Procedure TDNDListBox.SetNumberColumn(Enabled : Boolean);
Begin
 fShowNumberColumn := Enabled;
 Invalidate;
End;

Procedure TDNDListBox.HighLightButton(ButtonID : Integer);
Var I : Integer;
Begin
 if not fButtons Then Exit;
 if ButtonID > fButtonCount-1 Then Exit;
 If ( ButtonID <> -1 ) AND ( fButton[ButtonID].HighLighted ) Then Exit;

 For I := 0 To fButtonCount-1 Do Begin
   If ( I <> ButtonID ) and fButton[I].HighLighted Then Begin
     fButton[I].HighLighted := False;
     DrawButton(I);
   End;
End;
 If ( ButtonID = -1 ) Then Exit;
 fButton[ButtonID].HighLighted := True;
 DrawButton(ButtonID);
End;

    Procedure TDNDListbox.SetList(NewList : TPrimalDNDList);
    Begin
     if NewList <> fList Then Begin
         fList := NewList;
         Invalidate;
       End;
    End;

procedure TDNDListBox.WndProc(var Message: TMessage);
Var ButtonID : Integer;
    ITem : TPrimalDNDObject;
    I : Integer;
    B : Boolean;
Const Left : Boolean = False;
Begin
  if not Assigned(fList) then Begin
    inherited WndProc(Message);
    Exit;
  End;
  if (Message.Msg = WM_MOUSEMOVE) Then Begin
     if fButtons Then Begin
       ButtonID := (TWMMouse(Message).YPos Div (fItemHeight Div 2)) mod 100;
       if ( ( TWMMouse(Message).XPos < Bm.Width ) or
             ( TWMMouse(Message).XPos > Bm.Width+fButtonWidth-1 ) ) Then ButtonID := -1;
       HighlightButton(ButtonID);
     End;
  End;
  if (Message.Msg >= WM_MOUSEFIRST) and (Message.Msg <= WM_MOUSELAST) and
     ( TWMMouse(Message).XPos >= 0 ) and ( TWMMouse(Message).YPos >= 0 ) and
     ( TWMMouse(Message).XPos < Width ) and ( TWMMouse(Message).YPos < Height ) Then Begin
     If ((TWMMouse(Message).Keys) AND MK_LBUTTON) <> 0 Then Begin
       If not Left Then Begin
         Left := True;
         ButtonID := (TWMMouse(Message).YPos Div (fItemHeight Div 2)) mod 100;
         If Assigned( FOnSelect ) Then Begin
           if ( ( TWMMouse(Message).XPos < Bm.Width ) And
                ( ( ButtonID div 2 ) < fList.Count ) ) Then Begin
                FOnSelect(Self,fList[ButtonID div 2 + FrameTop]);
           End;
         End;

         if ( ( TWMMouse(Message).XPos < Bm.Width ) or
              ( ( ButtonID div 2 ) >= fList.Count ) or
              ( TWMMouse(Message).XPos > Bm.Width+fButtonWidth-1 ) ) Then
         Else Begin
            If ( ( ButtonID mod 2 ) = 0 ) Then Begin
              Item := TPrimalDNDObject(fList[(ButtonID div 2)+fScrollBar.Position]);
              B := False;
              If Assigned( FOnMax) Then FOnMax(Self,Item,B);
              If not B Then Begin
                If Assigned( FOnIncrease ) Then FOnIncrease(Self,Item);
                Item.Increase;
                If Assigned( FAfterIncrease ) Then FAfterIncrease(Self,Item);
              End;
            End Else Begin
              if (ButtonID div 2)+fScrollBar.Position < fList.Count Then Begin
                Item := TPrimalDNDObject(fList[(ButtonID div 2)+fScrollBar.Position]);
                I := fList.Count;
                If Assigned( FOnDecrease ) Then FOnDecrease(Self,Item);
                if FList.Count = I Then Begin
                  Item.Decrease;
                  If Assigned( FAfterDecrease ) Then FAfterDecrease(Self,Item);
                End;
              End;
            End;
            Invalidate;
            Exit;
         End;
       End;
     End Else Left := False;
  End;

  inherited WndProc(Message);
ENd;

Constructor TDNDListBox.create(AOwner: TComponent);
Begin
  inherited Create(AOwner);
  Bm := Nil;
  Width := 250;
  Height := 250;
  ShowHint := True;
  DoubleBuffered :=True;
  fShowNumberColumn := True;
  fButtons := True;
End;

procedure TDNDListBox.Scrollviewer(sender:TObject);
begin
 FrameTop:=FScrollbar.position;
 FrameBottom:=FrameTop+clientHeight-1;
 Invalidate;
 // Render
end;

Destructor TDNDListBox.Destroy;
Begin
  if Assigned( bm ) Then bm.free;
  Inherited Destroy;
End;

Procedure TDNDListBox.CreateWnd;
Begin
  Inherited CreateWnd;
  if Assigned(FScrollBar) Then Exit;
  fItemHeight  :=32;
  fNumberWidth :=32;
  fButtonWidth := fItemHeight Div 2;
  ClientHeight := (ClientHeight - (ClientHeight mod fItemHeight))+2;
  FScrollBar:=TScrollBar.create(self);
  FScrollBar.kind:=sbVertical;
  FScrollBar.parent:=Self;
  FScrollBar.min:=0;
  FScrollBar.max:=0;
  FScrollBar.OnChange:=ScrollViewer;
  FScrollBar.Align := alRight;
  FScrollBar.OnChange:=ScrollViewer;
  FrameTop:=0;
  FrameBottom:=clientHeight;
  bm:=Tbitmap.create;
  bm.canvas.font.name := 'Verdana';
  fButtonCount := (ClientHeight*2) Div fItemHeight;
  SetLength(fButton, fButtonCount);
  bm.width:=clientWidth-FScrollbar.width - fButtonWidth-1;
  bm.height:=clientHeight;
End;

Procedure TDNDListBox.DrawButton(I : Integer);
Var R : TRect;
   Color2 : TCOlor;
   Size : INteger;
Begin
 If not Assigned(bm) Then Exit;
 If (I < 0) Then Exit;
 if Not Assigned(fList) or ( I >= fList.Count*2 ) Then Begin
    R := Rect(bm.width,I*(fItemHeight DIV 2),bm.width+fButtonWidth,(I+1)*(fItemHeight Div 2));
    canvas.Brush.color:= ClWhite;
    canvas.FillRect(R);
 End Else Begin
    if not fButtons Then Exit;
    R := Rect(bm.width,I*(fItemHeight DIV 2),bm.width+fButtonWidth,(I+1)*(fItemHeight Div 2));
    If ( I < length(fButton) ) and ( fButton[I].Highlighted ) Then Begin
       canvas.Brush.color:= ClWhite;
       Color2 := ClBlack;
    End else Begin
       canvas.Brush.color:= ClSilver;
       Color2 := ClBlack;
    End;
    canvas.FillRect(R);
    R.Left := R.Left + (fButtonWidth Div 2);
    Size := fButtonWidth Div 4;
    canvas.Brush.color:= Color2;
    If (I mod 2) = 0 Then Begin
      R.Top := R.Top + (fButtonWidth Div 4)+1;
      canvas.MoveTo(R.Left,R.Top);
      canvas.LineTo(R.Left-Size,R.Top+Size);
      canvas.LineTo(R.Left+Size,R.Top+Size);
      canvas.LineTo(R.Left,R.Top);
    End Else Begin
      R.Top := R.Bottom - (fButtonWidth Div 4)-1;
      canvas.MoveTo(R.Left,R.Top);
      canvas.LineTo(R.Left-Size,R.Top-Size);
      canvas.LineTo(R.Left+Size,R.Top-Size);
      canvas.LineTo(R.Left,R.Top);
    End;
 End;
End;

Procedure TDNDListBox.PreparePaint;
var R,R2:trect;
Var I : Integer;

 procedure PrintText(Y : Integer; S : String);
 Var L,T :  Integer;
 Begin
   L := (Bm.Width Div 2 ) - (bm.canvas.TextWidth(S) Div 2);
   if fShowNumberColumn Then L := L - (fNumberWidth Div 2);
   T := Y + (fItemHeight Div 2 ) - (bm.canvas.TextHeight(S) Div 2);
   bm.canvas.TextOut(L,T,S);
end;

 procedure PrintNumber(Y : Integer; N : Real);
 Var L,T :  Integer;
     S : String;
 Begin
   S := FloatToStrF(N, ffGeneral, 4,1);
   L := (Bm.Width) - (fNumberWidth div 2) - (bm.canvas.TextWidth(S) Div 2);
   T := Y + (fItemHeight Div 2 ) - (bm.canvas.TextHeight(S) Div 2);
   bm.canvas.TextOut(L,T,S);
end;

Var Item : TPrimalDNDObject;
    Count : Integer;
Begin
  If not Assigned(bm) Then Exit;
  Count := 0;
  R:=rect(0,0,bm.width,bm.height);
  bm.canvas.Brush.color:= clGray;
{  bm.canvas.FrameRect(R);}
  R:=rect(1,1,bm.width-1,bm.height-1);
  bm.canvas.Brush.color:= ClWhite;
  bm.canvas.FillRect(R);
  If Assigned(fList) Then Begin
    Count := (Bm.Height div fItemHeight);
    PageBottom := fList.Count - (Bm.Height Div fItemHeight);
    If PageBottom < 0 Then PageBottom := 0;
    If Count > fList.Count Then Count := fList.Count;
    For I := 0 To Count-1  Do begin
      if ( I+FScrollbar.Position > fList.Count-1 ) Then Continue;
      Item := TPrimalDNDObject(fList[I+FScrollbar.Position]);
      R2 := Rect(1,1+I*fItemHeight,bm.width-1,(I+1)*fItemHeight+1);
      if fShowNumberColumn Then R2.Right := R2.Right - fNumberWidth;
      if (I mod 2) = 0 Then
        bm.canvas.Brush.color:= $CCCCCC
      else
        bm.canvas.Brush.color:= $DDDDDD;

      if Item.fGroup<>fGroup Then
        bm.canvas.Brush.color:= $888888;

      if ( not Item.HasPrerequisites ) Then
         bm.canvas.Brush.color:= ClRed;

      bm.canvas.FillRect(R2);
      if Item.fDisabled Then bm.canvas.Pen.color := ClGray Else bm.canvas.Pen.color := ClWhite;

       if Item.fGroup<>fGroup Then
         bm.canvas.font.color := $BBBBBB
       Else
         bm.canvas.font.color := $000000;

      PrintText(I*FItemHeight, Item.Name);
      if fShowNumberColumn Then Begin
         if (I mod 2) = 0 Then
            bm.canvas.Brush.color:= $DDDDDD
         else
            bm.canvas.Brush.color:= $EEEEEE;

         if Item.fGroup<>fGroup Then
            bm.canvas.Brush.color:= $888888;

         R2 := Rect(bm.width-fNumberWidth-1,I*fItemHeight+1,bm.width-1,I*fItemHeight+fItemHeight+1);
         if ( not Item.HasPrerequisites ) Then
            bm.canvas.Brush.color:= ClRed;
         bm.canvas.FillRect(R2);

       if Item.fGroup<>fGroup Then
         bm.canvas.font.color := $BBBBBB
       Else
         bm.canvas.font.color := $000000;

        PrintNumber(I*FItemHeight, Item.DisplayValue);

     End;

      if fButtons Then Begin
         DrawButton((I*2));
         DrawButton((I*2)+1);
      End;

      if Assigned(FOnPaint) then Begin
        FOnPaint(Self, R2, Item);
      End;

    End;
  End;

  For I := Count-1 To (Bm.Height div fItemHeight) Do begin
    if fButtons Then Begin
       DrawButton((I*2));
       DrawButton((I*2)+1);
    End;
  End;

End;

Procedure TDNDListBox.Paint;
Var
  w,h : integer;
Begin
 If (not Assigned(Canvas)) or (not canFocus) or (not Assigned(bm)) Then Exit;
 w := clientWidth-FScrollbar.width-1;
 If fButtons Then W := W - fButtonWidth;
 h := ClientHeight;
 if bm.width<>w then bm.width:=w;
 if bm.height<>h then bm.height:=h;
 PreparePaint;
 canvas.draw(0,0,bm);
 FScrollbar.Min:=0;
 FScrollBar.Max := PageBottom;
 FScrollBar.Visible := True;
 FScrollBar.Enabled := PageBottom <> 0;
{ FScrollbar.Largechange := 1;}
End;

 Procedure TDNDListBox.SetGroup(I : Integer);
 Begin
  fGroup := I;
  Invalidate;
 End;

 Procedure Register;
 Begin
  RegisterComponents('Daan',[TDNDListBox]);
 End;

end.
