// HintX ver. 1.01 by Plamen R. Balkansky - plamenb@softhome.net
// -------------------------------------------------------------
// HintX is a multiline hint which position on the screen
// -------------------------------------------------------------
// can be changed. HintRows property is TStrings - it can be used
// -------------------------------------------------------------
// both run and design time. Caption at runtime contains the
// -------------------------------------------------------------
// Row with max length .
// -------------------------------------------------------------
// HintX is a freeware. If you wish to make any improvements please
// -------------------------------------------------------------
// send me the new version.

unit HintX;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  THintX = class(TGraphicControl)
  private
    FFocusControl: TWinControl;
    FAutoSize: Boolean;
    FHint: TStrings;
    procedure SetAutoSize(Auto: Boolean);
    procedure SetFocusControl(Value: TWinControl);
    procedure SetHintRows(Value: TStrings);
    function GetHintRows: TStrings;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure CMMouseEnter(var Msg: TMessage); message CM_MOUSEENTER;
  protected
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property HintRows: TStrings read GetHintRows write SetHintRows;
    property AutoSize: Boolean read FAutoSize write SetAutosize;
    property Caption;
    property Color;
    property FocusControl: TWinControl read FFocusControl write SetFocusControl;
    property Font;
    property ParentColor;
    property ParentFont;
  end;

procedure Register;

implementation

{ TDemoLabel }

constructor THintX.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FComponentStyle := FComponentStyle - [csInheritable];
  FHint := TStringList.Create;
  ParentColor := FALSE;
  Color := $00D2FFFF;
  Width := 50;
  Height := 18;
  FAutoSize := TRUE;
end;


procedure THintX.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = FFocusControl) then
    FFocusControl := nil;
end;

procedure THintX.SetFocusControl(Value: TWinControl);
begin
  FFocusControl := Value;
  Value.FreeNotification(Value);
end;

procedure THintX.SetAutoSize(Auto: Boolean);
begin
  FAutoSize := Auto;
end;

procedure THintX.SetHintRows(Value: TStrings);
begin
  FHint.Assign(Value);
  Paint;
end;

function THintX.GetHintRows: TStrings;
begin
  Result := FHint;
end;

procedure THintX.Paint;
var
  Rect: TRect;
  A: array[0..2] of TPoint;
  I: Integer;
  R: Integer; // number of rows to show;
  S: string; // hint row with max width
begin
  s := '';
  if FHint.Count > 0 then S := FHint.Strings[0];
  for i := 1 to FHint.Count - 1 do
    if Length(S) < Length(FHint.Strings[I]) then
      S := FHint.Strings[I];
  if (S = '') and (csDesigning in Self.ComponentState) then
  begin
    S := Self.Name;
    FHint.Add(S);
  end;
  R := FHint.Count;
  Caption := S;
  if AutoSize then
  begin
    Width := Canvas.TextWidth(S) + 4;
    Height := Canvas.TextHeight(S) * R + 2;
  end;
  Rect := ClientRect;
  Canvas.Font := Font;
  Canvas.Brush.Color := Color;
  Canvas.FillRect(Rect);
  Rect.Left := Rect.Left + 2;
  for i := 0 to FHint.Count - 1 do
  begin
    DrawText(Canvas.Handle, PChar(FHint.Strings[I]), Length(FHint.Strings[I]), Rect,
      DT_EXPANDTABS or DT_WORDBREAK or DT_LEFT);
    Rect.Top := Rect.Top + Canvas.TextHeight(S);
  end;
  Canvas.Pen.Color := $00ABABAB;
  A[0] := Point(0, Rect.Bottom);
  A[1] := Point(0, 0);
  A[2] := Point(Rect.Right, 0);
  Polyline(Canvas.Handle, A, 3);
  Canvas.Pen.Color := $0;
  A[0] := Point(Rect.Right - 1, 0);
  A[1] := Point(Rect.Right - 1, Rect.Bottom - 1);
  A[2] := Point(0, Rect.Bottom - 1);
  Polyline(Canvas.Handle, A, 3);
end;

procedure THintX.CMDialogChar(var Message: TCMDialogChar);
begin
  if (FFocusControl <> nil) and Enabled and
    IsAccel(Message.CharCode, Caption) then
    with FFocusControl do
      if CanFocus then
      begin
        SetFocus;
        Message.Result := 1;
      end;
end;

procedure THintX.CMTextChanged(var Message: TMessage);
begin
  inherited;
  Invalidate;
end;

procedure THintX.CMMouseEnter(var Msg: TMessage);
begin
  inherited;
  Hide;
end;

procedure Register;
begin
  RegisterComponents('Additional', [THintX]);
end;

end.

