unit HintPanel;
(* HintPanel V1.0
 Note: This is freeware you may do what you like with it, but not to sell it for
 for a profit. If you have any questions please email me at Hiq2q@aol.com
 Creator: F. Joe Darley

Description:
 This Hint panel is used to display a myriad of font styles, colors, font effects,
 and display effects to the hints of your application(s). Note this component
 will be displayed on your samples pallet in your Delphi's IDE.  This Component
 is Delphi 3.x and 4.x compatable.

Properties:
  Duration: (is a long integer property) This property is used to tell the
    Hint Panel how long to display the Hint in milliseconds 2000 is the default
    Which is 2 seconds.
  ShowComponentHint: (is a Boolean property) This property is used to tell the
    Hint Panel to display the Hint of a control.

Method:
  Display:(This Method uses an object parameter). This method is used to have the
     Hint panel to gain access of the controls Hint and to display it.
     Example.

      Procedure TForm1.Button1Enter (Sender: TObject);
      Begin
         HintPanel1.Display (sender);
      End;

*)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type


  THintPanel = class(TPanel)
  private
   TimHint:TTimer;
   fShowComponentHint:boolean;
   fDuration:LongInt;
   procedure  ShowAHint(x : integer;  y : integer; Caption2 : string; fDuration : LongInt;
                           comp:TwinControl);
   procedure TimeEnd(sender:Tobject);
    { Private declarations }
  protected
   property Color default clWindow;
    { Protected declarations }
  public
   constructor Create(AOwner: TComponent); override;
   procedure Display(sender:Tobject);
    { Public declarations }
  published

   property ShowComponentHint :boolean read fShowComponentHint write fShowComponentHint;
   property Duration:longint read fduration write fduration default 2000;
    { Published declarations }
  end;

procedure Register;

implementation
{$R Hint.DCR}

constructor THintPanel.Create(AOwner: TComponent);
begin
  Inherited;
  TimHint := TTimer.Create(Self);
  TimHint.Enabled := False;
  ShowComponentHint := true;
  Duration:=2000;
  timHint.OnTimer := TimeEnd;
  visible:=false;
  Font.Color :=clred;
  Font.Style := [fsBold];
  Color:=clWhite;
end;

procedure THintPanel.TimeEnd(sender:Tobject);
begin
if Visible <> false then
   Visible := false;
   timHint.Enabled := false;
end;

procedure THintPanel.Display(sender:Tobject);
var
PO:Tpoint;
begin
 if ShowComponentHint then begin
  Application.ProcessMessages;
         PO:= Twincontrol(sender).ClientOrigin;
ShowAHint(PO.X +(TWinControl(Sender).width div 4),
           PO.Y + TWinControl(Sender).Height + 6,
            TWinControl(Sender).Hint,
            duration,TWinControl(Sender));
  end;
end;

procedure THintPanel.ShowAHint(x : integer; y : integer; Caption2 : string;
                           fDuration : LongInt;
                           comp:TwinControl);
var
  dc : hdc;
  OldFont : hFont;
  pt : TSize;
  p : pChar;
  rt:TPoint;
  comp2,Comp1:Twincontrol;
begin

   comp2:= comp.parent;
 while comp2.Parent <> nil do begin     //loop to find the main parent
        Comp1:= comp2.Parent;
        if Comp1.parent <> nil then
         comp2:= comp1.parent
        else
         break;

 end;
    if Comp2.Parent <> nil then begin //gets the main parent and assigns panel to it
       parent:= comp2.Parent;
       rt:= comp1.ClientOrigin;
       end
    else begin
         rt := comp2.ClientOrigin;
         parent:= comp1.Parent
       end;

  if timHint.Enabled <> false then
    timHint.Enabled := false;
  timHint.Enabled := false;
  if Visible <> false then
     Visible := false;
  if Caption2 = '' then exit;
     Caption := caption2;
 {Get the width of the caption string}
  GetMem(p, Length(Caption) + 1);
  StrPCopy(p, Caption);
  dc := GetDc(Handle);
  OldFont := SelectObject(dc,Font.Handle);
  GetTextExtentPoint32(dc, p, Length(Caption), pt);
  SelectObject(dc, OldFont);
  ReleaseDc(Handle, Dc);
  FreeMem(p, Length(Caption) + 1);
 {Position and show the panel}

  Left := x- rt.x;
  Top :=  y - rt.y;
  Width := pt.cx + 6;
  Height := pt.cy + 4;
 if duration  <> 0 then  begin
  Visible := true;
  BringToFront;
  end;
 {Fire off the timer to hide the panel}

  timHint.Interval := Duration;
  timHint.Enabled := true;

end;



procedure Register;
begin
  RegisterComponents('Samples', [THintPanel]);
end;

end.
