unit FrmSpellLevelEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DNDSpells, StdCtrls, ExtCtrls;

type
  TSpellLevelEditor = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Label1: TLabel;
    ComboBox3: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
  private
    { Private declarations }
  public
    fLevel : TSpellLevel;
    Procedure SetLevel(Level : TSpellLevel);
    Procedure LevelToEdit;
    Procedure EditToLevel;
    { Public declarations }
  end;

var
  SpellLevelEditor: TSpellLevelEditor;

implementation

Uses DNDWorld, DNDClasses;

{$R *.DFM}

Procedure TSpellLevelEditor.SetLevel(Level : TSpellLevel);
Begin
 fLevel := level;
 LevelToEdit;
End;

Procedure TSpellLevelEditor.LevelToEdit;
Begin
  ComboBox3.ItemIndex := fLevel.Level;
  if ( fLevel.BaseClass <> nil ) or ( fLEvel.Domain = '') Then Begin
    RadioButton1.Checked := True;
    if ( fLevel.BaseClass <> nil ) Then
      Combobox1.ItemIndex := Combobox1.Items.IndexOf(fLevel.BaseClass.Name);
  End Else Begin
    RadioButton2.Checked := True;
    Combobox2.ItemIndex := Combobox2.Items.IndexOf(fLevel.Domain);
  End;
End;

Procedure TSpellLevelEditor.EditToLevel;
Begin
  fLevel.Level := Combobox3.ItemIndex;
  if RadioButton1.Checked Then Begin
    fLevel.BaseClass := TBaseClass(ComboBox1.Items.Objects[Combobox1.ItemIndex]);
    fLevel.Domain := '';
  End Else Begin
    fLevel.BaseClass := nil;
    fLevel.Domain := Combobox2.Items[Combobox2.ItemIndex];
  End;
End;

procedure TSpellLevelEditor.FormCreate(Sender: TObject);
Var I : Integer;
begin
 Combobox1.Clear;
 Combobox2.Clear;
 For I := 0 To World.Classes.Count-1 Do
   ComBoBox1.Items.Addobject(World.Classes[I].Name,World.Classes[I]);
 For I := 0 To World.Domains.Count-1 Do
   ComBoBox2.Items.Add(World.Domains[I].Name);
 Combobox1.ItemIndex := 0;
 Combobox2.ItemIndex := 0;
end;

procedure TSpellLevelEditor.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
EditToLevel;
end;

procedure TSpellLevelEditor.ComboBox1Change(Sender: TObject);
begin
 RadioButton1.Checked := True;
end;

procedure TSpellLevelEditor.ComboBox2Change(Sender: TObject);
begin
  RadioButton2.Checked := True;
end;

end.
