unit FrmSpellImporter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DNDSpells;

type
  TSpellImporter = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
   Spell : TBaseSpell;
    { Public declarations }
   Procedure ImportFile(FileName : String);
   Procedure HandleComponents(S : String);
   Procedure HandleLevel(S : String);
   Procedure HandleSave(S : String);
   Procedure HandleResistance(S : String);
  end;

var
  SpellImporter: TSpellImporter;

implementation

Uses DNDWorld;

{$R *.DFM}

Function IsNewSpell(S : String) : Integer;
Var I : Integer;
Begin
 Result := 0;
 For I := 1 To TOTALSCHOOLS Do If ( Pos(Schools[I],S) = 1 ) Then Result := I;
End;

Function Key ( S: String) : String;
Var A : Integer;
Begin
 A := Pos(':',S);
 if ( A < 0 ) Then Begin
   Result := '';
   Exit;
 End;
 Result := Lowercase(Copy(S,1,A-1));
End;

Function Value ( S: String) : String;
Var A : Integer;
Begin
 A := Pos(':',S);
 if ( A < 0 ) Then Begin
   Result := '';
   Exit;
 End;
 Result := Lowercase(Copy(S,A+1,1024));
End;

Procedure TSpellImporter.HandleLevel(S : String);
Var Key,Value : String;
   AtKey : Boolean;
   I : Integer;


   Procedure AddNext(Key,VAlue : String);
   Var SpellLevel : TSPellLevel;
      I : Integer;
   Begin
    For I := 0 To World.Domains.Count-1 Do If Lowercase(World.Domains[I].Name) = Key Then Begin
       SpellLevel := TSpellLevel.Create;
       SpellLevel.Domain := World.Domains[I].Name;
       SpellLevel.Level := StrToInt(Value);
       Spell.SpellLevels.Add(SpellLEvel);
    End;
    if (  Key = 'clr' ) Then Begin
       SpellLevel := TSpellLevel.Create;
       SpellLevel.BaseClass := World.AddClass('Cleric');
       SpellLevel.Level := StrToInt(Value);
       Spell.SpellLevels.Add(SpellLEvel);
    End;
    if (  Key = 'drd' ) Then Begin
       SpellLevel := TSpellLevel.Create;
       SpellLevel.BaseClass := World.AddClass('Druid');
       SpellLevel.Level := StrToInt(Value);
       Spell.SpellLevels.Add(SpellLEvel);
    End;
    if (  Key = 'rgr' ) Then Begin
       SpellLevel := TSpellLevel.Create;
       SpellLevel.BaseClass := World.AddClass('Ranger');
       SpellLevel.Level := StrToInt(Value);
       Spell.SpellLevels.Add(SpellLEvel);
    End;
    if (  Key = 'brd' ) Then Begin
       SpellLevel := TSpellLevel.Create;
       SpellLevel.BaseClass := World.AddClass('Bard');
       SpellLevel.Level := StrToInt(Value);
       Spell.SpellLevels.Add(SpellLEvel);
    End;
    if (  Key = 'sor/wiz' ) Then Begin
       SpellLevel := TSpellLevel.Create;
       SpellLevel.BaseClass := World.AddClass('Sorcerer');
       SpellLevel.Level := StrToInt(Value);
       Spell.SpellLevels.Add(SpellLEvel);
       SpellLevel := TSpellLevel.Create;
       SpellLevel.BaseClass := World.AddClass('Wizard');
       SpellLevel.Level := StrToInt(Value);
       Spell.SpellLevels.Add(SpellLEvel);
    End;
   End;


Begin
 AtKey := True;
 S := Trim(S);
 For I := 1 To Length(S) Do Begin
   If ( S[I] ) = ' ' Then AtKey := not AtKey
   Else If ( S[I] ) = ',' Then Begin AddNext(Key,Value); AtKey := False; Key := ''; Value := ''; End
   Else Begin
      If AtKey Then Key := Key + S[I] Else Value := Value + S[I];
   End;
 End;
 If LEngth(Key ) > 0 Then
 AddNext(Key,Value);

End;

Procedure TSpellImporter.HandleSave(S : String);
Begin
 if Pos( '(object)',S) <> 0 Then Inc(Spell.SaveFlags,1);
 if Pos( '(harmless)',S) <> 0 Then Inc(Spell.SaveFlags,2);
 if Pos( 'none',S) <> 0 Then Spell.Save := 0;
 if Pos( 'partial',S) <> 0 Then Spell.Save := 1;
 if Pos( 'half',S) <> 0 Then Spell.Save := 2;
 if Pos( 'negates',S) <> 0 Then Spell.Save := 3;
 if Pos( 'disbelief',S) <> 0 Then Spell.Save := 4;
 if Pos( 'see text',S) <> 0 Then Spell.Save := 5;

 Spell.SaveStat := 0;
 if Pos( 'fort',S) <> 0 Then Spell.SaveStat := 1;
 if Pos( 'ref',S) <> 0 Then Spell.SaveStat := 2;
 if Pos( 'will',S) <> 0 Then Spell.SaveStat := 3;
End;

Procedure TSpellImporter.HandleResistance(S : String);
Begin
 if Pos( '(object)',S) <> 0 Then Inc(Spell.MrFlags,1);
 if Pos( '(harmless)',S) <> 0 Then Inc(Spell.MrFlags,2);

 if Pos( 'no',S) <> 0 Then Spell.Mr := 0;
 if Pos( 'yes',S) <> 0 Then Spell.Mr := 1;
 if Pos( 'see text',S) <> 0 Then Spell.Mr := 2;
End;

Procedure TSpellImporter.HandleComponents(S : String);
Begin
  if Pos( 'v', s) <> 0 Then Inc(Spell.Components,1);
  if Pos( 's', s) <> 0 Then Inc(Spell.Components,2);
  if Pos( 'm', s) <> 0 Then Inc(Spell.Components,4);
  if Pos( ' f', s) <> 0 Then Inc(Spell.Components,8);
  if Pos( 'df', s) <> 0 Then Inc(Spell.Components,16);
  if Pos( 'xp', s) <> 0 Then Inc(Spell.Components,32);
End;

Procedure TSpellImporter.ImportFile(FileName : String);
Var F : TextFile;
    S : String;
    LastS : String;
    ke,Va : String;
Begin
 Spell := nil;
 AssignFile(F,FileName);
 Reset(F);
 Try
  S := '';
  While not EOF(F) Do Begin
    LastS := S;
    ReadLn(F,S);
    if ( IsNewSpell(S) > 0 ) Then Begin
       Spell := World.AddSpell(LastS);
       Spell.MageSchool := Schools[IsNewSpell(S)];
    End;

    Ke := Key(S);
    Va := Value(S);

    If ( Ke = 'level') Then HandleLevel(Va);
    If ( Ke = 'components') Then HandleComponents(Va);
    If ( Ke = 'saving throw') Then HandleSave(Va);
    If ( Ke = 'spell resistance') Then HandleResistance(Va);
    
    If ( Ke = 'casting time') Then Spell.CastingTime := Va;
    If ( Ke = 'range') Then Spell.CastingTime := Va;
    If ( Ke = 'area') Then Spell.Area := Va;
    If ( Ke = 'duration') Then Spell.Duration := Va;
    If ( Ke = 'target') Then Spell.Target := Va;
    If ( Ke = 'effect') Then Spell.effect := Va;
{    Level: Clr 2
    Components: V, S, M, DF
    Casting Time: 1 action
    Range: Close (25 ft. + 5 ft./2 levels)
    Area: 20-ft.-radius emanation
    Duration: 2 hours/level
    Saving Throw: None
    Spell Resistance: No }

  End;
 Finally
  CloseFile(F);
 End;
End;

procedure TSpellImporter.FormCreate(Sender: TObject);
begin
  ImportFile(ExtractFileDir(ParamstR(0))+'\spells.txt');
end;

end.
