unit FrmSpellEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DNDSpells, FrmAffectedEditor, ComCtrls, Menus,
  CheckLst;

type
  TSpellEditor = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Button2: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    ListView1: TListView;
    PopupMenu1: TPopupMenu;
    Add1: TMenuItem;
    N1: TMenuItem;
    Delete1: TMenuItem;
    SpellSchoolSelector: TComboBox;
    Label28: TLabel;
    CheckListBox1: TCheckListBox;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    Edit2: TEdit;
    Label4: TLabel;
    Edit3: TEdit;
    Label5: TLabel;
    Edit4: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    Edit5: TEdit;
    Label8: TLabel;
    Edit6: TEdit;
    Label9: TLabel;
    Edit7: TEdit;
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ListView1DblClick(Sender: TObject);
    procedure Add1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    fSpell : TBaseSpell;
    Procedure SetSpell(Spell : TBaseSpell);
    Procedure SpellToEdit;
    Procedure EditToSpell;
    Procedure SpellDomainClassToEdit;
  end;

var
  SpellEditor: TSpellEditor;

implementation

Uses FrmSpelllevelEditor;


{$R *.DFM}

Procedure TSpellEditor.SetSpell(Spell : TBaseSpell);
Begin
 fSpell := Spell;
 SpellToEdit;
End;

Procedure TSpellEditor.SpellToEdit;
Var I : Integer;
Begin
 Edit1.Text := fSpell.Name;
 if ( fSpell.MageSchool <> '' ) Then Begin
   I := SpellSchoolSelector.Items.IndexOf(fSpell.mageSchool);
 End Else I := -1;
 If ( I = -1 ) Then I := 0;
 SpellSchoolSelector.ItemIndex := I;
 SpellDomainClassToEdit;
 ComboBox1.ItemIndex := fSpell.Save;
 ComboBox2.ItemIndex := fSpell.SaveStat;
 CheckBox1.Checked := (fSpell.SaveFlags and 1 ) > 0 ;
 CheckBox2.Checked := (fSpell.SaveFlags and 2 ) > 0 ;
 ComboBox3.ItemIndex := fSpell.Mr;
 CheckBox3.Checked := (fSpell.MrFlags and 1 ) > 0 ;
 CheckBox4.Checked := (fSpell.MrFlags and 2 ) > 0 ;

 For I := 0 To 5 Do Begin
   CheckListBox1.Checked[I] := (fSpell.Components and (1 shl I)) <> 0;
 End;

 ComboBox1Change(nil);

Edit2.Text := fSpell.CastingTime;
Edit3.Text := fSpell.Range;
Edit4.Text := fSpell.Area;
Edit5.Text := fSpell.Duration;
Edit6.Text := fSpell.Target;
Edit7.Text := fSpell.Effect;
{ Components := Stream.ReadInteger;}

End;

Procedure TSpellEditor.EditToSpell;
Var I : Integer;
   Al : INteger;
Begin
 fSpell.Name := Edit1.Text;
 fSpell.MageSchool := SpellSchoolSelector.Items[SpellSchoolSelector.ItemIndex];
 fSpell.Save := ComboBox1.ItemIndex;
 fSpell.SaveStat := ComboBox2.ItemIndex;
 fSpell.SaveFlags := 0;
 If CheckBox1.Checked Then Inc(fSpell.SaveFlags,1);
 If CheckBox2.Checked Then Inc(fSpell.SaveFlags,2);
 fSpell.Mr := ComboBox3.ItemIndex;
 fSpell.MrFlags := 0;
 If CheckBox3.Checked Then Inc(fSpell.MrFlags,1);
 If CheckBox4.Checked Then Inc(fSpell.MrFlags,2);

 Al := 0;
 For I := 0 To 5 Do Begin
   if CheckListBox1.Checked[I] Then Inc(Al,1 shl I);
 End;

 fSpell.Components := Al;

 fSpell.CastingTime:= Edit2.Text;
 fSpell.Range:= Edit3.Text;
 fSpell.Area:= Edit4.Text;
 fSpell.Duration:= Edit5.Text;
 fSpell.Target:= Edit6.Text;
 fSpell.Effect:= Edit7.Text;

End;

procedure TSpellEditor.Button2Click(Sender: TObject);
Var Win : TAffectEditor;
begin
  Win := TAffectEditor.Create(Self);
  Try
    Win.SetAffect(fSpell);
    Win.Caption := 'Spell Affect Editor - Redblade 3e';
    Win.ShowModal;
  Finally
    Win.Free;
  End;
end;

Procedure TSpellEditor.SpellDomainClassToEdit;
var LI : TListItem;
    I : Integer;
Begin
 ListView1.Items.Clear;
 For I := 0 To fSpell.SpellLevels.Count-1 Do Begin
   LI := Listview1.Items.Add;
   LI.Data := fSpell.SpellLevels[I];
   If fSpell.SpellLevels[I].BaseClass <> nil Then
     LI.Caption := fSpell.SpellLevels[I].BaseClass.Name
   Else
     LI.Caption := 'Domain: '+fSpell.SpellLevels[I].Domain;

   LI.SubItems.Add(IntToStr(fSpell.SpellLevels[I].Level));
 End;
End;


procedure TSpellEditor.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 EditToSpell;
end;

procedure TSpellEditor.ListView1DblClick(Sender: TObject);
Var Win : TSpellLevelEditor;
begin
  if ListView1.Selected = nil then exit;
  Win := TSpellLevelEditor.Create(Self);
  Try
    Win.SetLevel(TSpellLevel(ListView1.Selected.Data));
    Win.ShowModal;
    SpellDomainClassToEdit;
  Finally
    Win.Free;
  End;
end;

procedure TSpellEditor.Add1Click(Sender: TObject);
Var Li : TListItem;
begin
 Li := ListView1.Items.Add;
 Li.Caption := '';
 Li.SubItems.Add('');
 Li.Data := TSpellLevel.Create;
 fSpell.SpellLevels.Add(Li.Data);
 ListView1.Selected := Li;
 ListView1DblClick(Self);
end;

procedure TSpellEditor.Delete1Click(Sender: TObject);
Var Item : TObject;
begin
 if ListView1.Selected <> nil Then Begin
   Item := ListView1.Selected.Data;
   fSpell.SpellLevels.Extract(Item);
   TSpellLEvel(Item).Free;
   ListView1.Selected.Delete;
 End;
end;

procedure TSpellEditor.FormCreate(Sender: TObject);
Var I :Integer;
begin
 For I := 1 To TOTALSCHOOLS Do
   SpellSchoolSelector.Items.Add(Schools[I]);
 PageControl1.ActivePage := TabSheet1;
end;

procedure TSpellEditor.FormShow(Sender: TObject);
begin
 if Edit1.CanFocus Then Edit1.SetFocus;
end;

procedure TSpellEditor.ComboBox1Change(Sender: TObject);
begin
 Combobox2.Enabled := not (Combobox1.ItemIndex in [0,5]);
end;

end.

