unit FrmSkillEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DNDObjects, FrmAffectedEditor, ComCtrls,
  UniDndListbox, Menus;

type
  TSkillEditor = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Button2: TButton;
    Label3: TLabel;
    ComboBox1: TComboBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    TabSheet3: TTabSheet;
    SkillOverview: TDNDListBox;
    SynergySkills: TDNDListBox;
    TabSheet2: TTabSheet;
    ListBox1: TListBox;
    PopupMenu1: TPopupMenu;
    Add1: TMenuItem;
    N1: TMenuItem;
    Delete1: TMenuItem;
    Edit1: TEdit;
    Label1: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure SkillOverviewSelect(Control: TWinControl; Item: TDNDObject);
    procedure SynergySkillsSelect(Control: TWinControl; Item: TDNDObject);
    procedure Add1Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    fSkill : TBaseSkill;
    Procedure SetSkill(Skill : TBaseSkill);
    Procedure SkillToEdit;
    Procedure EditToSkill;
    { Public declarations }
  end;

var
  SkillEditor: TSkillEditor;

implementation

{$R *.DFM}

Uses DNDWorld, FrmParameterEditor;

Procedure TSKillEditor.SkillToEdit;
Begin
 SynergySkills.List := fSkill.Synergy;
 SkillOverview.List := World.Skills;
 Combobox1.ItemIndex := fSkill.PrimeAbility;
 CheckBox1.Checked := fSkill.ArmorCheckPenalty;
 CheckBox2.Checked := fSkill.TrainedOnly;
 Edit1.Text := fSkill.name;
 ListBox1.Items.Assign(fSkill.Parameters);
End;

Procedure TSkillEditor.EditToSkill;
Begin
 fSkill.Name := Edit1.Text;
 fSkill.PrimeAbility := Combobox1.ItemIndex;
 fSkill.ArmorCheckPenalty := CheckBox1.Checked;
 fSkill.TrainedOnly := CheckBox2.Checked;
End;

Procedure TSkilLEditor.SetSkill(Skill : TBaseSkill);
Begin
 fSkill := Skill;
 SkillToEdit;
End;

procedure TSkillEditor.Button2Click(Sender: TObject);
Var Win : TAffectEditor;
begin
  Win := TAffectEditor.Create(Self);
  Try
    Win.SetAffect(fSkill);
    Win.Caption := 'Skill Affect Editor - Redblade 3e';
    Win.ShowModal;
  Finally
    Win.Free;
  End;
end;

procedure TSkillEditor.SkillOverviewSelect(Control: TWinControl;
  Item: TDNDObject);
begin
  If ( Item <> nil ) Then
   if fSkill.Synergy.IndexOf(Item) = -1 Then
      fSkill.Synergy.Add(Item);
  SynergySkills.Invalidate;
end;

procedure TSkillEditor.SynergySkillsSelect(Control: TWinControl;
  Item: TDNDObject);
begin
  If ( Item <> nil ) Then
  fSkill.Synergy.Extract(Item);
  SynergySkills.Invalidate;
end;

procedure TSkillEditor.Add1Click(Sender: TObject);
begin
  fSkill.Parameters.Add('Empty');
  ListBox1.ItemIndex := ListBox1.Items.Add('Empty');
  ListBox1DblClick(Self);
end;

procedure TSkillEditor.ListBox1DblClick(Sender: TObject);
Var Win : TParameterEditor;
begin
   if ListBox1.ItemIndex = -1 Then Exit;
   Win := TParameterEditor.Create(Self);
   Try
     Win.Edit1.Text := ListBox1.Items[ListBox1.ItemIndex];
     fSkill.Parameters.Delete(ListBox1.ItemIndex);
     ListBox1.Items.Delete(ListBox1.ItemIndex);
     Win.ShowModal;
     ListBox1.Items.Add(Win.Edit1.Text);
     fSkill.Parameters.Add(Win.Edit1.TExt);
   Finally
     Win.Free;
   End;
end;

procedure TSkillEditor.Delete1Click(Sender: TObject);
begin
  if ListBox1.ItemIndex = -1 Then Exit;
  fSkill.Parameters.Delete(ListBox1.ItemIndex);
  ListBox1.Items.Delete(ListBox1.ItemIndex);
end;

procedure TSkillEditor.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
EditToSkill;
end;

procedure TSkillEditor.FormShow(Sender: TObject);
begin
 PageControl1.ActivePage := TabSheet1;
 If Edit1.CanFocus Then Edit1.SetFocus;
end;

end.
