unit FrmPrint;

interface

uses
  WinProcs, WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Preview, ComCtrls, Buttons, ToolWin;

type
  TPrintForm = class(TForm)
    PrintPreview1: TPrintPreview;
    Image1: TImage;
    ToolBar1: TToolBar;
    Shape1: TShape;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    BtnClose: TSpeedButton;
    BtnPrint: TSpeedButton;
    BtnScreenZoom: TSpeedButton;
    SizeSelector: TComboBox;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    PagePanel: TPanel;
    BtnPrev: TSpeedButton;
    BtnPage1: TSpeedButton;
    BtnPage2: TSpeedButton;
    BtnPage3: TSpeedButton;
    BtnPage4: TSpeedButton;
    BtnPage5: TSpeedButton;
    BtnPage6: TSpeedButton;
    BtnPage7: TSpeedButton;
    BtnPage8: TSpeedButton;
    BtnPage9: TSpeedButton;
    BtnNext: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure PrintPreview1Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure BtnCloseClick(Sender: TObject);
    procedure SizeSelectorChange(Sender: TObject);
    procedure BtnScreenZoomClick(Sender: TObject);
    procedure BtnPrintClick(Sender: TObject);
    procedure BtnPage1Click(Sender: TObject);
    procedure BtnNextClick(Sender: TObject);
    procedure BtnPrevClick(Sender: TObject);
  private
    { Private declarations }
  public
    Procedure Template;
    Procedure UpdateCaption;
    { Public declarations }
  end;

var
  PrintForm: TPrintForm;

implementation

{$R *.DFM}

Procedure TPrintForm.Template;

  Procedure ItemOut(XOffset, YOffset : Integer);
  Begin
    With PrintPreview1.Canvas Do Begin
      Pen.Color := CLGray;
      Pen.Style := PsSolid;
      Pen.Width := 4;
      MoveTo(XOffset,YOffset);
      LineTo(Xoffset+100,YOffset);
      PrintPreview1.Canvas.TextOut(XOffset,YOffset,'Item '+IntToStr(YOffset));
    End;
  End;

var R : TRect;
    I,J : Integer;
Begin
  R := PrintPreview1.Pagerect;
  PrintPreview1.Units := mmLoMetric;
{ PrintPreview1.Canvas.BRush.Color := CLSilver;
  PrintPreview1.Canvas.Pen.Color := CLBlack;
  PrintPreview1.Canvas.Pen.Style := PsSolid;
  PrintPreview1.Canvas.Pen.Width := 4;
  PrintPreview1.Canvas.Ellipse(R.Left,R.Top,R.Right,R.Bottom);
  PrintPreview1.Canvas.FillRect(Rect(R.Left,R.Top,R.Left+200,R.Top+200));
  PrintPreview1.Canvas.LineTo(R.Left+100,R.Top);
  PrintPreview1.Canvas.LineTo(R.Left+100,R.Top+100);
  PrintPreview1.Canvas.LineTo(R.Left,R.Top+100);
  PrintPreview1.Canvas.LineTo(R.Left,R.Top);
  PrintPreview1.Canvas.TextOut(R.Left,R.Top,'Banana');}
  For I := 0 To 20 Do Begin
    PrintPreview1.Canvas.MoveTo(I*100,0);
    PrintPreview1.Canvas.LineTo(I*100+random(120),2900);
  End;
  For J := 0 To 29 Do Begin
    PrintPreview1.Canvas.MoveTo(0,J*100+random(120));
    PrintPreview1.Canvas.LineTo(2100,J*100);
  End;
End;

procedure TPrintForm.FormCreate(Sender: TObject);
begin
  with PrintPreview1 do
  begin
    BeginDoc;
    Template;
    NewPage;
    Template;
    NewPage;
    Template;
    EndDoc;
  end;
  ActiveControl := PrintPreview1;
  SizeSelector.ItemIndex := 9;
{  ComboBox1.ItemIndex := 5;}
end;

Procedure TPrintForm.UpdateCaption;
Begin
 Caption := 'Preview - ('+IntToStr(PrintPreview1.CurrentPage)+'/'+IntToStr(PrintPreview1.TotalPages)+')';
End;

procedure TPrintForm.PrintPreview1Change(Sender: TObject);
var TotalPages : integer;
begin
 UpdateCaption;
 TotalPages := PrintPreview1.TotalPages;
 Case PrintPreview1.CurrentPage of
    1 : BtnPage1.Down := True;
    2 : BtnPage2.Down := True;
    3 : BtnPage3.Down := True;
    4 : BtnPage4.Down := True;
    5 : BtnPage5.Down := True;
    6 : BtnPage6.Down := True;
    7 : BtnPage7.Down := True;
    8 : BtnPage8.Down := True;
    9 : BtnPage9.Down := True;
 End;
 PagePanel.Visible := TotalPages > 1;
 BtnNext.Left := BtnPrev.Width * (TotalPages+1);
 ToolButton4.Visible := TotalPages > 1;
 BtnPage2.Visible := TotalPages > 1;
 BtnPage3.Visible := TotalPages > 2;
 BtnPage4.Visible := TotalPages > 3;
 BtnPage5.Visible := TotalPages > 4;
 BtnPage6.Visible := TotalPages > 5;
 BtnPage7.Visible := TotalPages > 6;
 BtnPage8.Visible := TotalPages > 7;
 BtnPage9.Visible := TotalPages > 8;
{  if PrintPreview1.CurrentPage <> 0 then
  begin
    with PrintPreview1 do
      Label3.Caption := Format('Page %d of %d', [CurrentPage, TotalPages]);
    Label3.Update;
  end
  else
    Label3.Caption := 'Empty';}
end;

procedure TPrintForm.Button3Click(Sender: TObject);
begin
 PrintPreview1.CurrentPage := PrintPreview1.CurrentPage +1;
end;

procedure TPrintForm.Button4Click(Sender: TObject);
begin
 PrintPreview1.CurrentPage := PrintPreview1.CurrentPage -1;
end;

procedure TPrintForm.BtnCloseClick(Sender: TObject);
begin
 Close;
end;

procedure TPrintForm.SizeSelectorChange(Sender: TObject);
begin
  case SizeSelector.ItemIndex of
    0: PrintPreview1.Zoom := 500;
    1: PrintPreview1.Zoom := 200;
    2: PrintPreview1.Zoom := 150;
    3: PrintPreview1.Zoom := 100;
    4: PrintPreview1.Zoom := 75;
    5: PrintPreview1.Zoom := 50;
    6: PrintPreview1.Zoom := 25;
    7: PrintPreview1.Zoom := 10;
    8: PrintPreview1.ZoomState := zsZoomToWidth;
    9: PrintPreview1.ZoomState := zsZoomToFit;
  end;
  ActiveControl := PrintPreview1;
end;

procedure TPrintForm.BtnScreenZoomClick(Sender: TObject);
begin
 SizeSelector.ItemIndex := 9;
 SizeSelectorChange(Self);
 ActiveControl := PrintPreview1;
end;

procedure TPrintForm.BtnPrintClick(Sender: TObject);
begin
{  if PrintPreview1.State = psReady then
    PrintPreview1.Print;
  ActiveControl := PrintPreview1;}
  Close;
end;

procedure TPrintForm.BtnPage1Click(Sender: TObject);
begin
 PrintPreview1.CurrentPage := TComponent(Sender).Tag;
end;

procedure TPrintForm.BtnNextClick(Sender: TObject);
begin
 PrintPreview1.CurrentPage := PrintPreview1.CurrentPage +1;
end;

procedure TPrintForm.BtnPrevClick(Sender: TObject);
begin
 PrintPreview1.CurrentPage := PrintPreview1.CurrentPage -1;
end;

end.
