unit FrmMain;

{

  I finally

  Version 0.2b:
  --------------
  + Expanded the Laboratory to allow creation of magical armors,
    shields and weapons. (For example, turn a 'dagger' into a 'Vorpal Dagger +1'
    or a 'Leather Armor' into a 'Shadow Leather Armor +2'
  + Added a character preview window.
  * Humans had one skillpoint too much, Fixed.
  * Humans had one feat too much, Fixed.
  * Fixed 'Mega Initiative' bug.
  * Fixed Learned feats and Bonus feats not recognising each other.
  * Fixed bugs with automatic feats being selectable more than once.
  * Fixed several spelling errors.
  * Fixed several updating problems.
  * Added 'projectile' item group, containing projectiles for weapons.

  Planned:
  -------------
  + Tweaking the Sword & Fist Classes
  + Adding the other sourcebooks (Masters of the Wild, etc.)
  + Adding the DMG prestigeclasses and races.
  + Export to .RTF file (with some layout)






==










  -------------------


  Version 2:
  - Ranger selecting favorite enemies.
  - Selecting Deities
  - Length, Weight, Appearance?
  - Synergy bonuses are currently igonored
  - move 'bonus affects' for feats from the 'base' field to the 'misc' field
    (for example: Fort, Ref, Will, Improved Fortitude )
  - Gold -> Sworfs! Allow DM to modify the word for 'gold'. :)
  - No place to see HP or attack rolls.
  - History generation 'was renowned for his skill at move-silently'
    make the history more alignment prone
  - Hitpoint reroll function.
  - Class Specific Selections of Parameters. (For example a rangers favoried enimy)
  - 'Additional Tasks' lists. Shows what players need to do to the character
    sheet

  Missing Functionality:
  - Shield equipping
  - Improved Critical (Still uses weapon1-weapon5)
  - Point blank shot
  - Prestege classes...
  - Check ALL feats of ALL additional books and check if any part of the
    character generator is affected.
  - Lightning Fists: Monk level 4+
  - Mantis Leap: Monk Level 7+
  - Reevaluate: Monkey Grip
  - Calculate extra attacks with BAB for prestige classes
  - Ghostwalker, Knowledge: Law
  - Halfling outrider: Doesn't get a BAB bonus? :/
  - Check all prestige classes for extra items and weapon proficiencies.
  - Add 'Sword and Fist' equipment.


  Required Support:

  equipment <name>
  - Equipment masterwork heavy armor and masterwork large shield.
  - Weapon Focus (Any melee Weapon)
  - Spiked Gauntlet weapon proficiency
  - Perform OR intimidate, 4 ranks.
  - Must have at least two feats from the list of fighter bonus feats
  - Ability to cast 7 differnet divinations, one of which must be 3rd level or higher.
  - Two Knowledge Skills (Any Type)
  - Any threemetamagic or item creation feats, plu s skill focus (Knowledge[Any])
  - Ability to cast spells without preparation
  - Ability to turn undead
  - Access to a specific domain



}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DNDCharacter, DNDWorld, DNDClasses, DNDSpells, DNDObjects,StdCtrls, Buttons, ExtCtrls, Spin,
  ComCtrls, UniDNDListBOx, Menus, ToolWin, Tabnotbk, DNDOutput, HintX,
  DNDHistory, Grids, DNDWeapons, DNDItems, Registry;

Const Version : String = '0.2b';

Const AlignText: Array[1..9] of String = (
'Lawful Good',
'Neutral Good',
'Chaotic Good',
'Lawful Neutral',
'Neutral',
'Chaotic Neutral',
'Lawful Evil',
'Neutral Evil',
'Chaotic Evil');

type
  TMain = class(TForm)
    BtnNav1: TSpeedButton;
    BtnNav2: TSpeedButton;
    BtnNav3: TSpeedButton;
    BtnNav4: TSpeedButton;
    BtnNav9: TSpeedButton;
    Shape2: TShape;
    Shape3: TShape;
    Label1: TLabel;
    Label2: TLabel;
    Shape4: TShape;
    Label3: TLabel;
    BtnNav11: TSpeedButton;
    BtnNav12: TSpeedButton;
    Pages: TNotebook;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Name: TEdit;
    RaceSelector: TComboBox;
    Alignment: TComboBox;
    Classes: TDNDListBox;
    AvailableClasses: TDNDListBox;
    Panel6: TPanel;
    Label24: TLabel;
    Label26: TLabel;
    Label5: TLabel;
    BaseSTR: TStaticText;
    BaseDEX: TStaticText;
    BaseCon: TStaticText;
    BaseInt: TStaticText;
    BaseWis: TStaticText;
    BaseCha: TStaticText;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label6: TLabel;
    STR: TStaticText;
    DEX: TStaticText;
    CON: TStaticText;
    INT: TStaticText;
    WIS: TStaticText;
    CHA: TStaticText;
    PrevBtn: TButton;
    NextBtn: TButton;
    Label4: TLabel;
    AvailableSkills: TDNDListBox;
    Label10: TLabel;
    CrossClass: TComboBox;
    TrainedSkills: TDNDListBox;
    Label11: TLabel;
    CombinedTrainedSkills: TDNDListBox;
    Label22: TLabel;
    CombinedSP: TStaticText;
    ClassSP: TStaticText;
    Bevel2: TBevel;
    AssignPanel: TPanel;
    RollHolder1: TStaticText;
    RollHolder2: TStaticText;
    RollHolder3: TStaticText;
    RollHolder4: TStaticText;
    RollHolder5: TStaticText;
    RollHolder6: TStaticText;
    Label31: TLabel;
    AssignShow1: TStaticText;
    AssignShow2: TStaticText;
    AssignShow3: TStaticText;
    AssignShow4: TStaticText;
    AssignShow5: TStaticText;
    AssignShow6: TStaticText;
    StrAssignBtn: TButton;
    DexAssignBtn: TButton;
    ConAssignbtn: TButton;
    ChaAssignBtn: TButton;
    IntAssignBtn: TButton;
    WisAssignBtn: TButton;
    BonusPanel: TPanel;
    Label32: TLabel;
    Bonus4: TComboBox;
    Bonustxt4: TLabel;
    BonusTxt8: TLabel;
    Bonus8: TComboBox;
    BonusTxt12: TLabel;
    Bonus12: TComboBox;
    BonusTxt16: TLabel;
    Bonus16: TComboBox;
    BonusTxt20: TLabel;
    Bonus20: TComboBox;
    FeatSelector: TDNDListBox;
    Label33: TLabel;
    LearnedFeats: TDNDListBox;
    Label34: TLabel;
    FPFeats: TStaticText;
    BtnNav5: TSpeedButton;
    LanguageSelector: TDNDListBox;
    Label36: TLabel;
    LearnedLanguages: TDNDListBox;
    Label37: TLabel;
    LPLanguages: TStaticText;
    TrainedSpells: TDNDListBox;
    Label38: TLabel;
    AvailableSpells: TDNDListBox;
    Label39: TLabel;
    MainMenu1: TMainMenu;
    FIle1: TMenuItem;
    SaveCharacter1: TMenuItem;
    LoadCharacter1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    N2: TMenuItem;
    NewCharacter1: TMenuItem;
    SaveAs1: TMenuItem;
    N3: TMenuItem;
    Printpreview1: TMenuItem;
    ToolBar1: TToolBar;
    ClassSelector: TComboBox;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    SpellSchoolSelector: TComboBox;
    Label28: TLabel;
    SpellLevelSelector: TComboBox;
    Label29: TLabel;
    Panel7: TPanel;
    ShowLevel: TStaticText;
    SpecializationPanel: TPanel;
    SpecializeSelect: TComboBox;
    ProhibitedSelect: TComboBox;
    Label21: TLabel;
    Label23: TLabel;
    Label25: TLabel;
    DomainPanel: TPanel;
    Label27: TLabel;
    Label35: TLabel;
    Label40: TLabel;
    SelDomain1: TComboBox;
    SelDomain2: TComboBox;
    UDStr: TUpDown;
    UDDex: TUpDown;
    UDCon: TUpDown;
    UDInt: TUpDown;
    UDWis: TUpDown;
    UDCha: TUpDown;
    Label41: TLabel;
    Label42: TLabel;
    Label43: TLabel;
    TextSheet1: TMenuItem;
    Config1: TMenuItem;
    Customize1: TMenuItem;
    DomainSelector: TComboBox;
    Label44: TLabel;
    Hint: TPanel;
    Shape1: TShape;
    HintTitle: TLabel;
    HintText: TLabel;
    Label45: TLabel;
    FreeFeats: TDNDListBox;
    Label46: TLabel;
    Label47: TLabel;
    SelectableClassAbilities: TDNDListBox;
    ChosenClassAbilities: TDNDListBox;
    ClassAbilitiesSP: TStaticText;
    BtnNav6: TSpeedButton;
    BtnNav10: TSpeedButton;
    FreeClassAbilityList: TDNDListBox;
    Label48: TLabel;
    BtnNav13: TSpeedButton;
    HistoryTxt: TMemo;
    History: TLabel;
    PersonalityTraits: TMemo;
    Label51: TLabel;
    Goals: TMemo;
    Label52: TLabel;
    SpeedButton3: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    GenderSelector: TComboBox;
    Label53: TLabel;
    SpeedButton1: TSpeedButton;
    RollSelector: TComboBox;
    Button1: TButton;
    TotalModified: TStaticText;
    Label30: TLabel;
    BaseModified: TStaticText;
    PointAssignPanel: TPanel;
    Label55: TLabel;
    StrPoints: TStaticText;
    DexPoints: TStaticText;
    ConPoints: TStaticText;
    IntPoints: TStaticText;
    WisPoints: TStaticText;
    ChaPoints: TStaticText;
    TotBuyPoints: TStaticText;
    Label54: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    Label61: TLabel;
    Label62: TLabel;
    Label63: TLabel;
    MaxBuyPoints: TStaticText;
    Label64: TLabel;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label65: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    Label66: TLabel;
    Label67: TLabel;
    Label68: TLabel;
    Label69: TLabel;
    Label70: TLabel;
    Label71: TLabel;
    Label72: TLabel;
    Label73: TLabel;
    Label74: TLabel;
    Label75: TLabel;
    SpellInfoGrid: TStringGrid;
    Label76: TLabel;
    Label77: TLabel;
    BonusFeatSelector: TDNDListBox;
    FPBonusFeats: TStaticText;
    Label78: TLabel;
    BonusFeatsLearned: TDNDListBox;
    BtnNav14: TSpeedButton;
    Label79: TLabel;
    Help: TMenuItem;
    About1: TMenuItem;
    N4: TMenuItem;
    Help1: TMenuItem;
    BtnNav7: TSpeedButton;
    AvailableItems: TDNDListBox;
    Label80: TLabel;
    Copper: TStaticText;
    Silver: TStaticText;
    Gold: TStaticText;
    Platinum: TStaticText;
    Label81: TLabel;
    Label82: TLabel;
    Label83: TLabel;
    Label84: TLabel;
    CharInventory: TDNDListBox;
    Label85: TLabel;
    BtnNav8: TSpeedButton;
    CharInventory2: TDNDListBox;
    Label86: TLabel;
    CharEquipped: TDNDListBox;
    ComboBox1: TComboBox;
    DualWield: TCheckBox;
    Label87: TLabel;
    ItemType: TComboBox;
    ItemSize: TComboBox;
    Label88: TLabel;
    Label89: TLabel;
    BuyForFree: TCheckBox;
    TwoHandedWield: TCheckBox;
    Panel1: TPanel;
    WeaponInfo: TLabel;
    N5: TMenuItem;
    Misc1: TMenuItem;
    DiceRoller1: TMenuItem;
    N6: TMenuItem;
    SelectCampaignsetting1: TMenuItem;
    BtnLabratory: TSpeedButton;
    RGroupSelector: TComboBox;
    Panel2: TPanel;
    Label90: TLabel;
    Panel3: TPanel;
    Label91: TLabel;
    N7: TMenuItem;
    ShowCharacterPreview: TMenuItem;
    procedure SelectPage(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AlignmentChange(Sender: TObject);
    procedure RaceSelectorChange(Sender: TObject);
    procedure NameChange(Sender: TObject);
    procedure ClassesMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure AvailableClassesSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure ClassesDecrease(Control: TWinControl; Item: TPrimalDNDObject);
    procedure ClassesIncrease(Control: TWinControl; Item: TPrimalDNDObject);
    procedure CopyBtnClick(Sender: TObject);
    procedure PasteBtnClick(Sender: TObject);
    procedure ReRollBtnClick(Sender: TObject);
    procedure PrevBtnClick(Sender: TObject);
    procedure NextBtnClick(Sender: TObject);
    procedure PagesPageChanged(Sender: TObject);
    procedure CrossClassChange(Sender: TObject);
    procedure ClassSelectorChange(Sender: TObject);
    procedure AvailableSkillsSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure TrainedSkillsDecrease(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure UpdateCombined(Control: TWinControl; Item: TPrimalDNDObject);
    procedure TrainedSkillsMax(Control: TWinControl; Item: TPrimalDNDObject;
      var AtMax: Boolean);
    procedure RollDiceBtnClick(Sender: TObject);
    procedure AssignBtnClick(Sender: TObject);
    procedure BonusSet(Sender: TObject);
    procedure ClassesMax(Control: TWinControl; Item: TPrimalDNDObject;
      var AtMax: Boolean);
    procedure FeatSelectorSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure LearnedFeatsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure LanguageSelectorSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure LearnedLanguagesSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure AvailableSpellsSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure TrainedSpellsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure Exit1Click(Sender: TObject);
    procedure LoadCharacter1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure NewCharacter1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SaveCharacter1Click(Sender: TObject);
    procedure SpellSchoolSelectorChange(Sender: TObject);
    procedure SpellLevelSelectorChange(Sender: TObject);
    procedure ClassesAfterIncrease(Control: TWinControl; Item: TPrimalDNDObject);
    procedure ClassesAfterDecrease(Control: TWinControl; Item: TPrimalDNDObject);
    procedure SpecializeSelectChange(Sender: TObject);
    procedure ProhibitedSelectChange(Sender: TObject);
    procedure SelDomain1Change(Sender: TObject);
    procedure SelDomain2Change(Sender: TObject);
    procedure UDStrClick(Sender: TObject; Button: TUDBtnType);
    procedure UDDexClick(Sender: TObject; Button: TUDBtnType);
    procedure UDConClick(Sender: TObject; Button: TUDBtnType);
    procedure UDIntClick(Sender: TObject; Button: TUDBtnType);
    procedure UDWisClick(Sender: TObject; Button: TUDBtnType);
    procedure UDChaClick(Sender: TObject; Button: TUDBtnType);
    procedure TextSheet1Click(Sender: TObject);
    procedure Customize1Click(Sender: TObject);
    procedure Shape1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SelectableClassAbilitiesSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure ChosenClassAbilitiesSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure SpeedButton10Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure GenderSelectorChange(Sender: TObject);
    procedure RollSelectorChange(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure BonusFeatSelectorSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure BonusFeatsLearnedSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure About1Click(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure AvailableItemsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure CharInventorySelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure CharInventory2Select(Control: TWinControl; Item: TPrimalDNDObject);
    procedure CharEquippedSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure Button5Click(Sender: TObject);
    procedure DualWieldClick(Sender: TObject);
    procedure ItemTypeChange(Sender: TObject);
    procedure TwoHandedWieldClick(Sender: TObject);
    procedure AvailableSkillsPaint(Sender: TObject; R: TRect;
      Item: TPrimalDNDObject);
    procedure AvailableItemsPaint(Sender: TObject; R: TRect;
      Item: TPrimalDNDObject);
    procedure AvailableSpellsPaint(Sender: TObject; R: TRect;
      Item: TPrimalDNDObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure AvailableClassesMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer; Item: TPrimalDNDObject);
    procedure ClassesMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer; Item: TPrimalDNDObject);
    procedure CharInventory2Paint(Sender: TObject; R: TRect;
      Item: TPrimalDNDObject);
    procedure DiceRoller1Click(Sender: TObject);
    procedure Panel2Click(Sender: TObject);
    procedure ClassesPaint(Sender: TObject; R: TRect; Item: TPrimalDNDObject);
    procedure RGroupSelectorChange(Sender: TObject);
    procedure Panel7MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ShowCharacterPreviewClick(Sender: TObject);
  private
    { Private declarations }
    Changing  : Boolean;
    Store     : TAbilities;
    LPMax     : Integer;
    LPLeft    : Integer;
    SPMax     : Integer;
    SPCMax    : Integer;
    SPCLeft   : Integer;
    SPLeft    : Integer;
    AssignPos : Integer;
    FPLeft    : Integer;
    FPMax     : Integer;
    FPBonusLeft    : Integer;
    FPBonusMax     : Integer;
    ClassAPLeft : Integer;
    ClassAPMax  : Integer;
    LastfileName : String;
    FilteredSpells : TSpellList;
    FilteredItems  : TItemList;
    Procedure AlignmentUpdate;
  public
    SaveCancelled : Boolean;
    NewName   : String;
    Character : TCharacter;
    CurrentClass : TTrainedClass;
    PreviewX,PreviewY : Integer;
    { Public declarations }
    Procedure Changed;
    Procedure BuildWorld;
    Procedure UpdateCaption;
    Procedure RefreshClassSelector;
    Procedure SelectSkills;
    Procedure CalcSPLeft;
    Procedure CalcFPLeft;
    Procedure UpdateBonuses;
    Procedure CalcLanguagePointsLeft;
    Procedure BuildSpells;
    Procedure SelectSpells;
    Procedure UpdateFilterSpells;
    Procedure NewCharacter;
    Procedure UpdateSpecializeSelect;
    Procedure SetSpecialization;
    Procedure FindSpecializiation;
    Procedure InitDomainSelect;
    Procedure FindDomains;
    Procedure ClassSchoolLimit;
    Procedure GenerateSheet(fType : Integer);
    Procedure UpdateFilterItems;
    Procedure ClassDomainLimit;
    Procedure UpdateRaceSelector;
    Procedure CalcClassPointsLeft;
    Procedure UpdateClassAbilityList;
    Procedure GenerateName;
    Function  SelectFeatParameters(Item: TPrimalDNDObject) : String;
    Procedure UpdateCharacterMoney;
    Procedure UpdateWeaponShow;

    Procedure SetDualWield(NAar : Boolean);
    Procedure SetTwoHandedWield(NAar : Boolean);
    Procedure ThingHint(S : String);

    Procedure SaveConfig;
    Procedure LoadConfig;

    Procedure EditInLabratory(Item : TDNDItem);

    Procedure CalculateClassSpells(C : TTrainedClasS);
    Function  PrestigeScript(fClass : TBaseClass) : Boolean;

    Procedure ClearBooklets;
    Procedure SetCharacterPreview(B : Boolean);
  end;

var
  Main: TMain;

implementation

uses FrmParameterSelect, FrmCustomize, FrmRandomName, FrmAbout, FrmDiceRolls,
  FrmLabratory, FrmBaseClassSelect, UniPrestigeSCript, FrmPreview;

{$R *.DFM}

Procedure TMain.ClearBooklets;
Begin
 RGroupSelector.Items.Assign(World.ResourceGroups);
 RGroupSelector.itemIndex := World.fGroup;
 RGroupSelectorChange(Self);
End;

Procedure TMain.UpdateCharacterMoney;
Begin
 Platinum.Caption := IntToStr(Character.Money.Platinum);
     Gold.Caption := IntToStr(Character.Money.Gold);
   Silver.Caption := IntToStr(Character.Money.Silver);
   Copper.Caption := IntToStr(Character.Money.Copper);
End;

Procedure TMain.NewCharacter;
Begin

 Combobox1.ItemIndex := 0;
 CharEquipped.List := Character.Equipped[0];

 ItemType.itemIndex := 0;
 ItemSize.ItemIndex := 0;

 RollSelector.ItemIndex := 0;
 LastfileName := '';
 GenderSelector.ItemIndex := 0;
 SpellSchoolSelector.ItemIndex := 0;
 DomainSelector.ItemIndex := 0;
 SpellLevelSelector.ItemIndex := 0;
 Character.New;
 GenerateName;
 Character.Name := NewName;
 BtnNav1.Down := True;
 Pages.PageIndex := 0;
 RaceSelectorChange(Self);
 Classes.Invalidate;
 TrainedSkills.Invalidate;
 CombinedTrainedSkills.Invalidate;
 LearnedFeats.Invalidate;
 BonusFeatsLearned.Invalidate;
 FreeFeats.Invalidate;
 LearnedLanguages.Invalidate;
 RefreshClassSelector;
 FindSpecializiation;
 FindDomains;
 RollDiceBtnClick(Self);
 If Name.CanFocus Then Name.SetFocus;
End;

Procedure TMain.ThingHint(S : String);
Begin
 If S <> Panel7.Caption Then
 Panel7.Caption := S;
End;

Procedure TMain.UpdateCaption;
Var I  :Integer;
    Caption : String;
Begin
 Caption := 'Redblade 3e - ';
 if (Character.Name <> '') THen Caption := Caption + Character.Name+ ' - ';
 If Character.Classes.Count > 0 Then
 For I := 0 To Character.Classes.Count-1 Do Begin
   Caption := Caption + ' '+floatToStr(Character.Classes[I].Value) + ' ' + Character.Classes[I].Name;
   If ( I < Character.Classes.Count-1) Then
    Caption := Caption + ' /';
 End;
 If Character.TotalLevel > 0 Then Begin
   Caption := Caption + ' (Level '+IntToStr(Character.TotalLevel)+')';
 End Else Caption := Caption + 'Creating';
 Main.Caption := Caption;
End;

Procedure TMain.UpdateBonuses;
Begin
 Bonus4.Visible := (Character.BonusAbilities > 0);
 BonusTxt4.Visible := Bonus4.Visible;
 Bonus8.Visible := (Character.BonusAbilities > 1);
 BonusTxt8.Visible := Bonus8.Visible;
 Bonus12.Visible := (Character.BonusAbilities > 2);
 BonusTxt12.Visible := Bonus12.Visible;
 Bonus16.Visible := (Character.BonusAbilities > 3);
 BonusTxt16.Visible := Bonus16.Visible;
 Bonus20.Visible := (Character.BonusAbilities > 4);
 BonusTxt20.Visible := Bonus20.Visible;
 Bonus4.ItemIndex := Character.BonusStat[1];
 Bonus8.ItemIndex := Character.BonusStat[2];
 Bonus12.ItemIndex := Character.BonusStat[3];
 Bonus16.ItemIndex := Character.BonusStat[4];
 Bonus20.ItemIndex := Character.BonusStat[5];
End;

Procedure TMain.UpdateRaceSelector;
Var I : Integer;
Begin
 RaceSelector.Items.BeginUpdate;
 RaceSelector.Items.Clear;
 For I := 0 To World.Races.Count-1 Do Begin
   RaceSelector.Items.AddObject(World.Races[I].Name,TObject(World.Races[I]));
 End;
 RaceSelector.Items.EndUpdate;
 If Assigned(Character) and Assigned(Character.Race) Then Begin
   RaceSelector.ItemIndex := RaceSelector.Items.IndexOfObject(Character.Race);
 End;
End;

Function AbilityScortePointCost(Original : Integer) : Integer;
Begin
  Case Original of
 0..8 : Result := 0;
    9 : Result := 1;
   10 : Result := 2;
   11 : Result := 3;
   12 : Result := 4;
   13 : Result := 5;
   14 : Result := 6;
   15 : Result := 8;
   16 : Result := 10;
   17 : Result := 13;
   18 : Result := 16;
   Else Result := 99;
  End;
End;

Procedure TMain.Changed;
Const ClassesCount : Integer = 0;
Var I : Integer;
Begin
 if Changing Then Exit;
 Character.fChanged := True;
 Changing := True;
 Character.Calculate;
 RollSelector.ItemIndex := Character.RollMethod;
 RollSelectorChange(Self);
 if ClassSelector.ItemIndex = -1 Then ClassSelector.ItemIndex := 0;

 BaseModified.Caption := IntToStr(Character.Base.Abilities.Str+Character.Base.Abilities.Dex+Character.Base.Abilities.Con+Character.Base.Abilities.Int+Character.Base.Abilities.Wis+Character.Base.Abilities.Cha);
 TotalModified.Caption := IntToStr(Character.Abilities.Str+Character.Abilities.Dex+Character.Abilities.Con+Character.Abilities.Int+Character.Abilities.Wis+Character.Abilities.Cha);

{ ShowMessage(IntToStR(Character.FeatPoints));}

 Str.Caption := IntToStr(Character.Abilities.Str);
 Dex.Caption := IntToStr(Character.Abilities.Dex);
 Con.Caption := IntToStr(Character.Abilities.Con);
 Int.Caption := IntToStr(Character.Abilities.Int);
 Wis.Caption := IntToStr(Character.Abilities.Wis);
 Cha.Caption := IntToStr(Character.Abilities.Cha);

 UDStr.Position := Character.Base.Abilities.Str;
 UDDex.Position := Character.Base.Abilities.Dex;
 UDCon.Position := Character.Base.Abilities.Con;
 UDInt.Position := Character.Base.Abilities.Int;
 UDWis.Position := Character.Base.Abilities.Wis;
 UDCha.Position := Character.Base.Abilities.Cha;

 StrPoints.Caption := IntToStr(AbilityScortePointCost(Character.Base.Abilities.Str));
 DexPoints.Caption := IntToStr(AbilityScortePointCost(Character.Base.Abilities.Dex));
 ConPoints.Caption := IntToStr(AbilityScortePointCost(Character.Base.Abilities.Con));
 IntPoints.Caption := IntToStr(AbilityScortePointCost(Character.Base.Abilities.Int));
 WisPoints.Caption := IntToStr(AbilityScortePointCost(Character.Base.Abilities.Wis));
 ChaPoints.Caption := IntToStr(AbilityScortePointCost(Character.Base.Abilities.Cha));

 TotBuyPoints.Caption := IntToStR(
   StrToInt(StrPoints.Caption)+
   StrToInt(DexPoints.Caption)+
   StrToInt(ConPoints.Caption)+
   StrToInt(IntPoints.Caption)+
   StrToInt(WisPoints.Caption)+
   StrToInt(ChaPoints.Caption) );

   DualWield.Checked := Character.DualWield > 0;
   TwoHandedWield.Checked := Character.TwoHandedWield > 0;
   UpdateWeaponShow;

  If StrToInt(TotBuyPoints.Caption) > StrToInt(MaxBuyPoints.Caption) Then
    TotBuyPoints.Color := clRed
  Else
    TotBuyPoints.Color := ClBtnFace;

 UpdateBonuses;

 Name.Text := Character.Name;

 GenderSelector.ItemIndex := Character.Gender;

 I := Alignment.Items.IndexOfObject(TOBject(Character.Alignment));
 If ( I > -1 ) Then Alignment.ItemIndex := I Else Alignment.ItemIndex := 0;

 If Assigned(Character.Race) Then
   RaceSelector.ItemIndex := RaceSelector.Items.IndexOfObject(Character.Race);
{ Speed.Caption := IntToStr(Character.Points.Speed);
 Will.Caption := IntToStr(Character.SavingThrows.Willpower);
 Ref.Caption := IntToStr(Character.SavingThrows.Reflex);
 Fort.Caption := IntToStr(Character.SavingThrows.Fortitude);}

 ClassesCount := Character.Classes.Count;

 ShowLevel.Caption := IntTOStr(Character.TotalLevel);

 FindSpecializiation;
 UpdateCaption;
 CalcLanguagePointsLeft;
 Changing := FAlse;
 If Assigned(Preview) Then Preview.Update;
End;

procedure TMain.SelectPage(Sender: TObject);
begin
 Hint.Visible := False;
 Pages.PageIndex := TComponent(Sender).Tag;
end;


Procedure TMain.BuildSpells;
Begin
End;

Procedure TMain.BuildWorld;
Begin
 //---
 {$I-}
  MkDir(ExtractFilePath(ParamStr(0))+'campaigns');
  if ( IoResult <> 0 ) Then;
  MkDir(ExtractFilePath(ParamStr(0))+'characters');
  if ( IoResult <> 0 ) Then;
  MkDir(ExtractFilePath(ParamStr(0))+'charactersheets');
  if ( IoResult <> 0 ) Then;
 {$I+}
 if (fileexists(World.WorldFileName)) Then
   World.Load(World.WorldFileName)
 Else if (fileexists(ExtractFilePath(ParamStr(0))+'campaigns\corerules.rw3')) Then
   World.Load(ExtractFilePath(ParamStr(0))+'campaigns\corerules.rw3');
 UpdateRaceSelector;
{ World.Save('C:\WINDOWS\DESKTOP\WORLD.DAT');}
End;

procedure TMain.FormCreate(Sender: TObject);
begin
 LoadConfig;
 Randomize;
 BuildWorld;

 FilteredSpells := TSpellList.Create;
 FilteredItems  := TItemList.Create;
 InitDomainSelect;
 Store := TAbilities.Create;
 CrossClass.ItemIndex := 0;
 Changing := True;
 Pages.PageIndex := 0;
 BtnNav1.Down := True;
 Character := TCharacter.Create;
 Character.OnChange := Changed;

 CharInventory.List := Character.Inventory;
 CharInventory2.List := Character.Inventory;
 CombinedTrainedSkills.List := Character.Skills;
 RaceSelector.ItemIndex := 0;
 RaceSelectorChange(Self);
 AlignmentChange(Self);
 Changing := False;
 Classes.List := Character.classes;
 FreeFeats.List := Character.Feats;
 LearnedFeats.List := Character.LearnedFeats;
 AvailableClasses.List := World.Classes;
 FeatSelector.List := World.Feats;
 LanguageSelector.List := Character.BonusLanguages;
 LearnedLanguages.List := Character.Languages;

 RollDiceBtnClick(Self);
 RefreshClassSelector;
end;

procedure TMain.AlignmentChange(Sender: TObject);
begin
 if Alignment.ItemIndex <> -1 Then
 Character.Alignment := Integer(Alignment.Items.Objects[Alignment.ItemIndex]);
end;

procedure TMain.RaceSelectorChange(Sender: TObject);
Var Total : Integer;
begin
 If RaceSelector.ItemIndex <> -1 Then Begin

   If ( Character.Race <> nil ) Then Begin
     Total := Character.TotalLevel-Character.Race.LevelCost+TBaseRace(RaceSelector.Items.Objects[RaceSelector.ItemIndex]).LevelCost;
     If ( Total > 20 ) Then Begin
       ShowMessage('This race costs several levels to have, which would take you over the 20 maximum. Please remove '+IntToStr(Total-20)+' character level(s) before selecting this race.');
       RaceSelector.ItemIndex := RaceSelector.Items.IndexOfObject(Character.Race);
       Exit;
     End;
   End;
   Character.Race := TBaseRace(RaceSelector.Items.Objects[RaceSelector.ItemIndex]);
   Changed;
 End;
End;

procedure TMain.NameChange(Sender: TObject);
begin
 Character.Name := Name.Text;
 UpdateCaption;
end;

procedure TMain.ClassesMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
{ If Bt1Down Then Exit;
 Bt1Down := True;
 If not assigned(Classes.Selected) then exit;
 If Button = MbRight Then Begin
  If TTrainedClasS(Classes.Selected.Data).Level = 1 Then Begin
    Character.RemoveClass(Classes.Selected.Data);
  End Else
  TTrainedClasS(Classes.Selected.Data).Level :=TTrainedClasS(Classes.Selected.Data).Level - 1;
 End;}
end;

Procedure TMain.RefreshClassSelector;
Var CurrentClass : String;
    I :  Integer;
Begin
 If ClassSelector.ItemIndex <> -1 Then Begin
    CurrentClass := ClassSelector.Items[ClassSelector.ItemIndex];
 End Else CurrentClass := '';
 Character.Classes.ToStrings(ClassSelector.Items);
 If ClassSelector.items.Count = -1 Then Begin
    ClassSelector.ItemIndex := -1;
 End;
 If CurrentClass <> '' Then Begin
    I := ClassSelector.Items.IndexOf(CurrentClass);
    If I <> -1 Then ClassSelector.ItemIndex := I Else ClassSelector.ItemIndex := 0;
 End;
 ClassSelector.Enabled := ClassSelector.Items.Count > 0;
 ClassSelectorChange(Self);
 AlignmentUpdate;
End;

Function TMain.PrestigeScript(fClass : TBaseClass) : Boolean;
Var PS : TPrestigeScript;
Begin
 PS := TPrestigeScript.Create;
 Try
   Result := Ps.Process(fClass);
 Finally
   PS.Free;
 End;
End;

procedure TMain.AvailableClassesSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var TC : TTrainedClass;
    I : Integer;
    S : String;
begin
 S := '';
 If ( Character.TotalLevel = 20 ) Then Begin
   Requires('');
   Requires('Your total levels cannot exceed 20.');
   Exit;
 End;
 if ( not TAffected(Item).MeetsPrerequisites(Character) ) Then
  Exit;

 TC := Character.fClasses.HasBaseClass(TBaseClass(Item));
 If TC <> nil Then Begin
   TC.Value := TC.Value+1;
   Changed;
 End Else Begin

   If PrestigeScript(TBaseClass(Item)) Then Exit;

   For I := 1 To 20 Do
    If TBaseClass(Item).Level[I].Points.CasterBonusLevels <> 0 Then Begin
     BaseClassSelect := TBaseClassSelect.Create(self);
     BaseClassSelect.SetList;
     If BaseClassSelect.ParameterList.Items.Count = 0 Then Begin
        ShowMessage('There are no spellcasting classes available. You need at least one spellcasting class to select this class.');
        BaseClassSelect.Free;
        Exit;
     End;

     If BaseClassSelect.ShowModal =  MrOk Then Begin
        S := BaseClassSelect.ParameterList.Items[BaseClassSelect.ParameterList.ItemIndex];
        BaseClassSelect.Free;
        break;
     End Else Begin
        BaseClassSelect.Free;
        Exit;
     End;
   End;

   TC := Character.AddClass(TBaseClass(Item));
   TC.LeansOnClass := S;
 End;
 Classes.Invalidate;
 RefreshClassSelector;
 Changed;
end;

Procedure TMain.AlignmentUpdate;
Var I : Integer;
Var LastAlign : TObject;
Begin
 LastAlign := nil;
 If (AlignMent.ItemIndex<>-1) Then
   LastAlign := Alignment.Items.Objects[Alignment.ItemIndex];
 Alignment.Items.BeginUpdate;
 Alignment.Clear;
 For I := 1 To 9 Do
   If not Character.IllegalAlignment(I-1) Then
     Alignment.Items.AddObject(AlignText[I],TOBject(1 SHL I));
 Alignment.Items.EndUpdate;
 I := Alignment.Items.IndexOfObject(TObject(LastAlign));
 If ( I > -1 ) Then Alignment.ItemIndex := I Else Alignment.ItemIndex := 0;
 AlignmentChange(Self);
End;

procedure TMain.ClassesDecrease(Control: TWinControl; Item: TPrimalDNDObject);
Var I : Integer;
begin
 If Item.Value = 1 Then Begin
   For I := 0 To Character.Classes.Count-1 Do begin
     If ( lowercase(Character.Classes[I].LeansOnClass) = Lowercase(TTrainedClass(Item).Name) ) Then Begin
       ShowMessage('The '+Character.Classes[I].Name+' requires this class. Please remote '+Character.Classes[I].Name+' first.');
       Exit;
     End;
   End;
   Item.Free;
   RefreshClassSelector;
 End;
 Changed;
end;

procedure TMain.ClassesIncrease(Control: TWinControl; Item: TPrimalDNDObject);
begin
 Changed;
end;

procedure TMain.CopyBtnClick(Sender: TObject);
begin
 Store.Str := StrToInt(BaseStr.Caption);
 Store.Dex := StrToInt(BaseDex.Caption);
 Store.Con := StrToInt(BaseCon.Caption);
 Store.Int := StrToInt(BaseInt.Caption);
 Store.Wis := StrToInt(BaseWis.Caption);
 Store.Cha := StrToInt(BaseCha.Caption);
 PasteBtn.Enabled := True;
end;

procedure TMain.PasteBtnClick(Sender: TObject);
begin
 Changing := True;
 With Character.Base.Abilities Do Begin
    Str := Store.Str;
    Dex := Store.Dex;
    Con := Store.Con;
    Int := Store.Int;
    Wis := Store.Wis;
    Cha := Store.Cha;
 End;
 Changing := False;
 Changed;
end;

procedure TMain.ReRollBtnClick(Sender: TObject);
begin
 Character.Base.Abilities.Roll4D4DropLowest;
end;

procedure TMain.PrevBtnClick(Sender: TObject);
begin
 If Pages.PageIndex > 0 Then pages.PageIndex := Pages.PageIndex -1;
end;

procedure TMain.NextBtnClick(Sender: TObject);
begin
 If Pages.PageIndex < Pages.Pages.Count-1 Then pages.PageIndex := Pages.PageIndex + 1;
end;

procedure TMain.PagesPageChanged(Sender: TObject);
Var I : Integer;
begin
 If Pages.PageIndex = 0 Then PrevBtn.Enabled := False;
 If Pages.PageIndex < Pages.Pages.Count Then NextBtn.Enabled := True;
 If Pages.PageIndex = Pages.Pages.Count-1 Then NextBtn.Enabled := False;
 If Pages.PageIndex > 0  Then PrevBtn.Enabled := True;

 If Pages.PageIndex = 0 Then BtnNav1.Down := True;
 If Pages.PageIndex = 1 Then BtnNav2.Down := True;
 If Pages.PageIndex = 2 Then BtnNav3.Down := True;
 If Pages.PageIndex = 3 Then BtnNav4.Down := True;
 If Pages.PageIndex = 4 Then BtnNav5.Down := True;
 If Pages.PageIndex = 5 Then BtnNav6.Down := True;
 If Pages.PageIndex = 6 Then BtnNav7.Down := True;
 If Pages.PageIndex = 7 Then BtnNav8.Down := True;
 If Pages.PageIndex = 8 Then BtnNav9.Down := True;
 If Pages.PageIndex = 9 Then BtnNav10.Down := True;
 If Pages.PageIndex = 10 Then BtnNav11.Down := True;
 If Pages.PageIndex = 11 Then BtnNav12.Down := True;
 If Pages.PageIndex = 12 Then BtnNav13.Down := True;
 If Pages.PageIndex = 13 Then BtnNav14.Down := True;

 Case Pages.PageIndex Of
   2 : Begin
          SPMax := Character.SkillPoints;
          ClassSelectorChange(Self);
       End;
   3 : Begin
          CalcFPLeft;
       End;
   5 : Begin
         CalcClassPointsleft;
         UpdateClassAbilityList;
       End;
   6 : Begin
         UpdateFilterItems;
         UpdateCharacterMoney;
       End;
   7 : Begin
         UpdateFilterItems;
       End;
   8 : Begin
          SpecializationPanel.Visible := Character.CanSpecialize;
          DomainPanel.Visible := Character.CanSelectDomains;
       End;
   9 : Begin
         For I := 0 To Character.Classes.Count-1 Do
         CalculateClassSpells(Character.Classes[I]);
         ClassDomainLimit;
         ClassSchoolLimit;
         SelectSpells;
      End;
 End;
end;

Procedure TMain.SelectSkills;
Var T : TTrainedClass;
Begin
 If ClassSelector.ItemIndex = -1 Then Begin
   AvailableSkills.List := nil;
   TrainedSkills.List := nil;
   Exit;
 End;
 T := TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]);
 If ( CrossClass.ItemIndex = 1 ) Then Begin
   AvailableSkills.List := T.BaseClass.CrossClassSkills;
 End Else
   AvailableSkills.List := T.BaseClass.MainSkills;
 TrainedSkills.List := T.LearnedSkills;
 AvailableSkills.Invalidate;
End;

Procedure TMain.UpdateFilterSpells;
Var I :Integer;
Var T : TTrainedClass;
    Spell : TTrainedSpell;
Begin
 AvailableSpells.List := Nil;
 For I := FilteredSpells.Count-1 DownTo 0 Do
   FilteredSpells.Items[I].Free;
 T := TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]);
 For I := 0 To World.Spells.Count-1 Do Begin
   If (World.Spells[I].UsableBy(T)){ or
      (World.Spells[I].HasDomain(Character.Domain1) and Character.CanSelectDomains) or
      (World.Spells[I].HasDomain(Character.Domain2) and Character.CanSelectDomains)}
        Then Begin
     If ( SpellSchoolSelector.ItemIndex > 0 ) Then
       If World.Spells[I].MageSchool <> SpellSchoolSelector.Items[SpellSchoolSelector.ItemIndex] Then Continue;
     If ( DomainSelector.ItemIndex > 0 ) Then
       If not World.Spells[I].HasDomain(DomainSelector.Items[DomainSelector.ItemIndex]) Then Continue;
     If World.Spells[I].SpellLevel(T) <> SpellLevelSelector.ItemIndex Then Continue;
     Spell := TTrainedSpell.Create(World.Spells[I],FilteredSpells);
     Spell.Level := World.Spells[I].SpellLevel(T);
   End;
 End;
 AvailableSpells.List := FilteredSpells;
End;

Procedure TMain.UpdateFilterItems;
Var I :Integer;
Var Item : TDNDItem;
Begin
 AvailableItems.List := Nil;
 For I := FilteredItems.Count-1 DownTo 0 Do Begin
   Item := FilteredItems.Items[I];
   FilteredItems.Extract(Item);
   Item.Free;
 End;
 For I := 0 To World.Items.Count-1 Do Begin
   if (ItemType.ItemIndex > -1) And (World.Items[I].Kind <> ItemType.ItemIndex) Then COntinue;
   if (ItemSize.ItemIndex <> 0) And (World.Items[I].Size <> ItemSize.ItemIndex-1) Then COntinue;
   Item := TDNDItem.Create;
   Item.Clone(World.Items[I]);
   FilteredItems.Add(Item);
 End;
 AvailableItems.List := FilteredItems;
End;

Procedure TMain.SelectSpells;
Var T : TTrainedClass;
    I : Integer;
Begin
 If ClassSelector.ItemIndex = -1 Then Begin
   TrainedSpells.List := nil;
   Exit;
 End;
 T := TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]);
 TrainedSpells.List := T.LearnedSpells;
 UpdateFilterSpells;

 For I := 0 To 9 Do Begin
    if T.Points.Arcane[I] > -1 Then Begin
      SpellInfoGrid.Cells[I,0] := Character.SpellsCastPerDay(T,I);
      SpellInfoGrid.Cells[I,2] := IntToStr(Character.SpellDC(T,I));
    End Else Begin
      SpellInfoGrid.Cells[I,0] := '';
      SpellInfoGrid.Cells[I,2] := '';
    End;

    if T.Points.Known[I] > -1 Then Begin
      SpellInfoGrid.Cells[I,1] := IntToStr(Character.SpellsKnown(T,I));
    End Else Begin
      SpellInfoGrid.Cells[I,1] := '';
    End;

 End;
End;

procedure TMain.CrossClassChange(Sender: TObject);
begin
 SelectSkills;
end;

Procedure TMain.UpdateClassAbilityList;
Var      T : TTrainedClass;
begin
 T := Nil;
 If ClassSelector.ItemIndex <> -1 Then Begin
   T := TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]);
 End;
 CurrentClass := T;

 if Assigned( T) Then Begin

   FeatSelector.List := Character.SelectableFeats;
   BonusfeatSelector.List := Character.SpecialBonusFeats;

   FPBonusMax := Character.BonusFeatPoints(T);
   FPBonusLeft := FPBonusMAx - Character.BonusFeatPointsUsed(T);
   FPBonusFeats.Caption := IntToStr(FPBonusLeft);

   FreeClassAbilityList.List := T.FreeClassAbilities;
   ChosenClassAbilities.List := T.ChosenClassAbilities;
   SelectableClassAbilities.List := T.SelectableClassAbilities;
   BonusFeatsLearned.List := T.LearnedBonusFeats;

 End Else Begin
   FeatSelector.List := nil;
   BonusfeatSelector.List := nil;
   FreeClassAbilityList.List := nil;
   ChosenClassAbilities.List := nil;
   SelectableClassAbilities.List := nil;
 End;
 BonusFeatSelector.Visible := Character.SpecialBonusFeats.Count>0;
 If BonusFeatSelector.Visible Then Begin
   FeatSelector.Height := 130;
   LearnedFeats.Height := 130;
 End Else Begin
   FeatSelector.Height := 322;
   LearnedFeats.Height := 180;
 End;
 BonusFeatsLearned.Visible :=BonusFeatSelector.Visible;
 Label77.Visible :=  BonusFeatSelector.Visible;
 FpBonusFeats.Visible :=  BonusFeatSelector.Visible;

End;

procedure TMain.ClassSelectorChange(Sender: TObject);
Var      T : TTrainedClass;
begin

 If ClassSelector.ItemIndex <> -1 Then Begin
   T := TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]);
   SPCMax := Character.ClassSkillpoints(T);
 End Else SPCMax := 0;

 UpdateClassAbilityList;
 SelectSkills;
 SelectSpells;
 CalcSPLeft;
 Character.RevalidateCrossclass;
 TrainedSkills.Invalidate;
end;

procedure TMain.AvailableSkillsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
 if (SPcLeft = 0) Then Begin
  Requires('');
  Requires('No skillpoints left');
  Exit;
 End;
 If TBaseSkill(Item).Parameters.Count > 0 Then Begin
   ParameterSelect := TParameterSelect.Create(self);
   ParameterSelect.SetList(TBaseSkill(Item).Parameters);
   If ParameterSelect.ShowModal =  MrOk Then Begin
     Character.AddSkill(TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]).BaseClass,
               TBaseSkill(Item),
               ParameterSelect.ParameterList.Items[ParameterSelect.ParameterList.ItemIndex]);
   End;
   ParameterSelect.Free;
 End Else Begin
   Character.AddSkill(TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]).BaseClass,TBaseSkill(Item),'');
 End;

 TrainedSkills.Invalidate;
 CombinedTrainedSkills.Invalidate;
 CalcSPLeft;
 Changed;
end;

procedure TMain.TrainedSkillsDecrease(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
 If Item.Value = 1 Then Begin
   Item.Free;
   Changed;
   CalcSPLeft;
   CombinedTrainedSkills.Invalidate;
 End;
end;

procedure TMain.UpdateCombined(Control: TWinControl; Item: TPrimalDNDObject);
begin
 Changed;
 CalcSPLeft;
 CombinedTrainedSkills.Invalidate;
end;

Procedure TMain.CalcFPLeft;
Begin
 FPMax := Character.FeatPoints;
 FPLeft := FPMAx - Character.FeatPointsUsed;
 FPFeats.Caption := IntToStr(FPLeft);
 UpdateClassAbilityList;
End;

Procedure TMain.CalcSPLeft;
Var T : TTrainedClass;
Begin
  If ClassSelector.ItemIndex = -1 Then Begin
    CombinedSP.Caption := '-';
    ClassSP.Caption := '-';
    Exit;
  End;
  CalcClassPointsLeft;
  T := TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]);
  SPCLeft := SPCMax - Character.ClassSkillPointsUsed(T);
  SPLeft := SPMax - Character.SkillPointsUsed;
  CombinedSP.Caption := IntToStr(SPLeft);
  ClassSP.Caption := IntToStr(SPCLeft);
End;

Procedure TMain.CalcClassPointsLeft;
Var T : TTrainedClass;
Begin
  if ( ClassSelector.itemIndex < 0 ) Then Exit;
  T := TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]);
  ClassAPMax  := T.Points.MaxClassAbilities;
  ClassAPLeft := ClassAPMax - Character.ClassAbilityPointsUsed(T);
  ClassAbilitiesSP.Caption := IntToStr(ClassAPLeft);
End;


procedure TMain.TrainedSkillsMax(Control: TWinControl; Item: TPrimalDNDObject;
  var AtMax: Boolean);
Var Max : Real;
begin
 Max := Character.MaxSkillRank(TTrainedSkill(Item).BaseSkill);
 if (SPCLeft = 0) Then atMax := True Else
 If (Character.CurrentSkillRank(TTrainedSkill(Item).BaseSkill) < Max ) Then atMax := False Else atMax := True;
end;

procedure TMain.RollDiceBtnClick(Sender: TObject);
Var I,J : Integer;
    Dice : Array[0..5] of Integer;
    tmp : Integer;
begin
 PointAssignPanel.Visible := False;
 Case RollSelector.ItemIndex Of
   0 : For I := 0 To 5 Do Dice[I] := Roll4D6();
   1 : Begin
         AssignPanel.Visible := False;
            AssignShow1.Caption := IntToStr(Roll4D6());
            AssignShow2.Caption := IntToStr(Roll4D6());
            AssignShow3.Caption := IntToStr(Roll4D6());
            AssignShow4.Caption := IntToStr(Roll4D6());
            AssignShow5.Caption := IntToStr(Roll4D6());
            AssignShow6.Caption := IntToStr(Roll4D6());
            With Character.Base.Abilities Do Begin
               Str := StrtoInt(AssignShow1.Caption);
               Dex := StrtoInt(AssignShow2.Caption);
               Con := StrtoInt(AssignShow3.Caption);
               Int := StrtoInt(AssignShow4.Caption);
               Wis := StrtoInt(AssignShow5.Caption);
               Cha := StrtoInt(AssignShow6.Caption);
               AssignPanel.Visible := False;
            End;
            Exit;
       End;
   2 : For I := 0 To 5 Do Dice[I] := Random(6)+Random(6)+Random(6)+3;
   3 : Begin
         AssignPanel.Visible := False;
            AssignShow1.Caption := IntToStr(Random(6)+Random(6)+Random(6)+3);
            AssignShow2.Caption := IntToStr(Random(6)+Random(6)+Random(6)+3);
            AssignShow3.Caption := IntToStr(Random(6)+Random(6)+Random(6)+3);
            AssignShow4.Caption := IntToStr(Random(6)+Random(6)+Random(6)+3);
            AssignShow5.Caption := IntToStr(Random(6)+Random(6)+Random(6)+3);
            AssignShow6.Caption := IntToStr(Random(6)+Random(6)+Random(6)+3);
            With Character.Base.Abilities Do Begin
               Str := StrtoInt(AssignShow1.Caption);
               Dex := StrtoInt(AssignShow2.Caption);
               Con := StrtoInt(AssignShow3.Caption);
               Int := StrtoInt(AssignShow4.Caption);
               Wis := StrtoInt(AssignShow5.Caption);
               Cha := StrtoInt(AssignShow6.Caption);
               AssignPanel.Visible := False;
            End;
            Exit;
       End;
   4 : For I := 0 To 5 Do Dice[I] := Roll5D6();
  10 : Begin
         Dice[0] := 15;
         Dice[1] := 14;
         Dice[2] := 13;
         Dice[3] := 12;
         Dice[4] := 10;
         Dice[5] := 8;
       End;
 End;

 For I := 0 To 5 Do
  For J := 0 To 5 Do If Dice[I] >Dice[J] Then Begin
   Tmp := Dice[I];
   Dice[I] := Dice[J];
   Dice[J] := Tmp;
  End;
 RollHolder1.Caption := IntToStr(Dice[0]);
 RollHolder2.Caption := IntToStr(Dice[1]);
 RollHolder3.Caption := IntToStr(Dice[2]);
 RollHolder4.Caption := IntToStr(Dice[3]);
 RollHolder5.Caption := IntToStr(Dice[4]);
 RollHolder6.Caption := IntToStr(Dice[5]);
 RollHolder1.Enabled := True;
 RollHolder2.Enabled := False;
 RollHolder3.Enabled := False;
 RollHolder4.Enabled := False;
 RollHolder5.Enabled := False;
 RollHolder6.Enabled := False;
 StrAssignBtn.Enabled := True;
 DexAssignBtn.Enabled := True;
 ConAssignBtn.Enabled := True;
 IntAssignBtn.Enabled := True;
 WisAssignBtn.Enabled := True;
 ChaAssignBtn.Enabled := True;
 AssignPos := 0;
 AssignShow1.Caption := '';
 AssignShow2.Caption := '';
 AssignShow3.Caption := '';
 AssignShow4.Caption := '';
 AssignShow5.Caption := '';
 AssignShow6.Caption := '';
 AssignPanel.Visible := True;
end;

procedure TMain.AssignBtnClick(Sender: TObject);
Var Button : TButton;
    Val : Integer;
begin
 Button := TButton(Sender);
 Button.Enabled := False;
 Case AssignPos of
   0 : Begin
         Val := StrToInt(RollHolder1.Caption);
         RollHolder1.Enabled := False;
         RollHolder2.Enabled := True;
       End;
   1 : Begin
         Val := StrToInt(RollHolder2.Caption);
         RollHolder2.Enabled := False;
         RollHolder3.Enabled := True;
       End;
   2 : Begin
         Val := StrToInt(RollHolder3.Caption);
         RollHolder3.Enabled := False;
         RollHolder4.Enabled := True;
       End;
   3 : Begin
         Val := StrToInt(RollHolder4.Caption);
         RollHolder4.Enabled := False;
         RollHolder5.Enabled := True;
       End;
   4 : Begin
         Val := StrToInt(RollHolder5.Caption);
         RollHolder5.Enabled := False;
         RollHolder6.Enabled := True;
       End;
   Else Begin
         Val := StrToInt(RollHolder6.Caption);
         RollHolder6.Enabled := False;
       End;
 End;
 Inc(AssignPos);
 Case Button.tAg of
    0  : Begin
           AssignShow1.Caption := IntToStr(Val);
         End;
    1  : Begin
           AssignShow2.Caption := IntToStr(Val);
         End;
    2  : Begin
           AssignShow3.Caption := IntToStr(Val);
         End;
    3  : Begin
           AssignShow4.Caption := IntToStr(Val);
         End;
    4  : Begin
           AssignShow5.Caption := IntToStr(Val);
         End;
    5  : Begin
           AssignShow6.Caption := IntToStr(Val);
         End;
 End;
 if (AssignPos = 6) Then Begin
    With Character.Base.Abilities Do Begin
       Str := StrtoInt(AssignShow1.Caption);
       Dex := StrtoInt(AssignShow2.Caption);
       Con := StrtoInt(AssignShow3.Caption);
       Int := StrtoInt(AssignShow4.Caption);
       Wis := StrtoInt(AssignShow5.Caption);
       Cha := StrtoInt(AssignShow6.Caption);
       AssignPanel.Visible := False;
    End;
 End;
end;

procedure TMain.BonusSet(Sender: TObject);
begin
 If TComboBox(Sender).ItemIndex <> -1 Then Begin
    Character.BonusStat[TComponent(Sender).Tag] := TComboBox(Sender).ItemIndex;
    Changed;
 End;
end;

procedure TMain.ClassesMax(Control: TWinControl; Item: TPrimalDNDObject;
  var AtMax: Boolean);
begin
 if TTrainedClass(Item).BaseClass.MaxLevel = TtrainedClass(Item).Level Then Begin
   AtMax := True;
   Requires('');
   Requires('This class cannot raise above level '+IntToStr(TTrainedClass(Item).BaseClass.MaxLevel));
   Exit;
 End;
 If ( Character.TotalLevel = 20 ) Then Begin
   AtMax := True;
   Requires('');
   Requires('Your total levels cannot exceed 20.');
 End;
end;

Function TMain.SelectFeatParameters(Item: TPrimalDNDObject) : String;
Var I : Integer;
  Tmp : TWeapon;
    C : Integer;
Begin
 Result := '-';
 if TBaseFeat(ITem).NeedsFeat <> '' Then Begin
   { If this feat needs its parameters from a different feat, gather those
     instead!' }
   ParameterSelect := TParameterSelect.Create(self);
   Try
     For I := 0 to Character.LearnedFeats.Count-1 Do
      if Lowercase(Character.LearnedFeats[I].baseFeat.Name) =
         Lowercase(TBaseFeat(Item).NeedsFeat) Then
        ParameterSelect.ParameterList.Items.Add(Character.LearnedFeats[I].Parameter);

     For C := 0 to Character.Classes.Count-1 Do
     For I := 0 to Character.Classes[C].LearnedBonusFeats.Count-1 Do
      if Lowercase(Character.Classes[C].LearnedBonusFeats[I].baseFeat.Name) =
         Lowercase(TBaseFeat(Item).NeedsFeat) Then
        ParameterSelect.ParameterList.Items.Add(Character.Classes[C].LearnedBonusFeats[I].Parameter);


     ParameterSelect.ParameterList.ItemIndex := 0;
     If ( ParameterSelect.ParameterList.Items.Count <= 0 ) Then Begin
       Requires(TBaseFeat(Item).NeedsFeat);
     End;
     If ( ParameterSelect.ParameterList.Items.Count > 0 ) and ( ParameterSelect.ShowModal =  MrOk ) Then
       Result := ParameterSelect.ParameterList.Items[ParameterSelect.ParameterList.ItemIndex];
   Finally
     ParameterSelect.Free;
   End;
 End Else If (TBaseFeat(Item).Flags and 2) > 0 Then Begin
   { If this feat needs its parameters drawn from the skills, do that! }
   ParameterSelect := TParameterSelect.Create(self);
   Try
     ParameterSelect.SetDNDList(World.Skills);
     If ( ParameterSelect.ParameterList.Items.Count > 0 ) and (ParameterSelect.ShowModal =  MrOk) Then
       Result := ParameterSelect.ParameterList.Items[ParameterSelect.ParameterList.ItemIndex];
   Finally
     ParameterSelect.Free;
   End;
 End Else If (TBaseFeat(Item).Flags and 4) > 0 Then Begin
   { This feat needs Class Simple Weapons! }
   ParameterSelect := TParameterSelect.Create(self);
   Try
     For I := 0 to CurrentClass.SelectableWeapons.Count-1 Do Begin
       Tmp := World.AddWeapon(TWeaponList(CurrentClass.SelectableWeapons).Items[I].Name);
       if Tmp.Group = 0 Then
          ParameterSelect.ParameterList.Items.Add(CurrentClass.SelectableWeapons[I].Name);
     End;

     If ( ParameterSelect.ParameterList.Items.Count > 0 ) and (ParameterSelect.ShowModal =  MrOk) Then
       Result := ParameterSelect.ParameterList.Items[ParameterSelect.ParameterList.ItemIndex];
   Finally
     ParameterSelect.Free;
   End;
 End Else If (TBaseFeat(Item).Flags and 8) > 0 Then Begin
   { This feat needs Class Simple Weapons! }
   ParameterSelect := TParameterSelect.Create(self);
   Try
     For I := 0 to CurrentClass.SelectableWeapons.Count-1 Do Begin
       Tmp := World.AddWeapon(TWeaponList(CurrentClass.SelectableWeapons).Items[I].Name);
       if Tmp.Group = 1 Then
          ParameterSelect.ParameterList.Items.Add(CurrentClass.SelectableWeapons[I].Name);
     End;

     If ( ParameterSelect.ParameterList.Items.Count > 0 ) and (ParameterSelect.ShowModal =  MrOk) Then
       Result := ParameterSelect.ParameterList.Items[ParameterSelect.ParameterList.ItemIndex];
   Finally
     ParameterSelect.Free;
   End;
 End Else If (TBaseFeat(Item).Flags and 16) > 0 Then Begin
   { This feat needs Class Simple Weapons! }
   ParameterSelect := TParameterSelect.Create(self);
   Try
     For I := 0 to CurrentClass.SelectableWeapons.Count-1 Do Begin
       Tmp := World.AddWeapon(TWeaponList(CurrentClass.SelectableWeapons).Items[I].Name);
       if Tmp.Group = 2 Then
          ParameterSelect.ParameterList.Items.Add(CurrentClass.SelectableWeapons[I].Name);
     End;

     If ( ParameterSelect.ParameterList.Items.Count > 0 ) and (ParameterSelect.ShowModal =  MrOk) Then
       Result := ParameterSelect.ParameterList.Items[ParameterSelect.ParameterList.ItemIndex];
   Finally
     ParameterSelect.Free;
   End;
 End else If TBaseFeat(Item).Parameters.Count > 0 Then Begin
   ParameterSelect := TParameterSelect.Create(self);
   Try
     ParameterSelect.SetList(TBaseFeat(Item).Parameters);
     If ParameterSelect.ShowModal =  MrOk Then Begin
       Result := ParameterSelect.ParameterList.Items[ParameterSelect.ParameterList.ItemIndex];
     End;
   Finally
     ParameterSelect.Free;
   End;
 End Else Result := '';
End;

procedure TMain.FeatSelectorSelect(Control: TWinControl; Item: TPrimalDNDObject);
Var PArameter : String;
begin
 Requires('');
 If FPLeft < 1 Then Begin
  Requires('No featpoints left');
  Exit;
 End;
 If ( not TBaseFeat(Item).MeetsPrerequisites(Character) ) Then Begin
   Exit;
 End;

 Parameter := SelectFeatParameters(Item);
 if Parameter <> '-' Then
 Character.AddFeat(TBaseFeat(Item),Parameter);
 CalcFPLeft;
 LearnedFeats.Invalidate;
 Changed;
end;

procedure TMain.LearnedFeatsSelect(Control: TWinControl; Item: TPrimalDNDObject);
begin
 Item.Free;
 CalcFPLeft;
 LearnedFeats.Invalidate;
 Changed;
end;

Procedure TMain.CalcLanguagePointsLeft;
Begin
 LPMax := Character.LanguagePoints;
 LPLeft := LPMAx - Character.Languages.Count;
 LPLanguages.Caption := IntToStr(LPLeft);
End;

procedure TMain.LanguageSelectorSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
 If (LPLeft < 1) Then  Begin
  Requires('');
  Requires('No languagepoints left');
  Exit;
 End;
 If ( Character.Languages.IndexOf(Item) = -1 ) Then Begin
   Character.AddLanguage(TLanguage(Item));
   CalcLanguagePointsLeft;
   Changed;
   LearnedLanguages.Invalidate;
 End;
end;

procedure TMain.LearnedLanguagesSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
 If ( Character.Base.Languages.IndexOf(Item) <> -1 ) Then Begin
   Character.RemoveLanguage(TLanguage(Item));
   CalcLanguagePointsLeft;
   Changed;
   LearnedLanguages.Invalidate;
 End Else Begin
   Requires('');
   Requires('Cannot remove default racial language(s).');
   Exit;
 End;
end;

procedure TMain.AvailableSpellsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var lEvel : Integer;
     I  :integer;
     Count : Integer;
     T : TTrainedClass;
begin
 Level := Round(TTrainedSpell(ITem).Level);

 T := TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]);
 Count := 0;
 For I := 0 To T.LearnedSpells.Count-1 Do
   If TTrainedSpell(T.LearnedSpells[I]).Level = Level Then
 Inc(Count);

 if ( T.Points.Known[Level] > -1 ) and ( Count >= T.Points.Known[Level] ) Then Begin
   If MessageDlg('That would cross your ''known spells'' limit for that level. Add it anyway?', mtConfirmation,
      [mbYes, mbNo], 0) = mrNo Then Begin
      Exit;
   End;
 End;

 Character.AddSpell(TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]).BaseClass,TTrainedSpell(Item).BaseSpell,Round(TTrainedSpell(ITem).Level));
 Changed;
 TrainedSpells.Invalidate;
end;

procedure TMain.TrainedSpellsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
 Item.Free;
 Changed;
 TrainedSpells.Invalidate;
end;

procedure TMain.Exit1Click(Sender: TObject);
begin
 Close;
end;

procedure TMain.LoadCharacter1Click(Sender: TObject);
Var OpenDialog : TOpenDialog;
begin
 OpenDialog := TOpenDialog.Create(Self);
 OpenDialog.DefaultExt := 'rb3';
 openDialog.InitialDir := ExtractFilePath(ParamStr(0))+'characters';
 OpenDialog.Filter := 'Redblade Character(*.rb3)|*.rb3';
 If OpenDialog.Execute Then Begin
   Screen.Cursor := crHourGlass;
   Application.ProcessMessages;
   Try
     NewCharacter;
     Character.Load(OpenDialog.FileName);
     Changed;
     RefreshClassSelector;
     UpdateRaceSelector;
     Changed;
     SelectSpells;
     FindDomains;
     FindSpecializiation;
     LastFileName := OpenDialog.FileName;
     Changed;
     AssignPanel.Visible := False;
     PointAssignPanel.Visible := False;
   Finally
     Screen.Cursor := crDefault;
   End;
 End;
 OpenDialog.Free;
end;

procedure TMain.SaveAs1Click(Sender: TObject);
Var SaveDialog : TSaveDialog;
Label Skip;
begin

 Character.WorldFileName := ExtractfileName(World.WorldFileName);
 SaveDialog := TSaveDialog.Create(Self);
 SaveDialog.DefaultExt := 'rb3';
 SaveDialog.InitialDir := ExtractFilePath(ParamStr(0))+'characters';
 SaveDialog.Filter := 'Redblade Character(*.rb3)|*.rb3';
 SaveCancelled := FAlse;
 If ( Main.Character.Name <> '' ) Then
  SaveDialog.FileName := Main.Character.Name+'.rb3';
 If ( LastFileName <> '' ) Then
  SaveDialog.FileName := LastFileName;
 If SaveDialog.Execute Then Begin
   If FileExists(SaveDialog.FileName) Then
      Case MessageDlg('This file already exists. overwrite?', mtConfirmation,
        [mbYes, mbNo,mbCancel], 0) of
         MrNo, MrCancel : Goto Skip;
      End;
   Character.Save(SaveDialog.FileName);
   LastFileName := SaveDialog.FileName;
 End Else SaveCancelled := True;
 Skip:
 SaveDialog.Free;
end;

procedure TMain.NewCharacter1Click(Sender: TObject);
Var CanClose : Boolean;
begin
 CanClose := False;
 If Character.fChanged Then
  Case MessageDlg('Are you sure you want to create a new character? (This will destroy your current character)', mtWarning,
     [mbOk,mbCancel], 0) of
    MrOk : Begin
                CanClose := True;
            End;
    MrCancel : Begin
                     CanClose := False;
               End;
 End;
 If CanClose Then NewCharacter;
end;

procedure TMain.FormShow(Sender: TObject);
Const Start : Boolean = True;
Begin
  If Start Then Begin
    Start := False;
    NewCharacter;
    Changed;
  End;
end;

procedure TMain.SaveCharacter1Click(Sender: TObject);
begin
  If LastFileName = '' Then SaveAs1Click(Self) Else Begin
    Character.Save(LastFIleName);
  End;
end;

procedure TMain.SpellSchoolSelectorChange(Sender: TObject);
begin
 SelectSpells;
end;

procedure TMain.SpellLevelSelectorChange(Sender: TObject);
begin
 SelectSpells;
end;

procedure TMain.ClassesAfterIncrease(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
 Changed;
end;

Procedure TMain.CalculateClassSpells(C : TTrainedClasS);
Var I : Integer;
    S : TTrainedSpell;
Begin

 If C.BaseClass.AutoHasAllClassSpells = 0 Then Exit;

 For I := C.LearnedSpells.Count-1 DownTo 0 Do Begin
   C.LearnedSpells[I].Free;
 End;

 For I := 0 To World.Spells.Count-1 Do Begin
   If (World.Spells[I].UsableBy(C)) Then BEgin
      S := TTrainedSpell.Create( World.spells[I] ,TSpellList( C.LearnedSpells) );
      S.Level := World.Spells[I].SpellLevel(C);
   End;
 End;
End;

procedure TMain.ClassesAfterDecrease(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
 Changed;
end;

Procedure TMain.InitDomainSelect;
Var I : Integer;
Begin
 SelDomain1.Items.BeginUpdate;
 SelDomain2.Items.BeginUpdate;
 SelDomain1.Items.Clear;
 SelDomain2.Items.Clear;
{ For I := 1 To TOTALDOMAINS Do Begin
   SelDomain1.Items.Add(Domains[I]);
   SelDomain2.Items.Add(Domains[I]);
 End;}
 For I := 1 To World.Domains.Count-1 Do Begin
   SelDomain1.Items.Add(World.Domains[I].Name);
   SelDomain2.Items.Add(World.Domains[I].Name);
 End;
 SelDomain1.Items.EndUpdate;
 SelDomain2.Items.EndUpdate;
End;

Procedure TMain.UpdateSpecializeSelect;
Var Group : String;
Begin
 if SpecializeSelect.ItemIndex = -1 Then SpecializeSelect.itemIndex := 0;
 if SpecializeSelect.ItemIndex <> 0 Then Begin
   Group := SpecializeSelect.Items[SpecializeSelect.ItemIndex];
   InitProhibited(Group, ProhibitedSelect.Items);
   ProhibitedSelect.ItemIndex := 0;
   ProhibitedSelect.Enabled := True;
 End Else Begin
   ProhibitedSelect.Clear;
   ProhibitedSelect.Enabled := False;
 End;
 ClassSchoolLimit;
 ClassDomainLimit;
End;

Procedure TMain.ClassSchoolLimit;
Var I : Integer;
Begin
  SpellSchoolSelector.Items.BeginUpdate;
  SpellSchoolSelector.Clear;
  SpellSchoolSelector.Items.Add('All');
  For I := 1 To TOTALSCHOOLS Do
    if Pos(Schools[I],Character.ProHibitedSchools)=0 Then SpellSchoolSelector.Items.Add(Schools[I]);
  SpellSchoolSelector.Items.EndUpdate;
  SpellSchoolSelector.ItemIndex := 0;
End;

Procedure TMain.ClassDomainLimit;
Var I : Integer;
Begin
  DomainSelector.Items.BeginUpdate;
  DomainSelector.Clear;
  DomainSelector.Items.Add('All');
  For I := 1 To World.Domains.Count-1 Do
    if Pos(lowercase(World.Domains[I].Name),lowercase(Character.ProhibitedDomains))=0 Then DomainSelector.Items.Add(World.Domains[I].Name);
  DomainSelector.Items.EndUpdate;
  DomainSelector.ItemIndex := 0;
  DomainSelector.DropDownCount := DomainSelector.Items.Count;
End;

procedure TMain.FindSpecializiation;
var I : Integer;
Begin
 If Character.SpecializedSchools ='' Then Begin
   SpecializeSelect.ItemIndex := 0;
   UpdateSpecializeSelect;
   Exit;
 End;
 I := SpecializeSelect.Items.IndexOf(Character.SpecializedSchools);
 If ( I <> -1 ) Then SpecializeSelect.ItemIndex := I;

 If Character.ProhibitedSchools ='' Then Exit;
 I := ProhibitedSelect.Items.IndexOf(Character.ProhibitedSchools);
 If ( I <> -1 ) Then ProhibitedSelect.ItemIndex := I;

End;

procedure TMain.FindDomains;
var I : Integer;
Begin
 I := SelDomain1.Items.IndexOf(Character.Domain1);
 If ( I <> -1 ) Then SelDomain1.ItemIndex := I;

 I := SelDomain2.Items.IndexOf(Character.Domain2);
 If ( I <> -1 ) Then SelDomain2.ItemIndex := I;

End;

Procedure Tmain.SetSpecialization;
Begin
 If ProhibitedSelect.ItemIndex <> -1 Then
 If SpecializeSelect.ItemIndex = 0 Then Begin
   Character.SpecializedSchools := '';
   Character.ProhibitedSchools := '';
 End Else Begin
   Character.SpecializedSchools := SpecializeSelect.Items[SpecializeSelect.ItemIndex];;
   If ProhibitedSelect.ItemIndex <> -1 Then
     Character.ProHibitedSchools := ProhibitedSelect.Items[ProhibitedSelect.ItemIndex];
 End;
 ClassSchoolLimit;
 ClassDomainLimit;
End;

procedure TMain.SpecializeSelectChange(Sender: TObject);
begin
 UpdateSpecializeSelect;
 SetSpecialization;
end;

procedure TMain.ProhibitedSelectChange(Sender: TObject);
begin
 SetSpecialization;
end;

procedure TMain.SelDomain1Change(Sender: TObject);
begin
 Character.Domain1 := SelDomain1.Items[SelDomain1.ItemIndex];
end;

procedure TMain.SelDomain2Change(Sender: TObject);
begin
 Character.Domain2 := SelDomain2.Items[SelDomain2.ItemIndex];
end;

Function AddToStr(Int : Integer) : String;
Begin
  Result := IntToStr(Int);
  If ( Int > 0 ) Then Result := '+' + Result;
End;


Function SpellSaveToText(T : TBaseSpell) : String;
Const Txt: Array[0..5] of String = ( '', 'Part', 'Half', 'Nega', 'Disb', 'Txt' );
Const Stt: Array[0..3] of String = ( '', 'Fort ', 'Ref ', 'Will ' );

Begin
 Result := Stt[T.SaveStat] + Txt[T.Save];
{ if ( T.SaveFlags and 1 ) > 0 then Result := Result + 'o';
 if ( T.SaveFlags and 2 ) > 0 then Result := Result + 'h';}

 Case T.mr Of
    0 : Begin
         If Result <> '' Then Result := Result+',';
         Result := Result + 'MR';
{         if ( T.MrFlags and 1 ) > 0 then Result := Result + 'o';
         if ( T.MrFlags and 2 ) > 0 then Result := Result + 'h';}
       End;
 End;

End;

Function SpellComponentsToText(T : TBaseSpell) : String;
Const Comps: Array[0..5] of String = ( 'v','s','m','f','df','xp');
var  I : Integer;
Begin
 Result := '';
 For I := 0 To 5 Do If ( T.Components and (1 SHL I) ) > 0 Then Begin
   If Result <>'' Then Result := Result +',';
   Result := Result + Comps[I];
 End;
End;

Function IntToStrL(I : Integer) : String;
Begin
 Result := IntToStr(I);
 While Length(Result) < 3 Do Result := ' '+Result;
End;

Function IntToStrM(I : Integer) : String;
Begin
 Result := IntToStr(I);
 While Length(Result) < 7 Do Result := '_'+Result;
End;

Function FloatToStrL(I : Extended) : String;
Begin
 Result := FloatToStr(I);
 While Length(Result) < 3 Do Result := ' '+Result;
End;

Procedure TMain.GenerateSheet(fType : Integer);
Var DNDOutput : TDNDOutput;
    I : Integer;
    Row,Col : Integer;
    J : Integer;
    Line : Integer;
    LastSkill : Integer;

Procedure AddSpellPage;
Begin
    Line := 1;
    DNDOutput.NextPage;
    DNDOutput.HLine(1,79,1);
    DNDOutput.HLine(1,79,60);
End;

Procedure SpellHeader(B : Integer);
Begin
  With DNDOutput Do Begin
    If ( B = 0 ) or  ( B = 1 ) Then Begin
{      Inc(Line,2);}
{      PrintLn(2, Line,Character.Classes[I].Name + ' Spells',TeNormal);}
    End;
    If ( B = 0 ) or  ( B = 2 ) Then Begin
      Inc(Line,2);
      PrintLn(2, Line,'St Us',TeNormal);
      PrintLn(8, Line,'Name',TeNormal);
      PrintLn(32,Line,'School',TeNormal);
      PrintLn(40,Line,'Save',TeNormal);
      PrintLn(54,Line,'Components',TeNormal);
      PrintLn(79-3,Line,'Page',TeNormal);
    End;
  End;
End;

Var LastLevel : Integer;
    SpellLvl : Integer;
    Found : Boolean;
    Tmp : String;
    Weapon : TDNDItem;
    SpellsKnown : Integer;
    AnySpell : Boolean;
    XX : String;
    Bonus : Integer;
    JustNewPage : Boolean;
Begin
 if ( Character.fRace = nil ) Then Begin
  ShowMessage('Please select a race first');
  Exit;
 End;
 if ( Character.Classes.Count < 1 ) Then Begin
  ShowMessage('I refuse to generate a peasant! Please select a class first! (I''m a hero generator, not a peasant generator! *mumble* Good for nothing roleplayers *mumble* with their unique ideas *mumble*)');
  Exit;
 End;
 case fType of
   666 : DNDOutput := TDNDTextOutput.Create;
   Else DNDOutput := TDNDTextOutput.Create;
 End;
 Try
   Character.Calculate;
   For I := 0 To Character.Classes.Count-1 Do
   CalculateClassSpells(Character.Classes[I]);
   With DNDOutput Do Begin
    HLine(1,79,1);
    PrintLn(2,2,'Character:',TeNormal);
    PrintLn(13,2,Character.Name,TeNormal);
    PrintLn(40,2,'Alignment:',TeNormal);
    if Alignment.ItemIndex <> -1 Then
    PrintLn(51,2,Alignment.Items[Alignment.itemIndex],TeNormal);
    PrintLn(40,3,'    Speed:',TeNormal);
    PrintLn(51,3,IntToStr(Character.Speed)+' feet',TeNormal);
    HLine(1,79,4);
    PrintLn(2,3,'Race:',TeNormal);
    if ( Character.Race <> nil) Then
    PrintLn(13,3,Character.Race.Name,TeNormal);
    PrintLn(49,5,'Class:',TeNormal);
    Row:=0;Col:=0;
    if ( Character.Classes <> nil) Then Begin
      For I := 0 To Character.Classes.Count-1 Do Begin
         Inc(Row); If Row > 6 Then Begin
           Row := 1;
           Inc(Col,14);
         End;
          PrintLn(58+Col,4+Row,FloatToStr(Character.Classes.Items[I].Value)+' '+Character.Classes.Items[I].Name,TeNormal);
      End;
    End;
    PrintLn(2,6,'Str',TeNormal);
    PrintLn(2,7,'Dex',TeNormal);
    PrintLn(2,8,'Con',TeNormal);
    PrintLn(2,9,'Int',TeNormal);
    PrintLn(2,10,'Wis',TeNormal);
    PrintLn(2,11,'Cha',TeNormal);
    PrintLn(7,5,'Score',TeNormal);
    PrintLn(7,6,IntToStr(Character.Abilities.Str),TeNormal);
    PrintLn(7,7,IntToStr(Character.Abilities.Dex),TeNormal);
    PrintLn(7,8,IntToStr(Character.Abilities.Con),TeNormal);
    PrintLn(7,9 ,IntToStr(Character.Abilities.Int),TeNormal);
    PrintLn(7,10,IntToStr(Character.Abilities.Wis),TeNormal);
    PrintLn(7,11,IntToStr(Character.Abilities.Cha), TeNormal);
    PrintLn(13,5,'Mod',TeNormal);
    PrintLn(13,6,AddToStr(Character.Abilities.StrModifier),TeNormal);
    PrintLn(13,7,AddToStr(Character.Abilities.DexModifier),TeNormal);
    PrintLn(13,8,AddToStr(Character.Abilities.ConModifier),TeNormal);
    PrintLn(13,9 ,AddToStr(Character.Abilities.IntModifier),TeNormal);
    PrintLn(13,10,ADdToStr(Character.Abilities.WisModifier),TeNormal);
    PrintLn(13,11,AddToStr(Character.Abilities.ChaModifier),TeNormal);

    VLine(17,5,11);

    HLine(1,79,12);

    PrintLn(23,5, 'Total  Base Abil Misc Size Armor',TeNormal);
    PrintLn(18,6, 'ac',TeNormal);
    PrintLn(24,6,IntToStrL(Character.ArmorClass),TeNormal);
    PrintLn(18,7, 'hp',TeNormal);
    PrintLn(24,7,IntToStrL(Character.HitPoints),TeNormal);
    PrintLn(31,7,IntToStrL(Character.BaseHitPoints),TeNormal);
    PrintLn(36,7,IntToStrL(Character.ConHitPoints),TeNormal);
    PrintLn(18,8, 'fort',TeNormal);
    PrintLn(18,9,'ref ', TeNormal);
    PrintLn(18,10,'will',TeNormal);
    PrintLn(18,11,'init',TeNormal);
    PrintLn(24,8, IntToStrL(Character.Fortitude),TeNormal);
    PrintLn(24,9,IntToStrL(Character.Reflex), TeNormal);
    PrintLn(24,10,IntToStrL(Character.Will),TeNormal);
    PrintLn(24,11,IntToStrL(Character.Initiative),TeNormal);
    PrintLn(30,6, '=',TeNormal);
    PrintLn(30,7, '=',TeNormal);
    PrintLn(30,8, '=',TeNormal);
    PrintLn(30,9 ,'=',TeNormal);
    PrintLn(30,10,'=',TeNormal);
    PrintLn(30,11,'=',TeNormal);
    PrintLn(31,6, IntToStrL(Character.fRace.Points.ArmorClass),TeNormal);
    PrintLn(31,8, IntToStrL(Character.SavingThrows.Fortitude),TeNormal);
    PrintLn(31,9 ,IntToStrL(Character.SavingThrows.Reflex), TeNormal);
    PrintLn(31,10,IntToStrL(Character.SavingThrows.Willpower),TeNormal);
    PrintLn(31,11,'  1',TeNormal);
    PrintLn(35,6, '+',TeNormal);
    PrintLn(35,7, '+',TeNormal);
    PrintLn(35,8, '+',TeNormal);
    PrintLn(35,9 ,'+',TeNormal);
    PrintLn(35,10,'+',TeNormal);
    PrintLn(35,11,'+',TeNormal);
    PrintLn(36,6, IntToStrL(Character.ArmorDexBonus),TeNormal);
    PrintLn(36,8, IntToStrL(Character.Abilities.ConModifier),TeNormal);
    PrintLn(36,9 ,IntToStrL(Character.Abilities.DexModifier), TeNormal);
    PrintLn(36,10,IntToStrL(Character.Abilities.WisModifier),TeNormal);
    PrintLn(36,11, IntToStrL(Character.Abilities.DexModifier),TeNormal);
    PrintLn(40,6, '+',TeNormal);
{    PrintLn(40,7, '+',TeNormal);}
    PrintLn(40,8, '+',TeNormal);
    PrintLn(40,9 ,'+',TeNormal);
    PrintLn(40,10,'+',TeNormal);
    PrintLn(40,11,'+',TeNormal);
    PrintLn(41,6 , IntToStrL(Character.WisAcBonus),TeNormal);
    PrintLn(41,8 , IntToStrL(Character.Savebonus),TeNormal);
    PrintLn(41,9 , IntToStrL(Character.Savebonus),TeNormal);
    PrintLn(41,10, IntToStrL(Character.Savebonus),TeNormal);
    PrintLn(41,11, IntToStrL(Character.InitiativeMisc),TeNormal);
    PrintLn(45,6, '+',TeNormal);
{    PrintLn(45,8, '+',TeNormal);
    PrintLn(45,9 ,'+',TeNormal);
    PrintLn(45,10,'+',TeNormal);}
    PrintLn(46,6, IntToStrL(Character.SizeBonus),TeNormal);
    PrintLn(50,6, '+',TeNormal);
{    PrintLn(50,8, '+',TeNormal);
    PrintLn(50,9 ,'+',TeNormal);
    PrintLn(50,10,'+',TeNormal);}
    Tmp := IntToStrL(Character.ArmorBonus);
    If Character.ShieldBonus <> 0 Then Tmp := Tmp + '/'+IntTOStr(Character.ShieldBonus);
    PrintLn(51,6, Tmp,TeNormal);

    VLine(56,5,11);

    {-------------------------------------------------------------------------}

    PrintLn(2,14,'Skill               Key  Total Abil Rank Misc',TeNormal);

    SPMax := Character.SkillPoints;
    CalcSPLeft;
    if SPLeft > 0 Then
    PrintLn(8,14,'(Left: '+IntToStr(SPLeft)+')',TeNormal);


    Line := 0;
    LastSkilL := -1;
    For I := 0 To World.Skills.Count-1 Do Begin

     If not Character.SkillUsable(World.Skills[I]) Then Continue;

     Found := False;
     For J := 0 To Character.Skills.Count-1 Do Begin

       if Character.Skills[J].BaseSkill <> World.Skills[I] Then Continue;
       Found := True;

       If Character.SkillIsCrossClass(World.Skills[I]) Then
         PrintLn( 1,16+Line,'*',TeNormal);

       If Length(Character.Skills[J].Name) > 18 Then Begin
         PrintLn( 2,16+Line,Copy(Character.Skills[J].BaseSkill.Name,1,18),TeNormal);
       End Else Begin
         PrintLn( 2,16+Line,Copy(Character.Skills[J].Name,1,18),TeNormal);
       End;
       PrintLn(22,16+Line,Lowercase(AbTxt[World.Skills[I].PrimeAbility]),TeNormal);
       PrintLn(28,16+Line,FloatToStrL(Character.TrainedSkillTotalRanks(Character.Skills[J])),TeNormal);
       PrintLn(33,16+Line,IntToStrL(Character.SkillAbilityMod(World.Skills[I])),TeNormal);
       PrintLn(38,16+Line,FloatToStrL(Character.TrainedSkillRanks(Character.Skills[J])),TeNormal);
       PrintLn(43,16+Line,FloatToStrL(Character.TrainedSkillMiscRanks(Character.Skills[J])),TeNormal);
       PrintLn(32,16+Line,'=',TeNormal);
       PrintLn(37,16+Line,'+',TeNormal);
       PrintLn(42,16+Line,'+',TeNormal);
       Inc(Line);
       If Length(Character.Skills[J].Name) > 18 Then Begin
         PrintLn( 2,16+Line,Character.Skills[J].Parameter,TeNormal);
         Inc(Line);
         If ( Line > 47-16 ) Then Begin
            ShowMessage('Too many skills to fit on the main character sheet! Adding a seperate sheet.');
            LastSkill := I;
           Break;
         End;
       End;

     End;

     if not found Then Begin

       If Character.SkillIsCrossClass(World.Skills[I]) Then
         PrintLn( 1,16+Line,'*',TeNormal);

       PrintLn( 2,16+Line,World.Skills[I].Name,TeNormal);
       PrintLn(22,16+Line,Lowercase(AbTxt[World.Skills[I].PrimeAbility]),TeNormal);
       PrintLn(28,16+Line,FloatToStrL(Character.SkillTotalRanks(World.Skills[I])),TeNormal);
       PrintLn(33,16+Line,IntToStrL(Character.SkillAbilityMod(World.Skills[I])),TeNormal);
       PrintLn(38,16+Line,FloatToStrL(Character.SkillRanks(World.Skills[I])),TeNormal);
       PrintLn(43,16+Line,FloatToStrL(Character.SkillMiscRanks(World.Skills[I])),TeNormal);
       PrintLn(32,16+Line,'=',TeNormal);
       PrintLn(37,16+Line,'+',TeNormal);
       PrintLn(42,16+Line,'+',TeNormal);
       Inc(Line);
       if ( Line > 47-16 ) Then Begin
         ShowMessage('Too many skills to fit on the main character sheet! Adding a seperate sheet.');
         LastSkill := I;
         Break;
       End;
     End;

    End;


    For I := Line To 47-16 Do
    PrintLn(2,16+I,'___________________ ____ _____=____+____+____',TeNormal);


    Line := 49;

    PrintLn(1,Line,'================================================',TeNormal);
    Inc(Line);
    PrintLn(2,Line,'BAB           | Attack   Total  BAB Abil Size ',TeNormal);
    Inc(Line,1);
    PrintLn(2,Line,'              |',TeNormal);
    PrintLn(2,Line,Character.BAB,TeNormal);
    Inc(Line,1);
    PrintLn(2,Line,'              | Melee         =    +    +    ', TeNormal);
    PrintLn(29,Line,IntToStrL(Character.BABMeleeBase),TeNormal);
    PrintLn(34,Line,IntToStrL(Character.MeleeBase(0)),TeNormal);
    PrintLn(39,Line,IntToStrL(Character.Abilities.StrModifier),TeNormal);
    PrintLn(44,Line,IntToStrL(Character.Sizebonus),TeNormal);
    Inc(Line);
    PrintLn(2,Line,'              | Range         =    +    +    ', TeNormal);
    PrintLn(29,Line,IntToStrL(Character.BABRangeBase),TeNormal);
    PrintLn(34,Line,IntToStrL(Character.RangeBase(0)),TeNormal);
    PrintLn(39,Line,IntToStrL(Character.Abilities.DexModifier),TeNormal);
    PrintLn(44,Line,IntToStrL(Character.Sizebonus),TeNormal);


    {-------------------------------------------------------------------------}

{    For I := 0 To Character.Skills.Count-1 Do Begin
    End;}

    VLine(49,14,55);

    PrintLn(51,14,'Feats',TeNormal);

    CalcFPLeft;

    Bonus := 0;
    For I := 0 To Character.Classes.Count-1 Do Begin
      Bonus := Bonus + (Character.BonusFeatPoints(Character.Classes[I]) -
                       Character.BonusFeatPointsUsed(Character.Classes[I]));
    End;

    If Bonus > 0 Then Begin
      PrintLn(58,14,'(Left: '+IntToStr(FPLeft)+' + '+IntToStr(Bonus)+')',TeNormal);
    End Else If FPLeft > 0 Then
      PrintLn(58,14,'(Left: '+IntToStr(FPLeft)+')',TeNormal);

    Line := 0;
    For I := 0 To Character.LearnedFeats.Count-1 Do Begin
      PrintLn(51,16+Line, Character.LearnedFeats[I].Name,TeNormal);
      Inc(Line);
    End;
    For I := 0 To Character.Feats.Count-1 Do Begin
      PrintLn(51,16+Line,Character.Feats[I].Name,TeNormal);
      Inc(Line);
    End;
    While ( Line < 40-16 ) Do Begin
      PrintLn(51,16+Line,'____________________________',TeNormal);
      Inc(Line);
    End;
    Inc(LIne,2);
    PrintLn(51,16+Line,'Languages',TeNormal);
    Inc(LIne,2);
    For I := 0 To Character.Languages.Count-1 Do Begin
      PrintLn(51+((I MOD 2)*15),16+Line,Character.Languages[I].Name,TeNormal);
      If ( I mod 2 = 1 ) Then Inc(Line);
    End;

    While ( Line < 53-16 ) Do Begin
      PrintLn(51,16+Line,'_____________  _____________',TeNormal);
      Inc(Line);
    End;

    HLine(1,79,54);
    PrintLn(2,49,'(* Cross Class)',TeNormal);
    PrintLn(2,55,'Weapon                   Total Attacks  Damage  Critical  Range  Weight  Size',TeNormal);
{                 1234567890123456789012345678901234567890123456789012345678901234567890123456789}
    Line := 2;
    For I := -1 To 2 Do Begin
      Weapon := Character.GetWeapon(I);
      If (Weapon <> Nil) Then Begin
        If (I in [0,1]) and DualWield.Checked Then Begin
         PrintLn(1,54+Line,'*', TeNormal);
        End;
        If (I in [0,1]) and TwoHandedWield.Checked Then Begin
         PrintLn(1,54+Line,'#', TeNormal);
        End;
        PrintLn(2,54+Line,Weapon.RealName, TeNormal);
        PrintLn(23+4,54+Line,Character.WeaponTotalAttackBonus(I),TeNormal);
        PrintLn(38+4,54+Line,Character.WeaponDamage(I),TeNormal);
        PrintLn(46+4,54+Line,Character.WeaponCritical(I),TeNormal);
        PrintLn(56+4,54+Line,Character.WeaponRange(I),TeNormal);
        PrintLn(63+4,54+Line,Character.WeaponWEight(I),TeNormal);
        PrintLn(71+4,54+Line,Copy(Character.WeaponSize(I),1,3),TeNormal);
{        PrintLn(77-5,54+Line,Character.WeaponType(I),TeNormal);}
{        PrintLn(72,53+Line,Character.WeaponType(I),TeNormal);}
        Inc(Line);
      End;
    End;

    PrintLn(1,60,'=(* Dual Wielding)==(# Twohanded Wield)========================================',TeNormal);


    AddSpellPage;

    Line := 1;
    For I := 0 To Character.Classes.Count-1 Do Begin
      Inc(Line);
      PrintLn(1,Line,Character.Classes[I].Name + ' abilities',TeNormal);
      For J := 0 To Character.Classes[I].ChosenClassAbilities.Count-1 Do Begin
        Inc(Line);
        PrintLn(1,Line,'- ' +Character.Classes[I].ChosenClassAbilities[J].Name,TeNormal);
      End;
      For J := 0 To Character.Classes[I].FreeClassAbilities.Count-1 Do Begin
        Inc(Line);
        PrintLn(1,Line,'- '+Character.Classes[I].FreeClassAbilities[J].Name,TeNormal);
      End;
    End;

    HLine(1,79,Line);
    Inc(Line,1);
    Inc(Line,1);
    Println(1,Line,'Backpack:',TeNormal);
    Inc(Line,1);

    Println(1,Line,'Count  Item                          lb Count  Item                          lb',TeNormal);
    Inc(Line,1);

    For I := Line To 50 Do Begin

      Println(1,I,'[__] x ___________________________ ____ [__] x ___________________________ ____',TeNormal);
{      Println(1,I,'[__] x ________________________________ [__] x ____________ [__] x ____________',TeNormal);}

    End;

    For I := 0 To Character.Inventory.Count-1 Do Begin
      Println(8+((I mod 2)*40),Line,Copy(Character.Inventory[I].RealName,1,32),TeNormal);
      If Character.Inventory[I].Pounds > 0 Then
      Println(36+((I mod 2)*40),Line,' '+IntToStrL(Character.Inventory[I].Pounds),TeNormal);
      If (I mod 2 ) <> 0 Then Inc(Line);
    End;

    For I := 0 To Character.Equipped[0].Count-1 Do Begin
      Println(7+((I mod 2)*40),Line,'*'+Copy(Character.Equipped[0][I].RealName,1,32),TeNormal);
      If Character.Equipped[0][I].Pounds > 0 Then
      Println(36+((I mod 2)*40),Line,' '+IntToStrL(Character.Equipped[0][I].Pounds),TeNormal);
      If (I mod 2 ) <> 0 Then Inc(Line);
    End;

    Line := 51;
    HLine(1,79,Line);
    PrintLn(2,Line, '(* Equipped)',TeNormal);
    Line := 52;
    PrintLn(1,Line, 'Light Load: ____________   Medium Load: ____________   Heavy Load: ____________',TeNormal);
   {                 1234567890123456789012345678901234567890123456789012345678901234567890123456789}
    PrintLn(13,Line, IntToStr(Character.LightLoad), TeNormal);
    PrintLn(38+3,Line, IntToStr(Character.LightLoad+1)+'-'+IntToStr(Character.MediumLoad), TeNormal);
    PrintLn(62+6,Line, IntToStr(Character.MediumLoad+1)+'-'+IntToStr(Character.heavyLoad), TeNormal);

    Line := 53;

    HLine(1,79,Line);
    Inc(Line,1);
    Println(1,Line,'Pouch:',TeNormal);
    Inc(Line,1);
    Inc(Line,1);

    For I := Line To 59 Do Begin
       Println(1,I,'_______ __________  _______ __________  _______ __________  _______ ___________',TeNormal);

    End;

    Println(1,Line,'_______ Platinum__  _______ Gold______  _______ Silver____  _______ Copper_____',TeNormal);
  {              1234567890123456789012345678901234567890123456789012345678901234567890123456789}
    PrintLn(1,Line, IntToStrM(Character.Money.Platinum), TeNormal);
    PrintLn(21,Line, IntToStrM(Character.Money.Gold), TeNormal);
    PrintLn(41,Line, IntToStrM(Character.Money.Silver), TeNormal);
    PrintLn(61,Line, IntToStrM(Character.Money.Copper), TeNormal);
    Inc(Line,1);

    HLine(1,79,60);
    Line := 2;

    AnySpell := False;
    For I := 0 To Character.Classes.Count-1 Do Begin

      TSpellList(Character.Classes[I].LearnedSpells).Sort;
      if ( Line > 55 ) Then Begin
        AddSpellPage;
      End;

      LastLevel := -1;

      JustNewPage := False;
      For J := 0 To Character.Classes[I].LearnedSpells.Count-1 Do Begin
            if not AnySpell Then Begin
              AddSpellPage;
              AnySpell := True;
            End;

            If ( Line > 57 ) Then Begin
              AddSpellPage;
              JustNewPage := True;
{              SpellHeader(0);}
            End;
            Inc(Line);
            With TTrainedSpell(Character.Classes[I].LearnedSpells[J]).BaseSpell Do Begin
              SpellLvl := Round(TTrainedSpell(Character.Classes[I].LearnedSpells[J]).Level);
              if (SpellLvl <> LastLevel) or (JustNewPage) Then Begin
                If ( Line > 54 ) Then Begin
                  AddSpellPage;
                  Inc(Line);
{                  SpellHeader(0);}
                End;
                 JustNewPage := False;
                SpellHeader(1);
                Inc(Line);
                SpellsKnown := Character.SpellsKnown(Character.Classes[I],SpellLvl);
                If SpellsKnown > -1 Then Tmp := ', known spells: '+IntToStr(SpellsKnown) Else Tmp := '';

                XX := '';
                if Character.Classes[I].BaseClass.BonusSpell Then Begin
                  XX := '+1';
                End;


                PrintLn(2, Line,Character.Classes[I].Name + ' Spells - Level '+IntToStr(SpellLvl)+' (DC: '+IntToStr(Character.SpellDC(Character.Classes[I],SpellLvl))+', castable per day: '+Character.SpellsCastPerDay(Character.Classes[I],SpellLvl)+XX+tmp+' )', TeNormal );
                SpellHeader(2);
                Inc(Line);
                LastLevel := SpellLvl;
              End;
              PrintLn(2, Line,'__ __',TeNormal);
              PrintLn(8, Line,Copy(Name,1,25),TeNormal);
              PrintLn(34,Line,Copy(MageSchool,1,4),TeNormal);
              PrintLn(40,Line,SpellSaveToText(TTrainedSpell(Character.Classes[I].LearnedSpells[J]).BaseSpell),TeNormal);
              PrintLn(54,Line,SpellComponentsToText(TTrainedSpell(Character.Classes[I].LearnedSpells[J]).BaseSpell),TeNormal);
              PrintLn(79-3,Line,'____',TeNormal);


          End;
      End;
    End;

    AddSpellPage;

    HLine(1,79,Line);
    Inc(Line,1);
    Println(1,Line,'Appearance:',TeNormal);
    Inc(Line,2);

    If PersonalityTraits.Lines.Count = 0 Then For I := 0 To 10 Do Begin
       Println(1,Line,'_______________________________________________________________________________',TeNormal);
       Inc(Line);
       If ( Line > 55 ) Then Begin
          AddSpellPage;
          Line := 2;
          Println(1,Line,'Appearance:',TeNormal);
          Inc(Line,2);
        End;
    End;

    For I := 0 To PersonalityTraits.Lines.Count-1 Do Begin
      Println(1,Line,PersonalityTraits.Lines[I],TeNormal);
      Inc(Line);
      If ( Line > 55 ) Then Begin
        AddSpellPage;
        Line := 2;
        Println(1,Line,'Appearance:',TeNormal);
        Inc(Line,1);
      End;
    End;

    Inc(Line,1);
    HLine(1,79,Line);
    Inc(Line,1);
    Println(1,Line,'History:',TeNormal);
    Inc(Line,2);

    If HistoryTxt.Lines.Count = 0 Then For I := 0 To 20 Do Begin
       Println(1,Line,'_______________________________________________________________________________',TeNormal);
       Inc(Line);
       If ( Line > 55 ) Then Begin
         AddSpellPage;
         Line := 2;
         Println(1,Line,'History:',TeNormal);
         Inc(Line,2);
       End;
    End;

    For I := 0 To HistoryTxt.Lines.Count-1 Do Begin
      Println(1,Line,HistoryTxt.Lines[I],TeNormal);
      Inc(Line);
      If ( Line > 55 ) Then Begin
        AddSpellPage;
        Line := 2;
        Println(1,Line,'History:',TeNormal);
        Inc(Line,2);
      End;
    End;

    Inc(Line,1);
    HLine(1,79,Line);
    Inc(Line,1);
    Println(1,Line,'Goals:',TeNormal);
    Inc(Line,2);

    If Goals.Lines.Count = 0 Then For I := 0 To 10 Do Begin
       Println(1,Line,'_______________________________________________________________________________',TeNormal);
       Inc(Line);
       If ( Line > 55 ) Then Begin
         AddSpellPage;
         Line := 2;
         Println(1,Line,'Goals:',TeNormal);
         Inc(Line,2);
       End;
    End;

    For I := 0 To Goals.Lines.Count-1 Do Begin
      Println(1,Line,Goals.Lines[I],TeNormal);
      Inc(Line);
      If ( Line > 55 ) Then Begin
        AddSpellPage;
        Line := 2;
        Println(1,Line,'Goals:',TeNormal);
        Inc(Line,2);
      End;
    End;

    {-------------------------------------------------------------------------}

    If LastSkill > 0 Then Begin

      NextPage;
      Line := 1;
      HLine(1,79,Line);
      Inc(Line,1);

      PrintLn(2,Line,'Skill               Key  Total Abil Rank Misc',TeNormal);
      Inc(Line,2);

      For I := LastSkill+1 To World.Skills.Count-1 Do Begin

       If not Character.SkillUsable(World.Skills[I]) Then Continue;

       Found := False;
       For J := 0 To Character.Skills.Count-1 Do Begin

         if Character.Skills[J].BaseSkill <> World.Skills[I] Then Continue;
         Found := True;

         If Character.SkillIsCrossClass(World.Skills[I]) Then
           PrintLn( 1,Line,'*',TeNormal);

{        PrintLn( 2,Line,Copy(Character.Skills[J].Name,1,18),TeNormal);}
         If Length(Character.Skills[J].Name) > 18 Then Begin
           PrintLn( 2,Line,Copy(Character.Skills[J].BaseSkill.Name,1,18),TeNormal);
         End Else Begin
           PrintLn( 2,Line,Copy(Character.Skills[J].Name,1,18),TeNormal);
         End;

         PrintLn(22,Line,Lowercase(AbTxt[World.Skills[I].PrimeAbility]),TeNormal);
         PrintLn(32,Line,'=',TeNormal);
         PrintLn(28,Line,FloatToStrL(Character.TrainedSkillTotalRanks(Character.Skills[J])),TeNormal);
         PrintLn(33,Line,IntToStrL(Character.SkillAbilityMod(World.Skills[I])),TeNormal);
         PrintLn(38,Line,FloatToStrL(Character.TrainedSkillRanks(Character.Skills[J])),TeNormal);
         PrintLn(43,Line,FloatToStrL(Character.TrainedSkillMiscRanks(Character.Skills[J])),TeNormal);
         Inc(Line);
         If Length(Character.Skills[J].Name) > 18 Then Begin
           PrintLn( 2,Line,Character.Skills[J].Parameter,TeNormal);
           Inc(Line);
           If ( Line > 58 ) Then Begin
             ShowMessage('Woa! You skill hugger! I''m not adding a SINGLE sheet more! Bleh.');
             Break;
           End;
         End;

       End;

       if not found Then Begin

         If Character.SkillIsCrossClass(World.Skills[I]) Then
           PrintLn( 1,Line,'*',TeNormal);

         PrintLn( 2,Line,World.Skills[I].Name,TeNormal);
         PrintLn(22,Line,Lowercase(AbTxt[World.Skills[I].PrimeAbility]),TeNormal);
         PrintLn(28,Line,FloatToStrL(Character.SkillTotalRanks(World.Skills[I])),TeNormal);
         PrintLn(32,Line,'=',TeNormal);
         PrintLn(33,Line,IntToStrL(Character.SkillAbilityMod(World.Skills[I])),TeNormal);
         PrintLn(37,Line,'+',TeNormal);
         PrintLn(38,Line,FloatToStrL(Character.SkillRanks(World.Skills[I])),TeNormal);
         PrintLn(42,Line,'+',TeNormal);
         PrintLn(43,Line,FloatToStrL(Character.SkillMiscRanks(World.Skills[I])),TeNormal);
         Inc(Line);
         if ( Line > 58 ) Then Begin
           ShowMessage('Woa! You skill hugger! I''m not adding a SINGLE sheet more! Bleh.');
           Break;
           Break;
         End;
       End;

      End;


      For I := Line To 58 Do
      PrintLn(2,I,'___________________ ____ _____=____+____+____',TeNormal);

      HLine(1,79,60);

    End;

    {-------------------------------------------------------------------------}

   End;
   DNDOutput.Generate;
 Finally
   DNDOutput.Free;
 End;
End;

procedure TMain.UDStrClick(Sender: TObject; Button: TUDBtnType);
begin
 Character.Base.Abilities.Str := StrToInt(BaseStr.Caption);
end;

procedure TMain.UDDexClick(Sender: TObject; Button: TUDBtnType);
begin
 Character.Base.Abilities.Dex := StrToInt(BaseDex.Caption);
end;

procedure TMain.UDConClick(Sender: TObject; Button: TUDBtnType);
begin
 Character.Base.Abilities.Con := StrToInt(BaseCon.Caption);
end;

procedure TMain.UDIntClick(Sender: TObject; Button: TUDBtnType);
begin
 Character.Base.Abilities.Int := StrToInt(BaseInt.Caption);
end;

procedure TMain.UDWisClick(Sender: TObject; Button: TUDBtnType);
begin
 Character.Base.Abilities.Wis := StrToInt(BaseWis.Caption);
end;

procedure TMain.UDChaClick(Sender: TObject; Button: TUDBtnType);
begin
 Character.Base.Abilities.Cha := StrToInt(BaseCha.Caption);
end;

procedure TMain.TextSheet1Click(Sender: TObject);
begin
 GenerateSheet(0);
end;

procedure TMain.Customize1Click(Sender: TObject);
Var Win : TCustomize;
begin
 Win := TCustomize.Create(Self);
 Try
   Win.ShowModal;
   Main.Panel7.Caption := 'Campaign: '+World.Name;
   UpdateRaceSelector;
   ClearBooklets;
 Finally
   Win.Free;
 End;

end;

procedure TMain.Shape1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
 Hint.Visible := False;
end;

procedure TMain.SelectableClassAbilitiesSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var      T : TTrainedClass;
begin
 T := Nil;
 If ClassSelector.ItemIndex <> -1 Then Begin
   T := TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]);
 End;
 If (ClassAPLeft < 1) Then Exit;
 If ( T.ChosenClassAbilities.IndexOf(Item) = -1 ) Then Begin
   T.ChosenClassAbilities.Add(Item);
{   Character.AddLanguage(TLanguage(Item));}
   CalcClassPointsleft;
   Changed;
   ChosenClassAbilities.Invalidate;
  End;
end;

procedure TMain.ChosenClassAbilitiesSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var      T : TTrainedClass;
begin
 T := Nil;
 If ClassSelector.ItemIndex <> -1 Then Begin
   T := TTrainedClass(ClassSelector.Items.Objects[ClassSelector.ItemIndex]);
 End;

 If ( T <> nil ) Then Begin
   T.ChosenClassAbilities.Remove(Item);
   CalcClassPointsleft;
   ChosenClassAbilities.Invalidate;
 End;
end;

Var
  mTraits : Array[0..29] of String = (
    'Big Spender',
    'Bigot',
    'Clumsy',
    'Code of Behavior',
    'has debt',
    'Family Duties',
    'Phobia: crowds',
    'Phobia: darkness',
    'Phobia: enclosed spaces',
    'Phobia: fear',
    'Patriot',
    'Phobia: heights',
    'Phobia: insects',
    'Phobia: magic',
    'Phobia: psychic contact',
    'Phobia: snakes',
    'Phobia: spiders',
    'Phobia: undead',
    'Phobia: water',
    'Self-Sacrificing',
    'Slave',
    'Terminal Character',
    'Tongue-tied',
    'Unlucky',
    'Albino',
    'Allergic for Flowers',
    'Bruises Easily',
    'Colorblind',
    'Deep Sleeper',
    'Blind' );

procedure TMain.SpeedButton3Click(Sender: TObject);
begin
 PersonalityTraits.Lines.Add(mTraits[Random(Length(mTraits))]);
end;

procedure TMain.SpeedButton8Click(Sender: TObject);
begin
 RaceSelector.ItemIndex := Random(RaceSelector.Items.Count);
 RaceSelectorChange(Self);
end;

procedure TMain.SpeedButton9Click(Sender: TObject);
begin
 Alignment.ItemIndex := Random(Alignment.Items.Count);
 AlignmentChange(nil);
end;

procedure TMain.SpeedButton10Click(Sender: TObject);
begin
 AvailableClassesSelect(Self,World.Classes[Random(World.Classes.Count-1)]);
end;



procedure TMain.SpeedButton7Click(Sender: TObject);
begin
  RandomName := TRandomName.Create(Self);
  Try
    RandomName.ComboBox1.ItemIndex := GenderSelector.ItemIndex;
    if ( RandomName.ShowModal = mrOk ) Then Begin
      Character.Name := RandomName.Name;
      Name.Text := RandomName.Name;
    End;
  Finally
    RandomName.Free;
    RandomName := nil;
  End;
End;

Procedure TMain.GenerateName;
Var I,A,B,OldB : Integer;
    C   : String[10];

    Procedure ReplaceAllDoubles;
    Var I : Integer;
    Begin
     For I:=2 To Length(NewName) Do Begin
       While NewName[I-1] = NewName[I] Do NewName[I] := Char(97+Random(26));
     End;
    End;

    Procedure ReplaceAllNoums;
    Var I,L : Integer;
    Const Nu : Array[0..5] of Char = ('a','e','o','u','i','y');
    Begin
     L := 0;
     If (not(NewName[1] in ['a','A','e','E','o','O','u','U','i','I','y','Y'])) and
        (not(NewName[2] in ['a','A','e','E','o','O','u','U','i','I','y','Y'])) Then Begin
       NewName[2] := Nu[Random(6)];
     End;
     For I:=1 To Length(NewName) Do Begin
       If NewName[I] in ['a','A','e','E','o','O','u','U','i','I','y','Y'] Then Begin
         L := 0;
       End else Begin
        Inc(L);
        If L > 2 Then Begin
         NewName[I-1] := Nu[Random(6)];
        End;
       End;
     End;
    End;

    Procedure InvertedReplaceAllNoums;
    Var I,L : Integer;
    Const Nu : Array[0..5] of Char = ('a','e','o','u','i','y');
    Begin
     L := 0;
     If ((NewName[1] in ['a','A','e','E','o','O','u','U','i','I','y','Y'])) and
        ((NewName[2] in ['a','A','e','E','o','O','u','U','i','I','y','Y'])) Then Begin
       Delete(NewName,2,1);
     End;
     For I:=Length(NewName) Downto 1 Do Begin
       If NewName[I] in ['a','A','e','E','o','O','u','U','i','I','y','Y'] Then Begin
         L := 0;
       End else Begin
        Inc(L);
        If L > 2 Then Begin
          Delete(NewName,I,1);
        End;
       End;
     End;
    End;

Begin
 NewName := Char(65+Random(26));
 A := Random(3)+2;
 B := -1;
 For I := 1 To A Do Begin
  OldB := B;
  While B = OldB Do  B := Random(41);

  Case B Of
    0 : Case Random(3) of
          0 : C := 'rave';
          1 : C := 'cyn';
          2 : C := 'deir';
          3 : C := 'nime';
        End;
    1 : C := 'ly';
    2 : C := 'bor';
    3 : C := 'es';
    4 : C := 'ick';
    5 : C := 'mot';
    6 : C := 'da';
    7 : C := 'an';
    8 : C := 'ge';
    9 : C := 'sin';
   10 : C := 'rd';
   11 : C := 'pa';
   12 : C := 'tri';
   13 : C := 'deh';
   14 : C := 'de';
   15 : C := 'fer';
   16 : C := 'in';
   17 : C := 'ru';
   18 : C := 'be';
   19 : C := 'en';
   20 : C := 'ni';
   21 : C := 'ie';
   22 : C := 'ls';
   23 : C := 'an';
   24 : C := 'dre';
   25 : C := 'che';
   26 : C := 'lt';
   27 : C := 'ba';
   28 : C := 'ker';
   29 : C := 'bu';
   30 : C := 're';
   31 : C := 'np';
   32 : C := 'au';
   33 : C := 'il';
   34 : C := 'ian';
   35 : C := 'kim';
   36 : C := 'ko';
   37 : C := 'os';
   38..40 : C := Char(97+Random(26));
  End;
  NewName := NewName + C;
 End;
 ReplaceAllDoubles;
 ReplaceAllNoums;
End;


procedure TMain.SpeedButton1Click(Sender: TObject);
begin
 GenderSelector.ItemIndex := Random(GenderSelector.Items.Count-1);
 if ( Random(500)=1 ) Then GenderSelector.ItemIndex := 2;
 GenderSelectorChange(Self);
end;

procedure TMain.GenderSelectorChange(Sender: TObject);
begin
 If GenderSelector.ItemIndex <> -1 Then
   Character.Gender := GenderSelector.ItemIndex;
end;

procedure TMain.RollSelectorChange(Sender: TObject);
begin
 Character.RollMethod := RollSelector.ItemIndex;
 PointAssignPanel.Visible := (RollSelector.ItemIndex > 4) and (RollSelector.ItemIndex <> 10);
 Button1.Enabled := not PointAssignPanel.Visible;
 if PointAssignPanel.Visible Then Begin
   AssignPanel.Visible := False;
 End;

 Case RollSelector.ItemIndex of
   5 : MaxBuyPoints.Caption := '15';
   6 : MaxBuyPoints.Caption := '22';
   7 : MaxBuyPoints.Caption := '25';
   8 : MaxBuyPoints.Caption := '28';
   9 : MaxBuyPoints.Caption := '32';
  10 : RollDiceBtnClick(Self);
 End;
 Changed;
end;


procedure TMain.Button2Click(Sender: TObject);
begin
 Character.Base.Abilities.Str := 8;
 Character.Base.Abilities.Dex := 8;
 Character.Base.Abilities.Con := 8;
 Character.Base.Abilities.Int := 8;
 Character.Base.Abilities.Wis := 8;
 Character.Base.Abilities.Cha := 8;
 Changed;
end;

procedure TMain.Button3Click(Sender: TObject);
begin
PointAssignPanel.Visible := False;
end;

procedure TMain.Button4Click(Sender: TObject);
begin
 AssignPanel.Visible := False;
end;

procedure TMain.SpeedButton5Click(Sender: TObject);
Var History : THistory;
begin
 if Character.Gender = 0 Then
   History := THistory.Create(Character.Name,'he','his','him',False)
 Else if Character.Gender = 1 Then
   History := THistory.Create(Character.Name,'she','her','her',False)
 Else
   History := THistory.Create(Character.Name,'it','it','it',False);
 Try
   HistoryTxt.Text := History.Generate;
 Finally
   History.Free;
 End;

end;

procedure TMain.BonusFeatSelectorSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var PArameter : String;
begin
 Requires('');
 If FPBonusLeft < 1 Then Begin
  Requires('No featpoints left');
  Exit;
 End;
 UpdateClassAbilityList;
 if ( not TBaseFeat(Item).MeetsPrerequisites(Character) ) Then Exit;

 Parameter := SelectFeatParameters(Item);
 if Parameter <> '-' Then
 Character.AddBonusFeat(TBaseFeat(Item),Parameter,CurrentClass);
 CalcFPLeft;
 BonusFeatsLearned.Invalidate;
 Changed;
end;

procedure TMain.BonusFeatsLearnedSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
 Item.Free;
 CalcFPLeft;
 BonusFeatsLearned.Invalidate;
 Changed;
end;

procedure TMain.About1Click(Sender: TObject);
Var About : TAbout;
begin
  About := TAbout.Create(Self);
  Try
     About.ShowModal;
  Finally
     About.Free;
  End;
end;

procedure TMain.Help1Click(Sender: TObject);
begin
  Application.HelpFile := ExtractFilePath(PAramStr(0))+'\redblade3e.hlp';
  Application.HelpJump('');
end;

Procedure Tmain.EditInLabratory(Item : TDNDItem);
Var NewItem : TDNDItem;
Begin
 Labratory := TLabratory.Create(Self);
 Try
   Labratory.BuyForFree.Checked := BuyForFree.Checked;
   NewItem := TDNDItem.Create;
   NewItem.Clone(TDNDItem(Item));
   Labratory.fItem := NewItem;
   Labratory.ItemToEdit;
   Case Labratory.ShowModal Of
     MrCancel : Begin
                  NewItem.Free;
                End;
     mrOk     : Begin
                  Character.Inventory.Add(Labratory.fItem);
                  UpdateCharacterMoney;
                  CharInventory.Invalidate;
                End;
   End;
 Finally
  Labratory.Free;
 End;
End;

procedure TMain.AvailableItemsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var NewItem : TDNDItem;
begin
 If BtnLabratory.Down Then Begin
  EditInLabratory(TDNDItem(Item));
  Exit;
 End;

 If not BuyForFree.Checked Then BEgin
   If not Character.Money.CanPay(TDNDItem(Item).Cost) Then Begin
     Requires('');
     Requires('You need more money if you want to buy that.');
     Exit;
   End;
   Character.Money.Pay(TDNDItem(Item).Cost);
 End;
 NewItem := TDNDItem.Create;
 NewItem.Clone(TDNDItem(Item));
 Character.Inventory.Add(NewItem);
 UpdateCharacterMoney;
 CharInventory.Invalidate;
end;

procedure TMain.CharInventorySelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
 If not BuyForFree.Checked Then BEgin
   Character.Money.Add(TDNDItem(Item).Cost);
 End;
 Character.Inventory.Extract(Item);
 Item.Free;
 UpdateCharacterMoney;
 CharInventory.Invalidate;
end;

procedure TMain.ComboBox1Change(Sender: TObject);
begin
 CharEquipped.List := Character.Equipped[Combobox1.ItemIndex];
end;

procedure TMain.CharInventory2Select(Control: TWinControl;
  Item: TPrimalDNDObject);
Var NewItem : TDNDItem;
   Count : Integer;
   I : Integer;
begin
 Count := 0;
 For I := 0 To Character.Equipped[Combobox1.ItemIndex].Count-1 Do
  if Character.Equipped[Combobox1.ItemIndex][I].Kind = ItWeapon Then Inc(Count);
 If Count > 2 Then Begin
  if MessageDlg('Only the first three weapons will be calculated on your character sheet. Add this one anyway?', mtConfirmation,
     [mbOk, mbCancel], 0) = mrCancel then Exit;
 End;
 NewItem := TDNDItem.Create;
 NewItem.Clone(TDNDItem(Item));
 Character.Equipped[Combobox1.ItemIndex].Add(NewItem);
 Character.Inventory.Extract(Item);
 Item.Free;
 CharEquipped.Invalidate;
 CharInventory2.Invalidate;
 UpdateWeaponShow;
 Changed;

end;

procedure TMain.CharEquippedSelect(Control: TWinControl; Item: TPrimalDNDObject);
Var NewItem : TDNDItem;
begin
 NewItem := TDNDItem.Create;
 NewItem.Clone(TDNDItem(Item));
 Character.Inventory.Add(NewItem);
 Character.Equipped[Combobox1.ItemIndex].Extract(Item);
 Item.Free;
 CharEquipped.Invalidate;
 CharInventory2.Invalidate;
 UpdateWeaponShow;
 Changed;
end;

procedure TMain.Button5Click(Sender: TObject);
begin
{ For I := 0 To World.Items.Count-1 Do Begin
   If TDNDITem(World.Items[I]).Size > 0 Then Inc(TDNDItem(World.Items[I]).Size);
 End;}
{  Character.WeaponTotalAttackBonus(0);
  Character.WeaponTotalAttackBonus(1);}
{  Character.WeaponDamage(0);}
end;


Procedure TMain.UpdateWeaponShow;
Var Weap1, Weap2, Weap3 : TDNDItem;
Begin
 If TwoHandedWield.Checked Then Begin
   SetDualWield(False);
 End Else Begin
 End;
 Weap1 := Character.GetWeapon(0);
 Weap2 := Character.GetWeapon(1);

 If TwohandedWield.Checked and not Character.OtherBladeSide Then Begin
    If ( Weap1 =nil ) Then Begin
      ShowMessage('Need at least one weapon to do this.');
      SetDualWield(False);
      SetTwoHandedWield(False);
      Exit;
    End;
    ShowMessage(Weap1.realname+' cannot be wielded with two hands.');
    SetDualWield(False);
    SetTwoHandedWield(False);
    UpdateWeaponShow;
    Exit;
 ENd;

 if ( Weap2 = nil ) Then Begin
   if Weap1 = nil Then Begin
     WeaponInfo.Caption := 'No weapons wielded';
   End Else
     WeaponInfo.Caption := Weap1.RealName
 End Else If Character.OtherBladeSide Then Begin

   If ( Weap1.Size < Character.fRace.Size ) Then Begin
     ShowMessage(Weap1.realname+' is too small to wield with two hands.');
     SetDualWield(False);
     SetTwoHandedWield(False);
     UpdateWeaponShow;
     Exit;
   End;

   WeaponInfo.Caption := Weap1.RealName+' wielded in both hands.';
 End Else Begin
   If Character.DualWield > 0 Then Begin

      If ( Weap1.Size > Character.fRace.Size ) Then Begin
         ShowMessage(Weap1.realname+' is too big to dual-wield.');
         SetDualWield(False);
         SetTwoHandedWield(False);
         UpdateWeaponShow;
         Exit;
      End;

      If ( Weap2.Size > Character.fRace.Size ) Then Begin
         ShowMessage(Weap2.realname+' is too big to dual-wield.');
         SetDualWield(False);
         SetTwoHandedWield(False);
         UpdateWeaponShow;
         Exit;
      End;

      WeaponInfo.Caption := Weap1.RealName+' wielded in main hand + '+Weap2.RealName+' wielded in off hand';
   End Else Begin
      WeaponInfo.Caption := Weap1.RealName+' + '+Weap2.RealName;
   End;
 End;
 Weap3 := Character.GetWeapon(2);
 if ( Weap3 <> nil ) Then Begin
   WeaponInfo.CAption := WeaponInfo.Caption + ' + '+Weap3.RealName;
 End;
End;

procedure TMain.DualWieldClick(Sender: TObject);
var Weap2 : TDNDItem;
begin
 Weap2 := Character.GetWeapon(1);
 If DualWield.Checked and ( Weap2 = nil ) Then Begin
   ShowMessage('Need more than one weapon equipped.');
   SetDualWield(False);
   SetTwoHandedWield(False);
   Exit;
 End;
 If DualWield.Checked Then
 Character.DualWield := 1 Else Character.DualWield := 0;
 UpdateWeaponShow;
end;

procedure TMain.ItemTypeChange(Sender: TObject);
begin
  UpdateFilterItems;
end;

Procedure TMain.SetDualWield(NAar : Boolean);
Begin
  DualWield.OnClick := Nil;
  DualWield.Checked := Naar;
  TwoHandedWield.Enabled := not DualWield.Checked;

  If DualWield.Checked Then
    Character.DualWield := 1 Else
    Character.DualWield := 0;
  DualWield.OnClick := DualWieldClick;
End;

Procedure TMain.SetTwoHandedWield(NAar : Boolean);
Begin
  TwoHandedWield.OnClick := Nil;
  TwoHandedWield.Checked := Naar;
  If TwoHandedWield.Checked Then
    Character.TwoHandedWield := 1 Else
    Character.TwoHandedWield := 0;
  TwoHandedWield.OnClick := TwoHandedWieldClick;
End;

procedure TMain.TwoHandedWieldClick(Sender: TObject);
begin
 If TwoHandedWield.Checked Then Begin
    Character.TwoHandedWield := 1;
 End Else Begin
    Character.TwoHandedWield := 0;
{    SetDualWield(False);}
 End;
 UpdateWeaponShow;
end;

Function PIntToStr(I : Integer) : String;
Begin
 If I < 0 Then Result := IntToStR(I)+' '
 Else if I > 0 Then Result := '+'+IntTostr(I)+' '
 Else Result := ' ';
End;

procedure TMain.AvailableSkillsPaint(Sender: TObject; R: TRect;
  Item: TPrimalDNDObject);
Var TXT : String;
 Prime : Integer;
 Shift : Integer;
begin
 With TDNDListBox(Sender).Canvass Do Begin
   Brush.Style := BsClear;
   Font.Size := 7;
   Font.Color := $550000;
   Shift := 0;
   if Item is TTrainedSkill Then Begin
     Shift := -32;
     Prime := TTrainedSkill(Item).BaseSkill.PrimeAbility;
   End Else
     Prime := TBaseSkill(Item).PrimeAbility;
   Case Prime of
      0 : Txt := PIntToStr(Character.Abilities.StrModifier)+'STR';
      1 : Txt := PIntToStr(Character.Abilities.DexModifier)+'DEX';
      2 : Txt := PIntToStr(Character.Abilities.ConModifier)+'CON';
      3 : Txt := PIntToStr(Character.Abilities.IntModifier)+'INT';
      4 : Txt := PIntToStr(Character.Abilities.WisModifier)+'WIS';
      5 : Txt := PIntToStr(Character.Abilities.ChaModifier)+'CHA';
   End;
   If Item.fGroup<>AvailableSkills.Group Then
     font.color := $BBBBBB;

   TextOut(R.Right-TextWidth(txt)-3+Shift,R.Top,Txt);
   Font.Color := ClBlack;
   Font.Size := 8;
 End;
end;

procedure TMain.AvailableItemsPaint(Sender: TObject; R: TRect;
  Item: TPrimalDNDObject);
Var Txt : String;
begin
 With TDNDListBox(Sender).Canvass Do Begin
   Brush.Style := BsClear;
   Font.Size := 7;
   Font.Color := $550000;
   Txt := TDNDItem(Item).Cost.GetAsText;
   If ( Txt = '' ) THen Txt := 'Free ';
   If Item.fGroup<>AvailableItems.Group Then
     font.color := $BBBBBB;
   TextOut(R.Right-TextWidth(txt)-3,R.Top,Txt);
   Font.Color := ClBlack;
   Font.Size := 8;
 End;
 CharInventory2Paint(Sender,R,Item);
end;

procedure TMain.AvailableSpellsPaint(Sender: TObject; R: TRect;
  Item: TPrimalDNDObject);
Var Txt : String;
begin
 With TDNDListBox(Sender).Canvass Do Begin
   Brush.Style := BsClear;
   Font.Size := 7;
   Font.Color := $550000;
   If Item.fGroup<>AvailableSpells.Group Then
     font.color := $BBBBBB;

   Txt := 'Level '+IntToStr(Round(TTrainedSpell(Item).Level));
   TextOut(R.Right-TextWidth(txt)-3,R.Top,Txt);
   Txt := Copy(TTrainedSpell(Item).BaseSpell.MageSchool,1,4);
   TextOut(R.Right-TextWidth(txt)-3,R.Bottom-TextHeight(txt)-1,Txt);
   Font.Color := ClBlack;
   Font.Size := 8;
 End;
end;

procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
 SaveConfig;
 If Character.fChanged Then
  Case MessageDlg('Do you want to save your character before exiting?', mtConfirmation,
     [mbYes, mbNo,mbCancel], 0) of
    MrYes : Begin
              SaveAs1Click(Self);
              CanClose := not SaveCancelled;
            End;
    MrNo : Begin
                    CanClose := True;
            End;
    MrCancel : Begin
                     CanClose := False;
               End;
 End;
end;

procedure TMain.AvailableClassesMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer; Item: TPrimalDNDObject);
begin
 If ( Item <> nil ) Then Begin
  ThingHint(Item.Description);
 End Else ThingHInt('');
end;

procedure TMain.ClassesMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer; Item: TPrimalDNDObject);
begin
 If ( Item <> nil ) Then Begin
  If Item is TTrainedSkill Then
    ThingHint(TTrainedSkill(Item).BaseSkill.Description)
  Else If Item is TTrainedFeat Then
    ThingHint(TTrainedFeat(Item).BaseFeat.Description)
  Else
    ThingHint(Item.Description);
 End Else ThingHInt('');
end;

procedure TMain.CharInventory2Paint(Sender: TObject; R: TRect;
  Item: TPrimalDNDObject);
Var Txt : String;

Function WeaponSmall(Item :TDNDItem ) : String;
Var
    I : Integer;
 DamBonus : String;
Begin
 If Item.Att1DamageDice = 0 Then Begin
   Result := '';
 End Else Begin
   DamBonus := '';
   If Item.SpecialBonus > 1 Then DamBonus := '+'+IntToStr(Item.SpecialBonus-1);
   Result := IntTOStr(Item.Att1DamageDice)+'d'+InttOStr(Item.Att1DamageDiceSize)+DamBonus;
 End;

 If Result <> '' then Begin
   Result := Result+', ';
   if Item.CriticalRange < 20 Then Result := Result+IntToStr(Item.CriticalRange)+'-20';

   Result := Result + 'x'+IntToStr(Item.Att1CritMultiplier)
 End;

 If ( Item.WeaponFlags and 1 ) > 0 Then Begin
   If Item.Att2DamageDice <> 0 Then
       Result := Result+', '+IntTOStr(Item.Att2DamageDice)+'d'+InttOStr(Item.Att2DamageDiceSize);

   If Result <> '' then Begin
      Result := Result+', ';
      if Item.CriticalRange < 20 Then Result := Result+IntToStr(Item.CriticalRange)+'-20';

      Result := Result + 'x'+IntToStr(Item.Att2CritMultiplier)
   End;
 End;

 For I := 0 To World.Weapons.Count-1 Do
  If  World.Weapons[I].Name = Item.WeaponProfNeeded Then Begin
    If Result <> '' Then Result := Result + ', ';
    Case World.Weapons[I].Group of
      0 : Result := Result + 'Simple';
      1 : Result := Result + 'Martial';
      2 : Result := Result + 'Exotic';
    End;
    Break;
  End;
End;

begin
 With TDNDListBox(Sender).Canvass Do Begin
   Brush.Style := BsClear;
   Font.Size := 7;
   Font.Color := $666666;
   Case TDNDItem(Item).Kind Of
     ItWeapon : Txt := WeaponSmall(TDNDItem(Item));
     ItArmor  : Begin
                  Txt := IntToStr(TDNDItem(Item).AcBonus)+' ac';
                  If Pos('shield',lowercase(TDNDItem(Item).ArmorFeatRequired)) = 0 Then
                    Txt := Txt + ', '+Copy(lowercase(TDNDItem(Item).ArmorFeatRequired),Pos('(',TDNDItem(Item).ArmorFeatRequired)-1,255);
                End;
   End;
   TextOut(R.Left+3,R.Bottom-TextHeight(Txt)-1,Txt);
   Font.Color := ClBlack;
   Font.Size := 8;
 End;
 // Flop
end;

procedure TMain.DiceRoller1Click(Sender: TObject);
begin
 If DiceRolls = Nil Then DiceRolls := TDiceRolls.Create(Self);
 DiceRolls.Show;
end;

procedure TMain.Panel2Click(Sender: TObject);
Var OpenDialog : TOpenDialog;
Begin
 OpenDialog := TOpenDialog.Create(Self);
 OpenDialog.DefaultExt := 'rw3';
 OpenDialog.InitialDir := ExtractFilePath(ParamStr(0))+'campaigns';
 OpenDialog.Filter := 'Redblade Campaign World(*.rw3)|*.rw3';
 If OpenDialog.Execute Then Begin
   If MessageDlg('This will clear the current character. Do you wish to load this campaign setting?', mtWarning, [mbOk,mbCancel], 0) = MrOk Then Begin
     Screen.Cursor := crHourGlass;
     Application.ProcessMessages;
     Try
       World.Load(OpenDialog.FileName);
       UpdateRaceSelector;
       NewCharacter;
       UpdateRaceSelector;
     Finally
       Screen.Cursor := crDefault;
     End;
   End;
 End;
 OpenDialog.Free;
End;

Procedure TMain.LoadConfig;
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey('\Software\Redblade3e', True)
    then begin
      World.WorldFileName := Reg.ReadString('lastcampaign');
      Try
        PreviewX := Reg.ReadInteger('CharPreviewX');
        PreviewY := Reg.ReadInteger('CharPreviewY');
        SetCharacterPreview(Reg.ReadBool('CharPreview'));
      Except
        If Screen.Height > Height+100 Then Begin
          PreviewX := Left;
          PreviewY := Top+Height;
          SetCharacterPreview(True);
        End;
      End;
    end;
  finally
    Reg.CloseKey;
    Reg.Free;
    inherited;
  end;
End;

Procedure TMain.SaveConfig;
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey('\Software\Redblade3e', True)
    then begin
       Reg.WriteString('lastcampaign',World.WorldFileNAme);
       Reg.WriteBool('CharPreview',ShowCharacterPreview.checked);
       Reg.WriteInteger('CharPreviewX',PreviewX);
       Reg.WriteInteger('CharPreviewY',PreviewY);
    end;
  finally
    Reg.CloseKey;
    Reg.Free;
    inherited;
  end;
End;


procedure TMain.ClassesPaint(Sender: TObject; R: TRect; Item: TPrimalDNDObject);
Var TXT : String;
begin
 Txt := TTrainedClass(Item).LeansOnClass;
 If Txt ='' Then Exit;
 With TDNDListBox(Sender).Canvass Do Begin
   Brush.Style := BsClear;
   Font.Size := 7;
   Font.Color := $550000;
   TextOut(R.Right-TextWidth(txt)-3-32,R.Top,Txt);
   Font.Color := ClBlack;
   Font.Size := 8;
 End;
End;

procedure TMain.RGroupSelectorChange(Sender: TObject);
begin
  World.fGroup := RGroupSelector.itemIndex;
  AvailableClasses.Group := World.fGroup;
  AvailableSkills.Group := World.fGroup;
  FeatSelector.Group := World.fGroup;
  BonusFeatSelector.Group := World.fGroup;
  LanguageSelector.Group := World.fGroup;
  AvailableItems.Group := World.fGroup;
  AvailableSpells.Group := World.fGroup;
end;

procedure TMain.Panel7MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
 panel7.Caption := 'Campaign: '+World.Name;
end;

procedure TMain.ShowCharacterPreviewClick(Sender: TObject);
begin
 SetCharacterPreview(not ShowCharacterPreview.Checked);
end;

Procedure TMain.SetCharacterPreview(B : Boolean);
Var TMp : TPreview;
Begin
 ShowCharacterPreview.checked := B;
 If B Then BEgin
  if not Assigned(Preview) Then Begin
   Preview := TPreview.Create(Self);
  End;
  Preview.Top := PreviewY;
  Preview.Left := PreviewX;
  if (Preview.Top = 0 ) Then Preview.Top := Top+64;
  if (Preview.Left = 0 ) Then Preview.Left := Left+64;
  Preview.Update;
  Preview.Show;
 End Else If Assigned(Preview) Then Begin
   Tmp := Preview;
   Preview := Nil;
   Tmp.Close;
 End;
End;

end.
