unit FrmLabratory;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DNDItems, StdCtrls, ComCtrls, ExtCtrls, ShellApi;

type
  TLabratory = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    BuyForFree: TCheckBox;
    Button2: TButton;
    Panel2: TPanel;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Image1: TImage;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    CheckBox3: TCheckBox;
    TabSheet5: TTabSheet;
    GroupBox1: TGroupBox;
    WeaponEnchantment: TComboBox;
    Label81: TLabel;
    Label83: TLabel;
    Silver: TStaticText;
    Platinum: TStaticText;
    Label82: TLabel;
    Label84: TLabel;
    Copper: TStaticText;
    Gold: TStaticText;
    GroupBox2: TGroupBox;
    ArmorEnchantment: TComboBox;
    GroupBox3: TGroupBox;
    ShieldEnchantment: TComboBox;
    MeleeBox: TGroupBox;
    CheckBox1: TCheckBox;
    Label4: TLabel;
    CheckBox2: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    Label5: TLabel;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    CheckBox13: TCheckBox;
    CheckBox14: TCheckBox;
    CheckBox15: TCheckBox;
    CheckBox16: TCheckBox;
    CheckBox17: TCheckBox;
    CheckBox18: TCheckBox;
    CheckBox19: TCheckBox;
    CheckBox20: TCheckBox;
    CheckBox21: TCheckBox;
    Label6: TLabel;
    CheckBox22: TCheckBox;
    CheckBox23: TCheckBox;
    CheckBox24: TCheckBox;
    CheckBox25: TCheckBox;
    Label7: TLabel;
    Label8: TLabel;
    RangeBox: TGroupBox;
    Label9: TLabel;
    CheckBox26: TCheckBox;
    CheckBox27: TCheckBox;
    CheckBox28: TCheckBox;
    CheckBox29: TCheckBox;
    CheckBox30: TCheckBox;
    CheckBox31: TCheckBox;
    CheckBox32: TCheckBox;
    CheckBox33: TCheckBox;
    CheckBox34: TCheckBox;
    CheckBox35: TCheckBox;
    CheckBox36: TCheckBox;
    CheckBox37: TCheckBox;
    CheckBox38: TCheckBox;
    CheckBox39: TCheckBox;
    CheckBox40: TCheckBox;
    Label10: TLabel;
    Label11: TLabel;
    ArmorBox: TGroupBox;
    Label12: TLabel;
    Label13: TLabel;
    CheckBox41: TCheckBox;
    CheckBox42: TCheckBox;
    CheckBox43: TCheckBox;
    CheckBox44: TCheckBox;
    CheckBox45: TCheckBox;
    CheckBox46: TCheckBox;
    CheckBox47: TCheckBox;
    CheckBox48: TCheckBox;
    CheckBox49: TCheckBox;
    CheckBox50: TCheckBox;
    CheckBox51: TCheckBox;
    CheckBox52: TCheckBox;
    CheckBox53: TCheckBox;
    CheckBox54: TCheckBox;
    CheckBox55: TCheckBox;
    CheckBox56: TCheckBox;
    CheckBox57: TCheckBox;
    CheckBox58: TCheckBox;
    CheckBox59: TCheckBox;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    ShieldBox: TGroupBox;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    CheckBox60: TCheckBox;
    CheckBox61: TCheckBox;
    CheckBox62: TCheckBox;
    CheckBox63: TCheckBox;
    CheckBox64: TCheckBox;
    CheckBox65: TCheckBox;
    CheckBox66: TCheckBox;
    CheckBox68: TCheckBox;
    CheckBox70: TCheckBox;
    CheckBox71: TCheckBox;
    CheckBox72: TCheckBox;
    CheckBox73: TCheckBox;
    CheckBox74: TCheckBox;
    CheckBox75: TCheckBox;
    CheckBox76: TCheckBox;
    CheckBox77: TCheckBox;
    CheckBox78: TCheckBox;
    CheckBox67: TCheckBox;
    Label24: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BuyForFreeClick(Sender: TObject);
    procedure WeaponEnchantmentChange(Sender: TObject);
    procedure MeleeBoxClick(Sender: TObject);
    procedure RangeClick(Sender: TObject);
    procedure ArmorSelect(Sender: TObject);
    procedure CheckBox60Click(Sender: TObject);
    procedure Label24Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    NewCost : TMoney;
    fItem : TDNDItem;
    Procedure ItemToEdit;
    Procedure RecalcGold;
    Function CheckAllowedWeapon(PlusBonus : Integer) : Integer;
    Function CheckAllowedArmor(PlusBonus : Integer) : Integer;
    Function CheckAllowedShield(PlusBonus : Integer) : Integer;
    Function WeaponSpecials : String;
    Function ShieldSpecials : String;
    Function ArmorSpecials : String;
  end;

var
  Labratory: TLabratory;

implementation

uses FrmMain, DNDCharacter, DNDObjects;

{$R *.DFM}

Procedure TLabratory.ItemToEdit;
Begin
  Edit1.Text := fItem.Name;
  Case fItem.Kind of
     ItWeapon : TabSheet2.TabVisible := True;
     ItArmor  : Begin
                 if ( fItem.WeaponFlags And 32 ) > 0 Then { Shield}
                   TabSheet5.TabVisible := True
                 Else
                   TabSheet3.TabVisible := True;
                End;
     Else TabSheet1.TabVisible := True;
  End;
  RecalcGold;
End;


Function TLabratory.WeaponSpecials : String;
Var I : INteger;
Begin
 Result := '';
 For I := 0 To ComponentCount-1 Do Begin
   If  (Components[I] is TCheckBox) and
      ((TCheckBox(Components[I]).Parent = MeleeBox) or (TCheckBox(Components[I]).Parent = RangeBox)) and
        TCheckBox(Components[I]).Checked
        Then Begin
      Result := Result+TCheckBox(Components[I]).Caption+' ';
   End;
 End;
End;

Function TLabratory.ArmorSpecials : String;
Var I : INteger;
Begin
 Result := '';
 For I := 0 To ComponentCount-1 Do Begin
   If  (Components[I] is TCheckBox) and
      ((TCheckBox(Components[I]).Parent = ArmorBox)) and
        TCheckBox(Components[I]).Checked
        Then Begin
      Result := Result+TCheckBox(Components[I]).Caption+' ';
   End;
 End;
End;

Function TLabratory.ShieldSpecials : String;
Var I : INteger;
Begin
 Result := '';
 For I := 0 To ComponentCount-1 Do Begin
   If  (Components[I] is TCheckBox) and
      ((TCheckBox(Components[I]).Parent = ShieldBox)) and
        TCheckBox(Components[I]).Checked
        Then Begin
      Result := Result+TCheckBox(Components[I]).Caption+' ';
   End;
 End;
End;

Function TLabratory.CheckAllowedWeapon(PlusBonus : Integer) : Integer;
Var I :Integer;

Begin
 Result := PlusBonus;

 If PlusBonus = 0 Then Begin
 For I := 0 To ComponentCount-1 Do
   If (Components[I] is TCheckBox) and (
      (TCheckBox(Components[I]).Parent = MeleeBox) or
      (TCheckBox(Components[I]).Parent = RangeBox)) Then Begin
         If WeaponEnchantment.ItemIndex < 2 Then Begin
           TCheckBox(Components[I]).Checked := False;
           TCheckBox(Components[I]).Enabled := False;
         End Else Begin
           TCheckBox(Components[I]).Enabled := True;
     End;
   End;
   Exit;
 End;

 For I := 0 To ComponentCount-1 Do Begin
   If (TCheckBox(Components[I]).Parent = MeleeBox) or
      (TCheckBox(Components[I]).Parent = RangeBox)
       Then
   If Components[I] is TCheckBox Then
     If TCheckBox(Components[I]).Checked Then Begin
       Result := Result + TCheckBox(Components[I]).Tag;
     End;
 End;

 For I := 0 To ComponentCount-1 Do
   If (TCheckBox(Components[I]).Parent = MeleeBox) or
      (TCheckBox(Components[I]).Parent = RangeBox) Then Begin
     If (Components[I] is TCheckBox) and (not TCheckBox(Components[I]).Checked) Then Begin
         TCheckBox(Components[I]).Enabled :=
           Result+TCheckBox(Components[I]).Tag<11;
     End;
   End;
 If Result > 10 Then Begin
   WeaponEnchantment.ItemIndex := WeaponEnchantment.ItemIndex - ( Result - 10 );
   Result := 10;
 End;
End;

Function TLabratory.CheckAllowedArmor(PlusBonus : Integer) : Integer;
Var I :Integer;

Begin
 Result := PlusBonus;

 If PlusBonus = 0 Then Begin
 For I := 0 To ComponentCount-1 Do
   If (Components[I] is TCheckBox) and (TCheckBox(Components[I]).Parent = ArmorBox) Then Begin
         If ArmorEnchantment.ItemIndex < 2 Then Begin
           TCheckBox(Components[I]).Checked := False;
           TCheckBox(Components[I]).Enabled := False;
         End Else Begin
           TCheckBox(Components[I]).Enabled := True;
     End;
   End;
   Exit;
 End;

 For I := 0 To ComponentCount-1 Do Begin
   If (TCheckBox(Components[I]).Parent = ArmorBox)  Then
   If Components[I] is TCheckBox Then
     If TCheckBox(Components[I]).Checked Then Begin
       Result := Result + TCheckBox(Components[I]).Tag;
     End;
 End;

 For I := 0 To ComponentCount-1 Do
   If (TCheckBox(Components[I]).Parent = ArmorBox) Then Begin
     If (Components[I] is TCheckBox) and (not TCheckBox(Components[I]).Checked) Then Begin
         TCheckBox(Components[I]).Enabled :=
           Result+TCheckBox(Components[I]).Tag<11;
     End;
   End;
 If Result > 10 Then Begin
   ArmorEnchantment.ItemIndex := ArmorEnchantment.ItemIndex - ( Result - 10 );
   Result := 10;
 End;
End;
Function TLabratory.CheckAllowedShield(PlusBonus : Integer) : Integer;
Var I :Integer;

Begin
 Result := PlusBonus;

 If PlusBonus = 0 Then Begin
 For I := 0 To ComponentCount-1 Do
   If (Components[I] is TCheckBox) and (TCheckBox(Components[I]).Parent = ShieldBox) Then Begin
         If ShieldEnchantment.ItemIndex < 2 Then Begin
           TCheckBox(Components[I]).Checked := False;
           TCheckBox(Components[I]).Enabled := False;
         End Else Begin
           TCheckBox(Components[I]).Enabled := True;
     End;
   End;
   Exit;
 End;

 For I := 0 To ComponentCount-1 Do Begin
   If (TCheckBox(Components[I]).Parent = ShieldBox)  Then
   If Components[I] is TCheckBox Then
     If TCheckBox(Components[I]).Checked Then Begin
       Result := Result + TCheckBox(Components[I]).Tag;
     End;
 End;

 For I := 0 To ComponentCount-1 Do
   If (TCheckBox(Components[I]).Parent = ShieldBox) Then Begin
     If (Components[I] is TCheckBox) and (not TCheckBox(Components[I]).Checked) Then Begin
         TCheckBox(Components[I]).Enabled :=
           Result+TCheckBox(Components[I]).Tag<11;
     End;
   End;
 If Result > 10 Then Begin
   ShieldEnchantment.ItemIndex := ShieldEnchantment.ItemIndex - ( Result - 10 );
   Result := 10;
 End;
End;

Procedure TLabratory.RecalcGold;
Const WeaponPlus: Array[0..10] of Integer = ( 0, 2000, 8000, 18000, 32000, 50000, 72000, 98000, 128000, 162000, 200000 );
Const ArmorPlus: Array[0..10] of Integer = ( 0, 1000,4000,9000,16000,25000,36000,49000,64000,81000,100000 );
Var PlusBonus: Integer;
Begin
   NewCost.Clear;
   NewCost.Add(fItem.Cost);
   Case fItem.Kind of
     ItWeapon : Begin
                 if WeaponEnchantment.ItemIndex > 0 Then NewCost.Gold := NewCost.Gold+300;
                 PlusBonus := 0;
                 If WeaponEnchantment.ItemIndex > 1 Then
                    PlusBonus := WeaponEnchantment.ItemIndex-1;
                 PlusBonus := CheckAllowedWeapon(PlusBonus);
                 NewCost.Gold := NewCost.Gold+WeaponPlus[PlusBonus];
                End;
     ItArmor  : Begin
                  PlusBonus := 0;
                  if ( fItem.WeaponFlags And 32 ) > 0 Then Begin { Shield}
                     if ShieldEnchantment.ItemIndex > 0 Then
                         NewCost.Gold := NewCost.Gold+150;
                     If ShieldEnchantment.ItemIndex > 1 Then
                       PlusBonus := ShieldEnchantment.ItemIndex-1;
                     PlusBonus := CheckAllowedShield(PlusBonus);
                  End Else Begin
                     if ArmorEnchantment.ItemIndex > 0  Then
                            NewCost.Gold := NewCost.Gold+150;
                     If ArmorEnchantment.ItemIndex > 1 Then
                       PlusBonus := ArmorEnchantment.ItemIndex-1;
                     PlusBonus := CheckAllowedArmor(PlusBonus);
                  End;
                  NewCost.Gold := NewCost.Gold+ArmorPlus[PlusBonus];

               End;
     Else;
   End;
   Platinum.Caption := IntToStr(NewCost.Platinum);
   Gold.Caption := IntToStr(NewCost.Gold);
   Silver.Caption := IntToStr(NewCost.Silver);
   Copper.Caption := IntToStr(NewCost.Copper);
End;

procedure TLabratory.Button1Click(Sender: TObject);
begin

   RecalcGold;

   If not BuyForFree.Checked Then BEgin


     If not Main.Character.Money.CanPay(NewCost) Then Begin
       ShowMessage('You need more money if you want to buy that.');
       ModalResult := MrNone;
       Exit;
     End;
     Main.Character.Money.Pay(NewCost);
   End;

   fItem.RealName := Edit1.Text;
   fItem.Cost.Clear;
   fItem.Cost.Add(NewCost);

   Case fItem.Kind of
      ItWeapon : Begin
                   if WeaponEnchantment.ItemIndex = 1 Then Begin
                      fItem.RealName := fItem.RealName+' (masterwork)';
                        If fItem.SpecialBonus < 1 Then
                           fItem.SpecialBonus := 1;
                   End;
                   if WeaponEnchantment.ItemIndex > 1 Then Begin
                      fItem.RealName := WeaponSpecials+fItem.RealName+' +'+IntToStr(WeaponEnchantment.ItemIndex-1);
                      If fItem.SpecialBonus < 1 Then Begin
                       fItem.SpecialBonus := WeaponEnchantment.ItemIndex;
                      End;
                   End;
                 End;
      ItArmor  : Begin
                   if ( fItem.WeaponFlags And 32 ) > 0 Then Begin { Shield}
                     if ShieldEnchantment.ItemIndex = 1 Then BEgin
                        If fItem.CheckPenalty > 0 Then
                           dec(fItem.CheckPenalty);
                        fItem.RealName := fItem.RealName+' (masterwork)';
                     End;
                     if ShieldEnchantment.ItemIndex > 1 Then Begin
                         fItem.RealName := ShieldSpecials+fItem.RealName+' +'+IntToStr(ShieldEnchantment.ItemIndex-1);
                         fItem.AcBonus := fItem.AcBonus + ShieldEnchantment.ItemIndex-1;
                     End;

                  End Else Begin
                        if ArmorEnchantment.ItemIndex = 1 Then Begin
                          If fItem.CheckPenalty > 0 Then
                             dec(fItem.CheckPenalty);
                          fItem.RealName := fItem.RealName+' (masterwork)';
                        End;
                     if ArmorEnchantment.ItemIndex > 1 Then Begin
                         fItem.RealName := ArmorSpecials+fItem.RealName+' +'+IntToStr(ArmorEnchantment.ItemIndex-1);
                         fItem.AcBonus := fItem.AcBonus + ArmorEnchantment.ItemIndex-1;
                     End;
                   End;
                   End;
      Else TabSheet1.TabVisible := True;
   End;

End;

procedure TLabratory.FormCreate(Sender: TObject);
Var I :Integer;
begin
 WeaponEnchantment.ItemIndex := 0;
 ArmorEnchantment.ItemIndex := 0;
 ShieldEnchantment.ItemIndex := 0;
 NewCost := TMoney.Create;
 For I := 0 To PageControl1.PageCount-1 Do Begin
   PageControl1.Pages[I].TabVisible := False;
 End;
end;

procedure TLabratory.FormDestroy(Sender: TObject);
begin
 NewCost.Free;
end;

procedure TLabratory.BuyForFreeClick(Sender: TObject);
begin
 Main.BuyForFree.Checked := BuyForFree.Checked;
end;

procedure TLabratory.WeaponEnchantmentChange(Sender: TObject);
begin
 RecalcGold;
end;

procedure TLabratory.MeleeBoxClick(Sender: TObject);
begin
 RecalcGold;
end;

procedure TLabratory.RangeClick(Sender: TObject);
begin
 RecalcGold;
end;

procedure TLabratory.ArmorSelect(Sender: TObject);
begin
 RecalcGold;
end;

procedure TLabratory.CheckBox60Click(Sender: TObject);
begin
 RecalcGold;
end;

function ExecuteFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..79] of Char;
begin
  Result := ShellExecute(Main.Handle, nil,
    StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
    StrPCopy(zDir, DefaultDir), ShowCmd);
end;

procedure TLabratory.Label24Click(Sender: TObject);
begin
  ExecuteFile('http://www.aliciana.com/','','',SW_SHOW);
end;

end.
