unit FrmItemEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, DNDITems;

type
  TItemEditor = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Label1: TLabel;
    Button2: TButton;
    Edit1: TEdit;
    ComboBox1: TComboBox;
    Label3: TLabel;
    ComboBox3: TComboBox;
    Label4: TLabel;
    Edit3: TEdit;
    Label5: TLabel;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    ComboBox2: TComboBox;
    Label9: TLabel;
    TabSheet2: TTabSheet;
    Label10: TLabel;
    Edit7: TEdit;
    Edit8: TEdit;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Edit9: TEdit;
    Edit11: TEdit;
    Edit10: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Label15: TLabel;
    Edit12: TEdit;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Edit13: TEdit;
    Label19: TLabel;
    Label20: TLabel;
    Edit14: TEdit;
    Label21: TLabel;
    Edit15: TEdit;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    Edit2: TEdit;
    Label2: TLabel;
    TabSheet3: TTabSheet;
    Label22: TLabel;
    ComboBox4: TComboBox;
    Edit16: TEdit;
    Label23: TLabel;
    Edit17: TEdit;
    Label24: TLabel;
    Label25: TLabel;
    Edit18: TEdit;
    Label26: TLabel;
    Edit19: TEdit;
    Label28: TLabel;
    Edit20: TEdit;
    Label27: TLabel;
    Label29: TLabel;
    Edit21: TEdit;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    Edit22: TEdit;
    Label30: TLabel;
    Edit23: TEdit;
    Label31: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    fItem : TDNDItem;
    Procedure SetItem(Item : TDNDItem);
    Procedure ItemToEdit;
    Procedure EditToItem;
  end;

var
  ItemEditor: TItemEditor;

implementation

Uses FrmAffectedEditor, DNDWorld;

{$R *.DFM}
Procedure TItemEditor.ItemToEdit;
Var I :Integer;
Begin
 Edit1.Text := fItem.Realname;
 Edit2.Text := IntToStr(fItem.Pounds);
 Edit23.Text := fItem.Description;
 Edit3.Text := IntToStr(fItem.Cost.Platinum);
 Edit4.Text := IntToStr(fItem.Cost.Gold);
 Edit5.Text := IntToStr(fItem.Cost.Silver);
 Edit6.Text := IntToStr(fItem.Cost.Copper);
 Combobox1.ItemIndex := fItem.Kind;
 Combobox3.ItemIndex := fItem.Size;
 Combobox2.ItemIndex := fItem.WearLoc;

 Edit7.TExt := fItem.WeaponProfNeeded;

 CheckBox1.Checked := ( fItem.WeaponFlags And 1 ) > 0;
 CheckBox2.Checked := ( fItem.WeaponFlags And 2 ) > 0;
 CheckBox3.Checked := ( fItem.WeaponFlags And 4 ) > 0;
 CheckBox4.Checked := ( fItem.WeaponFlags And 8 ) > 0;
 CheckBox5.Checked := ( fItem.WeaponFlags And 16 ) > 0;
 CheckBox6.Checked := ( fItem.WeaponFlags And 32 ) > 0;
 CheckBox7.Checked := ( fItem.WeaponFlags And 64 ) > 0;
 CheckBox8.Checked := ( fItem.WeaponFlags And 128 ) > 0;
 CheckBox9.Checked := ( fItem.WeaponFlags And 256 ) > 0;

 Edit8.Text := IntToStr(fItem.Att1DamageDice);
 Edit10.Text := IntToStr(fItem.Att1DamageDiceSize);
 Edit13.Text := IntToStr(fItem.Att1CritMultiplier);
 Edit9.Text := IntToStr(fItem.Att2DamageDice);
 Edit11.Text := IntToStr(fItem.Att2DamageDiceSize);
 Edit14.Text := IntToStr(fItem.Att2CritMultiplier);
 Edit12.Text := IntToStr(fItem.CriticalRange);
 Edit15.Text := IntToStr(fItem.RangeIncrement);

 For I := 0 To World.Feats.Count-1 Do Begin
   If Pos('armor proficiency',lowercase(World.Feats[I].name)) <> 0 Then
     Combobox4.Items.Add(World.Feats[I].Name);
   If Pos('shield proficiency',lowercase(World.Feats[I].name)) <> 0 Then
     Combobox4.Items.Add(World.Feats[I].Name);
 End;

 Combobox4.Text := fItem.ArmorFeatRequired;
 Edit21.Text := IntToStr(fItem.AcBonus);
 Edit16.Text := IntToStr(fItem.MaxDexBonus);
 Edit17.Text := IntToStr(fItem.CheckPenalty);
 Edit18.Text := IntToStr(fItem.ArcaneSpellFailure);
 Edit19.Text := IntToStr(fItem.SpeedPenalty30);
 Edit20.Text := IntToStr(fItem.SpeedPenalty20);
 Edit22.Text := IntToStr(fItem.MaxCompositeBonus);


End;



Procedure TItemEditor.EditToItem;
Begin
 fItem.Name := Edit1.Text;
 fItem.Description := Edit23.Text;
 fItem.Pounds := StrToIntDef(Edit2.Text, 0);
 fItem.Cost.Platinum := StrToIntDef(Edit3.Text,0);
 fItem.Cost.Gold     := StrToIntDef(Edit4.Text,0);
 fItem.Cost.Silver   := StrToIntDef(Edit5.Text,0) ;
 fItem.Cost.Copper   := StrToIntDef(Edit6.Text,0)  ;
 fItem.Kind := Combobox1.ItemIndex;
 fItem.Size := Combobox3.ItemIndex;
 fItem.WearLoc := Combobox2.itemIndex;

 fItem.WeaponProfNeeded := Edit7.TExt;
 fItem.WeaponFlags := 0;
 If CheckBox1.Checked Then Inc(fItem.WeaponFlags,1);
 If CheckBox2.Checked Then Inc(fItem.WeaponFlags,2);
 If CheckBox3.Checked Then Inc(fItem.WeaponFlags,4);
 If CheckBox4.Checked Then Inc(fItem.WeaponFlags,8);
 If CheckBox5.Checked Then Inc(fItem.WeaponFlags,16);
 If CheckBox6.Checked Then Inc(fItem.WeaponFlags,32);
 If CheckBox7.Checked Then Inc(fItem.WeaponFlags,64);
 If CheckBox8.Checked Then Inc(fItem.WeaponFlags,128);
 If CheckBox9.Checked Then Inc(fItem.WeaponFlags,256);

 fItem.Att1DamageDice := StrToIntDef(Edit8.Text,1);
 fItem.Att1DamageDiceSize := StrToIntDef(Edit10.Text,1);
 fItem.Att1CritMultiplier := StrToIntDef(Edit13.Text,2);
 fItem.Att2DamageDice := StrToIntDef(Edit9.Text,1);
 fItem.Att2DamageDiceSize := StrToIntDef(Edit11.Text,1);
 fItem.Att2CritMultiplier := StrToIntdef(Edit14.Text,2);
 fItem.CriticalRange := StrToIntDef(Edit12.Text,20);
 fItem.RangeIncrement := StrToIntDef(Edit15.Text,0);

 fItem.ArmorFeatRequired := Combobox4.Text;
 fItem.AcBonus := StrTointDef(Edit21.Text,0);
 fItem.MaxDexBonus := StrToIntDef(Edit16.Text,-1);
 fItem.CheckPenalty := StrToIntDef(Edit17.Text,0);
 fItem.ArcaneSpelLFailure := StrToIntDef(Edit18.TExt,0);
 fItem.SpeedPenalty30 := StrToIntDef(Edit19.Text,0);
 fItem.SpeedPenalty20 := StrToIntDef(Edit20.Text,0);
 fItem.MaxCompositeBonus := StrToIntDef(Edit22.Text,0);
End;

Procedure TItemEditor.SetItem(Item : TDNDItem);
Begin
 fItem := Item;
 ItemToEdit;
End;

procedure TItemEditor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  EditToItem;
end;

procedure TItemEditor.FormShow(Sender: TObject);
begin
 If Edit1.CanFocus Then Edit1.SetFocus;
end;

procedure TItemEditor.Button2Click(Sender: TObject);
Var Win : TAffectEditor;
begin
  Win := TAffectEditor.Create(Self);
  Try
    Win.SetAffect(fItem);
    Win.Caption := 'Item Affect Editor - Redblade 3e';
    Win.ShowModal;
  Finally
    Win.Free;
  End;
end;

procedure TItemEditor.FormCreate(Sender: TObject);
begin
 PageControl1.ActivePage := TabSheet1;
end;

end.
