unit FrmFeatEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DNDObjects, FrmAffectedEditor, ComCtrls, Menus;

type
  TFeatEditor = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Label1: TLabel;
    Edit1: TEdit;
    Button2: TButton;
    TabSheet2: TTabSheet;
    ListBox1: TListBox;
    PopupMenu1: TPopupMenu;
    Add1: TMenuItem;
    N1: TMenuItem;
    Delete1: TMenuItem;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Edit2: TEdit;
    Label2: TLabel;
    CheckBox3: TCheckBox;
    Label3: TLabel;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    Edit6: TEdit;
    Label8: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Add1Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    fFeat : TBaseFeat;
    Procedure SetFeat(Feat : TBaseFeat);
    Procedure FeatToEdit;
    Procedure EditToFeat;
    { Public declarations }
  end;

var
  FeatEditor: TFeatEditor;

implementation

Uses FrmParameterEditor;

{$R *.DFM}
Procedure TFeatEditor.FeatToEdit;
Begin
 Edit1.Text := fFeat.Name;
 Edit6.Text := fFeat.Description;
 CheckBox1.Checked := (fFeat.Flags and 1) > 0;
 CheckBox2.Checked := (fFeat.Flags and 2) > 0;
 CheckBox3.Checked := (fFeat.Flags and 4) > 0;
 CheckBox4.Checked := (fFeat.Flags and 8) > 0;
 CheckBox5.Checked := (fFeat.Flags and 16) > 0;
 Edit2.Text := fFeat.NeedsFeat;
 ListBox1.Items.Assign(fFeat.Parameters);
End;

Procedure TFeatEditor.EditToFeat;
Begin
 fFeat.Name := Edit1.Text;
 fFeat.Flags := 0;
 if CheckBox1.Checked Then Inc(fFeat.Flags,1);
 if CheckBox2.Checked Then Inc(fFeat.Flags,2);
 if CheckBox3.Checked Then Inc(fFeat.Flags,4);
 if CheckBox4.Checked Then Inc(fFeat.Flags,8);
 if CheckBox5.Checked Then Inc(fFeat.Flags,16);
 fFeat.NeedsFeat := Edit2.Text;
fFeat.Description := Edit6.Text;
End;

Procedure TFeatEditor.SetFeat(Feat : TBaseFeat);
Begin
 fFeat := Feat;
 FeatToEdit;
End;

procedure TFeatEditor.Button2Click(Sender: TObject);
Var Win : TAffectEditor;
begin
  Win := TAffectEditor.Create(Self);
  Try
    Win.SetAffect(fFeat);
    Win.Caption := 'Feat Affect Editor - Redblade 3e';
    Win.ShowModal;
  Finally
    Win.Free;
  End;
end;

procedure TFeatEditor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 EditToFeat;
end;

procedure TFeatEditor.Add1Click(Sender: TObject);
begin
  fFeat.Parameters.Add('Empty');
  ListBox1.ItemIndex := ListBox1.Items.Add('Empty');
  ListBox1DblClick(Self);
end;

procedure TFeatEditor.ListBox1DblClick(Sender: TObject);
Var Win : TParameterEditor;
begin
   if ListBox1.ItemIndex = -1 Then Exit;
   Win := TParameterEditor.Create(Self);
   Try
     Win.Edit1.Text := ListBox1.Items[ListBox1.ItemIndex];
     fFeat.Parameters.Delete(ListBox1.ItemIndex);
     ListBox1.Items.Delete(ListBox1.ItemIndex);
     Win.ShowModal;
     ListBox1.Items.Add(Win.Edit1.Text);
     fFeat.Parameters.Add(Win.Edit1.TExt);
   Finally
     Win.Free;
   End;
end;

procedure TFeatEditor.Delete1Click(Sender: TObject);
begin
  if ListBox1.ItemIndex = -1 Then Exit;
  fFeat.Parameters.Delete(ListBox1.ItemIndex);
  ListBox1.Items.Delete(ListBox1.ItemIndex);
end;

procedure TFeatEditor.FormShow(Sender: TObject);
begin
PageControl1.ActivePage := TabSheet1;
If Edit1.CanFocus Then Edit1.SetFocus;
end;

end.
