unit FrmCustomize;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, UniDndListbox, DNDWorld, DNDObjects, DNDSpells,
  Menus, DNDWeapons, FrmWeaponEditor, FrmSpellImporter, CheckLst;

type
  TCustomize = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    Panel1: TPanel;
    Button1: TButton;
    ClassList: TDNDListBox;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    RaceList: TDNDListBox;
    Skills: TDNDListBox;
    Button6: TButton;
    Feats: TDNDListBox;
    TabSheet5: TTabSheet;
    Spells: TDNDListBox;
    TabSheet6: TTabSheet;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Button14: TButton;
    Button15: TButton;
    TabSheet7: TTabSheet;
    Button16: TButton;
    Button17: TButton;
    TabSheet8: TTabSheet;
    Button18: TButton;
    Button19: TButton;
    WeaponListBox: TDNDListBox;
    Button20: TButton;
    TabSheet9: TTabSheet;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Label4: TLabel;
    CheckListBox1: TCheckListBox;
    Label5: TLabel;
    CheckListBox2: TCheckListBox;
    Label6: TLabel;
    TabSheet10: TTabSheet;
    ItemListBox: TDNDListBox;
    Button21: TButton;
    Button22: TButton;
    Button23: TButton;
    Panel2: TPanel;
    Label7: TLabel;
    Label8: TLabel;
    Panel3: TPanel;
    Label9: TLabel;
    RGroupSelector: TComboBox;
    Button24: TButton;
    MnuResourceGroup: TPopupMenu;
    AddResourceGroup1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    EditResourceGroup1: TMenuItem;
    DeleteResourceGroup: TMenuItem;
    Domains: TDNDListBox;
    Languages: TDNDListBox;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ClassListSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure RaceListSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure Button6Click(Sender: TObject);
    procedure SkillsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure Button7Click(Sender: TObject);
    procedure FeatsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure Button8Click(Sender: TObject);
    procedure SpellsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure Button9Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure WeaponListBoxSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure Button20Click(Sender: TObject);
    procedure Edit4Change(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure Button21Click(Sender: TObject);
    procedure ItemListBoxSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure Button22Click(Sender: TObject);
    procedure Button23Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Button24Click(Sender: TObject);
    procedure AddResourceGroup1Click(Sender: TObject);
    procedure EditResourceGroup1Click(Sender: TObject);
    procedure DeleteResourceGroupClick(Sender: TObject);
    procedure DomainsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure LanguagesSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure RGroupSelectorChange(Sender: TObject);
  private
    { Private declarations }
  public
    SaveCancelled : Boolean;
    { Public declarations }
  end;

var
  Customize: TCustomize;

implementation

uses FrmClassEditor, DNDClasses, FrmRaceEditor, FrmSkillEditor,FrmFeatEditor,
FrmSpellEditor, FrmLanguageEditor, FRMDelete, FrmDomainEditor, FrmItemEditor,
DNDITems, FrmMain, FrmResourceGroupEditor;

{$R *.DFM}


procedure TCustomize.Button1Click(Sender: TObject);
begin
 Close;
end;

procedure TCustomize.FormCreate(Sender: TObject);
begin
 PageControl1.ActivePage := TabSheet9;
 ClassList.List := World.Classes;
 RaceList.List := World.Races;
 Skills.List := World.Skills;
 Feats.List := World.Feats;
 Spells.List := World.Spells;
 WeaponListBox.List := World.Weapons;
 Domains.List := World.Domains;
 Languages.List := World.Languages;
 Edit4.Text := World.Name;
 Edit1.Text := World.Author;
 Edit2.Text := World.Email;
 Edit3.Text := World.Url;
 ItemListBox.List := World.Items;
 RGroupSelector.Items.Assign(World.ResourceGroups);
 RGroupSelector.itemIndex := World.fGroup;
 RGroupSelectorChange(Self);
end;

procedure TCustomize.ClassListSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var Win : TClassEditor;
begin
 If ( Item <> nil ) Then Begin
   Win := TClassEditor.Create(Self);
   Try
     Win.SetClass(TBaseClass(Item));
     Win.ShowModal;
   Finally
     Win.Free;
   End;
 End;
end;

procedure TCustomize.Button3Click(Sender: TObject);
Var OpenDialog : TOpenDialog;
begin
 OpenDialog := TOpenDialog.Create(Self);
 OpenDialog.DefaultExt := 'rw3';
 OpenDialog.InitialDir := ExtractFilePath(ParamStr(0))+'campaigns';
 OpenDialog.Filter := 'Redblade Campaign World(*.rw3)|*.rw3';
 If OpenDialog.Execute Then Begin
   If MessageDlg('This will clear the current character. Do you wish to load this campaign setting?', mtWarning, [mbOk,mbCancel], 0) = MrOk Then Begin
     Screen.Cursor := crHourGlass;
     Application.ProcessMessages;
     Try
       World.Load(OpenDialog.FileName);
       Main.NewCharacter;
       Spells.Invalidate;
     Finally
       Screen.Cursor := crDefault;
     End;
   End;
 End;
 OpenDialog.Free;
end;

procedure TCustomize.Button2Click(Sender: TObject);
Var SaveDialog : TSaveDialog;
begin
 SaveDialog := TSaveDialog.Create(Self);
 SaveDialog.DefaultExt := 'rw3';
 SaveDialog.InitialDir := ExtractFilePath(ParamStr(0))+'campaigns';
 SaveDialog.Filter := 'Redblade Campaign World(*.rw3)|*.rw3';
 SaveCancelled := False;
 If SaveDialog.Execute Then Begin
   Screen.Cursor := CrHourGlass;
   Try
     Application.ProcessMessages;
     World.Save(SaveDialog.FileName);
   Finally
     Screen.Cursor := CrDefault;
   End;
 End Else SaveCancelled := True;
 SaveDialog.Free;
End;

procedure TCustomize.Button4Click(Sender: TObject);
begin
  ClassListSelect(Self,World.AddClass('New Class'));
  ClassList.Invalidate;
end;

procedure TCustomize.Button5Click(Sender: TObject);
begin
  RaceListSelect(Self,World.AddRace('New Race'));
  RaceList.Invalidate;
end;

procedure TCustomize.RaceListSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var Win : TRaceEditor;
begin
 If ( Item <> nil ) Then Begin
   Win := TRaceEditor.Create(Self);
   Try
     Win.SetRace(TBaseRace(Item));
     Win.ShowModal;
   Finally
     Win.Free;
   End;
 End;
end;

procedure TCustomize.Button6Click(Sender: TObject);
begin
  SkillsSelect(Self,World.AddSkill('New Skill'));
  Skills.Invalidate;
end;

procedure TCustomize.SkillsSelect(Control: TWinControl; Item: TPrimalDNDObject);
Var Win : TSkillEditor;
begin
 If ( Item <> nil ) Then Begin
   Win := TSkillEditor.Create(Self);
   Try
     Win.SetSkill(TBaseSkill(Item));
     Win.ShowModal;
   Finally
     Win.Free;
   End;
 End;
end;

procedure TCustomize.Button7Click(Sender: TObject);
begin
  FeatsSelect(Self,World.AddFeat('New Feat'));
  Feats.Invalidate;
end;

procedure TCustomize.FeatsSelect(Control: TWinControl; Item: TPrimalDNDObject);
Var Win : TFeatEditor;
begin
 If ( Item <> nil ) Then Begin
   Win := TFeatEditor.Create(Self);
   Try
     Win.SetFeat(TBaseFeat(Item));
     Win.ShowModal;
   Finally
     Win.Free;
   End;
 End;
end;

procedure TCustomize.Button8Click(Sender: TObject);
begin
  SpellsSelect(Self,World.AddSpell('New Spell'));
  Spells.Invalidate;
end;

procedure TCustomize.SpellsSelect(Control: TWinControl; Item: TPrimalDNDObject);
Var Win : TSpellEditor;
begin
 If ( Item <> nil ) Then Begin
   Win := TSpellEditor.Create(Self);
   Try
     Win.SetSpell(TBaseSpell(Item));
     Win.ShowModal;
   Finally
     Win.Free;
   End;
 End;
end;

procedure TCustomize.Button9Click(Sender: TObject);
Var Win : TDeleteThing;
begin
  Win := TDEleteThing.Create(Self);
  try
    Win.SetList(World.Classes);
    Win.ShowModal;
     ClassList.Invalidate;
  Finally
    Win.Free;
  End;
end;

procedure TCustomize.Button14Click(Sender: TObject);
Var Language : TLanguage;
begin
 Language := World.AddLanguage('');
 LanguagesSelect(Self,Language);
end;

procedure TCustomize.Button15Click(Sender: TObject);
Var Win : TDeleteThing;
begin
  Win := TDEleteThing.Create(Self);
  try
    Win.SetList(World.Languages);
    Win.ShowModal;
  Finally
    Win.Free;
  End;
end;

procedure TCustomize.Button10Click(Sender: TObject);
Var Win : TDeleteThing;
begin
  Win := TDEleteThing.Create(Self);
  try
    Win.SetList(World.Races);
    Win.ShowModal;
    RaceList.Invalidate;
  Finally
    Win.Free;
  End;
end;

procedure TCustomize.Button11Click(Sender: TObject);
Var Win : TDeleteThing;
begin
  Win := TDEleteThing.Create(Self);
  try
    Win.SetList(World.Skills);
    Win.ShowModal;
    Skills.Invalidate;
  Finally
    Win.Free;
  End;
end;

procedure TCustomize.Button12Click(Sender: TObject);
Var Win : TDeleteThing;
begin
  Win := TDEleteThing.Create(Self);
  try
    Win.SetList(World.Feats);
    Win.ShowModal;
    Feats.Invalidate;
  Finally
    Win.Free;
  End;
end;

procedure TCustomize.Button13Click(Sender: TObject);
Var Win : TDeleteThing;
begin
  Win := TDEleteThing.Create(Self);
  try
    Win.SetList(World.Spells);
    Win.ShowModal;
    Spells.Invalidate;
  Finally
    Win.Free;
  End;
end;

procedure TCustomize.Button16Click(Sender: TObject);
Var Domain : TDomain;
begin
 Domain := World.AddDomain('');
 DomainsSelect(Self,Domain);
{ if ( ListBox2.Items.IndexOfObject(Domain) = -1 ) Then Begin
   I := ListBox2.Items.AddObject('Domain',Domain);
   ListBox2.ItemIndex := I;
   ListBox2DblClick(Self);
End;}
end;

procedure TCustomize.Button17Click(Sender: TObject);
Var Win : TDeleteThing;
begin
  Win := TDEleteThing.Create(Self);
  try
    Win.SetList(World.Domains);
    Win.ShowModal;
  Finally
    Win.Free;
  End;
end;

procedure TCustomize.Button18Click(Sender: TObject);
begin
 WeaponListBoxSelect(Self,World.AddWeapon('New Weapon'));

end;

procedure TCustomize.Button19Click(Sender: TObject);
Var Win : TDeleteThing;
begin
  Win := TDEleteThing.Create(Self);
  try
    Win.SetList(World.Weapons);
    Win.ShowModal;
    WeaponListBox.Invalidate;
  Finally
    Win.Free;
  End;
end;

procedure TCustomize.WeaponListBoxSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var Win : TWeaponEditor;
begin
  if Item = nil Then Exit;
   Win := TWeaponEditor.Create(Self);
   Try
     Win.SetWeapon(TWeapon(Item));
     Win.ShowModal;
     WeaponListBox.Invalidate;
   Finally
     Win.Free;
   End;
end;

procedure TCustomize.Button20Click(Sender: TObject);
Var Win : TSpellImporter;
begin
  Win := TSpellImporter.Create(Self);
  try
    Win.ShowModal;
  Finally
    Win.Free;
  End;
End;

procedure TCustomize.Edit4Change(Sender: TObject);
begin
 World.Name := Edit4.Text;

end;

procedure TCustomize.Edit1Change(Sender: TObject);
begin
 World.Author := Edit1.Text;
end;

procedure TCustomize.Edit2Change(Sender: TObject);
begin
 World.Email := Edit2.Text;
end;

procedure TCustomize.Edit3Change(Sender: TObject);
begin
 World.Url := Edit3.Text;
end;

procedure TCustomize.Button21Click(Sender: TObject);
Var Item : TDNDItem;
begin
 Item := World.AddItem('New Item');
 ItemListBoxSelect(Self,Item);
end;

procedure TCustomize.ItemListBoxSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var Win : TItemEditor;
begin
  if Item = nil Then Exit;
   Win := TItemEditor.Create(Self);
   Try
     Win.SetItem(TDNDItem(Item));
     Win.ShowModal;
     ItemListBox.Invalidate;
   Finally
     Win.Free;
   End;
end;

procedure TCustomize.Button22Click(Sender: TObject);
Var Win : TDeleteThing;
begin
  Win := TDEleteThing.Create(Self);
  try
    Win.SetList(World.Items);
    Win.ShowModal;
    ItemListBox.Invalidate;
  Finally
    Win.Free;
  End;
end;

procedure TCustomize.Button23Click(Sender: TObject);
Var I : Integer;
 Item : TDNDItem;
begin
 For I := 0 To World.Weapons.Count-1 Do Begin
   Item := World.AddItem(World.Weapons[I].Name);
{   ShowMessage(IntToStr(World.Weapons[I].Size));}
   Item.Size := World.Weapons[I].Size;
   Item.WeaponProfNeeded := Item.RealName;
   Item.CriticalRange := 20;
   Item.Att1CritMultiplier := 2;
   Item.Att2CritMultiplier := 2;
 End;

end;

procedure TCustomize.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  Case MessageDlg('Do you want to save your world before exitting?', mtConfirmation,
     [mbYes, mbNo,mbCancel], 0) of
    MrYes : Begin
              Button2Click(Self);
              CanClose := not SaveCancelled;
            End;
    MrNo : Begin
                    CanClose := True;
            End;
    MrCancel : Begin
                     CanClose := False;
               End;
 End;
end;

procedure TCustomize.Button24Click(Sender: TObject);
begin
 MnuResourceGroup.Popup(Left+Button24.Left,Top+Button24.Top);
end;

procedure TCustomize.AddResourceGroup1Click(Sender: TObject);
begin
 World.Resourcegroups.Add('--');
 RGroupSelector.Items.Assign(World.ResourceGroups);
 RGroupSelector.itemIndex := World.ResourceGroups.Count-1;
 EditResourceGroup1Click(Self);
{ResourceGroupEditor}
end;

procedure TCustomize.EditResourceGroup1Click(Sender: TObject);
Var Index : Integer;
begin
 If RGroupSelector.ItemIndex = -1 Then Exit;
 ResourceGroupEditor := TResourceGroupEditor.Create(Self);
 Try
   ResourceGroupEditor.Edit1.Text := World.ResourceGroups[RGroupSelector.ItemIndex];
   ResourceGroupEditor.ShowModal;
   Index := RGroupSelector.ItemIndex;
   World.ResourceGroups[Index] := ResourceGroupEditor.Edit1.Text;
   RGroupSelector.Items[Index] := ResourceGroupEditor.Edit1.Text;
   RGroupSelector.ItemIndex := Index;
 Finally
   ResourceGroupEditor.Free;
 End;
end;

procedure TCustomize.DeleteResourceGroupClick(Sender: TObject);
begin
 If RGroupSelector.ItemIndex = -1 Then Exit;

 If MessageDlg('Are you sure you want to delete this resource group?', mtConfirmation,
     [mbYes, mbNo,mbCancel], 0) =  MrYes Then Begin
 World.ResourceGroups.Delete(RGroupSelector.ItemIndex);
 RGroupSelector.Items.Delete(RGroupSelector.ItemIndex);
 RGroupSelector.ItemIndex := 0;
 End;
end;

procedure TCustomize.DomainsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var Win : TDomainEditor;
begin
   Win := TDomainEditor.Create(Self);
   Try
     Win.SetDomain(TDomain(Item));
     Win.ShowModal;
   Finally
     Win.Free;
   End;
end;

procedure TCustomize.LanguagesSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
Var Win : TLanguageEditor;
begin
   Win := TLanguageEditor.Create(Self);
   Try
     Win.SetLanguage(TLanguage(Item));
     Win.ShowModal;
   Finally
     Win.Free;
   End;
end;

procedure TCustomize.RGroupSelectorChange(Sender: TObject);
begin
  World.fGroup := RGroupSelector.itemIndex;
  ClassList.Group := World.fGroup;
  RaceList.Group := World.fGroup;
  Skills.Group := World.fGroup;
  Feats.Group := World.fGroup;
  Spells.Group := World.fGroup;
  Domains.Group := World.fGroup;
  Languages.Group := World.FGroup;
  WeaponListBox.Group := World.FGroup;
  ItemListBox.Group := World.fGroup;
end;

end.
