unit FrmClassEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DNDClasses, ComCtrls, StdCtrls, ExtCtrls, CheckLst, UniDndListbox, DNDObjects;

type
  TClassEditor = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Label2: TLabel;
    Edit1: TEdit;
    SkillOverview: TDNDListBox;
    SkillOverview2: TDNDListBox;
    MainSkills: TDNDListBox;
    CrossClassSkills: TDNDListBox;
    Edit2: TEdit;
    Label1: TLabel;
    Edit6: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    Edit7: TEdit;
    TabSheet5: TTabSheet;
    Label10: TLabel;
    ComboBox2: TComboBox;
    Label11: TLabel;
    Memo1: TMemo;
    Label12: TLabel;
    Label13: TLabel;
    Edit9: TEdit;
    Label14: TLabel;
    TabSheet6: TTabSheet;
    Button2: TButton;
    ListBox1: TListBox;
    Button3: TButton;
    TabSheet4: TTabSheet;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    Label6: TLabel;
    Edit3: TEdit;
    Label5: TLabel;
    Edit4: TEdit;
    Label7: TLabel;
    Edit5: TEdit;
    ComboBox1: TComboBox;
    Label3: TLabel;
    CheckListBox1: TCheckListBox;
    CheckBox9: TCheckBox;
    Label4: TLabel;
    Edit8: TEdit;
    Panel2: TPanel;
    Label15: TLabel;
    Panel3: TPanel;
    Label16: TLabel;
    procedure CheckListBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SkillOverviewSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure SkillOverview2Select(Control: TWinControl; Item: TPrimalDNDObject);
    procedure CrossClassSkillsSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure MainSkillsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    fClass : TBaseClass;
    { Public declarations }
    Procedure SetClass(NewClass : TBaseClass);
    Procedure EditsToClass;
    Procedure ClassToEdits;
  end;

var
  ClassEditor: TClassEditor;

implementation

 Uses DNDWorld, FrmAffectedEditor, FrmClassTool;

{$R *.DFM}

 Procedure TClassEditor.SetClass(NewClass : TBaseClass);
 Begin
  fClass := NewClass;
  Caption := fClass.Name + ' - Redblade 3e';
  ClassToEdits;
  MainSkills.List := fClass.MainSkills;
  CrossClassSkills.List := fClass.CrossClassSkills;
 End;

 Procedure TClassEditor.EditsToClass;
 Var Al : Integer;
     I : Integer;
 Begin


 fClass.PrestigeCastLevel := ComBoBox2.ItemIndex;

 fClass.PrestigeRaces := Edit9.TExt;

 fClass.PrestigeScript.Clear;
 For I := 0 To Memo1.lInes.Count-1 Do
   fClass.PrestigeScript.Add(memo1.Lines[I]);


   fClass.fGroup := StrToIntDef(Edit8.Text,0);
   fClass.name := Edit2.text;
   fClass.CastStat := Combobox1.ItemIndex;
   fClass.HPPerLEvel := StrToIntDef(Edit1.Text,1);
   fClass.CanSpecialize := CheckBox1.Checked;
   fClass.CanSelectDomains := CheckBox2.Checked;
   fClass.AddChaToSaves := CheckBox3.Checked;
   fClass.AddWisToAc := CheckBox4.Checked;
   fClass.BonusSpell := CheckBox5.Checked;
   fClass.SpellsDivine := CheckBox9.Checked;
   fClass.MaxLevel := StrToIntDef(Edit7.Text,0);
   fClass.MoneyDice := StrToIntDef(Edit3.TExt,0);
   fClass.MoneyDiceSize := StrToIntDef(Edit4.TExt,0);
   fClass.MoneyMultiplier := StrToIntDef(Edit5.TExt,0);
   fClass.Description := Edit6.Text;
   fClass.AutoHasAllClassSpells := 0;
   If CheckBox8.Checked Then
     fClass.AutoHasAllClassSpells := 1;
   Al := 0;
   For I := 0 To 8 Do Begin
     if not CheckListBox1.Checked[I] Then Inc(Al,1 shl I);
   End;
   fClass.IllegalAlignment := Al;

   If CheckBox6.Checked Then
     fClass.MonkUnarmedAttacks := 1
   Else
     fClass.MonkUnarmedAttacks := 0;

   If CheckBox7.Checked Then
     fClass.MonkSpeed := 1
   Else
     fClass.MonkSpeed := 0;

 End;

 Procedure TClassEditor.ClassToEdits;
 Var i : Integer;
 Begin
   For I := 0 To MAX_LEVELS-1 Do ListBox1.Items.AddObject('Level '+IntToStr(I+1),TObject(I));
   Edit2.Text := fClass.Name;
   Combobox1.ItemIndex := fClass.CastStat;
   Edit1.Text := IntToStr(fClass.HPPerLEvel);
   CheckBox1.Checked := fClass.CanSpecialize;
   CheckBox2.Checked := fClass.CanSelectDomains;
   CheckBox3.Checked := fClass.AddChaToSaves;
   CheckBox4.Checked := fClass.AddWisToAc;
   CheckBox5.Checked := fClass.BonusSpell;
   CheckBox8.Checked := fClass.AutoHasAllClassSpells <> 0;
   CheckBox9.Checked := fClass.SpellsDivine;
   Edit8.Text := IntToStr(fClass.fGroup);
   Edit3.Text := IntToStr(fClass.MoneyDice);
   Edit4.Text := IntToStr(fClass.MoneyDiceSize);
   Edit5.Text := IntToStr(fClass.MoneyMultiplier);
   Edit6.Text := fClass.description;
   Edit7.Text := IntToStr(fClass.MaxLevel);

   For I := 0 To 8 Do Begin
     CheckListBox1.Checked[I] := (fClass.IllegalAlignment and (1 shl I)) = 0;
   End;


   CheckBox6.Checked := fClass.MonkUnarmedAttacks = 1;
   CheckBox7.Checked := fClass.MonkSpeed = 1;


   Combobox2.itemIndex := fClass.PrestigeCastLevel;
   Edit9.TExt := fClass.PrestigeRaces;

   Memo1.Lines.BeginUpdate;
   Memo1.Lines.Clear;
   Memo1.Lines.Assign(fClass.PrestigeScript);
   Memo1.Lines.EndUpdate;
 End;

procedure TClassEditor.CheckListBox1Click(Sender: TObject);
begin
  EditsToClass;
end;

procedure TClassEditor.FormCreate(Sender: TObject);
begin
 SkillOverview.List := World.Skills;
 SkillOverview2.List := World.Skills;
end;

procedure TClassEditor.SkillOverviewSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
   if fClass.MainSkills.IndexOf(Item) = -1 Then
     fClass.MainSkills.Add(Item);
  MainSkills.Invalidate;
end;

procedure TClassEditor.SkillOverview2Select(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
   if fClass.CrossClassSkills.IndexOf(Item) = -1 Then
      fClass.CrossClassSkills.Add(Item);
  CrossClassSkills.Invalidate;
end;

procedure TClassEditor.CrossClassSkillsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
  fClass.CrossClassSkills.Extract(Item);
  CrossClassSkills.Invalidate;
end;

procedure TClassEditor.MainSkillsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
  fClass.MainSkills.Extract(Item);
  MainSkills.Invalidate;
end;

procedure TClassEditor.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  EditsToClass;
end;

procedure TClassEditor.ListBox1DblClick(Sender: TObject);
Var Win : TAffectEditor;
begin
 If ( ListBox1.ItemIndex <> -1 ) Then Begin
    Win := TAffectEditor.Create(Self);
  Try
    Win.SetAffect(fClass.Level[ListBox1.ItemIndex+1]);
    Win.SetClass(fClass,ListBox1.itemIndex+1);
    Win.PageControl1.ActivePage := Win.ClassAbilities;
    Win.ShowModal;
  Finally
    Win.Free;
  End;
 End;
end;

procedure TClassEditor.Button2Click(Sender: TObject);
Var Win : TAffectEditor;
begin
  Win := TAffectEditor.Create(Self);
  Try
    Win.SetAffect(fClass);
    Win.Caption := 'Class base Affect Editor - Redblade 3e';
    Win.ShowModal;
  Finally
    Win.Free;
  End;
end;

procedure TClassEditor.PageControl1Change(Sender: TObject);
begin
 if PageControl1.ActivePage = TabSheet1 Then
   if Edit2.CanFocus Then Edit2.SetFocus;
end;

procedure TClassEditor.FormShow(Sender: TObject);
begin
 PageControl1.ActivePage := TabSheet1;
 if Edit2.CanFocus Then Edit2.SetFocus;
end;

procedure TClassEditor.Button3Click(Sender: TObject);
begin
 ClassToolWindow := TClassToolWindow.Create(Self);
 Try
   ClassToolWindow.SetClass(fClass);
   ClassToolWindow.ShowModal;
 Finally
   ClassToolWindow.Free;
 End;
end;

End.
