unit FrmClassAbilityEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DNDClasses;

type
  TClassAbilityEditor = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    CheckBox1: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    ListBox1: TListBox;
    Label3: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    fAbility : TClassAbility;
    fClass   : TBaseClass;
    fLevel   : Integer;
    { Public declarations }
    Procedure SetAbility(NewAbility : TClassAbility);
    Procedure SetClass(NewClass : TBaseClass; Level : Integer);
    Procedure AbToEdit;
    Procedure EditToAb;
    Procedure BuildBackview;
  end;

var
  ClassAbilityEditor: TClassAbilityEditor;

implementation

{$R *.DFM}

Procedure TClassAbilityEditor.SetClass(NewClass : TBaseClass; Level : Integer);
Begin
 fClass := NewClass;
 fLevel := Level;
End;

Procedure TClassAbilityEditor.BuildBackview;
Var I, J : Integer;
    GroupHad : Array[0..255] of Boolean;
Begin
 For I := 0 To 255 Do GroupHad[I] := False;
 For I := fLevel-1 DownTo 1 Do Begin
   For J := 0 To fClass.Level[I].ClassAbilities.Count-1 Do
     If fClass.Level[I].ClassAbilities[J].Choose Then Begin
{        ListBox1.Add(fClass.Level[I].ClassAbilities[J]);}
     End Else Begin
        if fClass.Level[I].ClassAbilities[J].OverrideID > 0 Then Begin
           If GroupHad[fClass.Level[I].ClassAbilities[J].OverrideID] Then Begin
             Continue;
           End Else Begin
             GroupHad[fClass.Level[I].ClassAbilities[J].OverrideID] := True;
           End;
        End;
        ListBox1.Items.Add('['+IntToStR(fClass.Level[I].ClassAbilities[J].OverrideID)+'] '+fClass.Level[I].ClassAbilities[J].Name);
     End;
End;
End;


Procedure TClassAbilityEditor.SetAbility(NewAbility : TClassAbility);
Begin
 fAbility := newAbility;
 AbToEdit;
End;

Procedure TClassAbilityEditor.AbToEdit;
Begin
 Edit1.Text := FAbility.Name;
 Edit2.Text := IntToStr(FAbility.OverrideID);
 CheckBox1.Checked := Fability.Choose;
End;

Procedure TClassAbilityEditor.EditToAb;
Begin
 FAbility.Name := Edit1.Text ;
 FAbility.OverrideID := StrToIntDef(Edit2.Text,0);
 Fability.Choose := CheckBox1.Checked;
End;

procedure TClassAbilityEditor.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
EditToAb;
end;

procedure TClassAbilityEditor.FormShow(Sender: TObject);
begin
 BuildBackview;
end;

end.
