unit FrmAffectedEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DNDObjects, ComCtrls, StdCtrls, ExtCtrls, UniDndListbox, Grids, Menus,
  DNDClasses;

type
  TAffectEditor = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    TabSheet6: TTabSheet;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    ClassAbilities: TTabSheet;
    FeatOverview: TDNDListBox;
    FreeFeats: TDNDListBox;
    FreeSkills: TDNDListBox;
    SkillOverview: TDNDListBox;
    Label10: TLabel;
    Edit10: TEdit;
    Label11: TLabel;
    Edit11: TEdit;
    Label12: TLabel;
    Edit12: TEdit;
    Label13: TLabel;
    Edit13: TEdit;
    Edit14: TEdit;
    Label14: TLabel;
    Label15: TLabel;
    Edit15: TEdit;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Edit26: TEdit;
    TabSheet7: TTabSheet;
    Label24: TLabel;
    Label26: TLabel;
    SpellGrid: TStringGrid;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    AttackRoll: TStringGrid;
    ListView1: TListView;
    PopupMenu1: TPopupMenu;
    Add1: TMenuItem;
    N1: TMenuItem;
    Delete1: TMenuItem;
    LanguageOverview: TDNDListBox;
    FreeLanguages: TDNDListBox;
    Button2: TButton;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Edit7: TEdit;
    Edit8: TEdit;
    Edit9: TEdit;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    LanguageOverview2: TDNDListBox;
    BonusLanguages: TDNDListBox;
    Label43: TLabel;
    Label44: TLabel;
    Label25: TLabel;
    FeatOverview3: TDNDListBox;
    BonusFeats: TDNDListBox;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;
    Edit16: TEdit;
    TabSheet2: TTabSheet;
    Label46: TLabel;
    Label45: TLabel;
    SelectableFeats: TDNDListBox;
    FeatOverview2: TDNDListBox;
    Button3: TButton;
    TabSheet8: TTabSheet;
    Label50: TLabel;
    Label51: TLabel;
    FreeWeapons: TDNDListBox;
    WeaponOverview1: TDNDListBox;
    Label52: TLabel;
    Label53: TLabel;
    SelectableWeapons: TDNDListBox;
    WeaponOverview2: TDNDListBox;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Edit17: TEdit;
    Label54: TLabel;
    Label55: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure SkillOverviewSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure FeatOverviewSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure FreeFeatsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure FreeSkillsAfterDecrease(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure Button2Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure ListView1DblClick(Sender: TObject);
    procedure Add1Click(Sender: TObject);
    procedure LanguageOverviewSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure FreeLanguagesSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure LanguageOverview2Select(Control: TWinControl; Item: TPrimalDNDObject);
    procedure BonusLanguagesSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure PageControl1Change(Sender: TObject);
    procedure FeatOverview2Select(Control: TWinControl; Item: TPrimalDNDObject);
    procedure FeatOverview3Select(Control: TWinControl; Item: TPrimalDNDObject);
    procedure SelectableFeatsSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure BonusFeatsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure Button3Click(Sender: TObject);
    procedure WeaponOverview1Select(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure WeaponOverview2Select(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure FreeWeaponsSelect(Control: TWinControl; Item: TPrimalDNDObject);
    procedure SelectableWeaponsSelect(Control: TWinControl;
      Item: TPrimalDNDObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    fAffect : TAffected;
    fClass  : TBaseClass;
    fLevel : Integer;
    { Public declarations }
    Procedure SetAffect(Affect : TAffected);
    Procedure SetClass(NewClass : TBaseClass; NewLevel : Integer);
    Procedure AffectToEdit;
    Procedure EditToAffect;
    Procedure ClassAbToEdit;
    Procedure AbilityAssign;
  end;

var
  AffectEditor: TAffectEditor;

implementation

 Uses DNDWorld, FrmParameterSelect, FrmClassAbilityEditor;

{$R *.DFM}

Procedure TAffectEditor.SetClass(NewClass : TBaseClass; NewLevel : Integer);
Begin
 fClass := NewClass;
 fLevel := NewLevel;
End;

 Procedure TAffectEditor.AffectToEdit;
 Var I : Integer;
 Begin
  Edit1.Text := IntToStr(fAffect.Abilities.Str);
  Edit2.Text := IntToStr(fAffect.Abilities.Dex);
  Edit3.Text := IntToStr(fAffect.Abilities.Con);
  Edit4.Text := IntToStr(fAffect.Abilities.Int);
  Edit5.Text := IntToStr(fAffect.Abilities.Wis);
  Edit6.Text := IntToStr(fAffect.Abilities.Cha);
  Edit7.Text := IntToStr(fAffect.Savingthrows.Reflex);
  Edit8.Text := IntToStr(fAffect.Savingthrows.Fortitude);
  Edit9.Text := IntToStr(fAffect.Savingthrows.Willpower);
  Edit10.Text := IntToStr(fAffect.Points.MaxSkill);
  Edit11.Text := IntToStr(fAffect.Points.MaxFeat);
  Edit12.Text := IntToStr(fAffect.Points.MaxClassAbilities);
  Edit13.Text := IntToStr(fAffect.Points.Hit);
  Edit14.Text := IntToStr(fAffect.Points.Armorclass);
  Edit15.Text := IntToStr(fAffect.Points.Speed);
  Edit16.Text := IntToStr(fAffect.Points.MaxBonusFeat);
  Edit26.Text := IntToStr(fAffect.Points.Initiative);
  Edit17.Text := IntToStr(fAffect.Points.CasterBonusLevels);
  For I := 0 To MAX_ATTACKS-1 Do Begin
     AttackRoll.Cells[I,0] := IntToStr(FAffect.Points.ToHit[I]);
     AttackRoll.Cells[I,1] := IntToStr(FAffect.Points.Damage[I]);
     AttackRoll.Cells[I,2] := IntToStr(FAffect.Points.BareHandToHit[I]);
  End;

  For I := 0 To MAX_SPELL_LEVEL Do Begin
    SpellGrid.Cells[I,0] := IntToStr(FAffect.Points.Arcane[I]);
{    SpellGrid.Cells[I,1] := IntToStr(FAffect.Points.Divine[I]);}
    SpellGrid.Cells[I,1] := IntToStr(FAffect.Points.Known[I]);
  End;
  ClassAbToEdit;
 End;

 Procedure TAffectEditor.EditToAffect;
 Var i : Integer;
 Begin
  fAffect.Abilities.Str := StrToIntDef(Edit1.Text,0);
  fAffect.Abilities.Dex := StrToIntDef(Edit2.Text,0);
  fAffect.Abilities.Con := StrToIntDef(Edit3.Text,0);
  fAffect.Abilities.Int := StrToIntDef(Edit4.Text,0);
  fAffect.Abilities.Wis := StrToIntDef(Edit5.Text,0);
  fAffect.Abilities.Cha := StrToIntDef(Edit6.Text,0);
  fAffect.SavingThrows.Reflex    := StrToIntDef(Edit7.Text,0);
  fAffect.SavingThrows.Fortitude := StrToIntDef(Edit8.Text,0);
  fAffect.SavingThrows.Willpower := StrToIntDef(Edit9.Text,0);
  fAffect.Points.MaxSkill := StrToIntDef(Edit10.Text,0);
  fAffect.Points.MaxFeat := StrToIntDef(Edit11.Text,0);
  fAffect.Points.MaxClassAbilities := StrToIntDef(Edit12.Text,0);
  fAffect.Points.Hit := StrToIntDef(Edit13.Text,0);
  fAffect.Points.Armorclass := StrToIntDef(Edit14.Text,0);
  fAffect.Points.Speed := StrToIntDef(Edit15.Text,0);
  fAffect.Points.Initiative := StrToIntDef(Edit26.Text,0);
  fAffect.Points.MaxBonusFeat := StrToIntDef(Edit16.Text,0);
  fAffect.Points.CasterBonusLevels := StrToIntdef(Edit17.Text,0);
  For I := 0 To MAX_ATTACKS-1 Do Begin
     FAffect.Points.ToHit[I] := StrToInt(AttackRoll.Cells[I,0]);
     FAffect.Points.Damage[I] := StrToInt(AttackRoll.Cells[I,1]);
     FAffect.Points.BareHandToHit[I] := StrToInt(AttackRoll.Cells[I,2]);
  End;
  For I := 0 To MAX_SPELL_LEVEL Do Begin
    FAffect.Points.Arcane[I] := StrToInt(SpellGrid.Cells[I,0]);
{    FAffect.Points.Divine[I] := StrToInt(SpellGrid.Cells[I,1]);}
    FAffect.Points.Known[I]  := StrToInt(SpellGrid.Cells[I,1]);
  End;
 End;

 Procedure TAffectEditor.SetAffect(Affect : TAffected);
 Begin
   fAffect := Affect;
   ClassAbilities.Visible := fAffect is TLevel;
   FreeSkills.List := fAffect.Skills;
   FreeFeats.List := fAffect.Feats;
   FreeLanguages.List := fAffect.Languages;
   BonusLanguages.List := fAffect.BonusLanguages;
   Button2.Enabled := fAffect.Prerequisites <> nil;
   SelectableFeats.List := fAffect.SelectableFeats;
   BonusFeats.List := fAffect.SpecialBonusFeats;
   FreeWeapons.List := fAffect.FreeWeapons;
   SelectableWeapons.List := fAffect.SelectableWeapons;
   AffectToEdit;
 End;

procedure TAffectEditor.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  EditToAffect;
end;

procedure TAffectEditor.FormCreate(Sender: TObject);
begin
 fClass := nil;
 SkillOverview.List      := World.Skills;
 FeatOverview.List       := World.Feats;
 FeatOverview2.List     := World.Feats;
 FeatOverview3.List     := World.Feats;

 LanguageOverview.List   := World.LAnguages;
 LanguageOverview2.List  := World.LAnguages;

 WeaponOverview1.List := World.Weapons;
 WeaponOverview2.List := World.Weapons;
 PageControl1.ActivePage := TabSheet3;
end;

procedure TAffectEditor.SkillOverviewSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
 Var Skill : TTrainedSkill;
  I : Integer;
  Parameter : String;
begin
 Parameter := '';
 If TBaseSkill(Item).Parameters.Count > 0 Then Begin

   ParameterSelect := TParameterSelect.Create(self);
   ParameterSelect.SetList(TBaseSkill(Item).Parameters);
   If ParameterSelect.ShowModal =  MrOk Then Begin
      Parameter := ParameterSelect.ParameterList.Items[ParameterSelect.ParameterList.ItemIndex];
   End;
   ParameterSelect.Free;
 End;
 Skill := TTrainedSkill.Create( TBaseSkill(Item) , fAffect.Skills );
 Skill.PArameter := Parameter;

 For I := 0 To fAffect.Skills.Count-1 Do Begin
   If ( ( fAffect.Skills.Items[I].BaseSkill = Skill.BaseSkill ) AND
       ( fAffect.Skills.Items[I] <> Skill ) AND
       ( fAffect.Skills.Items[I].Parameter = Parameter ) ) Then Begin
      Skill.Free;
      Break;
   End;
 End;

 FreeSkills.Invalidate;
end;

procedure TAffectEditor.FeatOverviewSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
   if fAffect.Feats.IndexOf(Item) = -1 Then
      fAffect.Feats.Add(Item);
  FreeFeats.Invalidate;
end;

procedure TAffectEditor.FreeFeatsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
  fAffect.Feats.Extract(Item);
  FreeFeats.Invalidate;
end;

procedure TAffectEditor.FreeSkillsAfterDecrease(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item.Value <= 0 ) Then
    Item.Free;
  FreeSkills.Invalidate;
end;


Procedure TAffectEditor.ClassAbToEdit;
var LI : TListItem;
    I : Integer;
Begin
 ListView1.Items.Clear;
 if not ( fAffect is TLevel ) Then Exit;
 For I := 0 To TLevel(fAffect).ClassAbilities.Count-1 Do Begin
   LI := Listview1.Items.Add;
   LI.Data := TLevel(fAffect).ClassAbilities[I];
   LI.Caption := TLevel(fAffect).ClassAbilities[I].Name;
   LI.SubItems.Add(IntToStr(TLevel(fAffect).ClassAbilities[I].OverrideID));
   if ( TLevel(fAffect).ClassAbilities[I].Choose ) Then
     LI.SubItems.Add('*')
   Else
     LI.SubItems.Add('');
 End;
End;

procedure TAffectEditor.Button2Click(Sender: TObject);
Var Win : TAffectEditor;
begin
  Win := TAffectEditor.Create(Self);
  Try
    Win.SetAffect(fAffect.Prerequisites);
    Win.Caption := 'Affect Requirement Editor - Redblade 3e';
    Win.ShowModal;
  Finally
    Win.Free;
  End;
end;

procedure TAffectEditor.Delete1Click(Sender: TObject);
Var Item : TObject;
begin
 if ListView1.Selected <> nil Then Begin
   Item := ListView1.Selected.Data;
   TLevel(fAffect).ClassAbilities.Extract(Item);
   TClassAbility(Item).Free;
   ListView1.Selected.Delete;
 End;
end;

procedure TAffectEditor.ListView1DblClick(Sender: TObject);
Var Win : TClassAbilityEditor;
begin
  if ( ListView1.Selected = nil) Then Exit;
  Win := TClassAbilityEditor.Create(Self);
  Try
    Win.SetAbility(TClassAbility(ListView1.Selected.DAta));
    Win.SetClass(fClass,fLevel);
    Win.ShowModal;
    AbilityAssign;
  Finally
    Win.Free;
  End;
end;

Procedure TAffectEditor.AbilityAssign;
Begin
 With ListView1.Selected Do Begin
   Caption := TClassAbility(Data).Name;
   SubItems[0] := IntToStr( TClassAbility(Data).OverrideID);
   if ( TClassAbility(Data).Choose ) Then
     SubItems[1] := '*'
   Else
     SubItems[1] := ' ';
 End;
End;

procedure TAffectEditor.Add1Click(Sender: TObject);
Var Li : TListItem;
begin
 Li := ListView1.Items.Add;
 Li.Caption := '';
 Li.SubItems.Add('');
 Li.SubItems.Add('');
 Li.Data := TClassAbility.Create;
 TLevel(fAffect).ClassAbilities.Add(Li.Data);
 ListView1.Selected := Li;
 AbilityAssign;
 ListView1DblClick(Self);
end;

procedure TAffectEditor.LanguageOverviewSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
   if fAffect.Languages.IndexOf(Item) = -1 Then
      fAffect.Languages.Add(Item);
  FreeLanguages.Invalidate;
end;

procedure TAffectEditor.FreeLanguagesSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
  fAffect.Languages.Extract(Item);
  FreeLanguages.Invalidate;
end;

procedure TAffectEditor.LanguageOverview2Select(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
   if fAffect.BonusLanguages.IndexOf(Item) = -1 Then
      fAffect.BonusLanguages.Add(Item);
  BonusLanguages.Invalidate;
end;

procedure TAffectEditor.BonusLanguagesSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
  fAffect.BonusLanguages.Extract(Item);
  BonusLanguages.Invalidate;
end;

procedure TAffectEditor.PageControl1Change(Sender: TObject);
begin
 if  Edit8.CanFocus Then
 Edit8.SetFocus;
end;

procedure TAffectEditor.FeatOverview2Select(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
   if fAffect.SelectableFeats.IndexOf(Item) = -1 Then
      fAffect.SelectableFeats.Add(Item);
  SelectableFeats.Invalidate;
end;

procedure TAffectEditor.FeatOverview3Select(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
   if fAffect.SpecialBonusFeats.IndexOf(Item) = -1 Then
      fAffect.SpecialBonusFeats.Add(Item);
  BonusFeats.Invalidate;
end;

procedure TAffectEditor.SelectableFeatsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
  fAffect.SelectableFeats.Extract(Item);
  SelectableFeats.Invalidate;
end;

procedure TAffectEditor.BonusFeatsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
  fAffect.SpecialBonusFeats.Extract(Item);
  BonusFeats.Invalidate;
end;

procedure TAffectEditor.Button3Click(Sender: TObject);
Var I : Integer;
Begin
 For I := 0 To World.Feats.Count-1 Do begin
   if fAffect.SelectableFeats.IndexOf(World.Feats[I]) = -1 Then
      fAffect.SelectableFeats.Add(World.Feats[I]);
 End;
  SelectableFeats.Invalidate;


end;

procedure TAffectEditor.WeaponOverview1Select(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
   if fAffect.FreeWeapons.IndexOf(Item) = -1 Then
      fAffect.FreeWeapons.Add(Item);
  FreeWeapons.Invalidate;
end;

procedure TAffectEditor.WeaponOverview2Select(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
   if fAffect.SelectableWeapons.IndexOf(Item) = -1 Then
      fAffect.SelectableWeapons.Add(Item);
  SelectableWeapons.Invalidate;
end;

procedure TAffectEditor.FreeWeaponsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
  fAffect.FreeWeapons.Extract(Item);
  FreeWeapons.Invalidate;
end;

procedure TAffectEditor.SelectableWeaponsSelect(Control: TWinControl;
  Item: TPrimalDNDObject);
begin
  If ( Item <> nil ) Then
  fAffect.SelectableWeapons.Extract(Item);
  SelectableWeapons.Invalidate;
end;

procedure TAffectEditor.Button4Click(Sender: TObject);
var I :Integer;
begin
 For I := 0 To World.Weapons.Count-1 Do Begin
   if fAffect.SelectableWeapons.IndexOf(World.Weapons[I]) = -1 Then
        fAffect.SelectableWeapons.Add(World.Weapons[I]);
 End;
 SelectableWeapons.Invalidate;
end;

procedure TAffectEditor.Button5Click(Sender: TObject);
Var I : Integer;
begin
 For I := 0 To World.Weapons.Count-1 Do If World.Weapons[I].Group = TButton(Sender).Tag Then Begin
   if fAffect.FreeWeapons.IndexOf(World.Weapons[I]) = -1 Then
        fAffect.FreeWeapons.Add(World.Weapons[I]);
 End;
 FreeWeapons.Invalidate;
end;

end.
