unit FrMRaceEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DNDClasses, StdCtrls, ExtCtrls, ComCtrls, Menus;

type
  TRaceEditor = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    ListView1: TListView;
    PopupMenu1: TPopupMenu;
    Add1: TMenuItem;
    N1: TMenuItem;
    Delete1: TMenuItem;
    Edit2: TEdit;
    Label3: TLabel;
    Button2: TButton;
    CheckBox1: TCheckBox;
    Label4: TLabel;
    Edit3: TEdit;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Add1Click(Sender: TObject);
    procedure ListView1DblClick(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    fRace : TBaseRace;
    Procedure SetRace(Race : TBaseRace);
    Procedure RaceToEdit;
    Procedure EditToRace;
    Procedure RaceAbToEdit;
  end;

var
  RaceEditor: TRaceEditor;

implementation

 Uses FrmRaceAbilityEditor, FrmAffectedEditor;

{$R *.DFM}

Procedure TRaceEditor.SetRace(Race : TBaseRace);
Begin
 fRace := Race;
 RaceAbToEdit;
 RaceToEdit;
End;

Procedure TRaceEditor.RaceToEdit;
Begin
 Edit2.Text := fRace.Name;
 Edit1.Text := fRace.FavoredClass;
 Edit3.Text := IntToStr(fRace.LevelCost);
 Combobox1.ItemIndex := frace.Size;
 CheckBox1.Checked := ( fRace.Flags and 1 ) > 0;
End;

Procedure TRaceEDitor.EditToRace;
Begin
 fRace.Name := Edit2.Text;
 fRace.FavoredClass := Edit1.Text;
 fRace.Size := Combobox1.ItemIndex;
 fRace.LevelCost := StrTOIntDef(Edit3.Text,2);
 fRace.Flags := 0;
 If CheckBox1.Checked Then inc(fRace.Flags,1);
End;

procedure TRaceEditor.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 EditToRace;
end;

procedure TRaceEditor.Add1Click(Sender: TObject);
Var Li : TListItem;
begin
 Li := ListView1.Items.Add;
 Li.Caption := '';
 Li.Data := TRaceAbility.Create;
 fRace.RaceAbilities.Add(Li.Data);
 ListView1.Selected := Li;
 ListView1.Selected.Caption := TRaceAbility(Li.Data).Name;
 ListView1DblClick(Self);
end;

Procedure TRaceEditor.RaceAbToEdit;
var LI : TListItem;
    I : Integer;
Begin
 ListView1.Items.Clear;
 For I := 0 To fRace.RaceAbilities.Count-1 Do Begin
   LI := Listview1.Items.Add;
   LI.Data := Frace.RaceAbilities[I];
   LI.Caption := FRace.RaceAbilities[I].Name;
 End;
End;

procedure TRaceEditor.ListView1DblClick(Sender: TObject);
Var Win : TRaceAbilityEditor;
begin
  if ( ListView1.Selected = nil) Then Exit;
  Win := TRaceAbilityEditor.Create(Self);
  Try
    Win.SetAbility(TRaceAbility(ListView1.Selected.DAta));
    Win.ShowModal;
    ListView1.Selected.Caption := TRaceAbility(ListView1.Selected.Data).Name;
  Finally
    Win.Free;
  End;
end;

procedure TRaceEditor.Delete1Click(Sender: TObject);
var Item : TObject;
begin
 if ListView1.Selected <> nil Then Begin
   Item := ListView1.Selected.Data;
   fRace.RaceAbilities.Extract(Item);
   TRaceAbility(Item).Free;
   ListView1.Selected.Delete;
 End;
end;

procedure TRaceEditor.Button2Click(Sender: TObject);
Var Win : TAffectEditor;
begin
  Win := TAffectEditor.Create(Self);
  Try
    Win.SetAffect(fRace);
    Win.Caption := 'Race Base Affect Editor - Redblade 3e';
    Win.ShowModal;
  Finally
    Win.Free;
  End;
end;

procedure TRaceEditor.FormCreate(Sender: TObject);
begin
 PageControl1.ActivePage := TabSheet1;
end;

procedure TRaceEditor.FormShow(Sender: TObject);
begin
 ActiveControl := Edit2;
end;

end.

