unit DNDWorld;

interface

Uses contnrs, classes,Dialogs, SysUtils, DNDObjects, DNDClasses, DNDCharacter, DNDSpells, DNDStream, DNDWeapons, DNDItems;

Const WORLD_FILE_ID : String = 'RedbladeWorldfilev1.00';

Type

TWorld = Class (TObject)
Private
Public
 Races               : TBaseRaceList;
 Classes             : TBaseClassList;
 Skills              : TBaseSkillList;
 Feats               : TBaseFeatList;
 Languages           : TLanguageList;
 Spells              : TBaseSpellList;
 Domains             : TDomainList;
 Weapons             : TWeaponList;
 Items               : TItemList;
 Author              : String;
 Email               : String;
 Url                 : String;
 Name                : String;
 WorldFileName       : String;
 ResourceGroups      : TStringList;
 fGroup              : Integer;
 Constructor Create;
 Destructor Destroy; Override;
 Function AddRace(Name : String) : TBaseRace;
 Function AddSpell(Name : String) : TBaseSpell;
 Function AddClass(Name : String) : TBaseClass;
 Function AddSkill(Name : String) : TBaseSkill;
 Function AddFeat(Name : String) : TBaseFeat;
 Function AddLanguage(Name : String) : TLanguage;
 Function AddWeapon(Name : String) : TWeapon;
 Function AddDeity(Name : String) : TBaseDeity;
 Function AddDomain(Name : String) : TDomain;
 Function AddItem(Name : String) : TDNDItem;
 Procedure RacesToString(Target : TStrings);
 Procedure ClassesToString(Target : TStrings);
 Procedure StreamWrite(Stream : TDNDStream);
 Procedure StreamRead(Stream : TDNDStream);
 Procedure Load(FileName : String);
 Procedure Save(FileName : String);
End;

Var World : TWorld;

implementation

Uses FrmMain;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

Constructor TWorld.Create;
Begin
 Inherited;
 ResourceGroups := TStringList.Create;
 Races   := TBaseRaceList.Create;
 Classes := TBaseClassList.Create;
 Skills  := TBaseSkillList.Create;
 Spells  := TBaseSpellList.Create;
 Feats   := TBaseFeatList.Create;
 Domains := TDomainList.Create;
 Languages := TLanguageList.Create;
 Weapons := TWeaponList.Create;
 Items  := TItemList.Create;

End;

Destructor TWorld.Destroy;
Begin
 Domains.Free;
 Spells.Free;
 Weapons.Free;
 Languages.Free;
 Feats.Free;
 Races.Free;
 Classes.Free;
 Skills.Free;
 Items.Free;
 ResourceGroups.Free;
 Inherited;
End;

Function TWorld.AddWeapon(Name : String) : TWeapon;
Var Weapon : TWeapon;
    I : Integer;
Begin
 For I := 0 To Weapons.Count-1 Do If Weapons[I].Name = Name Then Begin
  Result := Weapons[I];
  Exit;
 End;
 Weapon := TWeapon.Create();
 Weapon.Group := fGroup;
 Weapon.Name := Name;
 Weapons.Add(Weapon);
 Result := Weapon;
End;

Function TWorld.AddItem(Name : String) : TDNDItem;
Var Item : TDNDItem;
    I : Integer;
Begin
 For I := 0 To Items.Count-1 Do If Items[I].Name = Name Then Begin
  Result := Items[I];
  Exit;
 End;
 Item := TDNDItem.Create();
 Item.Name := Name;
 Item.fGroup := fGroup;
 Items.Add(Item);
 Result := Item;
End;

Function TWorld.AddLanguage(Name : String) : TLanguage;
Var Language : TLanguage;
    I : Integer;
Begin
 For I := 0 To Languages.Count-1 Do If Languages[I].Name = Name Then Begin
  Result := Languages[I];
  Exit;
 End;
 Language := TLanguage.Create();
 Language.Name := Name;
 Language.fGroup := fGroup;
 Languages.Add(Language);
 Result := Language;
End;

Function TWorld.AddRace(Name : String) : TBaseRace;
Var Race : TBaseRace;
Var I : Integer;
Begin
 For I := 0 To Races.Count-1 Do If Races[I].Name = Name Then Begin
  Result := Races[I];
  Exit;
 End;
 Race := TBaseRace.Create;
 Race.Name := Name;
 Race.fGroup := fGroup;
 Races.Add(Race);
 Result := Race;
End;

Function TWorld.AddClass(Name : String) : TBaseClass;
Var Clas : TBaseClass;
Var I : Integer;
Begin
 For I := 0 To Classes.Count-1 Do If Classes[I].Name = Name Then Begin
  Result := Classes[I];
  Exit;
 End;
 Clas := TBaseClass.Create;
 Clas.Name := Name;
 Clas.fGroup := fGroup;
 Classes.Add(Clas);
 Result := Clas;
End;

Function TWorld.AddSkill(Name : String) : TBaseSkill;
Var Skill : TBaseSkill;
Var I : Integer;
Begin

 For I := 0 To Skills.Count-1 Do If Skills[I].Name = Name Then Begin
  Result := Skills[I];
  Exit;
 End;
{ ShowMessage('Create '+Name+'('+IntToStr(Skills.Count)+')');}
 Skill := TBaseSkill.Create;
 Skill.Name := Name;
 Skill.fGroup := fGroup;
 Skills.Add(Skill);
 Result := Skill;
End;

Function TWorld.AddSpell(Name : String) : TBaseSpell;
Var Spell : TBaseSpell;
Var I : Integer;
Begin
 For I := 0 To Spells.Count-1 Do If Spells[I].Name = Name Then Begin
  Result := Spells[I];
  Exit;
 End;
 Spell := TBaseSpell.Create;
 Spell.Name := Name;
 Spell.fGroup := fGroup;
 Spells.Add(Spell);
 Result := Spell;
End;

Function TWorld.AddFeat(Name : String) : TBaseFeat;
Var Feat : TBaseFeat;
Var I : Integer;
Begin
 For I := 0 To Feats.Count-1 Do If Feats[I].Name = Name Then Begin
  Result := Feats[I];
  Exit;
 End;
 Feat := TBaseFeat.Create;
 Feat.Name := Name;
 Feat.fGroup := fGroup;
 Feats.Add(Feat);
 Result := Feat;
End;


Procedure TWorld.RacesToString(Target : TStrings);
var I : Integer;
Begin
 Target.BeginUpdate;
 Target.Clear;
 For I := 0 To Races.Count-1 Do
 Target.AddObject(Races[I].Name, Races[I]);
 Target.EndUpdate;
End;

Function TWorld.AddDeity(Name : String) : TBaseDeity;
Begin
 Result := Nil;
End;

Procedure TWorld.ClassesToString(Target : TStrings);
var I : Integer;
Begin
 Target.BeginUpdate;
 Target.Clear;
 For I := 0 To Classes.Count-1 Do
 Target.AddObject(Classes[I].Name, Classes[I]);
 Target.EndUpdate;
End;

Function TWorld.AddDomain(Name : String) : TDomain;
Var Domain : TDomain;
Var I : Integer;
Begin
 For I := 0 To Domains.Count-1 Do If Domains[I].Name = Name Then Begin
  Result := Domains[I];
  Exit;
 End;
 Domain := TDomain.Create;
 Domain.Name := Name;
 Domain.fGroup := fGroup;
 Domains.Add(Domain);
 Result := Domain;
End;

Procedure TWorld.StreamWrite(Stream : TDNDStream);
Var I :Integer;
Begin
 Languages.StreamWrite(Stream,True);
 Skills.StreamWrite(Stream,True);
 Feats.StreamWrite(Stream,True);
 Races.StreamWrite(Stream,True);
 Classes.StreamWrite(Stream,True);
 Spells.StreamWrite(Stream,True);
 Domains.StreamWrite(Stream,True);
 Weapons.StreamWrite(Stream,True);
 Stream.WriteString(Author);
 Stream.WriteString(Email);
 Stream.WriteString(Url);
 Stream.WriteString(NAme);
 Items.StreamWrite(Stream, True);

 Stream.WriteInteger(resourceGroups.Count);
 For I := 0 To ResourceGroups.Count-1 Do Stream.WriteString( ResourceGroups[I]);
End;

Procedure TWorld.StreamRead(Stream : TDNDStream);
Var Max, I : Integer;
Begin
 Languages.StreamRead(Stream,True);
 Skills.StreamRead(Stream,True);
 Feats.StreamRead(Stream,True);
 Races.StreamRead(Stream,True);
 Classes.StreamRead(Stream,True);
 Spells.StreamRead(Stream,True);
 Domains.StreamRead(Stream,True);
 Weapons.StreamRead(Stream,True);
 Author := Stream.ReadString;
 Email  := Stream.ReadString;
 Url    := Stream.ReadString;
 Name   := Stream.ReadString;
 Items.StreamRead(Stream,True);

 resourceGroups.Clear;
 Max := Stream.ReadInteger;
 For I := 0 To Max-1 Do ResourceGroups.Add(Stream.ReadString());

 Main.Panel7.Caption := 'Campaign: '+Name;
 Main.ClearBooklets;
End;

Procedure TWorld.Load(FileName : String);
Var Stream : TDNDStream;
Begin
 WorldFileName := FileName;
 Stream := TDNDStream.Create(FileName,fmOpenRead);
 if ( Stream.ReadString = WORLD_FILE_ID ) Then Begin
   Stream.ReadVersion;
   StreamRead(Stream);
 End Else ShowMessage('Not a valid World file.');
 Stream.Free;
End;

Procedure TWorld.Save(FileName : String);
Var Stream : TDNDStream;
Begin
 Stream := TDNDStream.Create(FileName,fmOpenWrite or fmCreate);
 Stream.WriteString(WORLD_FILE_ID);
 Stream.WriteVersion(1);
 StreamWrite(Stream);
 Stream.Free;
End;

Initialization
  World := TWorld.Create;
end.

