unit DNDWeapons;

interface

Uses DNDObjects, DNDStream;

Type
TWeapon = Class (TDNDObject)
Public
  Group       : Integer; { 0=Simple, 1=Martial, 2=Exotic }
  Ranged      : Integer; { 0=Melee, 1=Ranged }
  Size        : Integer; { 0=Unarmed Attacks, 1=Tiny, 2=Small, 3=Medium-size, 4=Large }
  Procedure StreamWrite(Stream : TDNDStream); Override;
  Procedure StreamRead(Stream : TDNDStream); Override;
End;

TWeaponList = Class (TDNDList)
Public
  Procedure   AddList(Source : TWeaponList);  // Add Source items to this list.
  function    GetWeapon(Index: Integer): TWeapon;
  procedure   SetWeapon(Index: Integer; AObject: TWeapon);
  Procedure   AddWeapon(Weapon : TWeapon);
  property    Items[Index: Integer]: TWeapon Read GetWeapon Write SetWeapon; default;
  Procedure StreamWrite(Stream : TDNDStream; StoreContent: Boolean);
  Procedure StreamRead(Stream : TDNDStream; StoreContent: Boolean);
End;


implementation

Uses DNDWOrld;

  Procedure  TWeaponList.AddList(Source : TWeaponList);  // Add Source items to this list.
  Var I : Integer;
  Begin
    For I := 0 To Source.Count-1 Do
      AddWeapon(Source.Items[I]);
  End;

  Procedure TWeapon.StreamWrite(Stream : TDNDStream);
  Begin
   Inherited;
   Stream.WriteInteger(Group);
   Stream.WriteInteger(Ranged);
   Stream.WriteInteger(Size);
  End;

  Procedure TWeapon.StreamRead(Stream : TDNDStream);
  Begin
   Inherited;
   Group := Stream.ReadInteger;
   Ranged := Stream.ReadInteger;
   Size := Stream.ReadInteger;
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Procedure TWeaponList.StreamWrite(Stream : TDNDStream; StoreContent: Boolean);
  Var I : Integer;
  Begin
    With Stream Do Begin
      WriteInteger(Count);
      For I := 0 To Count-1 Do Begin
         Stream.WriteString(Items[I].Name);
         if Storecontent Then Items[I].StreamWrite(Stream);
      End;
    End;
  End;

  Procedure TWeaponList.StreamRead(Stream : TDNDStream; StoreContent: Boolean);
  Var I, Max : Integer;
      Weapon : TWeapon;
      Name : String;
  Begin
    Clear;
    Max := Stream.ReadInteger;
    For I := 0 To Max-1 Do Begin
       Name := Stream.ReadString;
       Weapon := World.AddWeapon(Name);
       if StoreContent then Weapon.StreamRead(Stream);
       if World.Weapons <> Self Then Add(Weapon);
    End;
  End;

  Procedure  TWeaponList.AddWeapon(Weapon : TWeapon);
  Begin
   If(IndexOf(Weapon) <> -1) Then Exit;
   Add(Weapon);
  End;

  function TWeaponList.GetWeapon(Index: Integer): TWeapon;
  Begin
    Result := TWeapon(GetItem(Index));
  End;

  procedure TWeaponList.SetWeapon(Index: Integer; AObject: TWeapon);
  Begin
    SetItem(index,AObject);
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////


end.
