unit DNDStream;

interface

Uses Classes;

Type
 TDNDStream = Class(TFileStream)
 Public
   Version : Integer;
   Procedure WriteInteger(I : Integer);
   Function ReadInteger : Integer;
   Procedure WriteVersion(VersionNr : Integer);
   Procedure ReadVersion;
   Procedure WriteReal(R : Real);
   Function ReadReal : Real;
   Procedure WriteString(S : String);
   Function ReadString : String;
   Procedure WriteBoolean(B : Boolean);
   Function ReadBoolean : Boolean;
   Procedure WriteBaseSkill(Skill : TObject);
   Function ReadBaseSkill : TObject;
   Procedure WriteBaseClass(Clas : TObject);
   Function ReadBaseClass : TObject;
   Procedure WriteBaseFeat(Feat : TObject);
   Function ReadBaseFeat : TObject;
   Procedure WriteBaseSpell(Spell : TObject);
   Function ReadBaseSpell : TObject;
 End;

implementation

Uses DNDWorld, DNDObjects, DNDClasses, DNDSpells;

Procedure TDNDStream.WriteInteger(I : Integer);
Begin
 Write(I,Sizeof(I));
End;

Function TDNDStream.ReadInteger : Integer;
Begin
 Read(Result,Sizeof(Result));
End;

Procedure TDNDStream.WriteReal(R : Real);
Begin
 Write(R,Sizeof(R));
End;

Function TDNDStream.ReadReal : Real;
Begin
 Read(Result,Sizeof(Result));
End;

Procedure TDNDStream.WriteBoolean(B : Boolean);
Begin
 Write(B,Sizeof(B));
End;

Function TDNDStream.ReadBoolean : Boolean;
Begin
 Read(Result,Sizeof(Result));
End;

Procedure TDNDStream.WriteBaseClass(Clas : TObject);
Var Sk : TBaseClass;
Begin
 Sk := TBaseClass(Clas);
 if ( Sk = nil ) Then WriteString('') Else
 WriteString(Sk.Name);
End;

Function TDNDStream.ReadBaseClass : TObject;
Var Name : String;
Begin
 Name := ReadString;
 if ( Name = '' ) Then Result := nil Else
 Result := World.AddClass(Name);
 // Looks in the world object for this base skill and returns
End;

Procedure TDNDStream.WriteBaseSpell(Spell : TObject);
Var Sk : TBaseSpell;
Begin
 Sk := TBaseSpell(Spell);
 WriteString(Sk.Name);
End;

Function TDNDStream.ReadBaseSpell : TObject;
Var Name : String;
Begin
 Name := ReadString;
 Result := World.AddSpell(Name);
 // Looks in the world object for this base skill and returns
End;

Procedure TDNDStream.WriteBaseSkill(Skill : TObject);
Var Sk : TBaseSkill;
Begin
 Sk := TBaseSkill(Skill);
 WriteString(Sk.Name);
End;

Function TDNDStream.ReadBaseSkill : TObject;
Var Name : String;
Begin
 Name := ReadString;
 Result := World.AddSkill(Name);
 // Looks in the world object for this base skill and returns
End;

Procedure TDNDStream.WriteBaseFeat(Feat : TObject);
Var Sk : TBaseFeat;
Begin
 Sk := TBaseFeat(Feat);
 WriteString(Sk.Name);
End;

Function TDNDStream.ReadBaseFeat : TObject;
Var Name : String;
Begin
 Name := ReadString;
 Result := World.AddFeat(Name);
 // Looks in the world object for this base skill and returns
End;

Procedure TDNDStream.WriteString(S : String);
var
  Len: Integer;
begin
  Len := Length(S);
  Write(Len, SizeOf(Integer));
  Write(PChar(S)^, Len);
end;

Function TDNDStream.ReadString : String;
var
  StrLen: Integer;
  PBuf: PChar;
begin
  Read(StrLen, SizeOf(Integer));
  GetMem(PBuf, StrLen);
  try
    Read(PBuf^, StrLen);
    SetString(Result, PBuf, StrLen);
  finally
    FreeMem(PBuf, StrLen);
  end;
end;

Procedure TDNDStream.WriteVersion(VersionNr : Integer);
Begin
 WriteInteger(Versionnr);
End;

Procedure TDNDStream.ReadVersion;
Begin
 Version := ReadInteger;
End;

end.
