unit DNDSpells;
interface

Uses contnrs, Dialogs, SysUtils, Classes, DNDObjects, DNDClasses, DNDStream;

{Const TOTALDOMAINS = 21;
Const Domains : Array[1..TOTALDOMAINS] of String =
('Air', 'Animal', 'Chaos', 'Death', 'Destruction', 'Earth', 'Evil', 'Fire', 'Good',
'Healing', 'Knowledge', 'Law', 'Luck', 'Magic', 'Plant', 'Protection',
'Strength', 'Sun', 'Trickery', 'War', 'Water'); }

Const TOTALSCHOOLS = 9;
Const Schools : Array[1..TOTALSCHOOLS] of String =
( 'Abjuration', 'Conjuration', 'Divination', 'Enchantment',
  'Evocation', 'Illusion', 'Necromancy', 'Transmutation', 'Universal' );

// Bonus Spells based on modifier +1 to +17
Const BonusSpells : Array[1..17, 1..9] of Integer =
  (
     (  1,  0,  0,  0,  0,  0,  0,  0,  0 ),
     (  1,  1,  0,  0,  0,  0,  0,  0,  0 ),
     (  1,  1,  1,  0,  0,  0,  0,  0,  0 ),
     (  1,  1,  1,  1,  0,  0,  0,  0,  0 ),
     (  2,  1,  1,  1,  1,  0,  0,  0,  0 ),
     (  2,  2,  1,  1,  1,  1,  0,  0,  0 ),
     (  2,  2,  2,  1,  1,  1,  1,  0,  0 ),
     (  2,  2,  2,  2,  1,  1,  1,  1,  0 ),
     (  3,  2,  2,  2,  2,  1,  1,  1,  1 ),
     (  3,  3,  2,  2,  2,  2,  1,  1,  1 ),
     (  3,  3,  3,  2,  2,  2,  2,  1,  1 ),
     (  3,  3,  3,  3,  2,  2,  2,  2,  1 ),
     (  4,  3,  3,  3,  3,  2,  2,  2,  2 ),
     (  4,  4,  3,  3,  3,  3,  3,  2,  2 ),
     (  4,  4,  4,  3,  3,  3,  3,  2,  2 ),
     (  4,  4,  4,  4,  3,  3,  3,  3,  2 ),
     (  5,  4,  4,  4,  4,  3,  3,  3,  3 ) );

Type
        TSpellList = Class;

TSpellSchool = Class (TObject)
End;

TSpellSchoolList = Class (TDNDList)
End;

TSpellLevel = Class (TObject)
 BaseClass         : TBaseClass;
 Domain            : String;
 Level             : Integer;
 Procedure StreamWrite(Stream : TDNDStream);
 Procedure StreamRead(Stream : TDNDStream);
End;

TSpellLevelList = Class ( TObjectList)
  function    GetSpellLevel(Index: Integer): TSpellLevel;
  procedure   SetSpellLevel(Index: Integer; AObject: TSpellLevel);
  property    Items[Index: Integer]: TSpellLevel Read GetSpellLevel Write SetSpellLevel ; default;
  Function UsableBy(Clas : TTrainedClass) : Boolean;
  Function SpellLevel(Clas : TTrainedClass) : Integer;
  Function HasDomain(DomaiN : String) : Boolean;
  Procedure StreamWrite(Stream : TDNDStream);
  Procedure StreamRead(Stream : TDNDStream);
End;

TBaseSpell = Class (TAffected)
Private
Public
 SpellLevels       : TSpellLevelList;
 MageSchool        : String;

 Save              : Integer;
 SaveStat          : Integer;
 SaveFlags         : Integer;

 Mr                : Integer;
 MrStat            : Integer;
 MrFlags           : Integer;

 Components        : Integer;

 CastingTime: String;
 Range: String;
 Area: String;
 Duration: String;
 Target: String;
 Effect: String;

 Constructor Create; Override;
 Destructor Destroy; Override;
 Function UsableBy(Clas : TTrainedClass) : Boolean;
 Function SpellLevel(Clas : TTrainedClass) : Integer;
 Procedure AddLevel(Level : Integer; _Class : TBaseClass);
 Function HasDomain(DomaiN : String) : Boolean;
 Procedure AddDomain(Level : Integer; Domain : String);
 Procedure StreamWrite(Stream : TDNDStream); Override;
 Procedure StreamRead(Stream : TDNDStream); Override;
End;

TTrainedSpell = Class (TDNDObject)
Protected
 Function GetName: String; Override;
Public
 Level           : Real;
 BaseSpell       : TBaseSpell;
 List            : TSpellList;
 Function DisplayValue : Real; Override;
 Constructor Create(fSpell : TBaseSpell; fList : TSpellList); Reintroduce;
 Destructor Destroy; Override;
 Procedure Clear;
 Procedure StreamWrite(Stream : TDNDStream); Override;
 Procedure StreamRead(Stream : TDNDStream); Override;
End;

TSpellList = Class (TDNDList)
Private
{  Procedure   Changed;}
Public
  OnChange : TOnChange;
  Constructor Create;
  Destructor  Destroy; Override;
  function    GetSpell(Index: Integer): TTrainedSpell;
  procedure   SetSpell(Index: Integer; AObject: TTrainedSpell);
  property    Items[Index: Integer]: TTrainedSpell Read GetSpell Write SetSpell ; default;
  Function    HasBaseSpell(HasSpell : TBaseSpell) : TTrainedSpell;
  Procedure   StreamWrite(Stream : TDNDStream);
  Procedure   StreamRead(Stream : TDNDStream);
  Procedure   Sort;
End;

TBaseSpellList = Class (TDNDList)
Public
  function    GetSpell(Index: Integer): TBaseSpell;
  procedure   SetSpell(Index: Integer; AObject: TBaseSpell);
  property    Items[Index: Integer]: TBaseSpell Read GetSpell Write SetSpell ; default;
  Procedure   StreamWrite(Stream : TDNDStream; StoreContent: Boolean);
  Procedure   StreamRead(Stream : TDNDStream; StoreContent: Boolean);
End;

Procedure InitProhibited(Group : String; Selector : TStrings);

implementation

Uses FrmMain, DNDWorld;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Procedure TSpellLevel.StreamWrite(Stream : TDNDStream);
  Begin
    Stream.WriteBaseClass(BaseClass);
    Stream.WriteInteger(Level);
    Stream.WriteString(Domain);
  End;

  Procedure TSpellLevel.StreamRead(Stream : TDNDStream);
  Begin
    BaseClass := TBaseClass(Stream.ReadBaseClass);
    Level := Stream.ReadInteger;
    Domain := Stream.ReadString;
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Procedure TBaseSpellList.SetSpell(Index: Integer; AObject: TBaseSpell);
  Begin
    SetItem(index,AObject);
  End;

  Function TBaseSpellList.GetSpell(Index: Integer): TBaseSpell;
  Begin
   Result := TBaseSpell(GetItem(Index));
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Procedure TSpellLevelList.SetSpellLevel(Index: Integer; AObject: TSpellLevel);
  Begin
    SetItem(index,AObject);
  End;

  Function TSpellLevelList.GetSpellLevel(Index: Integer): TSpellLevel;
  Begin
   Result := TSpellLevel(GetItem(Index));
  End;

  /////////////////////////////////////////////////////////

  Function TSpellLevelList.HasDomain(DomaiN : String) : Boolean;
  Var i : Integer;
  Begin
     For I := 0 To Count-1 Do Begin
       if Items[I].Domain = Domain Then Begin
         Result := True;
         Exit;
       End;
     End;
     Result := False;
  End;

  Function TSpellLevelList.UsableBy(Clas : TTrainedClass) : Boolean;
  Var I : Integer;
  Begin
     Result := False;
     For I := 0 To Count-1 Do Begin
       If ( Clas.HighestCastLevel >= Items[I].Level  ) Then Begin
          if ( Pos(Items[I].Domain, Clas.BaseClass.Domains) <> 0 ) Then Begin
             Result := True;
             Break;
          End;
          if ( Clas.BaseClass = Items[I].BaseClass)  Then Begin
             Result := True;
             Break;
          End;
       End;
     End;
  End;

  { Find the lowest possible Level for the current spell }
  Function TSpellLevelList.SpellLevel(Clas : TTrainedClass) : Integer;
  Var I : Integer;
      Lowest : Integer;
  Begin
     Lowest := 999;
     For I := 0 To Count-1 Do Begin
       If ( Clas.HighestCastLevel >= Items[I].Level  ) Then Begin
          if ( Pos(Items[I].Domain, Clas.BaseClass.Domains ) <> 0 ) and
             ( Items[I].Level < Lowest ) Then
              Lowest := Items[I].Level;
          if ( Clas.BaseClass = Items[I].BaseClass) and
             ( Items[I].Level < Lowest ) Then
              Lowest := Items[I].Level;
       End;
     End;
     if ( Lowest = 999 ) Then Result := 0 Else Result := Lowest;
  End;

  Procedure TSpellLevelList.StreamWrite(Stream : TDNDStream);
  Var I : Integer;
  Begin
    Stream.WriteInteger(Count);
    For I := 0 To Count-1 Do
      Items[I].StreamWrite(Stream);
  End;

  Procedure TSpellLevelList.StreamRead(Stream : TDNDStream);
  Var I,Max : Integer;
      Sp    : TSpellLevel;
  Begin
   Max := Stream.ReadInteger;
   Clear;
   For I := 0 To Max -1 Do Begin
      Sp := TSpellLevel.Create;
      Sp.StreamRead(Stream);
      Add(Sp);
   End;
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Constructor TBaseSpell.Create;
  Begin
    Inherited;
    SpellLevels := TSpellLevelList.Create;
    MageSchool := '';
    CastingTime := '';
    Range       := '';
    Area        := '';
    Duration    := '';
  End;

  Destructor  TBaseSpell.Destroy;
  Begin
    SpellLevels.Free;
    Inherited;
  End;

  Function TBaseSpell.SpellLevel(Clas : TTrainedClass) : Integer;
  Begin
   Result := SpellLevels.SpellLevel(Clas);
  End;

  Function TBaseSpell.HasDomain(DomaiN : String) : Boolean;
  Begin
    Result := SpellLevels.HasDomain(Domain);
  End;


  Function TBaseSpell.UsableBy(Clas : TTrainedClass) : Boolean;
  Begin
    Result := False;
    If SpellLevels.UsableBy(Clas) Then Begin
       Result := True;
       Exit;
    End;
  End;

  Procedure TBaseSpell.AddDomain(Level : Integer; Domain : String);
  Var SL : TSpellLevel;
  Begin
   SL := TspellLevel.Create;
   SL.Domain := Domain;
   SL.BaseClass := nil;
   SL.Level := Level;
   SpellLevels.Add(SL);
  End;

  Procedure TBaseSpell.AddLevel(Level : Integer; _Class : TBaseClass);
  Var SL : TSpellLevel;
  Begin
   SL := TspellLevel.Create;
   SL.BaseClass := _Class;
   SL.Level := Level;
   SpellLevels.Add(SL);
  End;

  Procedure TBaseSpell.StreamWrite(Stream : TDNDStream);
  Begin
    Inherited;
    SpellLevels.StreamWrite(Stream);
    Stream.WriteString(MageSchool);
    Stream.WriteInteger(Save);
    Stream.WriteInteger(SaveStat);
    Stream.WriteInteger(SaveFlags);

    Stream.WriteInteger(Mr);
    Stream.WriteInteger(MrStat);
    Stream.WriteInteger(MrFlags);

    Stream.WriteInteger(Components);

    Stream.WriteString(CastingTime);
    Stream.WriteString(Range);
    Stream.WriteString(Area);
    Stream.WriteString(Duration);
    Stream.WriteString(Target);
    Stream.WriteString(Effect);
  End;

  Procedure TBaseSpell.StreamRead(Stream : TDNDStream);
  Begin
    Inherited;
    SpellLevels.StreamRead(Stream);
    MageSchool := Stream.ReadString;

    Save := Stream.ReadInteger;
    SaveStat := Stream.ReadInteger;
    SaveFlags := Stream.ReadInteger;
    Mr      := Stream.ReadInteger;
    MrStat  := Stream.ReadInteger;
    MrFlags := Stream.ReadInteger;

    Components := Stream.ReadInteger;

    CastingTime := Stream.ReadString;
    Range       := Stream.ReadString;
    Area        := Stream.ReadString;
    Duration    := Stream.ReadString;
    Target      := Stream.ReadString;
    Effect      := Stream.ReadString;

{    Stream.WriteInteger(Save);
    Stream.WriteInteger(SaveStat);
    Stream.WriteInteger(SaveFlags);

    Stream.WriteInteger(Mr);
    Stream.WriteInteger(MrStat);
    Stream.WriteInteger(MrFlags);

    Stream.WriteInteger(Components);}
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////


  Function TTrainedSpell.GetName : String;
  Begin
{   If Assigned(BaseSpell) Then Begin
     Result := BaseSpell.Name + ' ('+IntToStr(Round(Level))+')';
   End Else Result := '';}
   Result := BaseSpell.Name;
  End;

  Constructor TTrainedSpell.Create(fSpell : TBaseSpell; fList : TSpellList);
  // Create a new Trained Spell based on fSpell, and add it to a Spell List.
  Begin
   Inherited Create();
   BaseSpell := fSpell;
   List  := fList;
   List.Add(Self);
  End;

  Destructor TTrainedSpell.Destroy;
  // Kill self from the available Spell list.
  Begin
   List.Delete(List.IndexOf(Self));
   Inherited;
  End;

  Procedure TTrainedSpell.Clear;
  Begin
   Inherited;
  End;

  Function TTrainedSpell.DisplayValue : Real;
  Begin
    Result := Level;
  End;

  Procedure TTrainedSpell.StreamWrite(Stream : TDNDStream);
  Begin
    Inherited;
    Stream.WriteReal(Level);
    Stream.WriteBaseSpell(BaseSpell);
  End;

  Procedure TTrainedSpell.StreamRead(Stream : TDNDStream);
  Begin
    Inherited;
    Level := Stream.Readreal;
    BaseSpell := TBaseSpell(Stream.ReadBaseSpell);
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Constructor TSpellList.Create;
  Begin
    Inherited;
  End;

{  Procedure   TSpellList.Changed;
  Begin
    if Assigned(OnChange) Then OnChange;
  End;}

  Destructor TSpellList.Destroy;
  Begin
   Inherited;
  End;

  Procedure TSpellList.SetSpell(Index: Integer; AObject: TTrainedSpell);
  Begin
    SetItem(index,AObject);
  End;

  Function TSpellList.GetSpell(Index: Integer): TTrainedSpell;
  Begin
   Result := TTrainedSpell(GetItem(Index));
  End;

  Procedure TSpellList.Sort;
  Var X,Y : Integer;
      Tmp : TTrainedSpell;
  Begin
   For X := 0 To Count-1 Do
    For Y := 0 To Count-1 Do If Items[X].Level < Items[Y].Level Then Begin
      Tmp := Items[X];
      Items[X] := Items[Y];
      Items[Y] := Tmp;
    End;
  End;

  Function TSpellList.HasBaseSpell(HasSpell : TBaseSpell) : TTrainedSpell;
  Var I : Integer;
  Begin
   Result := Nil;
   For I := 0 To Count-1 Do
     If Items[i].BaseSpell = HasSpell Then Begin
       Result := Items[I];
       Exit;
     End;
  End;

  Procedure TSpellList.StreamWrite(Stream : TDNDStream);
  Var I : Integer;
  Begin
    Stream.WriteInteger(Count);
    For I := 0 To Count-1 Do
      Items[I].StreamWrite(Stream);
  End;

  Procedure TSpellList.StreamRead(Stream : TDNDStream);
  Var I, Max : Integer;
      TrainedSpell : TTrainedSpell;
  Begin
    Max := Stream.ReadInteger;
    Clear;
    For I := 0 To Max-1 Do Begin
      TrainedSpell := TTrainedSpell.Create(Nil,Self);
      TrainedSpell.StreamRead(Stream);
    End;
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Procedure TBaseSpellList.StreamWrite(Stream : TDNDStream; StoreContent: Boolean);
  Var I : Integer;
  Begin
    Stream.WriteInteger(Count);
    For I := 0 To Count-1 Do Begin
        Stream.WriteString(Items[I].Name);
        If StoreContent Then Items[I].StreamWrite(Stream);
    End;
  End;

  Procedure TBaseSpellList.StreamRead(Stream : TDNDStream; StoreContent: Boolean);
  Var I, Max : Integer;
      BaseSpell : TBaseSpell;
  Begin
    Max := Stream.ReadInteger;
    Clear;
    For I := 0 To Max-1 Do Begin
       BaseSpell := World.AddSpell(Stream.ReadString);
       if StoreContent Then BaseSpell.StreamRead(Stream);
       If ( Self <> World.Spells ) Then Add(BaseSpell);
    End;
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Procedure InitProhibited(Group : String; Selector : TStrings);
  Begin
    Group := Lowercase(Group);
    Selector.BeginUpdate;
    Selector.Clear;
    If Group = 'abjuration' Then With Selector Do Begin
       Add('Conjuration');
       Add('Enchantment');
       Add('Evocation');
       Add('Illusion');
       Add('Transmutation');
       Add('Divination, Necromancy');
    End Else
    If Group = 'conjuration' Then With Selector Do Begin
       Add('Evocation');
       Add('Abjuration, Enchantment');
       Add('Abjuration, Illusion');
       Add('Enchantment, Illusion');
       Add('Transmutation');
       Add('Abjuration, Divination, Necromancy');
       Add('Illusion, Divination, Necromancy');
       Add('Enchantment, Divination, Necromancy');
    End Else
    If Group = 'divination' Then With Selector Do Begin
       Add('Abjuration');
       Add('Conjuration');
       Add('Enchantment');
       Add('Evocation');
       Add('Illusion');
       Add('Necromancy');
       Add('Transmutation');
    End Else
    If Group = 'enchantment' Then With Selector Do Begin
       Add('Abjuration');
       Add('Conjuration');
       Add('Evocation');
       Add('Illusion');
       Add('Transmutation');
       Add('Divination, Necromancy');
    End Else
    If Group = 'evocation' Then With Selector Do Begin
       Add('Conjuration');
       Add('Abjuration, Enchantment');
       Add('Abjuration, Illusion');
       Add('Enchantment, Illusion');
       Add('Transmutation');
       Add('Abjuration, Divination, Necromancy');
       Add('Illusion, Divination, Necromancy');
       Add('Enchantment, Divination, Necromancy');
    End Else
    If Group = 'illusion' Then With Selector Do Begin
       Add('Abjuration');
       Add('Conjuration');
       Add('Enchantment');
       Add('Evocation');
       Add('Transmutation');
       Add('Divination, Necromancy');
    End else
    if Group = 'necromancy' Then With Selector Do Begin
       Add('Abjuration');
       Add('Conjuration');
       Add('Enchantment');
       Add('Evocation');
       Add('Illusion');
       Add('Divination');
       Add('Transmutation');
    End Else
    if Group = 'transmutation' Then With Selector Do Begin
       Add('Conjuration');
       Add('Evocation');
       Add('Abjuration, Enchantment');
       Add('Abjuration, Illusion');
       Add('Enchantment, Illusion');
       Add('Abjuration, Divination, Necromancy');
       Add('Illusion, Divination, Necromancy');
       Add('Enchantment, Divination, Necromancy');
    End Else showMessage('InitProhibited: Illegal Group ('+Group+')');
    Selector.EndUpdate;
  End;

end.
