unit DNDOutput;

interface

Uses Dialogs, Windows, SysUtils;

{ Interface to a customable character output thingy }

{ .rtf, .txt, .doc, directly to printer (canvas), etc etc }

Type TTextType = ( TeNormal, TeHeader, TeHLine, TeVLine );

Type TEntry = Class
 Text : String;
 Col, Row, Val, Page : integer;
 TextType : TTextType;
End;

Type TDNDOutput = Class
Private
  Entries  : Array of TEntry;
  LastPage : Integer;
Public
  Procedure PrintLn(Col,Row : Integer; Text : String; TextType : TTextType );
  Procedure Hline(Col,Col2,Row : Integer);
  Procedure Vline(Col,Row,Row2 : Integer);
  Procedure NextPage;
  Constructor Create;
  Destructor Destroy; Override;
  Procedure Generate; Virtual;
End;

Type TDNDTextOutput = Class(TDNDOutput)
Private
  Procedure Save(FileName : String);
Public
  Procedure Generate; Override;
End;


implementation

Uses FrmMain, ShellApi, DndCharacter;

 {***************************************************************************}

Procedure TDNDOutput.Hline(Col,Col2,Row : Integer);
Var Index : Integer;
Begin
 Index := Length(Entries);
 SetLength(entries,Index+1);
 Entries[Index] := TEntry.Create;
 Entries[Index].Col := Col;
 Entries[Index].Val := Col2;
 Entries[Index].Row := Row;
 Entries[Index].Text := '=';
 Entries[Index].TextType := TeHLINE;
 Entries[Index].Page := LastPage;
End;

Procedure TDNDOutput.Vline(Col,Row,Row2 : Integer);
Var Index : Integer;
Begin
 Index := Length(Entries);
 SetLength(entries,Index+1);
 Entries[Index] := TEntry.Create;
 Entries[Index].Col := Col;
 Entries[Index].Val := Row2;
 Entries[Index].Row := Row;
 Entries[Index].Text := '|';
 Entries[Index].TextType := TeVLINE;
 Entries[Index].Page := LastPage;
End;

Procedure TDNDOutput.PrintLn(Col,Row : Integer; Text : String; TextType : TTextType );
Var Index : Integer;
Begin
 Index := Length(Entries);
 SetLength(entries,Index+1);
 Entries[Index] := TEntry.Create;
 Entries[Index].Col := Col;
 Entries[Index].Row := Row;
 Entries[Index].Text := Text;
 Entries[Index].TextType := TextType;
 Entries[Index].Page := LastPage;
End;

Constructor TDNDOutput.Create;
Begin
 Inherited Create;
 SetLength(Entries,0);
 LastPage := 0;
End;

Destructor TDNDOutput.Destroy;
Var I : Integer;
Begin
 For I := 0 To Length(Entries)-1 Do Entries[I].Free;
 Inherited Destroy;
End;

Procedure TDNDOutput.Generate;
Begin
End;

Procedure TDNDOutput.NextPage;
Begin
 Inc(LastPage);
End;

 {***************************************************************************}
 {***************************************************************************}
 {***************************************************************************}

const TextLinesPerPage = 60;

function ExecuteFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..79] of Char;
begin
  Result := ShellExecute(Main.Handle, nil,
    StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
    StrPCopy(zDir, DefaultDir), ShowCmd);
end;


Procedure TDNDTextOutput.Save(FileName : String);
Var Text : Array[0..TextLinesPerPage] of String;
    Page : Integer;
    F : TextFile;
    I : Integer;
    J : Integer;
Begin
  AssignFile(F,FileName);
  Try
    Rewrite(F);
    For Page := 0 To LastPage Do Begin
      For I := 0 To TextLinesPerPage-1 Do Text[I] := '                                                                               ';
      For I := 0 To Length(Entries)-1 Do If Entries[I].Page = Page Then Begin
         Case Entries[I].TExtType of
            TeNormal : For J := 1 To Length(Entries[I].Text) Do Begin
                         If Entries[I].Row-1 > 59 Then ShowMessage('Out of range row '+Entries[I].text[J]+IntToStr(Entries[I].Row)+' '+IntToStr(Entries[I].Col));
                         If Entries[I].Col+J-1 > 79 Then ShowMessage('Out of range col '+Entries[I].text[J]);
                         Text[Entries[I].Row-1][Entries[I].Col+J-1] :=
                            Entries[I].text[J];
                       End;
            TeHLine  : For J := Entries[I].Col To Entries[I].Val Do Text[Entries[I].Row-1][J] := Entries[I].Text[1];
            TeVLine  : For J := Entries[I].Row To Entries[I].Val Do Text[J-1][Entries[I].Col] := Entries[I].Text[1];
         End;
      End;
      For I := 0 To TextLinesPerPage-1 Do
          WriteLn(F,Text[I]);
      If ( Page <> LAstPage ) Then
      Write(F,#12);
    End;

  Finally
    CloseFile(F);
    ExecuteFile(FileName,'','',SW_SHOW);
  End;
End;

Procedure TDNDTextOutput.Generate;
Var SaveDialog    : TSaveDialog;
Begin
 SaveDialog := TSaveDialog.Create(Main);
 Try
   SaveDialog.DefaultExt := 'txt';
   SaveDialog.InitialDir := ExtractFilePath(ParamStr(0))+'charactersheets';
   SaveDialog.Filter := 'Textfile(*.txt)|*.txt';
   If ( Main.Character.Name <> '' ) Then
   SaveDialog.FileName := Main.Character.Name+'.txt';
   If SaveDialog.Execute Then Begin
     Try
       Save(SaveDialog.Filename);
     Except
       MessageDlg('Unable to save '+SaveDialog.FileName, mtError, [mbOk],0);
     End;
   End;
 Finally
   SaveDialog.Free;
 End;
End;

 {***************************************************************************}
 {***************************************************************************}
 {***************************************************************************}

end.
