unit DNDItems;

interface

Uses DNDObjects, DNDStream, SysUtils;

Type TMoney = Class(TObject)
Public
  Platinum : Integer;
  Gold     : Integer;
  Silver   : Integer;
  Copper   : Integer;
  Procedure StreamWrite(Stream : TDNDStream);
  Procedure StreamRead(Stream : TDNDStream);
  Function CanPay(Price : TMoney) : Boolean;
  Function Pay(Var Price : TMoney ) : Boolean;
  Procedure Add(Price : TMoney );
  Function TotalCopper : Integer;
  Procedure Clear;
  Procedure Clone(Source : TMoney);
  Function GetAsText : String;
End;

Const ItWeapon                = 0;
      ItArmor                 = 1;
      ItAdventuringGear       = 2;
      ItClassTools            = 3;
      ItClothing              = 4;
      ItFoodDrinkLodging      = 5;
      ItMountsAndRelatedGear  = 6;
      ItAmmunition            = 7;
{      ItContainersAndCarriers = 7;}

Type TDNDItem = Class(TAffected)
Public
  Cost     : TMoney;
  Pounds   : Integer; { Weight }
  Kind     : Integer;
  Size     : Integer;
  WearLoc  : Integer;

  { Weapon Specific Abilities }
  WeaponProfNeeded     : String;
  WeaponFlags          : Integer;
  Att1DamageDice       : Integer;
  Att1DamageDiceSize   : Integer;
  Att1CritMultiplier   : Integer;
  Att2DamageDice       : Integer;
  Att2DamageDiceSize   : Integer;
  Att2CritMultiplier   : Integer;
  CriticalRange        : Integer;
  RangeIncrement       : Integer;

  { Armor Specific Abilities }
  ArmorFeatRequired    : String;
  AcBonus              : Integer;
  MaxDexBonus          : Integer;
  CheckPenalty         : Integer;
  ArcaneSpellFailure   : Integer;
  SpeedPenalty30       : Integer;
  SpeedPenalty20       : Integer;
  MaxCompositeBonus    : Integer;

  SpecialBonus         : Integer;
 {DONT FORGET TO ADD NEW PARAMETERS TO TDNDItem.Clone(Source : TDNDItem) }

  Procedure StreamWrite(Stream : TDNDStream); override;
  Procedure StreamRead(Stream : TDNDStream); override;
  Constructor Create; Override;
  Destructor  Destroy; Override;
  Procedure Clone(Source : TDNDItem);
  Function GetName : String; Override;
Published
  Property RealName : String read fName write FName;
End;

TItemList = Class (TDNDList)
Public
  function    GetItemx(Index: Integer): TDNDItem;
  procedure   SetItemx(Index: Integer; AObject: TDNDItem);
  property    Items[Index: Integer]: TDNDItem Read GetItemx Write SetItemx ; default;
  Procedure   StreamWrite(Stream : TDNDStream; StoreContent: Boolean);
  Procedure   StreamRead(Stream : TDNDStream; StoreContent: Boolean);
End;

implementation

Uses DNDWorld;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

Procedure TMoney.Add(Price : TMoney );
Begin
 Platinum := Platinum + Price.Platinum;
 Gold := Gold + Price.Gold;
 Silver := Silver + Price.Silver;
 Copper := Copper + Price.Copper;
End;

Function TMoney.GetAsText : String;
Begin
  Result := '';
  If Platinum > 0 Then Result := Result + ' ' +IntToStr(Platinum)+' pp ';
  If Gold > 0 Then Result := Result + ' '+IntToStr(Gold)+' gp ';
  If Silver > 0 Then Result := Result + ' '+IntToStr(Silver)+' sp ';
  If Copper > 0 Then Result := Result + ' '+IntToStr(copper)+' cp ';
End;

Procedure TMoney.Clone(Source : TMoney);
Begin
  Platinum := Source.Platinum;
  Gold     := Source.Gold;
  Silver   := Source.Silver;
  Copper   := Source.Copper;
End;

Procedure TMoney.StreamWrite(Stream : TDNDStream);
Begin
  Stream.WriteInteger(Platinum);
  Stream.WriteInteger(Gold);
  Stream.WriteInteger(Silver);
  Stream.WriteInteger(Copper);
End;

Procedure TMoney.StreamRead(Stream : TDNDStream);
Begin
 Platinum := Stream.ReadInteger;
 Gold     := Stream.ReadInteger;
 Silver   := Stream.ReadInteger;
 Copper   := Stream.ReadInteger;
End;

Function TMoney.TotalCopper : Integer;
Begin
 Result := Copper + Silver*10 + Gold*100 + Platinum*1000;
End;

Function TMoney.CanPay(Price : TMoney) : Boolean;
Begin
 Result := Price.TotalCopper <= TotalCopper;
End;

Procedure TMoney.Clear;
Begin
 Platinum := 0;
 Gold := 0;
 Silver := 0;
 Copper := 0;
End;

Function TMoney.Pay(Var Price : TMoney ) : Boolean;
Var Left : Integer;
Begin
 Result := CanPay(Price);
 If Result Then Begin
   Left := TotalCopper - Price.TotalCopper;
   Clear;
   While Left >= 1000 Do Begin Dec(Left,1000); Inc(Platinum); End;
   While Left >= 100 Do Begin Dec(Left,100); Inc(Gold); End;
   While Left >= 10 Do Begin Dec(Left,10); Inc(Silver); End;
   Copper := Left;
 End;
End;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

Procedure TDNDItem.StreamWrite(Stream : TDNDStream);
Begin
 Inherited;
 Cost.StreamWrite(Stream);
 Stream.WriteInteger(Kind);
 Stream.WriteInteger(WearLoc);
 Stream.WriteInteger(Pounds);
 Stream.WriteInteger(Size);
 Stream.WriteString(WeaponProfNeeded);
 Stream.WriteInteger(WeaponFlags);
 Stream.WriteInteger(Att1DamageDice);
 Stream.WriteInteger(Att1DamageDiceSize);
 Stream.WriteInteger(Att1CritMultiplier);
 Stream.WriteInteger(Att2DamageDice);
 Stream.WriteInteger(Att2DamageDiceSize);
 Stream.WriteInteger(Att2CritMultiplier);
 Stream.WriteInteger(CriticalRange);
 Stream.WriteInteger(RangeIncrement);

 Stream.WriteString(ArmorFeatRequired);
 Stream.WriteInteger(AcBonus);
 Stream.WriteInteger(MaxDexBonus);
 Stream.WriteInteger(CheckPenalty);
 Stream.WriteInteger(ArcaneSpellFailure);
 Stream.WriteInteger(SpeedPenalty30);
 Stream.WriteInteger(Speedpenalty20);
 Stream.WriteInteger(MaxCompositeBonus);
 Stream.WriteInteger(SpecialBonus);
End;

Procedure TDNDItem.StreamRead(Stream : TDNDStream);
Begin
 Inherited;
 Cost.StreamRead(Stream);
 Kind := Stream.ReadInteger;
 WearLoc := Stream.ReadInteger;
 Pounds := Stream.ReadInteger;
 Size := Stream.ReadInteger;
 WeaponProfNeeded := Stream.ReadString;
 WeaponFlags := Stream.ReadInteger;
 Att1DamageDice := Stream.ReadInteger;
 Att1DamageDiceSize := Stream.ReadInteger;
 Att1CritMultiplier := Stream.ReadInteger;
 Att2DamageDice := Stream.ReadInteger;
 Att2DamageDiceSize := Stream.ReadInteger;
 Att2CritMultiplier := Stream.ReadInteger;
 CriticalRange := Stream.ReadInteger;
 RangeIncrement := Stream.ReadInteger;

 ArmorFeatRequired := Stream.ReadString;
 AcBonus := Stream.ReadInteger;
 MaxDexBonus := Stream.ReadInteger;
 CheckPenalty := Stream.ReadInteger;
 ArcaneSpellFailure := Stream.ReadInteger;
 SpeedPenalty30 := Stream.Readinteger;
 SpeedPenalty20 := Stream.ReadInteger;
 MaxCompositeBonus := Stream.ReadInteger;
 SpecialBonus := Stream.ReadInteger;
End;

Constructor TDNDItem.Create;
Begin
 Inherited;
 Cost := TMoney.Create;
 MaxDexBonus := -1;
End;

Destructor TDNDItem.Destroy;
Begin
 Cost.Free;
 Inherited;
End;

 Function TDNDItem.GetName : String;
{ Var Price : String;}
 Begin
{ Price := Cost.GetAsText;
  If Price <> '' Then Price := ' ('+Price+')';}
  Result := fName {+ Price};
 End;

 Procedure TDNDItem.Clone(Source : TDNDItem);
 Begin
  Clear; Add(Source);
  fName := Source.fname;
  fDescription := Source.Description;
  Kind := Source.Kind;
  WearLoc := Source.WearLoc;
  Pounds := Source.Pounds;
  Size := Source.Size;
  Cost.Clone(Source.Cost);
  WeaponProfNeeded := Source.WeaponProfNeeded;
  WeaponFlags := Source.WeaponFlags;
  Att1DamageDice := Source.Att1DamageDice;
  Att1DamageDiceSize :=  Source.Att1DamageDiceSize;
  Att1CritMultiplier := Source.Att1CritMultiplier;
  Att2DamageDice := Source.Att2DamageDice;
  Att2DamageDiceSize := Source.Att2DamageDiceSize;
  Att2CritMultiplier := Source.Att2CritMultiplier;
  CriticalRange := Source.CriticalRange;
  RangeIncrement := Source.RangeIncrement;

   ArmorFeatRequired := Source.ArmorFeatRequired;
   AcBonus := Source.AcBonus;
   MaxDexBonus := Source.MaxDexBonus;
   CheckPenalty := Source.CheckPEnalty;
   ArcaneSpellFailure := Source.ArcaneSpellFailure;
   SpeedPenalty30 := Source.SpeedPenalty30;
   SpeedPenalty20 := Source.SpeedPenalty20;
   MaxCompositeBonus := Source.MaxCompositeBonus;
   SpecialBonus := Source.SpecialBonus;
 End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Procedure TItemList.StreamWrite(Stream : TDNDStream; StoreContent: Boolean);
  Var I : Integer;
  Begin
{   Inherited;}
    Stream.WriteInteger(Count);
    For I := 0 To Count-1 Do Begin
      Stream.WriteString(Items[I].Name);
      Items[I].StreamWrite(Stream);
    End;
  End;

  Procedure TItemList.StreamRead(Stream : TDNDStream; StoreContent: Boolean);
  Var I, Max : Integer;
      Item : TDNDItem;
      Name : String;
  Begin
{    Inherited;}
    Max := Stream.ReadInteger;
    Clear;
    For I := 0 To Max-1 Do Begin
      Name := Stream.ReadString;
      Item := TDNDItem.Create;
      Item.name := name;
      Item.StreamRead(Stream);
      Add(Item);
    End;
  End;

  Procedure TItemList.SetItemx(Index: Integer; AObject: TDNDItem);
  Begin
    SetItem(index,AObject);
  End;

  Function TItemList.GetItemx(Index: Integer): TDNDItem;
  Begin
   Result := TDNDItem(GetItem(Index));
  End;



end.
