unit DNDHistory;

interface


Type THistory = class(TObject)
Private
  fName   : String;
  fNames  : String;
  fHe     : String;
  fHis    : String;
  fHim    : String;
  fMother : Boolean;
  fFather : Boolean;
  fEvil   : Boolean;
  Function Birth : String;
  Function Raised : String;
  Function TraumaticEvent : String;
  Function Maturity : String;
  Function CloseFriend : String;
Public
  Function RandomNAme : String;
  Function RandomRace : String;
  Function RandomSkill : String;
  Function RandomJobPerson : String;
  Function RandomLocale : String;
  Function RandomAttitude : String;
  Function Generate : String;
  Function Region : String;
  Constructor Create(Name, He, His, Him : String; Evil : Boolean);
End;


implementation

Uses DNDWorld, FrmMain;

Constructor THistory.Create(Name, He, His, Him : String; Evil : Boolean);
Begin
 Inherited Create;
 fMother := True;
 fFather := True;
 fName  := Name;
 fNames := Name+'''s';
 fHe    := He;
 fHis   := His;
 fHim   := Him;
 fEvil  := Evil;
End;

Function THistory.Birth : String;
Begin
 Case Random(100) of
  00..10  : Result := fNames+ ' cannot remember being told any details about '+fHis+' birth.';
  11..30  : Begin
               Result := fNames+ ' mother died during '+fhis+' birth.';
              if ( Random(10) = 1 ) Then Result := Result + ' '+fNames+ ' father always blamed '+fHim+' for '+fHis+' mothers death.';
              fMother := FAlse;
            End;
  31..34   : Begin
              Result := fNames+ ' father died protecting '+fNames+' mother during birth.';
              if ( Random(10) = 1 ) Then Result := Result + ' '+fNames+ ' mother always blamed '+fHim+' for '+fHis+' fathers death.';
              fFather := FAlse;
            End;
      46  : Result := fNames+' was born during an exclipse.';
  47..48  : Result := fNames+' was born during a fierce battle.';
  49..54  : Result := fNames+' birth was shadowed by the fact '+fhis+' mother didn''t remember conception.';
  55..63  : Result := fNames+' birth had complications, which almost killed '+fHis+' mother.';
  64..65  : Result := fNames+' was born with a sign.';
  66..69  : Result := fNames+' was gifted to '+fHis+' parents by faeries.';
  70..79  : Result := fNames+' was delivered into this world by druids.';
  80..89  : Result := fNames+' was born during great famine.';
  90..95  : Result := fNames+' was born during [a big war].';
  96..100 : Result := fNames+' was born during [a rare celestial event].';
  Else Result := fNames+' birth was uneventfull.';
 End;
End;

Function THistory.CloseFriend : String;
Begin
 Result := fNames+ ' closest friend is ';
 Case Random(100) of
   0..25 : Result := Result+'a female '+RandomRace+' named '+RandomName+'.';
  26..50 : Result := Result+'a male '+RandomRace+' named '+RandomName+'.';
      51 : Result := Result+'a goat named '+RandomName+'.';
      52 : Result := Result+'an extradimensional chinchilla with choochoo powers.';
  53..58 : Result := Result+'an extraplanar creature called '+RandomName+'.';
      59 : Result := Result+'a pixie called '+RandomName+'.';
      60..75 : Result := fName+' has a large number of close friends.';
      76..85 : Result := fName+' has some friends, none close.';
   Else Result := fName+' has no close friends.';
 End;
End;

Function THistory.Region : String;
Begin
 Result := RandomLocale;
End;

Function THistory.Raised : String;
Var II, City : String;
    GotFamily : Boolean;
Begin
 GotFamily := False;


 Case Random(5) of
    0    : II := 'mentored';
    1..4 : II := 'raised';
 End;

 If Random(3)=0 Then if ( fEvil ) and (Random(10)<>0) Then Begin
   City := 'hatefully '+II;
 End Else Begin
   City := 'lovingly '+II;
 End;

 Case Random(100) of
   00..10 : City := 'in a small hamlet';
   11..12 : City := 'deep in a forest';
   13..16 : City := 'on the streets';
   17..20 : City := 'in a tribal community';
   21..25 : City := 'in a pacifistic community';
   26..28 : City := 'in a dwarven city';
   30     : City := 'in a castle';
   31     : City := 'on a boat';
   32     : City := 'on a harbour';
   33     : City := 'on a small isle';
   34     : City := 'on frozen planes';
   35     : City := 'in a hamstercage';
   36     : City := 'in a clerigy';
   37     : City := 'in a church';
   38     : City := 'in a monistary';
   39     : City := 'in a wizardstower';
   82..84 : City := 'in a frontier town';
   85..88 : City := 'in a fortress';
       89 : City := 'on the ethereal plane';
   90..99 : City := 'in a citadel';
   Else City := 'in a town called [townname]';
 End;

 if (( fEvil ) and (Random(50)=1)) or
    (Random(500)=1)  Then
   city := city + ' deep underground';

 if (Random(2)=1)  Then Begin
   Case Random(7) of
     0 : city := city + ' not far from a forbidden forest';
     1 : city := city + ' not far from a hostile race';
     2 : city := city + ' not far from a mysterious structure';
     3 : city := city + ' not far from a grand city';
     4 : city := city + ' which fell under constant attack';
     5 : city := city + ' far from other civilisations';
     6 : city := city + ' infused with magical energies';
   End;
 End;

 Case Random(100) of
      00  : Result := fHe+' was '+II+' by a goat named '+RandomName+' '+City+'.';
      01  : Result := fHe+' was '+II+' by a hamster named '+RandomName+' '+City+'.';
      66  : Result := fHe+' was '+II+' by a pixie named '+RandomName+' '+City+'.';
      67  : Result := fHe+' was '+II+' by a hill giant named '+RandomName+' '+City+'.';
      68  : Begin
              GotFamily := True;
              Result := fHe+' was '+II+' by a clan of roaming barbarians.';
            End;
      69  : Begin
              GotFamily := True;
              Result := fHe+' was '+II+' by a clan of barbarians.';
            End;
  70..72  : Result := fHe+' was '+II+' by a extraplanar creature called '+RandomName+'.';
  73..74  : Result := fHe+' was '+II+' by a demon called '+RandomName+'.';
  78..79  : Result := fHe+' was '+II+' by '+fhis+' sister named '+RandomName+' '+City+'.';
  80..92  : Result := fHe+' was '+II+' by '+fhis+' brother named '+RandomName+' '+City+'.';
  93..94  : Result := fHe+' was '+II+' by a wild animal '+City+'.';
  95..96  : Begin
               GotFamily := True;
               Result := fHe+' was adopted by a family '+City+'.';
            End;
  97..98  : Result := fHe+' was '+II+' by a highly respected person '+City+'.';
      99  : Result := fHe+' was '+II+' by a deity '+City+'.';
  Else Begin
    GotFamily := True;
    if fMother and fFather Then
     Result := fHe+' was '+II+' by '+fHis+' parents '+City+'.'
    Else If fMother Then
     Result := fHe+' was '+II+' by '+fHis+' mother '+City+'.'
    Else If fFather Then
     Result := fHe+' was '+II+' by '+fHis+' father '+City+'.'
    Else GotFamily := False;
  End;
 End;

 if GotFamily Then Begin
    Result := Result+' '+FNames+' family is ' ;
    Case Random(100) of
      00..05 : Result := Result + 'broke, ';
      06..25 : Result := Result + 'poor, ';
      50..72 : Result := Result + 'middleclass, ';
      73..92 : Result := Result + 'noble, ';
      93..99 : Result := Result + 'noble, rich beyond belief, ';
    End;

    Case Random(100) of
      00..05 : Result := Result + 'defensively powerless, ';
      06..25 : Result := Result + 'defensively weak, ';
      73..92 : Result := Result + 'defensively powerfull, ';
      93..99 : Result := Result + 'defensively mighty, ';
    End;

    Case Random(100) of
      93..99 : Result := Result + 'highly religious, ';
    End;

    Case Random(100) of
      00..05 : Result := Result + 'in constant combat with itself, ';
      06..25 : Result := Result + 'torn by internal squabbles, ';
      26..50 : Result := Result + 'ruled by the elders, ';
      51..72 : Result := Result + 'ruled by a single familymember, ';
      73..99 : Result := Result + 'focused in its intent, ';
    End;

    Case Random(100) of
          00 : Result := Result + 'and deemed irrelevant by the community.';
      01..05 : Result := Result + 'and hunted by the community.';
      06..25 : Result := Result + 'and disrespected by the community.';
      26..40 : Result := Result + 'and unnoticed by the community.';
      73..92 : Result := Result + 'and respected by the community.';
      93..99 : Result := Result + 'and held in high regard by the community.';
      Else Result := Result + 'and known by the community.';
    End;
 End;
End;

Function THistory.TraumaticEvent : String;
Begin
 Case Random(100) of
   00     : ;
   01..10 : Begin
               Result := 'In '+fhis+' childhood, '+fName+' loved to explore '+fHis+' home and its surroundings.';
            End;

   11..20 : Result := 'In '+fhis+' childhood, '+fName+' witnessed the horrors of war up close.';
   21..30 : Result := 'In '+fhis+' childhood, '+fName+' met the love of '+fhis+' live.';
   31..40 : Result := 'In '+fhis+' childhood, '+fName+' released an animal from a snare and befriended it.';
   41..42 : Result := 'In '+fhis+' childhood, '+fName+' saved a magical beast named '+RandomName+' and became befriended with it.';
   43..50 : Result := 'In '+fhis+' childhood, '+fName+' was praised for '+fHis+' skill at '+RandomSkill+', which caused '+fHim+' to be both admired and hated.';
   51..55 : Result := 'In '+fhis+' childhood, '+fName+' was bullied a lot.';
   56..60 : Result := 'In '+fhis+' childhood, '+fName+' had trouble reading and writing.';
   61..70 : Result := 'In '+fhis+' childhood, '+fName+' was abducted by a band of [nasty critters] and later rescued by [rescuer].';
   71..72 : Result := 'In '+fhis+' childhood, '+fName+' was caught stealing and was punished severly.';
   73..76 : Result := 'In '+fhis+' childhood, '+fName+' had trouble making friends.';
   77     : Result := 'In '+fhis+' childhood, '+fName+' made a lot of friends.';
   Else Result := fName+' had a worryless childhood.';
 End;

 if ( Random(3)=1 ) Then Begin
   Case Random(17) of
     00 : Result := Result + ' During this time, '+fname+' discovered the delights of playing music.';
     01 : Result := Result + ' During this time, '+fname+' discovered the delights of music.';
     02 : Result := Result + ' During this time, '+fnames+' destiny was influenced by an unknown entity.';
     03 : Result := Result + ' During this time, '+fnames+' lost '+fHis+' best friend.';
     04 : Result := Result + ' During this time, '+fnames+' discovered '+fHis+' bad attitude and corrected it '+fHim+'self.';
     05..15 : Result := Result + ' During this time, '+fnames+' '+RandomAttitude+' attitude surfaced, and influenced the way people looked at '+fHim+'.';
     16 : Result := Result + ' During this time, '+fnames+' saved a younger child from death, and tasted '+fhis+' first days of being a hero.';
   End;
 End;

End;

Function Thistory.Maturity : String;
Begin
 Case Random(100) of
      0 : Result := fName + ' left '+fHis+' life behind to learn a trade.';
      1 : Result := fName + ' met and married '+fHis+' love.';
      2 : Result := fName + ' left '+fHis+' life behind to live in solitude.';
      3 : Result := fName + ' fought in a grand and terrible war.';
      4 : Result := 'At a mature age, '+fName + ' set out to explore the world.';
      5 : Result := 'At a mature age, '+fName + ' joined a band of merchants to gain some money.';
      6 : Result := 'At a mature age, '+fName + ' had to run from the law.';
      7 : Result := fName + ' left '+fHis+' life behind to become a [class].';
      8 : Result := fName + ' left '+fHis+' life behind to live with '+fHis+' love.';
      9 : Result := fName + ' took a large trip, making her aware of the areas afar.';
 10..25 : Begin
            Result := fName + ' became an apprentice of '+RandomJobPerson+',';
            Case Random(100) of
               0     : Result := Result+' where '+fhe+' was used for horrible experiments.';
               1..10 : Result := Result+' where '+fhe+' learned the value of life.';
              11..20 : Result := Result+' where '+fhe+' first encountered '+RandomRace+'.';
              21..50 : Result := Result+' where '+fhis+' passion for adventuring was set aflame.';
              51..60 : Result := Result+' who learned '+fHim+' the virtues of [deity]';
              61..80 : Result := Result+' who abused '+fHim+' for lowly tasks.';
               Else Result := Result+'who teached '+fHim+' all the basics.';
            End;
          End;
 26..51 : Begin
               Case Random(10) of
                  0 : Result := 'At a mature age, '+fHe+' and a close friend set out on adventure.';
                  1 : Result := 'At a mature age, '+fHe+' and a family member set out on adventure.';
                  2 : Result := 'At a mature age, '+fHe+' and '+fHis+' mentor set out on adventure.';
                  3 : Result := 'At a mature age, '+fHe+' was send out on adventure.';
                  Else Result := 'At a mature age, ' + fHe + ' set out on adventure.';
               ENd;
               Case Random(5) of
                  0 : Result := 'During '+fHis+' travels '+fName+' saved a [person], who became '+fHis+' close friend.';
                  1 : Result := 'During '+fHis+' travels '+fName+' made a lifelong enemy.';
                  2 : Result := 'During '+fHis+' travels '+fName+' encountered and helped [a community].';
                  3 : Result := 'During '+fHis+' travels '+fName+' fought in [a war].';
                  4 : Result := 'During '+fHis+' travels '+fName+' fought in name of a [deity/king].';
               ENd;
          End;
 52..70 : Begin
           Result := fName + ' applied to ';
            Case Random(8) of
              0 : Result := Result + 'a guild of fighters';
              1 : Result := Result + 'the [king''s] army';
              2 : Result := Result + 'a guild of spellcasters';
              3 : Result := Result + 'a craftguild';
              4 : Result := Result + 'a guild of thieves';
              5 : Result := Result + 'a band of adventurers';
              6 : Result := Result + 'a band of thieves';
              7 : Result := Result + 'a syndicate of merchants';
            End;
            Case Random(23) of
              0      : Result := Result + ' and was accepted as a member.';
              1..5   : Result := Result + ' and was accepted in its ranks as a pupil.';
              6..8   : Result := Result + ' and was accepted as an apprentice.';
              9      : Result := Result + ' but was rejected on account of his personality.';
              10     : Result := Result + ' and was accepted as a member, but left after a conflict with one of the other members.';
              11     : Result := Result + ' and was accepted as a member, but was casted out after (unknowingly) insulting a high ranking member.';
              12     : Result := Result + ' and was accepted as a member, but was casted out after insulting a high ranking member.';
              13     : Result := Result + ' and was accepted as a member, but was casted out after attacking a high ranking member.';
              14     : Result := Result + ' but was rejected.';
              15     : Result := Result + ' but failed the initiation ritual.';
              16..22 : Result := Result + ' and performed above average in '+fhis+' initiation ritual.';
            End;
          End;
     71 : Result := fName + ' took a large trip.';
     72 : Result := fName + ' was abducted by an unknown entity.';
     73 : Result := fName + ' was held and tortured for many months.';
     75 : Result := fName + ' discovered a dark secret.';
     76 : Result := fName + ' was summoned by a wizard to fight for him.';
   Else Result := '';
 End;
End;

Function THistory.Generate : String;
Begin
 Result := Birth + ' ' +RandomLocale+' '+Raised + ' ' + TraumaticEvent + ' ' + Maturity + ' ' + CloseFriend;
End;

Function THistory.RandomLocale : String;
Begin
 Result := fname + ' grew up ';
 Case Random(17) of
    0 : Result := Result+'in a swampy area';
    1 : Result := Result+'on temperate grasslands';
    2 : Result := Result+'on beautifull grasslands';
    3 : Result := Result+'in a desert';
    4 : Result := Result+'in a tundric area';
  5,15..16 : Result := Result+'in a forested area';
    6 : Result := Result+'in a large jungle';
    7 : Result := Result+'in a hilly region';
    8 : Result := Result+'in a mountainous region';
    9 : Result := Result+'near a lake';
   10 : Result := Result+'near the coast';
   11 : Result := Result+'near the sea';
   12 : Result := Result+'near the ocean';
   13 : Result := Result+'on arctic hills';
   14 : Result := Result+'in a large tropical jungle';
 End;
 Result := Result+'.';
End;

Function THistory.RandomNAme : String;
begin
 Main.GenerateName;
 Result := Main.NewName;
End;

Function THistory.RandomRace : String;
Begin
 if ( World.Races.Count < 1 ) Then Begin
   Result := '[Race]';
   Exit;
 End;
 Result := World.Races[Random(World.Races.Count-1)].Name;
End;

Function THistory.RandomSkill : String;
Begin
 if ( World.Skills.Count < 1 ) Then Begin
   Result := '[Skill]';
   Exit;
 End;
 Result := World.Skills[Random(World.Skills.Count-1)].Name;
End;


Function THistory.RandomJobPerson : String;
Begin
 Case Random(25) of
     0..2  : Result := 'an insane mage';
     3..5  : Result := 'a cobbler';
     6..8  : Result := 'a hunter';
     9..11 : Result := 'a scolar';
    12..14 : Result := 'a respected warrior';
    15..16 : Result := 'a thief';
    17..18 : Result := 'a monk';
        19 : Result := 'anime specialist Edwin Koster';
        20 : Result := 'super-american Megan Jensen';
        21 : Result := 'Skinner of beasts and monsters Ruben Fuit';
        22 : Result := 'girl-expert sorcerer Niels Fuit';
        23 : Result := 'evil-sandmaster-sage Gerard Pel';
        24 : Result := 'bouncy Daan van Yperen';
 End;
End;

Function THistory.RandomAttitude : String;
Begin
 Case Random(26) of
  0     : Result := 'hatefull';
  1     : Result := 'vengefull';
  2     : Result := 'stubborn';
  3     : Result := 'explosive';
  4     : Result := 'careless';
  5     : Result := 'tempramental';
  6     : Result := 'vane';
  7     : Result := 'apathic';
  8     : Result := 'satanic';
  9     : Result := 'fearfull';
 10..11 : Result := 'loving';
 12..13 : Result := 'caring';
 14..15 : Result := 'fun';
 16..17 : Result := 'angelic';
 18..19 : Result := 'amusing';
 20..21 : Result := 'noble';
 22..23 : Result := 'friendly';
 24..25 : Result := 'forgiving';
 End;
End;


end.
