unit DNDClasses;

interface

Uses contnrs, Dialogs, SysUtils, DNDObjects, Classes, DNDStream;

Type
 TClassList = Class;

TRaceAbility = Class (TDNDObject)
End;

TRaceAbilityList = Class (TDNDList)
  function    GetRaceAbility(Index: Integer): TRaceAbility;
  procedure   SetRaceAbility(Index: Integer; AObject: TRaceAbility);
  property    Items[Index: Integer]: TRaceAbility Read GetRaceAbility Write SetRaceAbility; default;
  Procedure   StreamWrite(Stream : TDNDStream);
  Procedure   StreamRead(Stream : TDNDStream);
End;

TClassAbility = Class (TDNDObject)
  OverrideID : Integer; // If !=0, It tries to match other Abilities with this OverrideID. If Higher level it overrides them.
  Choose     : Boolean; // if set, can be chosen for ability points at this level
  Procedure   StreamWrite(Stream : TDNDStream); Override;
  Procedure   StreamRead(Stream : TDNDStream); Override;
End;

TClassAbilityList = Class (TDNDList)
  function    GetClassAbility(Index: Integer): TClassAbility;
  procedure   SetClassAbility(Index: Integer; AObject: TClassAbility);
  property    Items[Index: Integer]: TClassAbility Read GetClassAbility Write SetClassAbility; default;
  Procedure   StreamWrite(Stream : TDNDStream);
  Procedure   StreamRead(Stream : TDNDStream);
End;


TLevel = Class(TAffected)
  ClassAbilities : TClassAbilityList;
  // A Single character level. Contains changes FOR THAT LEVEL ONLY!
  // So you get:
  // Level 1:   +1 Feat
  // Level 2:   +0 Feat
  // Level 3:   +0 Feat
  // Level 4:   +1 Feat
  Constructor Create; Override;
  Destructor Destroy; Override;
  Procedure   StreamWrite(Stream : TDNDStream); Override;
  Procedure   StreamRead(Stream : TDNDStream); Override;
End;

TBaseClass = Class (TAffected)
 // This DISCRIBES A class, nothing more.
Public
  CrossClassSkills      : TBaseSkillList;
  MainSkills            : TBaseSkillList;
  Level                 : Array[1..MAX_LEVELS] of TLevel;
  CastStat              : Integer; // Stat used for casting: 0=STR,1=DEX,2=CON,3=INT,4=WIS,5=CHA
  IllegalAlignment      : Integer; // Bit Vector 0= Lawful Good, 2=Chaotic Good, 3 Lawful Neutral, etc.
  CanSpecialize         : Boolean;
  CanSelectDomains      : Boolean;
  AddChaToSaves         : Boolean;
  AddWisToAc            : Boolean;
  BonusSpell            : Boolean;
  HPPerLevel            : Integer; // 1Dx, Where HPPerLevel = X
  Domains               : String;
  MoneyDice             : Integer;
  MoneyDiceSize         : Integer;
  MoneyMultiplier       : Integer;
  MonkUnarmedAttacks    : Integer;
  MonkSpeed             : Integer;
  AutoHasAllClassSpells : Integer;
  MaxLevel              : Integer;
  SpellsDivine          : Boolean;

  PrestigeCastLevel     : Integer;
  PrestigeDivine        : Boolean;
  PrestigeRaces         : String;
  PrestigeScript        : TStringList;

  Constructor Create; Override;
  Destructor  Destroy; Override;
  Procedure Clear; Override;
  Procedure   StreamWrite(Stream : TDNDStream); Override;
  Procedure   StreamRead(Stream : TDNDStream); Override;
End;

TTrainedClass = Class (TAffected)
 // This points to a base class, and keeps a record of skillspoints + hitpoints
 // gained by this player at this level.
Protected
 Function GetName : String; Override;
 Function GetValue : Real; Override;
 Procedure SetValue(NewValue : Real); Override;
 Procedure SetLEvel(NewLevel : Integer);
Public
 BaseClass            : TBaseClass;
 List                 : TClassList;
 fLevel               : Integer;
 LearnedSkills        : TSkillList;
 LearnedSpells        : TDNDList;
 LearnedBonusFeats    : TFeatList;
 ChosenClassAbilities : TClassAbilityList;
 FreeClassAbilities   : TClassAbilityList;
 SelectableClassAbilities   : TClassAbilityList;
 HPLevel              : array[1..MAX_LEVELS] of Integer; // Actual Rolls for hitpoints of this Character.
 LeansOnClass         : String;
 Constructor Create(fClass : TBaseClass; fList : TClassList); Reintroduce;
 Destructor Destroy; Override;
 Procedure  AddTo(Target : TAffected);
 Function IsCrossClass(Skill : TBaseSkill) : Boolean;
 Function IsBanned    (Skill : TBaseSkill) : Boolean;
 Property Level : Integer Read fLevel Write SetLevel;
 Procedure   StreamWrite(Stream : TDNDStream); Override;
 Procedure   StreamRead(Stream : TDNDStream); Override;
 Function HighestCastLevel : Integer;
End;

TBaseDeity = Class (TAffected)
End;

TClassList = Class (TDNDList)
Private
  Procedure Changed;
Public
  OnChange  : TOnChange;
  Procedure   Clear; Override;
  function    GetClass(Index: Integer): TTrainedClass;
  procedure   SetClass(Index: Integer; AObject: TTrainedClass);
  property    Items[Index: Integer]: TTrainedClass Read GetClass Write SetClass ; default;
  Function    HasBaseClass(HasClass : TBaseclass) : TTrainedClass;
  Procedure   AddTo(Target : TAffected);
  Constructor Create;
  Procedure   ToStrings(Strings : TStrings);
  Procedure   StreamWrite(Stream : TDNDStream);
  Procedure   StreamRead(Stream : TDNDStream);
  Function    NamesCombined : String;
End;

TBaseClassList = Class (TDNDList)
Public
  function    GetClass(Index: Integer): TBaseClass;
  procedure   SetClass(Index: Integer; AObject: TBaseClass);
  property    Items[Index: Integer]: TBaseClass Read GetClass Write SetClass ; default;
  Procedure   StreamWrite(Stream : TDNDStream; StoreContent : Boolean);
  Procedure   StreamRead(Stream : TDNDStream; StoreContent : Boolean);
End;

TBaseRace = Class(Taffected)
  FavoredClass  : String;
  Size          : Integer; // {  Fine  Diminutive  Tiny  Small  Medium-size  Large  Huge  Gargantuan  Colossal}
  RaceAbilities : TRaceAbilityList;
  Flags         : Integer; { Bit 0 : +1 skillpoint per level }
  LevelCost     : Integer;
  Procedure   StreamWrite(Stream : TDNDStream); Override;
  Procedure   StreamRead(Stream : TDNDStream); Override;
  Constructor Create; Override;
  Destructor Destroy; Override;
End;

TBaseRaceList = Class (TDNDList)
Public
  function    GetRace(Index: Integer): TBaseRace;
  procedure   SetRace(Index: Integer; AObject: TBaseRace);
  property    Items[Index: Integer]: TBaseRace Read GetRace Write SetRace ; default;
  Procedure   StreamWrite(Stream : TDNDStream; StoreContent : Boolean);
  Procedure   StreamRead(Stream : TDNDStream; StoreContent : Boolean);
End;


implementation

Uses DNDSpells, DNDWorld, DNDCharacter, Frmmain;
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Function TTrainedClass.HighestCastLevel : Integer;
  Var I :Integer;
  Begin
   Result := -1;
   For I := 9 DownTo 0 Do Begin
     If Points.Arcane[I] > -1 Then Begin Result := I; Break; End;
   End;
  End;

  Procedure TClassAbility.StreamWrite(Stream : TDNDStream);
  Begin
     Inherited;
     Stream.WriteInteger(OverrideID);
     Stream.WriteBoolean(Choose);
  End;

  Procedure TClassAbility.StreamRead(Stream : TDNDStream);
  Begin
     Inherited;
     OverrideID := Stream.ReadInteger;
     Choose := Stream.ReadBoolean;
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Constructor TLevel.Create;
  Begin
   Inherited;
   ClassAbilities := TClassAbilityList.Create;
  End;

  Destructor TLevel.Destroy;
  Begin
   ClassAbilities.Free;
   Inherited;
  End;

  Procedure TLevel.StreamWrite(Stream : TDNDStream);
  Begin
    Inherited;
    ClassAbilities.StreamWrite(Stream);
  End;

  Procedure TLevel.StreamRead(Stream : TDNDStream);
  Begin
    Inherited;
    ClassAbilities.StreamRead(Stream);
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  function   TRaceAbilityList.GetRaceAbility(Index: Integer): TRaceAbility;
  Begin
    Result := TRaceability(GetObject(Index));
  End;

  procedure  TRaceAbilityList.SetRaceAbility(Index: Integer; AObject: TRaceAbility);
  Begin
    SetObject(index,AObject);
  End;

  Procedure TRaceAbilityList.StreamWrite(Stream : TDNDStream);
  Var I : Integer;
  Begin
   Stream.writeInteger(Count);
   For I := 0 To Count-1 Do
     Items[I].StreamWrite(Stream);
  End;

  Procedure TRaceAbilityList.StreamRead(Stream : TDNDStream);
  Var I , Max : Integer;
      RA : TRAceAbility;
  Begin
   Max := Stream.readInteger;
   For I := 0 To Max-1 Do Begin
     RA := TRaceAbility.Create;
     RA.StreamRead(Stream);
     Add(Ra);
   End;
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  function   TClassAbilityList.GetClassAbility(Index: Integer): TClassAbility;
  Begin
    Result := TClassability(GetObject(Index));
  End;

  procedure  TClassAbilityList.SetClassAbility(Index: Integer; AObject: TClassAbility);
  Begin
    SetObject(index,AObject);
  End;

  Procedure TClassAbilityList.StreamWrite(Stream : TDNDStream);
  Var I : Integer;
  Begin
   Stream.writeInteger(Count);
   For I := 0 To Count-1 Do
     Items[I].StreamWrite(Stream);
  End;

  Procedure TClassAbilityList.StreamRead(Stream : TDNDStream);
  Var I , Max : Integer;
      CA : TClassAbility;
  Begin
   Max := Stream.readInteger;
   For I := 0 To Max-1 Do Begin
     CA := TClassAbility.Create;
     CA.StreamRead(Stream);
     Add(CA);
   End;
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

Procedure TBaseClass.StreamWrite(Stream : TDNDStream);
Var I :  Integer;
Begin
 Inherited;
 CrossClassSkills.StreamWrite(Stream,False);
 MainSkills.StreamWrite(Stream,False);
 Stream.WriteInteger(MAX_LEVELS);
 For I := 1 To MAX_LEVELS Do
    Level[I].StreamWrite(Stream);
 Stream.WriteInteger(IllegalAlignment);
 Stream.WriteBoolean(CanSpecialize);
 Stream.WriteBoolean(CanSelectDomains);
 Stream.WriteInteger(HPPerLevel);
 Stream.WriteInteger(CastStat);
 Stream.WriteBoolean(AddChaToSaves);
 Stream.WriteBoolean(AddWisToAc);
 Stream.WriteBoolean(BonusSpell);
 Stream.WriteInteger(MoneyDice);
 Stream.WriteInteger(MoneyDiceSize);
 Stream.WriteInteger(MoneyMultiplier);
 Stream.WriteInteger(MonkUnarmedAttacks);
 Stream.WriteInteger(MonkSpeed);
 Stream.WriteInteger(AutoHasAllClassSpells);
 Stream.WriteInteger(MaxLevel);
 Stream.WriteBoolean(SpellsDivine);

 Stream.WriteInteger(PrestigeCastLevel);
 Stream.WriteBoolean(PrestigeDivine);
 Stream.WriteString(PrestigeRaces);
 Stream.WriteInteger(PrestigeScript.Count);
 For I := 0 To PrestigeScript.Count-1 Do
   Stream.WriteString(PrestigeScript[I]);
End;

Procedure TBaseClass.StreamRead(Stream : TDNDStream);
Var I,Max : Integer;
Begin
 Inherited;
 CrossClassSkills.StreamRead(Stream,False);
 MainSkills.StreamRead(Stream,False);
 Max := Stream.REadInteger;
 For I := 1 To Max Do
    Level[I].StreamRead(Stream);
 IllegalAlignment := Stream.ReadInteger;
 CanSpecialize := Stream.ReadBoolean;
 CanSelectDomains := Stream.ReadBoolean;
 HPPerLevel := Stream.ReadInteger;
 CastStat := Stream.ReadInteger;
 AddChaToSaves := Stream.ReadBoolean;
 AddWisToAC    := Stream.ReadBoolean;
 BonusSpell    := Stream.ReadBoolean;
 MoneyDice     := Stream.ReadInteger;
 MoneyDiceSize := Stream.ReadInteger;
 MoneyMultiplier := Stream.ReadInteger;
 MonkUnarmedAttacks := Stream.ReadInteger;
 MonkSpeed := Stream.ReadInteger;
 AutoHasAllClassSpells := Stream.ReadInteger;
 MaxLevel := Stream.ReadInteger;
 SpellsDivine := Stream.ReadBoolean;

 PrestigeCastLevel := Stream.ReadInteger;
 PrestigeDivine := Stream.ReadBoolean;
 PrestigeRaces := Stream.ReadString;

 PrestigeScript.Clear;
 Max := Stream.ReadInteger;
 For I := 0 To Max-1 Do
   PrestigeScript.Add(Stream.ReadString);

End;

Constructor TBaseClass.Create;
var I : Integer;
Begin
 CrossClassSkills := TBaseSkillList.Create;
 MainSkills := TBaseSkillList.Create;
 For I := 1 To MAX_LEVELS Do Level[i] := TLevel.Create;
 For I := 0 TO MAX_ATTACKS-1 Do Begin
  Level[1].Points.ToHit[I] := -1;
  Level[1].Points.ToHit[I] := -1;
  Level[1].Points.BareHandToHit[I] := -1;
 End;
 For I := 0 TO 9 Do Begin
  Level[1].Points.Arcane[I] := -1;
  Level[1].Points.Divine[I] := -1;
  Level[1].Points.Known[I] := -1;
 End;
 PrestigeScript := TStringList.Create;
 Inherited;
End;

Procedure TBaseClass.Clear;
Var I : Integer;
Begin
 For I := 0 To MAX_LEVELS-1 Do Level[I].Clear;
 AddChaToSaves := False;
 AddWisToAC    := False;
 BonusSpell    := False;
End;

Destructor  TBaseClass.Destroy;
Var I : Integer;
Begin
 PrestigeScript.Free;
 For I := 0 To MAX_LEVELS-1 Do Level[i].Free;
 CrossClassSkills.Free;
 MainSkills.Free;
 Inherited Destroy;
End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

 Constructor TTrainedClass.Create(fClass : TBaseClass; fList : TClassList);
 Begin
   Inherited Create;
   LearnedSkills := TSkillList.Create;
   LearnedBonusFeats := TFeatList.Create;
   LearnedSpells := TSpellList.Create;
   ChosenClassAbilities := TClassAbilityList.Create;
   FreeClassAbilities := TClassAbilityList.Create;
   SelectableClassAbilities := TClassAbilityList.Create;
   Min := 1;
   step := 1;
   Max := MAX_LEVELS;
   BaseClass := fClass;
   LEvel := 1;
   List  := fList;
   List.Add(Self);
   OnChange := fList.Changed;
 End;

 Destructor TTrainedClass.Destroy;
 // Kill self from the available Skill list.
 Var I : Integer;
 Begin
   I := List.IndexOf(Self);
   If I <> -1 THen List.Delete(I);
   ChosenClassAbilities.Free;
   SelectableClassAbilities.Free;
   FreeClassAbilities.Free;
   LearnedSpells.Free;
   LearnedSkills.Free;
   LearnedBonusFeats.Free;
   Inherited;
 End;

 Procedure  TTrainedClass.AddTo(Target : TAffected);
 Var I : Integer;
     J : Integer;
     GroupHad : Array[0..255] of Boolean;
     BonusLevels : Integer;
 Begin
   // Add all gained levels in this class to the Target
   // (Most likely a character)
   Clear;
   Target.Points.Level := Target.Points.Level + Level;
   Target.Skills.AddList(LearnedSkills);
{   Target.Feats.AddList(Feats);}

   Add(BaseClass);
   Target.Add(BaseClass);

   If Level > MAX_LEVELS  Then Begin
     Raise DNDException.Create('Level higher than maximum levels');
     Exit;
   End;

   FreeClassAbilities.Clear;
   SelectableClassAbilities.Clear;

   For I := 1 To Level Do Begin
      Target.Add(BaseClass.Level[I]);
      Add(BaseClass.Level[I]);
   End;

   BonusLevels := 0;
{$IFNDEF NOMAIN}
   For I := 0 To Main.Character.Classes.Count-1 Do begin
     If ( lowercase(Main.Character.Classes[I].LeansOnClass) = Lowercase(Name) ) Then Begin
       For J := 1 To Main.Character.Classes[I].Level Do
         Inc(BonusLevels,Main.Character.Classes[I].BaseClass.Level[J].Points.CasterBonusLevels);
     End;
   End;
{$ENDIF}

   If BonusLevels > 0 Then Begin
     For I := Level+1 To Level+BonusLevels Do Begin
        For J := 0 To 9 Do Begin
        Points.Arcane[J] :=
          Points.Arcane[J] +
          BaseClass.Level[I].Points.Arcane[J];
        End;
     End;
   End;

   For I := 0 To 255 Do
     GroupHad[I] := False;

   For I := Level DownTo 1 Do Begin
      For J := 0 To BaseClass.Level[I].ClassAbilities.Count-1 Do
        If BaseClass.Level[I].ClassAbilities[J].Choose Then Begin
            SelectableClassAbilities.Add(BaseClass.Level[I].ClassAbilities[J]);
        End Else Begin
         { Wierd code, but it basically causes the highest level ability of a
           specific group to be shown }
         if BaseClass.Level[I].ClassAbilities[J].OverrideID > 0 Then Begin
           If GroupHad[BaseClass.Level[I].ClassAbilities[J].OverrideID] Then Begin
             Continue;
           End Else Begin
             GroupHad[BaseClass.Level[I].ClassAbilities[J].OverrideID] := True;
           End;
         End;
         FreeClassAbilities.Add(BaseClass.Level[I].ClassAbilities[J]);
       End;
    End;

 End;

 Function TTrainedClass.IsCrossClass(Skill : TBaseSkill) : Boolean;
 Begin
   Result := BaseClass.CrossClassSkills.IndexOf(Skill) <> -1;
 End;

 Function TTrainedClass.IsBanned    (Skill : TBaseSkill) : Boolean;
 Begin
   Result := (BaseClass.MainSkills.IndexOf(Skill) = -1) and
             (BaseClass.CrossClassSkills.IndexOf(Skill) = -1);
 End;

 Function TTrainedClass.GetName : String;
 Begin
  if Assigned(BaseClass) Then
    Result := BaseClass.Name
  Else Result := 'UnAssigned';
 End;

 Function TTrainedClass.GetValue : Real;
 Begin
   Result := Level;
 End;

 Procedure TTrainedClass.SetLEvel(NewLevel : Integer);
 Var I : Integer;
 Begin
  fLevel := NewLevel;
  If fLevel > Max Then fLevel := Round(Max);

  if Assigned(BaseClass) Then
  For I := 1 to UMIN(fLevel,MAX_LEVELS) do
     If HPLevel[I] = 0 Then HPLevel[I] := Random(BaseClass.HPPerLevel);

 End;

 PRocedure TTrainedclass.SetValue(NewValue : Real);
 Begin
   Level := Round(NewValue);
{   fValue := Round(NewValue);}
   Inherited;
 End;

 Procedure TTrainedClass.StreamWrite(Stream : TDNDStream);
 Var I : integer;
 Begin
   Inherited;
   Stream.WriteBaseClass(BaseClass);
   Stream.WriteInteger(fLevel);
   LearnedSkills.StreamWrite(Stream);
   LearnedBonusFeats.StreamWrite(Stream);
   TSpellList(LearnedSpells).StreamWrite(Stream);
   ChosenClassAbilities.StreamWrite(Stream);
   For I := 1 to MAX_LEVELS do
      Stream.WriteInteger(HPLevel[I]);
   Stream.WriteString(LeansOnClass);
 End;

 Procedure TTrainedClass.StreamRead(Stream : TDNDStream);
 Var I : integer;
 Begin
   Inherited;
   BaseClass := TBaseClass(Stream.ReadBaseClass);
   fLevel := Stream.ReadInteger;
   LearnedSkills.StreamRead(Stream);
   LearnedBonusFeats.StreamRead(Stream);
   TSpellList(LearnedSpells).StreamRead(Stream);
   ChosenClassAbilities.StreamRead(Stream);
   For I := 1 to MAX_LEVELS do
     HPLevel[I] := Stream.ReadInteger;
   LeansOnClass := Stream.ReadString;
 End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Procedure   TClassList.Changed;
  Begin
    if Assigned(OnChange) Then OnChange;
  End;

  Procedure TClassList.Clear;
  Begin
     Inherited Clear;
  End;

  Procedure TClassList.SetClass(Index: Integer; AObject: TTrainedClass);
  Begin
    SetItem(index,AObject);
  End;

  Function TClassList.GetClass(Index: Integer): TTrainedClass;
  Begin
   Result := TTrainedClass(GetItem(Index));
  End;

  Function TClassList.HasBaseClass(HasClass : TBaseclass) : TTrainedClass;
  Var I : Integer;
  Begin
   Result := Nil;
   For I := 0 To Count-1 Do
     If Items[i].BaseClass = HasClass Then Begin
       Result := Items[I];
       Exit;
     End;
  End;

 Constructor TClassList.Create;
 Begin
   Inherited;
   OwnsObjects := False;
 End;

 Procedure  TClassList.AddTo(Target : TAffected);
 Var I : integer;
 Begin
   For I := 0 To Count-1 Do Begin
      Items[i].Addto(Target);
   End;
 End;

 Procedure TClassList.ToStrings(Strings : TStrings);
 Var I :Integer;
 Begin
  Strings.BeginUpdate;
  Strings.Clear;
  For I := 0 To Count-1 Do
   Strings.addObject(Items[I].Name, Items[i]);
  Strings.EndUpdate;
 End;

 Procedure TClassList.StreamWrite(Stream : TDNDStream);
 Var I : Integer;
 Begin
    Stream.WriteInteger(Count);
    For I := 0 To Count-1 Do
      Items[I].StreamWrite(Stream);
 End;

 Procedure TClassList.StreamRead(Stream : TDNDStream);
 Var I, Max : Integer;
     TrainedClass : TTrainedClass;
 Begin
   Max := Stream.ReadInteger;
   Clear;
   For I := 0 To Max-1 Do Begin
     TrainedClass := TTrainedClass.Create(Nil,Self);
     TrainedClass.StreamRead(Stream);
   End;
 End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Procedure TBaseClassList.SetClass(Index: Integer; AObject: TBaseClass);
  Begin
    SetItem(index,AObject);
  End;

  Function TBaseClassList.GetClass(Index: Integer): TBaseClass;
  Begin
   Result := TBaseClass(GetItem(Index));
  End;

  Procedure TBaseClassList.StreamWrite(Stream : TDNDStream; StoreContent : Boolean);
  Var I : Integer;
  Begin
    Stream.WriteInteger(Count);
    For I := 0 To Count-1 Do Begin
        Stream.WriteString(Items[I].Name);
        If StoreContent Then Items[I].StreamWrite(Stream);
    End;
  End;

  Procedure TBaseClassList.StreamRead(Stream : TDNDStream; StoreContent : Boolean);
  Var I, Max : Integer;
      BaseClass : TBaseClass;
  Begin
    Max := Stream.ReadInteger;
    Clear;
    For I := 0 To Max-1 Do Begin
       BaseClass := World.AddClass(Stream.ReadString);
       if StoreContent Then BaseClass.StreamRead(Stream);
       if World.Classes <> Self Then Add(BaseClass);
    End;
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////

  Procedure TBaseRaceList.SetRace(Index: Integer; AObject: TBaseRace);
  Begin
    SetItem(index,AObject);
  End;

  Function TBaseRaceList.GetRace(Index: Integer): TBaseRace;
  Begin
   Result := TBaseRace(GetItem(Index));
  End;

  Procedure TBaseRaceList.StreamWrite(Stream : TDNDStream; StoreContent : Boolean);
  Var I : Integer;
  Begin
    Stream.WriteInteger(Count);
    For I := 0 To Count-1 Do Begin
        Stream.WriteString(Items[I].Name);
        if StoreContent Then Items[I].StreamWrite(Stream);
    End;
  End;

  Procedure TBaseRaceList.StreamRead(Stream : TDNDStream; StoreContent: Boolean);
  Var I, Max : Integer;
      BaseRace : TBaseRace;
  Begin
    Max := Stream.ReadInteger;
    Clear;
    For I := 0 To Max-1 Do Begin
       BaseRace := World.AddRace(Stream.ReadString);
       If StoreContent Then BaseRace.StreamRead(Stream);
       if World.Races <> Self Then Add(BaseRace);
    End;
  End;

  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////


  Constructor TBaseRace.Create;
  Begin
    Inherited;
    RaceAbilities := TRaceAbilityList.Create;
  End;

  Destructor TbaseRace.Destroy;
  Begin
    RaceAbilities.Free;
    Inherited;
  End;

  Procedure TBaseRace.StreamWrite(Stream : TDNDStream);
  Begin
    Inherited;
    Stream.WriteString(FavoredClass);
    Stream.WriteInteger(Size);
    RaceAbilities.StreamWrite(Stream);
    Stream.WriteInteger(Flags);
    Stream.WriteInteger(LevelCost);
  End;

  Procedure TBaseRace.StreamRead(Stream : TDNDStream);
  Begin
    Inherited;
    FavoredClass := Stream.ReadString;
    Size := Stream.ReadInteger;
    RaceAbilities.StreamRead(Stream);
    Flags := Stream.ReadInteger;
    LevelCost := Stream.ReadInteger;
  End;

  Function TClassList.NamesCombined : String;
  Var i : Integer;
  Begin
      Result := '';
      For I := 0 To Count-1 Do Begin
        Result := Result + ' '+floatToStr(Items[I].Value) + ' ' + Items[I].Name;
        If ( I < Count-1) Then
        Result := Result + ' /';
     End;
  End;

end.
