'                             SLIDING PUZZLE
'                                   by
'                            Matthew D. Thomas
'                                (c) 2003
'
'
'                     ****READ THIS****
'This is a basic 24 piece sliding puzzle, used with a mouse.
'You will need to change the CHDIR to the directory where all the puzzle
'files are stored. The program automatically will load all .pic files in
'that directory. Use the arrows to select which picture you want to mix,
'and select that puzzle by clicking on the picture.
'The total moves it takes you are displayed when you solve the puzzle.
'Press F5 to start the program.
'To quit early, right click.
'
'Questions or comments?
'email:   rocketmat2@aol.com
'website: www.angelfire.com/rpg2/rocketdesigns

DECLARE SUB CheckWin ()
DECLARE SUB Colors ()
DECLARE SUB Init ()
DECLARE SUB LoadPix ()
DECLARE SUB MouseDriver (ax%)
DECLARE SUB Move ()

CONST UPDATE = 3, HIDE = 2, SHOW = 1
DIM SHARED Mouse$, bx%, cx%, dx%, lb%, rb%, moves%
DIM SHARED square%(1 TO 5, 1 TO 5)
DIM SHARED puzzle&(0 TO 16000)
DIM SHARED file%, choice%

CHDIR "c:\unzipped\puzzle\puzzle\"

Init
DIM SHARED file$(1 TO file%)
LoadPix

MouseDriver SHOW
DO
    Colors
    MouseDriver UPDATE
    IF lb% THEN
        IF ABS(cx% / 2 - 159.5) < 75 AND ABS(dx% - 104.5) < 75 THEN Move
        CheckWin
        DO: MouseDriver UPDATE: Colors: LOOP UNTIL NOT lb%
    END IF
LOOP UNTIL rb%


'mouse driver data ***DO NOT CHANGE***
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

SUB CheckWin
    w% = 1
    FOR r% = 1 TO 5
        FOR c% = 1 TO 5
            IF square%(r%, c%) <> w% THEN EXIT SUB
            w% = w% + 1: IF w% = 25 THEN w% = 0
        NEXT c%
    NEXT r%
    MouseDriver HIDE
    DEF SEG = &HA000
    BLOAD file$(choice%)
    COLOR 40
    PRINT "Congratulations!"
    PRINT
    COLOR 15
    PRINT "Total"
    PRINT "moves:"
    COLOR 40
    PRINT moves%
    PRINT
    MouseDriver SHOW
    WHILE lb% OR rb%: MouseDriver UPDATE: Colors: WEND
    WHILE NOT lb%: MouseDriver UPDATE: Colors: WEND
    MouseDriver HIDE
    PRINT "Questions or comments? Send emails to:"
    PRINT
    COLOR 40: PRINT "    rocketmat2@aol.com"
    PRINT
    COLOR 15: PRINT "Visit my site at"
    PRINT
    COLOR 40: PRINT "www.angelfire.com/rpg2/rocketdesigns"
    COLOR 15
    SYSTEM
END SUB

SUB Colors STATIC
    IF s% = 0 THEN
        s% = 1
        delay = .05
        DIM r#(48 TO 52)
        DIM a#(48 TO 52)
        FOR i% = 48 TO 52
            r#(i%) = (i% - 48) * 10 + 10
            a#(i%) = delay
        NEXT i%
    END IF
    FOR i% = 48 TO 52
        OUT &H3C8, 200 + i%: OUT &H3C9, INT(r#(i%)): OUT &H3C9, 0: OUT &H3C9, 0
        IF INT(r#(i%)) = 10 AND a#(i%) = -delay THEN a#(i%) = delay
        IF INT(r#(i%)) = 60 AND a#(i%) = delay THEN a#(i%) = -delay
        r#(i%) = r#(i%) + a#(i%)
    NEXT i%
END SUB

SUB Init
    RANDOMIZE TIMER
    Mouse$ = SPACE$(57)
    FOR i% = 1 TO 57
        READ a$
        h$ = CHR$(VAL("&H" + a$))
        MID$(Mouse$, i%, 1) = h$
    NEXT i%
    z% = 0
    FOR r% = 1 TO 5
        FOR c% = 1 TO 5
            z% = z% + 1
            square%(r%, c%) = z%
        NEXT c%
    NEXT r%
    square%(5, 5) = 0
    SCREEN 0
    FILES "*.pic"
    y% = 1
    file% = 0
    DO
        y% = y% + 1
        FOR x% = 1 TO 55 STEP 18
            IF SCREEN(y%, x%) = 32 THEN EXIT DO
            file% = file% + 1
        NEXT x%
    LOOP
END SUB

SUB LoadPix
    y% = 1
    f% = 0
    DO
        y% = y% + 1
        FOR x% = 1 TO 55 STEP 18
            IF SCREEN(y%, x%) = 32 THEN EXIT DO
            f% = f% + 1
            c% = 0
            DO UNTIL SCREEN(y%, x% + c%) = 32
                IF SCREEN(y%, x% + c%) <> 32 THEN
                    file$(f%) = file$(f%) + CHR$(SCREEN(y%, x% + c%))
                    c% = c% + 1
                END IF
            LOOP
            file$(f%) = file$(f%) + ".pic"
        NEXT x%
    LOOP
    SCREEN 13
    Colors
    choice% = 1
    DO
        DEF SEG = &HA000
        BLOAD file$(choice%)
        DRAW "bm 20,100c28e20d10r20d20l20d10h20brp24,28br39c26u9d19l20d10"
        DRAW "bm 299,100c28h20d10l20d20r20d10e20blp24,28bl39c26u9d19r20d10"
        DO: MouseDriver UPDATE: LOOP UNTIL NOT (lb% OR rb%)
        MouseDriver SHOW
        DO
            MouseDriver UPDATE
            Colors
        LOOP UNTIL lb%
        MouseDriver HIDE
        IF ABS(cx% / 2 - 40) < 20 THEN
            choice% = choice% - 1
            IF choice% = 0 THEN choice% = file%
          ELSEIF ABS(cx% / 2 - 279) < 20 THEN
            choice% = choice% + 1
            IF choice% = file% + 1 THEN choice% = 1
          ELSEIF ABS(cx% / 2 - 160) < 75 THEN EXIT DO
        END IF
    LOOP
    BLOAD file$(choice%)
    LINE (205, 150)-(234, 179), 0, BF
    z% = 0
    FOR y% = 1 TO 5
        FOR x% = 1 TO 5
            z% = z% + 1
            IF z% < 25 THEN GET (55 + x% * 30, y% * 30)-(84 + x% * 30, 29 + 30 * y%), puzzle&(z% * 640)
        NEXT x%
    NEXT y%
    GET (205, 150)-(234, 179), puzzle&(0)
    x% = 5
    y% = 5
    FOR i% = 1 TO 500
        h% = INT(RND * 2): v% = INT(RND * 2)
        xm% = 0: ym% = 0
        IF h% = 0 AND x% > 1 THEN
            xm% = -1
          ELSEIF h% = 1 AND x% < 5 THEN
            xm% = 1
        END IF
        square%(y%, x%) = square%(y%, x% + xm%)
        square%(y%, x% + xm%) = 0
        PUT (x% * 30 + 55, y% * 30), puzzle&(square%(y%, x%) * 640), PSET
        x% = x% + xm%
        LINE (x% * 30 + 55, y% * 30)-(x% * 30 + 84, y% * 30 + 29), 0, BF
        IF v% = 0 AND y% > 1 THEN
            ym% = -1
          ELSEIF v% = 1 AND y% < 5 THEN
            ym% = 1
        END IF
        square%(y%, x%) = square%(y% + ym%, x%)
        square%(y% + ym%, x%) = 0
        PUT (x% * 30 + 55, y% * 30), puzzle&(square%(y%, x%) * 640), PSET
        y% = y% + ym%
        LINE (x% * 30 + 55, y% * 30)-(x% * 30 + 84, y% * 30 + 29), 0, BF
    NEXT i%
END SUB

SUB MouseDriver (ax%)
   
    'This sub checks on the status of the mouse. Once again,
    'DO NOT EDIT THIS.
   
    DEF SEG = VARSEG(Mouse$)
    CALL Absolute(ax%, bx%, cx%, dx%, SADD(Mouse$))
    lb% = ((bx% AND 1) <> 0)
    rb% = ((bx% AND 2) <> 0)
END SUB

SUB Move
    xp% = INT((cx% / 2 - 85) / 30) + 1
    yp% = INT((dx% - 30) / 30) + 1
    IF yp% > 1 THEN IF square%(yp% - 1, xp%) = 0 THEN xm% = 0: ym% = -1
    IF yp% < 5 THEN IF square%(yp% + 1, xp%) = 0 THEN xm% = 0: ym% = 1
    IF xp% > 1 THEN IF square%(yp%, xp% - 1) = 0 THEN xm% = -1: ym% = 0
    IF xp% < 5 THEN IF square%(yp%, xp% + 1) = 0 THEN xm% = 1: ym% = 0
    IF xm% OR ym% THEN
        square%(yp% + ym%, xp% + xm%) = square%(yp%, xp%)
        MouseDriver HIDE
        LINE (55 + xp% * 30, yp% * 30)-(84 + xp% * 30, 29 + yp% * 30), 0, BF
        PUT (55 + (xp% + xm%) * 30, (yp% + ym%) * 30), puzzle&(square%(yp%, xp%) * 640), PSET
        MouseDriver SHOW
        square%(yp%, xp%) = 0
        moves% = moves% + 1
    END IF
END SUB

