{    }
{    Program  : SPOTDGR.PAS                                                 }
{    Function : Spot Diagram                                                }
{    Language : Borland Turbo Pascal 7.0                                    }
{    Autor    : Ivan Krastev                                                }
{     1999   : My Optics Co.                                               }
{    }

  USES Crt, Graph;

  VAR  k, Sk, Theta     : INTEGER;
       Cr, Hi, Ti       : INTEGER;
       Diam, H, F, w    : REAL;

  VAR  X0, Y0, dX, dY   : REAL;
       Rairy, Scale, Cs : REAL;

  VAR  r, d, n, e,
       p, q, x, y, z,
       Xi, Eta, Zeta    : ARRAY[1..25] OF REAL;

  VAR  GrDrv, GrMode    : INTEGER;

PROCEDURE RayTrace;

  VAR  A, B, C, DD, RR, tt,
       Qt, Qtp, Psi, Alpha, Beta : REAL;

BEGIN { RayTrace }
  x[1] := H*SIN(Theta*Pi/180);
  y[1] := H*COS(Theta*Pi/180);
  z[1] := 0;
  Xi[1]   :=  0;
  Eta[1]  := -SIN(w*Pi/180);
  Zeta[1] :=  COS(w*Pi/180);
  p[1] := x[1]*Zeta[1];
  q[1] := y[1]*Zeta[1];
  FOR k:= 1 TO Sk-1 DO
    BEGIN
      B    := 1/r[k];
      A    := B*(SQR(p[k])+SQR(q[k]));
      C    := SQR(Zeta[k]);
      DD   := C+B*((p[k]*Xi[k])+(q[k]*Eta[k]));
      Qt   := SQRT(SQR(DD)-A*B*(SQR(n[k])-e[k]*SQR(C)));
      z[k] := A/(DD+Qt);
      tt   := 1+B*z[k]*e[k];
      RR   := SQR(tt)-B*z[k]*(tt-1);
      IF (n[k]/n[k+1]) < 0 THEN
	BEGIN
	  Qtp := -Qt;
	  Psi := -2*Qt/(RR*C);
	  Cr  := Cr+1
	END
      ELSE
	BEGIN
	  Qtp := SQRT(SQR(Qt)+RR*C*(SQR(n[k+1])-SQR(n[k])));
	  Psi := (Qtp-Qt)/(RR*C)
	END;
      Alpha := Psi*(p[k]-(z[k]*Xi[k]));
      Beta  := Psi*(q[k]-(z[k]*Eta[k]));
      Xi[k+1]   := Xi[k]+(B*Alpha);
      Eta[k+1]  := Eta[k]+(B*Beta);
      Zeta[k+1] := SQRT(SQR(n[k+1])-SQR(Xi[k+1])-SQR(Eta[k+1]));
      IF (Sk > 2) AND (FRAC(0.5*Cr) > 0) THEN
	Zeta[k+1] := -Zeta[k+1];
      p[k+1] := p[k]+(tt*Alpha)-(d[k+1]*Xi[k+1]);
      q[k+1] := q[k]+(tt*Beta)-(d[k+1]*Eta[k+1]);
      x[k+1] := p[k+1]/Zeta[k+1];
      y[k+1] := q[k+1]/Zeta[k+1]
    END
END; { RayTrace }

BEGIN { SpotDgr }
  ClrScr;
  WRITE('Numbar of Surfaces     Sk    -> ');READ(Sk);
  WRITE('Clear Diameter         Diam  -> ');READ(Diam);
  WRITE('Effective Focal Length F     -> ');READ(F);
  WRITE('Half Field Angle       w     -> ');READ(w);
  WRITELN('Surface     r           e           d           n    ');
  WRITELN('------------------------------------------------------');
  FOR k:= 1 TO Sk DO
    BEGIN
      GotoXY(4, 6+k);WRITE(k);
      GotoXY(10,6+k);READ(r[k]);
      GotoXY(25,6+k);READ(e[k]);
      GotoXY(35,6+k);READ(d[k]);
      GotoXY(50,6+k);READ(n[k])
    END;
  Theta:= 0; Cr:= 0; Hi:= 2; Ti:= 2; Cs:= 0.075; { Initialisation }
  GrDrv:= Detect; InitGraph(GrDrv, GrMode, ' ');
  IF GraphResult <> GrOk THEN
    Halt(1);
  Scale := 480/Cs;
  Rairy := 1.2197*0.000555*F/Diam;
  Line(100, 240-TRUNC(Scale*0.0125), 100, 240+TRUNC(Scale*0.0125));
  Line(540, 240-TRUNC(Scale*Rairy), 540, 240+TRUNC(Scale*Rairy));
  OutTextXY(25, 240, '0.025 mm'); OutTextXY(550, 240, 'Airy Size');
  REPEAT
    H := 0;
    RayTrace;
    X0 := x[Sk]; Y0 := y[Sk];
    H  := 0.5*Diam;
    REPEAT
      RayTrace;
      dX := X0-x[Sk]; dY := Y0-y[Sk];
      PutPixel(ROUND(320+(Scale*dX)),ROUND(240+(Scale*dY)),White);
      IF (Theta <> 0) AND (Theta <> 180) THEN
	PutPixel(ROUND(320-(Scale*dX)),ROUND(240+(Scale*dY)),White);
      H := H-Hi
    UNTIL H <= 0;
    Theta := Theta+Ti
  UNTIL Theta > 180;
  Ch := ReadKey;
 CloseGraph
END. { SpotDgr }
