1   'PROGRAM SpotDgr
10   DEFSNG A-Z
20   DIM R(25), E(25), D(25), N(25), P(25), Q(25)
30   DIM X(25), Y(25), Z(25), XI(25), ETA(25), ZETA(25)
40   PI = 3.141592653#: HI = 10: TI = 10: DF = -1: CS = .075 'Initialisation
50   GOTO 500
100 'PROCEDURE - Max Herzberger Ray Trace
110  X(1) = H * SIN(THETA * PI / 180): Y(1) = H * COS(THETA * PI / 180): Z(1) = 0
120  XI(1) = 0: ETA(1) = -SIN(W * PI / 180): ZETA(1) = COS(W * PI / 180)
130  P(1) = X(1) * ZETA(1): Q(1) = Y(1) * ZETA(1)
140  FOR K = 1 TO SK - 1
150    B = 1 / R(K): A = B * ((P(K) ^ 2) + (Q(K) ^ 2)): C = (ZETA(K) ^ 2)
160    DD = C + B * ((P(K) * XI(K)) + (Q(K) * ETA(K)))
170    QT = SQR((DD ^ 2) - A * B * ((N(K) ^ 2) - E(K) * (C) ^ 2))
180    Z(K) = A / (DD + QT): TT = 1 + B * Z(K) * E(K): RR = (TT ^ 2) - B * Z(K) * (TT - 1)
190    IF (N(K) / N(K + 1)) < 0 THEN QTP = -QT: PSI = -2 * QT / (RR * C): CR = CR + 1 ELSE QTP = SQR((QT ^ 2) + RR * C * ((N(K + 1) ^ 2) - (N(K) ^ 2))): PSI = (QTP - QT) / (RR * C)
200    ALPHA = PSI * (P(K) - (Z(K) * XI(K))): BETA = PSI * (Q(K) - (Z(K) * ETA(K)))
210    XI(K + 1) = XI(K) + (B * ALPHA): ETA(K + 1) = ETA(K) + (B * BETA)
220    ZETA(K + 1) = SQR((N(K + 1) ^ 2) - (XI(K + 1) ^ 2) - (ETA(K + 1) ^ 2))
230    IF (SK > 2) AND (FIX(.5 * CR) > 0) THEN ZETA(K + 1) = -ZETA(K + 1)
240    P(K + 1) = P(K) + (TT * ALPHA) - (D(K + 1) * XI(K + 1))
250    Q(K + 1) = Q(K) + (TT * BETA) - (D(K + 1) * ETA(K + 1))
260    X(K + 1) = P(K + 1) / ZETA(K + 1): Y(K + 1) = Q(K + 1) / ZETA(K + 1)
270  NEXT K
280  RETURN
500 'Main Program
510  INPUT "Numbar of Surfaces     Sk    -> ", SK
520  INPUT "Clear Diameter         Diam  -> ", DIAM
530  INPUT "Focal Lengt of System  F     -> ", F
540  INPUT "Half Field Angle       w     -> ", W
550  PRINT "Surface       R         E           D       N"
560  FOR K = 1 TO SK
570    LOCATE 6 + K, 3: PRINT K
580    LOCATE 6 + K, 12: INPUT "", R(K)
590    LOCATE 6 + K, 25: INPUT "", E(K)
600    LOCATE 6 + K, 35: INPUT "", D(K)
610    LOCATE 6 + K, 45: INPUT "", N(K)
620  NEXT K
630  CLS : SCREEN 2
640  RAIRY = 1.2197 * .000555 * F / DIAM
650  D(SK) = D(SK) + DF: THETA = 0: SCALE = 200 / CS
660  LINE (100, 100 - (SCALE * .0125))-(100, 100 + (SCALE * .0125))
670  LINE (540, 100 - (SCALE * RAIRY))-(540, 100 + (SCALE * RAIRY))
680  LOCATE 1, 35: PRINT "Spot Diagram": LOCATE 13, 5: PRINT "0.025 mm": LOCATE 13, 70: PRINT "Airy Size"
690  WHILE THETA <= 180
700    H = 0: GOSUB 100 'Max Herzberger Ray Trace
710    X0 = X(SK): Y0 = Y(SK): H = .5 * DIAM
720    WHILE H > 0
730      GOSUB 100 'Max Herzberger Ray Trace
740      DX = X0 - X(SK): DY = Y0 - Y(SK)
750      PSET (320 + (2 * SCALE * DX), 100 - (SCALE * DY))
760      IF THETA <> 0 AND THETA <> 180 THEN PSET (320 - (2 * SCALE * DX), 100 - (SCALE * DY))
770      H = H - HI
780    WEND
790    THETA = THETA + TI
800  WEND
810  K$ = INKEY$: IF K$ = "" THEN 810
820  SCREEN 0, 0, 0
830  END 'Main Program

