1   'PROGRAM Spot Diagram - Demo 1
10   DEFSNG A-Z
20   DIM R(15), E(15), D(15), N(15), P(15), Q(15)
30   DIM X(15), Y(15), Z(15), XI(15), ETA(15), ZETA(15)
40   PI = 3.141592653#: HI = 3: TI = 6: DF = 0: CS = .075 'Initialisation
50   GOTO 500
100 'PROCEDURE - Max Herzberger Ray Trace
110  X(1) = H * SIN(THETA * PI / 180): Y(1) = H * COS(THETA * PI / 180): Z(1) = 0
120  XI(1) = 0: ETA(1) = -SIN(w * PI / 180): ZETA(1) = COS(w * PI / 180)
130  P(1) = X(1) * ZETA(1): Q(1) = Y(1) * ZETA(1)
140  FOR K = 1 TO SK - 1
150    B = 1 / R(K): A = B * ((P(K) ^ 2) + (Q(K) ^ 2)): C = (ZETA(K) ^ 2)
160    DD = C + B * ((P(K) * XI(K)) + (Q(K) * ETA(K)))
170    QT = SQR((DD ^ 2) - A * B * ((N(K) ^ 2) - E(K) * (C) ^ 2))
180    Z(K) = A / (DD + QT): TT = 1 + B * Z(K) * E(K): RR = (TT ^ 2) - B * Z(K) * (TT - 1)
190    IF (N(K) / N(K + 1)) < 0 THEN QTP = -QT: PSI = -2 * QT / (RR * C): CR = CR + 1 ELSE QTP = SQR((QT ^ 2) + RR * C * ((N(K + 1) ^ 2) - (N(K) ^ 2))): PSI = (QTP - QT) / (RR * C)
200    ALPHA = PSI * (P(K) - (Z(K) * XI(K))): BETA = PSI * (Q(K) - (Z(K) * ETA(K)))
210    XI(K + 1) = XI(K) + (B * ALPHA): ETA(K + 1) = ETA(K) + (B * BETA)
220    ZETA(K + 1) = SQR((N(K + 1) ^ 2) - (XI(K + 1) ^ 2) - (ETA(K + 1) ^ 2))
230    IF (SK > 2) AND (FIX(.5 * CR) > 0) THEN ZETA(K + 1) = -ZETA(K + 1)
240    P(K + 1) = P(K) + (TT * ALPHA) - (D(K + 1) * XI(K + 1))
250    Q(K + 1) = Q(K) + (TT * BETA) - (D(K + 1) * ETA(K + 1))
260    X(K + 1) = P(K + 1) / ZETA(K + 1): Y(K + 1) = Q(K + 1) / ZETA(K + 1)
270  NEXT K
280  RETURN
500  'Main Program
510  SK = 2: DIAM = 150: F = 1500: w = .5
520  R(1) = -3000: E(1) = 1: D(1) = 0: N(1) = 1
530  R(2) = 0: E(2) = 0: D(2) = -1500: N(2) = -1
540  CLS : SCREEN 2
550  RAIRY = 1.2197 * .000555 * F / DIAM
560  D(SK) = D(SK) + DF: THETA = 0: SCALE = 200 / CS
570  LOCATE 1, 35: PRINT "Spot Diagram"
580  LINE (100, 100 - (SCALE * .0125))-(100, 100 + (SCALE * .0125))
590  LINE (540, 100 - (SCALE * RAIRY))-(540, 100 + (SCALE * RAIRY))
600  LOCATE 13, 5: PRINT "0.025 mm": LOCATE 13, 70: PRINT "Airy Size"
610  WHILE THETA <= 180
620    H = 0: GOSUB 100 'Max Herzberger Ray Trace
630    X0 = X(SK): Y0 = Y(SK): H = .5 * DIAM
640    WHILE H > 0
650      GOSUB 100 'Max Herzberger Ray Trace
660      DX = X0 - X(SK): DY = Y0 - Y(SK)
670      PSET (320 + (2 * SCALE * DX), 100 - (SCALE * DY))
680      IF THETA <> 0 AND THETA <> 180 THEN PSET (320 - (2 * SCALE * DX), 100 - (SCALE * DY))
690      H = H - HI
700    WEND
710    THETA = THETA + TI
720  WEND
730  LOCATE 22, 30: PRINT "Half Field Angle  ": LOCATE 22, 49: PRINT w
740  LOCATE 23, 30: PRINT "Back Focal Length ": LOCATE 23, 49: PRINT D(SK): SOUND 1000, 10
750  K$ = INKEY$: IF K$ = "" THEN 750
760  SCREEN 0, 0, 0
770  END 'Main Program

