{  Ŀ  }
{    PROGRAM  : MULTISD.PAS          					     }
{    Function : Multi Spot Diagram - Polar Ray Distribution                 }
{    Language : Borland Turbo Pascal 7.0         			     }
{    Autor    : Ivan Krastev            				     }
{     1998   : My Optics         					     }
{    }

USES Crt, Graph;

{ General }
  VAR  Crefl, k,
       Sk, WL,
       Theta      : INTEGER;
       H1, Diam,
       w, F, BFL  : REAL;
{ Raytrace }
  VAR  r, d, e,
       p, q,
       x, y, z,
       Xi, Eta, Zeta : ARRAY[1..25] OF REAL;
       n             : ARRAY[1..3, 1..25] OF REAL;
{ Graph }
  VAR  GrDriver : INTEGER;
       GrMode   : INTEGER;

  VAR  Hi, Ti,
       HX, HY  : INTEGER;
       X0, Y0,
       XS, YS,
       Rairy,
       dX, dY  : REAL;

PROCEDURE RayTrace;
  VAR  A, B, C,
       DD, RR, tt,
       Qt, Qtp,
       Psi, Alpha, Beta : REAL;
BEGIN { RayTrace }

{ Polar Ray Distribution }
  x[1] := H1*SIN(Theta*Pi/180);
  y[1] := H1*COS(Theta*Pi/180);
  z[1] := 0;

  Xi[1]   :=  0;
  Eta[1]  := -SIN(w*Pi/180);
  Zeta[1] :=  COS(w*Pi/180);

  p[1] := x[1]*Zeta[1];
  q[1] := y[1]*Zeta[1];

  FOR k := 1 TO Sk-1 DO
    BEGIN
      B  := 1/r[k];
      A  := B*(SQR(p[k])+SQR(q[k]));
      C  := SQR(Zeta[k]);
      DD := C+B*((p[k]*Xi[k])+(q[k]*Eta[k]));

      Qt   := SQRT(SQR(DD)-A*B*(SQR(n[WL,k])-e[k]*SQR(C)));
      z[k] := A/(DD+Qt);
      tt   := 1+B*z[k]*e[k];
      RR   := SQR(tt)-B*z[k]*(tt-1);

      IF (n[WL,k]/n[WL,k+1]) < 0 THEN
	BEGIN
	  Qtp   := -Qt;
	  Psi   := -2*Qt/(RR*C);
	  Crefl := Crefl+1
	END
      ELSE
	BEGIN
	  Qtp := SQRT(SQR(Qt)+RR*C*(SQR(n[WL,k+1])-SQR(n[WL,k])));
	  Psi := (Qtp-Qt)/(RR*C)
	END;

      Alpha := Psi*(p[k]-(z[k]*Xi[k]));
      Beta  := Psi*(q[k]-(z[k]*Eta[k]));

      Xi[k+1]   := Xi[k]+(B*Alpha);
      Eta[k+1]  := Eta[k]+(B*Beta);
      Zeta[k+1] := SQRT(SQR(n[WL,k+1])-SQR(Xi[k+1])-SQR(Eta[k+1]));

      IF (Sk > 2) AND ODD(Crefl) THEN
	Zeta[k+1] := -Zeta[k+1];

      p[k+1] := p[k]+(tt*Alpha)-(d[k+1]*Xi[k+1]);
      q[k+1] := q[k]+(tt*Beta)-(d[k+1]*Eta[k+1]);

      x[k+1] := p[k+1]/Zeta[k+1];
      y[k+1] := q[k+1]/Zeta[k+1]

    END
END; { RayTrace }

BEGIN { PMultiSD }

  GrDriver := VGA;
  GrMode   := VGAHi;

  InitGraph(GrDriver, GrMode, '\BGI');
  OutTextXY(250, 10, 'Multi Spot Diagram');
  OutTextXY(230, 25, 'Design by Ivan Krastev');

  Sk    := 3;
  WL    := 1;
  Crefl := 0;

  Diam := 150;
  F    := 2000;

  d[1] :=  0;
  d[2] := -360;
  d[3] :=  560;

  BFL  := d[3];

  r[1] := -1000;
  r[2] := -373.33;

  e[1] := {0.671875} 1     {1.045};
  e[2] := {0}        2.778 {3.189};

  n[1,1] :=  1;
  n[1,2] := -1;
  n[1,3] :=  1;

  XS := 480/0.75;
  SetColor(Red);
  Rairy := 1.2197*0.000555*F/Diam;
  Circle(25, 25, TRUNC(0.0125*XS)); { Disk 0.025 mm }
  Circle(25, 65, TRUNC(Rairy*XS));  { Airy Disk  mm }

  SetColor(White);
  SetTextStyle(SmallFont, HorizDir, 4);
  OutTextXY(5, 40, '0.025 mm');
  OutTextXY(5, 75, 'Airy Disk');

  w     := 0;
  Hi    := 5;
  Ti    := 5;
  HX    := 75;
  HY    := 425;
  d[Sk] := d[Sk]-1;
  REPEAT
    REPEAT
      H1 := 0;
      RayTrace;
      X0 := x[Sk];
      Y0 := y[Sk];
      REPEAT
	H1 := 0.5*Diam;
	REPEAT
	  RayTrace;
	  dX := X0-x[Sk];
	  dY := Y0-y[Sk];
	  CASE Theta OF
	    0, 180 : PutPixel(ROUND(HX+(dX*XS)),
			 ROUND(HY+(dY*XS)),
			 White)
	  ELSE
	    BEGIN
	      PutPixel(ROUND(HX+(dX*XS)),
		       ROUND(HY+(dY*XS)),
		       White);
	      PutPixel(ROUND(HX+(-dX*XS)),
		       ROUND(HY+(dY*XS)),
		       White)
	    END
	  END; { CASE Theta }
	  H1 := H1-Hi
	UNTIL H1 <= 0;
	Theta := Theta+Ti
      UNTIL Theta > 180;
      Theta := 0;
      w     := w+0.15;
      HY    := HY-100
    UNTIL w > 0.5;
    w     := 0;
    Theta := 0;
    HY    := 425;
    HX    := HX+110;
    d[Sk] := d[Sk]+0.5
  UNTIL d[Sk] > (BFL+1);
  REPEAT UNTIL KeyPressed;
  CloseGraph
END. { PMultiSD }