1   'PROGRAM Multi Spot Diagram - Demo
10   DEFSNG A-Z
20   DIM R(15), E(15), D(15), N(15), P(15), Q(15)
30   DIM X(15), Y(15), Z(15), XI(15), ETA(15), ZETA(15)
40   PI = 3.141592653#: HI = 10: TI = 10: DF = 1: CS = 1 'Initialisation
50   GOTO 500
100 'PROCEDURE - Max Herzberger Ray Trace
110  X(1) = H * SIN(THETA * PI / 180): Y(1) = H * COS(THETA * PI / 180): Z(1) = 0
120  XI(1) = 0: ETA(1) = -SIN(W * PI / 180): ZETA(1) = COS(W * PI / 180)
130  P(1) = X(1) * ZETA(1): Q(1) = Y(1) * ZETA(1)
140  FOR K = 1 TO SK - 1
150    B = 1 / R(K): A = B * ((P(K) ^ 2) + (Q(K) ^ 2)): C = (ZETA(K) ^ 2)
160    DD = C + B * ((P(K) * XI(K)) + (Q(K) * ETA(K)))
170    QT = SQR((DD ^ 2) - A * B * ((N(K) ^ 2) - E(K) * (C) ^ 2))
180    Z(K) = A / (DD + QT): TT = 1 + B * Z(K) * E(K): RR = (TT ^ 2) - B * Z(K) * (TT - 1)
190    IF (N(K) / N(K + 1)) < 0 THEN QTP = -QT: PSI = -2 * QT / (RR * C): CR = CR + 1 ELSE QTP = SQR((QT ^ 2) + RR * C * ((N(K + 1) ^ 2) - (N(K) ^ 2))): PSI = (QTP - QT) / (RR * C)
200    ALPHA = PSI * (P(K) - (Z(K) * XI(K))): BETA = PSI * (Q(K) - (Z(K) * ETA(K)))
210    XI(K + 1) = XI(K) + (B * ALPHA): ETA(K + 1) = ETA(K) + (B * BETA)
220    ZETA(K + 1) = SQR((N(K + 1) ^ 2) - (XI(K + 1) ^ 2) - (ETA(K + 1) ^ 2))
230    IF (SK > 2) AND (FIX(.5 * CR) > 0) THEN ZETA(K + 1) = -ZETA(K + 1)
240    P(K + 1) = P(K) + (TT * ALPHA) - (D(K + 1) * XI(K + 1))
250    Q(K + 1) = Q(K) + (TT * BETA) - (D(K + 1) * ETA(K + 1))
260    X(K + 1) = P(K + 1) / ZETA(K + 1): Y(K + 1) = Q(K + 1) / ZETA(K + 1)
270  NEXT K
280  RETURN
500 'Main Program
501  INPUT "Numbar of Surfaces     Sk    -> ", SK
502  INPUT "Clear Diameter         Diam  -> ", DIAM
503  INPUT "Focal Lengt of System  F     -> ", F
504  INPUT "Half Field Angle       w     -> ", WMAX
505  PRINT "Surface       R         E           D       N"
506  FOR K = 1 TO SK
507    LOCATE 6 + K, 3: PRINT K
508    LOCATE 6 + K, 12: INPUT "", R(K)
509    LOCATE 6 + K, 25: INPUT "", E(K)
510    LOCATE 6 + K, 35: INPUT "", D(K)
511    LOCATE 6 + K, 45: INPUT "", N(K)
512  NEXT K
550  CLS : SCREEN 12: SCALE = 400 / CS: HX = 75: HY = 400
560  LINE (0, 0)-(639, 450), 1, BF: LINE (0, 0)-(639, 450), , B
570  RAIRY = 1.2197 * .000555 * F / DIAM
580  CIRCLE (70, 50), SCALE * RAIRY: LOCATE 2, 5: PRINT "Airy Disk"
590  CIRCLE (550, 50), SCALE * .0125: LOCATE 2, 65: PRINT "0.025 mm"
600  W = 0: THETA = 0: BFL = D(SK): D(SK) = D(SK) - DF:
610  LOCATE 2, 30: PRINT "Multi Spot Diagram"
620  WHILE D(SK) <= BFL + DF
630  WHILE W < WMAX
640      WHILE THETA <= 180
650        H = 0: GOSUB 100 'Max Herzberger Ray Trace
660        X0 = X(SK): Y0 = Y(SK): H = .5 * DIAM
670        WHILE H > 0
680          GOSUB 100 'Max Herzberger Ray Trace
690          DX = X0 - X(SK): DY = Y0 - Y(SK)
700          PSET (HX + (SCALE * DX), HY - (SCALE * DY))
710          IF THETA <> 0 AND THETA <> 180 THEN PSET (HX - (SCALE * DX), HY - (SCALE * DY))
720          H = H - HI
730        WEND
740        THETA = THETA + TI
750      WEND
760      THETA = 0: W = W + .15: HY = HY - 100
770    WEND
780    W = 0: THETA = 0: HY = 400: HX = HX + 110: D(SK) = D(SK) + .5
790  WEND
800 END 'Main Program

