; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
                             TITLE ListP.asm
; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

				COMMENT $

Este programa muestra:
	 Cmo obtener una lista de los procesos en tu PC
	 Cmo desplegar esta lista en un control de ventana hija
	  list view.
	 Cmo obtener el manejador de un proceso a partir del
	  ID del proceso
	 Cmo liquidar un proceso remoto

	Nuevo (22/07/2000) :
	 El nombre: Process Study v0.1
	 Cmo volcar una porcin de memoria al disco duro
	 Cmo desplegar, editar y volcar las caractersticas de un
          mdulo pe.
	 Cmo cargar un proceso

Asumo que tienes MASM 6.13 en el directorio C:\MASM32.
De todos modos no es difcil hacer los cambios apropiados.

Este programa es la tercera parte de un volcador de procesos
que he llamado VOLKT.

CONTACT: numit_or@subdimension.com
WEB:     http://members.xoom.com/numit_or/asm.html

 n u M I T_o r  [ kUT and Askatasuna Krackers Society ]

				$

; ========================================================================

	.386
	.model flat,stdcall

; ========================================================================

include C:\masm32\include\windows.inc
include C:\masm32\include\kernel32.inc
include C:\masm32\include\user32.inc
include C:\masm32\include\gdi32.inc
include C:\masm32\include\comctl32.inc
include C:\masm32\include\comdlg32.inc
include C:\masm32\include\th32.inc
include pefile.inc 

includelib kernel32.lib
includelib user32.lib
includelib gdi32.lib
includelib comctl32.lib
includelib comdlg32.lib
includelib TH32.lib

; ========================================================================

DlgProc proto :HWND, :UINT, :WPARAM, :LPARAM
ascii2dword proto :DWORD,:DWORD
GetBaseAddressFromPID proto :DWORD

; ========================================================================

; -----------------------------------------------
; Constantes del dilogo de edicin de secciones
; -----------------------------------------------
IDE_VSIZE               EQU    1201
IDE_REVAD               EQU    1202
IDE_DS                  EQU    1203
IDE_DO                  EQU    1204
IDE_CHAR                EQU    1205

; ======================================================================

 	.data

Col1	db "Tarea",0
Col2	db "IDP",0
Col3	db "IDM",0
Col4	db "Hilos",0
Col5	db "ID padre",0

Col6	db "Mdulo", 0
Col7	db "Dir", 0
Col8	db "Tamao", 0

template 	 db "%08lX",0

szStrTerminate   db  "Terminar Proceso",0
szStrRefresh     db  "Refrescar",0
szStrPartialDump db  "Volcado parcial", 0
szStrPEInfo      db  "PE info", 0
szStrClose       db  "Cerrar",0

msg_70          db   'No es un archivo PE.', 0
msg_71		db   'Problemas al intentar obtener el punto de entrada del proceso', 0
msg_72          db   'No se pudo cargar el proceso', 0

FilterStr1 	db   "Archivos ejecutables ( *.exe, *.dll, *.ocx)", 0
		db   "*.exe; *.dll; *.ocx", 0, 0

CaptionStr 	db   'Estudio de Procesos, por  n u M I T_o r',0
StrDlg 		db   'TreeDlg',0

; ========================================================================

	.data?
pinfo 		 PROCESS_INFORMATION <>
sui   		 STARTUPINFO <>

hInst 		 HINSTANCE ?
hProcess         dd ?

flg_0 		 dd ?
temp_dword       dd ?
hMainWnd         dd ?
oldlistviewproc	 dd ?
@hListView	 dd ?
@pMem		 dd ?
init		 dd ?
ListViewID	 dd ?

buffer 		 db   256 dup (?)
buff2            db    10 dup (?)
szStr   	 db    64 dup (?)

SectHeaderSize   dd ?
pSectHeader      dd ?
ImageBase        dd ?
NumberOfSections dw ?

; ========================================================================

	.code
entry:
; ----------------------------
; Salvar el handle del mdulo
; ----------------------------
	invoke	GetModuleHandle,0
        mov	hInst,eax
; ---------------------------
; Iniciar dilogo principal
; ---------------------------
	invoke	DialogBoxParam,hInst,10000,0,addr DlgProc,0
	invoke	ExitProcess,eax
; -----------------------------------------
; Iniciar controles comunes: para listview
; -----------------------------------------
	invoke	InitCommonControls

; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
; DlgProc procedure
; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DlgProc proc uses edi esi hDlg:HWND, msg:UINT, wParam:WPARAM, lParam:LPARAM 
local lppe:PROCESSENTRY32, hSnapshot:DWORD, i:DWORD, hListView:DWORD
local lvcolumn:LV_COLUMN, lvitem:LV_ITEM, pt:POINT, hMenu:DWORD
local ProcessID:DWORD, uCode:DWORD, me32:MODULEENTRY32

; ***************************** WM_INITDIALOG ******************************

	mov	eax,msg
        cmp	eax, WM_INITDIALOG
	jne	o1
; ----------------------------------
; Llenar la estructura OPENFILENAME
; ----------------------------------
	mov	ofn.lStructSize, SIZEOF ofn
	push	hDlg
        pop	ofn.hwndOwner
        push	hInst
        pop	ofn.hInstance
	mov	ofn.Flags, OFN_EXPLORER or OFN_LONGNAMES or OFN_HIDEREADONLY
	mov	ofn.lpstrTitle, 0
	mov	ofn.nMaxFile, 256
; -----------------------------
; Refrescar controles listview
; -----------------------------
	push	0
	push	hDlg
	call	RefreshListview
.if init==0
	inc	init
	mov	lvitem.iItem, 0
	mov	lvitem.iSubItem, 0
	mov	lvitem.state, 3
	mov	lvitem.stateMask, 3
	lea	eax, lvitem
	push	eax
	push	0
	push	LVM_SETITEMSTATE
	push	100
	push	hDlg
	call	SendDlgItemMessage
.endif
	jmp	o5	

; ************************** WM_NOTIFY ************************************

o1:	cmp 	eax, WM_NOTIFY
	jne 	o2	
	mov 	eax, lParam
	mov 	ecx, (NM_LISTVIEW ptr [eax]).hdr.code
	mov	edx, (NM_LISTVIEW ptr [eax]).hdr.idFrom
	.if cx==NM_RCLICK && (edx==100 || edx==101)
		; ----------------------------------------
		; Obtener el estado del item seleccionado
		; ----------------------------------------
		mov	ListViewID, edx
		mov	ecx, (NM_LISTVIEW ptr [eax]).iItem
		mov	lvitem.iItem, ecx
		mov	lvitem.iSubItem, 0
		mov	lvitem.imask, LVIF_STATE
		mov	lvitem.stateMask, 3
		lea	eax, lvitem
		push	eax
		push	0
		push	LVM_GETITEM
		push	edx
		push	hDlg
		call	SendDlgItemMessage
		; -------------------------------
		; Ha sido seleccionado el item?
		; -------------------------------
		mov	eax, lvitem.state
		cmp	eax, 3
		jne	o5
		; ------------------------------------------------
		; Ha sido seleccionado. Crear un me emergente
		; ------------------------------------------------
		call	CreatePopupMenu
		.if eax!=0
		  ; -----------------------------------------------------
		  ; Si se cre un men, agregar el texto a los elementos
		  ; -----------------------------------------------------
			xor	ebx, ebx
			mov	edi, 204

			push	offset szStrClose
			push	edi
			push	ebx
			push	eax

			mov	esi, ebx
			push	ebx
			dec	ebx
			push	ebx
			push	MF_SEPARATOR
			push	eax

			push	offset szStrPEInfo
			dec	edi
			push	edi
			push	esi
			push	eax

			push	offset szStrPartialDump
			dec	edi
			push	edi
			push	esi
			push	eax

			push	offset szStrRefresh
			dec	edi
			push	edi
			push	esi
			push	eax

			push	offset szStrTerminate
			dec	edi
			push	edi
			push	esi
			push	eax
			mov	esi, eax

			mov	edi, AppendMenu
			mov	ebx, 6
@q001:			call	edi
			dec	ebx
			jne	@q001
	  ; -------------------------------
	  ; Obtener la posicin del cursor
	  ; -------------------------------
			invoke	GetCursorPos, addr pt
	  ; ----------------
	  ; iniciar el men
	  ; ----------------
		  	invoke	TrackPopupMenu, esi, TPM_LEFTALIGN or TPM_RIGHTBUTTON,\ 
                               		pt.x, pt.y, 0, hDlg, NULL 
	  ; -----------------------
	  ; Liquidar el men
	  ; -----------------------
		  	invoke	DestroyMenu, esi
			invoke	DestroyMenu, hMenu          
		.endif

	.elseif	cx==LVN_ITEMCHANGED
		mov	ecx, (NM_LISTVIEW ptr [eax]).uNewState
		mov	edx, (NM_LISTVIEW ptr [eax]).hdr.idFrom
		.if ecx==3 && edx==100
		; -----------------------------
		; Obtener el item seleccionado
		; -----------------------------
			mov	ecx, (NM_LISTVIEW ptr [eax]).iItem
			mov	lvitem.iItem, ecx
			mov	lvitem.iSubItem, 1
			mov	lvitem.imask, LVIF_TEXT
			lea	edi, buffer
		; ---------------
		; Obtener el IDP 
		; ---------------
			call	ZeroBuffer
			mov	lvitem.pszText, edi
			mov	lvitem.cchTextMax, 9
			lea	eax, lvitem
			push	eax
			push	0
			push	LVM_GETITEM
			push	100
			push	hDlg
			call	SendDlgItemMessage
			push	offset temp_dword
			push	edi
			call	ascii2dword
		; -------------------------
		; Obtener el primer mdulo
		; -------------------------
			push	eax
			push	TH32CS_SNAPMODULE
			call	CreateToolhelp32Snapshot
			cmp	eax, -1
			je	o5
			mov	hSnapshot, eax
			mov	me32.dwSize, sizeof me32
        		lea	esi, me32
        		mov	dword ptr [esi], sizeof MODULEENTRY32
        		invoke	Module32First, eax, esi
        		or	eax, eax
			jne	s11
			invoke  SendDlgItemMessage, hDlg, 101, LVM_DELETEALLITEMS, eax, eax
			jmp	r11
		; ------------------------------
		; Llenar la estructura LV_ITEM
		; ------------------------------
s11:			mov	lvitem.imask, LVIF_TEXT
			mov	lvitem.iItem, 0
		; ------------------------------
		; Limpiar el control listview
		; ------------------------------
			push	101
			push	[ebp+8]
			call	GetDlgItem
			push	0
			push	0
			push	LVM_DELETEALLITEMS
			push	eax
			call	SendMessage
		; ------------------------
		; Insertar primer elemento
		; ------------------------
r10:			lea	esi, me32.szModule
			lea	edi, buffer
			call	ZeroBuffer
			invoke	lstrlen, esi
			inc	eax
			invoke	lstrcpyn, edi, esi, eax
			mov	lvitem.pszText, edi

			push	101
			push	hDlg
			call	GetDlgItem
			mov	esi, lvitem.iItem
			mov	ecx, 4
			mov	edx, LVM_SETITEM
			lea	ebx, lvitem

b12:			push	ebx
			push	esi
			push	edx
			push	eax
			dec	ecx		
			jne	b12

			mov	edx, LVM_INSERTITEM
			push	ebx
			push	esi
			push	edx
			push	eax
			mov	lvitem.iSubItem, 0
			mov	ebx, SendMessage
			call	ebx
		; ------------------------------
		; Insertar siguientes elementos
		; ------------------------------
			inc	lvitem.iSubItem
			call	ZeroBuffer
			invoke	wsprintf, edi, addr template, me32.th32ProcessID
			call	ebx

			inc	lvitem.iSubItem
			call	ZeroBuffer
			invoke	wsprintf, edi, addr template, me32.th32ModuleID
			call	ebx

			inc	lvitem.iSubItem
			call	ZeroBuffer
			invoke	wsprintf, edi, addr template, me32.modBaseAddr
			call	ebx

			inc	lvitem.iSubItem
			call	ZeroBuffer
			invoke	wsprintf, edi, addr template, me32.modBaseSize
			call	ebx
	; -----------------------------
	; Obtener el siguiente proceso
	; -----------------------------
			push	me32.th32ProcessID
   			invoke	Module32Next, hSnapshot, addr me32
			pop	ecx
			test	eax, eax
			je	r11
			cmp	ecx, me32.th32ProcessID
			jne	r11
			inc	lvitem.iItem
			jmp	r10
	; --------------------------------------------------
	; Verrar el manejador del snapshot
	; --------------------------------------------------
r11:			invoke	CloseHandle, hSnapshot
		.endif
	.endif
	jmp	o5

; **************************** WM_COMMAND *******************************
	
o2: 	cmp eax, WM_COMMAND
	jne o3
	mov eax,wParam
	.if ax==200
; ====================
; Terminar el proceso
; ====================
	; ----------------------------------------
	; obtener el ID del proceso desde el item
	; ----------------------------------------
		invoke	SendDlgItemMessage, hDlg, 100, LVM_GETNEXTITEM, -1, LVNI_ALL or LVNI_SELECTED
		mov	lvitem.iItem, eax
		mov	lvitem.imask, LVIF_TEXT
		lea	edi, buffer
		invoke	RtlZeroMemory, edi, 256
		mov	lvitem.pszText, edi
		mov	lvitem.cchTextMax, 9
		mov	lvitem.iSubItem,1
		invoke	SendDlgItemMessage, hDlg, 100, LVM_GETITEM, 0, addr lvitem
		invoke	ascii2dword, edi, addr ProcessID
	; ---------------------------------
	; obtener el manejador del proceso
	; ---------------------------------
		invoke	OpenProcess, PROCESS_ALL_ACCESS, 0, ProcessID
		mov	hProcess, eax
	; ----------------------
	; Terminar el proceso
	; ----------------------
		invoke	GetExitCodeProcess, hProcess, addr uCode
		invoke	TerminateProcess, hProcess, uCode
		invoke	CloseHandle, eax
		invoke	SendMessage, hDlg, WM_INITDIALOG, 0, 700

	   .elseif ax==201
; ===================
; Refrescar la lista
; ===================
refresh:	push	1
		push	hDlg
		call	RefreshListview	

	   .elseif ax==202
; ================
; Volcado parcial
; ================
	; ----------------------------------------
	; obtener el ID del proceso desde el item
	; ----------------------------------------
		invoke	SendDlgItemMessage, hDlg, 100, LVM_GETNEXTITEM, -1, LVNI_ALL or LVNI_SELECTED
		mov	lvitem.iItem, eax
		mov	lvitem.imask, LVIF_TEXT
		lea	edi, buffer
		invoke	RtlZeroMemory, edi, 256
		mov	lvitem.pszText, edi
		mov	lvitem.cchTextMax, 9
		mov	lvitem.iSubItem,1
		invoke	SendDlgItemMessage, hDlg, 100, LVM_GETITEM, 0, addr lvitem
		invoke	lstrcpy, addr buff2, edi
	; ---------------------------------------------
	; obtener el nombre del mdulo desde este item
	; ---------------------------------------------
		invoke	RtlZeroMemory, edi, 256
		mov	lvitem.cchTextMax, 256
		mov	lvitem.iSubItem, 0
		invoke	SendDlgItemMessage, hDlg, 100, LVM_GETITEM, 0, addr lvitem

		push	hDlg
		call	IsPartialDump

	.elseif ax==203
; ================================
; Desplegar info sobre secciones
; ================================
	; ----------------------------------------
	; obtener el ID del proceso desde el item
	; ----------------------------------------
		invoke	SendDlgItemMessage, hDlg, 100, LVM_GETNEXTITEM, -1, LVNI_ALL or LVNI_SELECTED
		mov	lvitem.iItem, eax
		mov	lvitem.imask, LVIF_TEXT
		lea	edi, buffer
		call	ZeroBuffer
		mov	lvitem.pszText, edi
		mov	lvitem.cchTextMax, 9
		mov	lvitem.iSubItem,1
		invoke	SendDlgItemMessage, hDlg, 100, LVM_GETITEM, 0, addr lvitem
		invoke	ascii2dword, edi, addr ProcessID
	; ------------------------------------------
	; obtener la direccin base de este proceso
	; ------------------------------------------
		; ---------------------------------------------
		; obtener el nombre del mdulo desde este item
		; ---------------------------------------------
		call	ZeroBuffer
		mov	lvitem.cchTextMax, 256
		mov	lvitem.iSubItem, 0
		invoke	SendDlgItemMessage, hDlg, 100, LVM_GETITEM, 0, addr lvitem
		; --------------------
		; obtener la base
		; --------------------
		invoke	GetBaseAddressFromPID, ProcessID
		or	eax, eax
		jne	_going

		push	30h
		push	offset titulo
		push	offset msg_71
		push	[ebp+8]
		call	MessageBox
		jmp	o5

_going:		mov	esi, eax
		mov	ImageBase, eax
		invoke	OpenProcess, PROCESS_ALL_ACCESS, 0, ProcessID
		mov	hProcess, eax
		; -------------------
		; Es un archivo pe?
		; -------------------
		push	esi
		add	esi, 03Ch              
		lea	edi, i
		invoke	ReadProcessMemory, hProcess, esi, edi, 4, addr temp_dword
		pop	esi
		add	esi, i
		invoke	ReadProcessMemory, hProcess, esi, edi, 4, addr temp_dword
                mov	eax, i
		cmp	ax, 'EP'
		je	is_pe2
		invoke	MessageBox, 0, addr msg_70, addr CaptionStr, 30h
                invoke	CloseHandle, hProcess
		jmp	o5
		; -------------------------------
		; Obtener el nmero de secciones
		; -------------------------------
is_pe2:		push	esi
		add	esi, 6      
		lea	edx, NumberOfSections
		invoke	ReadProcessMemory, hProcess, esi, edx, 2, addr temp_dword
		; -----------------------------------
		; Obtener el encabezado de secciones
		; -----------------------------------
		pop    esi
		add    esi, sizeof IMAGE_FILE_HEADER + sizeof IMAGE_OPTIONAL_HEADER + 4
		mov    pSectHeader, esi
		mov    ax, NumberOfSections
		mov    ecx, 28h
		mul    ecx
		mov    SectHeaderSize, eax
		push   eax
		invoke VirtualAlloc, 0, eax, MEM_COMMIT, PAGE_READWRITE
		mov    edi, eax
		mov    pMem, eax
		pop    eax
		invoke ReadProcessMemory, hProcess, esi, edi, eax, addr temp_dword
		mov    esi, edi

		push   hDlg
		pop    temp_dword

		push   esi
		push   offset SectInfoProc
		push   hDlg
		push   1002
		push   hInst
		Call   DialogBoxParamA

                invoke CloseHandle, hProcess
		invoke VirtualFree, esi, 0, MEM_RELEASE
		jmp o5
y4:
	.elseif ax==3001
; ================ 
; Cargar proceso
; =================
             	push	hDlg
              	pop	hMainWnd
	; ------------------------
	; Cargarlo desde otro hilo
	; ------------------------
              	xor	eax, eax
              	push	offset temp_dword
              	push	eax
              	push	eax
              	push	offset create_proc
              	push	eax
	      	push	eax
	      	call	CreateThread
		push	eax
		call	CloseHandle

	.elseif ax==204
; ==========================
; Cerrar la caja de dilogo
; ==========================
		jmp	_Close_

	.elseif ax==IDCANCEL
		jmp	_Close_

	.endif
; **************************** WM_CLOSE *******************************
		
o3:	cmp	eax, WM_CLOSE
	jne	o4
_Close_:
	invoke	EndDialog, hDlg, 0
	jmp	o5

o4:	xor	eax,eax
	ret

o5:	xor	eax,eax
	inc	al
        ret

o40:    mov	flg_0, 1
        jmp	o4

DlgProc endp

; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

create_proc:
; ----------------------------------
; Llenar la estructura OPENFILENAME
; ----------------------------------
	push	offset FilterStr1 ;  ->"Modules ( *.exe, *.dll, *.ocx)"
	pop	ofn.lpstrFilter
	lea	edi, buffer
	Call	ZeroBuffer
	mov	ofn.lpstrFile, edi
; -----------------------
; Seleccionar un programa
; -----------------------
	push	offset ofn
	call	GetOpenFileName
	or	eax, eax
	je	l0
; ------------------
; Iniciar el proceso
; ------------------
	; --------------------------------
	; Llenar la estructura STARTUPINFO 
	; --------------------------------
	lea	esi, pinfo
	push	esi
	lea	esi, sui
	push	esi
	call	GetStartupInfo
	mov	sui.dwFlags, STARTF_USESHOWWINDOW
	mov	sui.wShowWindow, SW_SHOWMINIMIZED
	; ------------------
	; Iniciar el proceso
	; ------------------
	xor	eax, eax
	push	esi
	push	eax
	push	eax
	push	NORMAL_PRIORITY_CLASS
	push	eax
	push	eax
	push	eax
	push	edi
	push	eax
	call	CreateProcess
	or	eax, eax
	jne	l0
	; --------------------------
	; Algo no sali bien: avisar
	; --------------------------
	push	30h
	push	offset titulo
	push	offset msg_72
	push	0
	call	MessageBox
	xor	eax, eax
	ret
	; -------------------------------
	; Refrescar la listview principal
	; -------------------------------
l0:     push	700
	push	0
	push	WM_INITDIALOG
	push	hMainWnd
	call	SendMessage

	push	hMainWnd
	call	BringWindowToTop
	xor	eax, eax
	inc	al
	ret

; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

GetBaseAddressFromPID proc uses ebx esi edi PID:DWORD
local me32:MODULEENTRY32
	invoke	CreateToolhelp32Snapshot, TH32CS_SNAPMODULE, PID
	or	eax, eax
	je	@fail
	mov	me32.dwSize, sizeof me32
	lea	esi, me32
	mov	ebx, eax
      	invoke	Module32First, eax, esi
	or	eax, eax
	je	@fail
	mov	eax, me32.th32ProcessID
	mov	edi, PID
	.while eax!=edi
		invoke	Module32Next, ebx, esi
		or	eax, eax
		je	@fail
		mov	eax, me32.th32ProcessID
	.endw
	push	me32.modBaseAddr
	invoke	CloseHandle, ebx
	pop	eax
@fail:	ret
GetBaseAddressFromPID endp

; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

RefreshListview	proc	uses esi edi ebx hDlg:DWORD, Param:DWORD

; --------------------------------------------------------------------------

local lppe:PROCESSENTRY32, hSnapshot:DWORD, hListView:DWORD
local lvcolumn:LV_COLUMN, lvitem:LV_ITEM, me32:MODULEENTRY32, i:DWORD

; --------------------------------------------------------------------------

	mov	ebx, hDlg
; -----------------------------
; Limpiar el control list view
; -----------------------------
	invoke	SendDlgItemMessage, ebx, 100, LVM_DELETEALLITEMS, 0, 0
	invoke	SendDlgItemMessage, ebx, 101, LVM_DELETEALLITEMS, 0, 0
; -------------------------------------------
; Get the ListView control handle
; Obtener el manejador del control listview
; -------------------------------------------
	invoke	GetDlgItem, ebx, 100
	mov	hListView, eax
	.if Param==0
		mov	lvcolumn.imask, LVCF_FMT+LVCF_SUBITEM+LVCF_TEXT+LVCF_WIDTH
		mov	lvcolumn.fmt, LVCFMT_CENTER

		mov	esi, eax
		lea	edi, lvcolumn
		mov	ebx, LVM_INSERTCOLUMN
		mov	eax, 3
		mov	ecx, 4

b0:		push	edi
		push	eax
		push	ebx
		push	esi
		dec	eax
		dec	ecx
		jne	b0

		mov	ebx, SendMessage

		mov	lvcolumn.lx, 232
		mov	lvcolumn.pszText, offset Col1
		call	ebx

		mov	lvcolumn.lx, 72
		mov	lvcolumn.pszText, offset Col2
		call	ebx

		mov	lvcolumn.pszText, offset Col3
		call	ebx

		mov	lvcolumn.pszText, offset Col5
		call	ebx

      		invoke	GetDlgItem, hDlg, 101
		mov	ebx, LVM_INSERTCOLUMN
		mov	edx, 4
		mov	ecx, 5

b1:		push	edi
		push	edx
		push	ebx
		push	eax
		dec	edx
		dec	ecx
		jne	b1

		mov	ebx, SendMessage

		mov	lvcolumn.lx, 140
		mov	lvcolumn.pszText, offset Col6
		call	ebx

		mov	lvcolumn.lx, 80
		mov	lvcolumn.pszText, offset Col2
		call	ebx

		mov	lvcolumn.pszText, offset Col3
		call	ebx

		mov	lvcolumn.pszText, offset Col7
		call	ebx

		mov	lvcolumn.pszText, offset Col8
		call	ebx
	.endif
; ------------------------------
; Agregar elementos al control
; -----------------------------
	; -----------------------------------------------
	; Obtener informacin sobre los procesos activos
	; -----------------------------------------------
		; ---------------
		; Primer proceso
		; ---------------
p2:		mov	i, 0
		invoke	CreateToolhelp32Snapshot, TH32CS_SNAPPROCESS, 0
		mov	hSnapshot, eax
		lea	ecx, lppe
		mov	dword ptr [ecx], sizeof lppe
op3:		invoke	Process32First, eax, ecx
		test	eax,eax
		je	r1
		mov	lvitem.imask, LVIF_TEXT
		mov	lvitem.iItem, 0
		; ------------------------
		; Insertar primer elemento
		; ------------------------
r0:		lea	esi, lppe.szExeFile
		lea	edi, buffer
		call	ZeroBuffer
		invoke	lstrlen, esi
		inc	eax
		invoke	lstrcpyn, edi, esi, eax
		mov	lvitem.pszText, edi

		mov	esi, lvitem.iItem
		mov	ecx, 3
		mov	edx, LVM_SETITEM
		lea	eax, lvitem
		mov	ebx, hListView
		
b2:		push	eax
		push	esi
		push	edx
		push	ebx
		dec	ecx		
		jne	b2

		mov	edx, LVM_INSERTITEM
		push	eax
		push	esi
		push	edx
		push	ebx
		lea	edi, buffer
		mov	lvitem.iSubItem, 0
		mov	ebx, SendMessage
		call	ebx
		; ------------------------------
		; Insertar siguientes elementos
		; ------------------------------
		inc	lvitem.iSubItem
		call	ZeroBuffer
		invoke	wsprintf, edi, addr template, lppe.th32ProcessID
		call	ebx

		inc	lvitem.iSubItem
		call	ZeroBuffer
		invoke	wsprintf, edi, addr template, lppe.th32ModuleID
		call	ebx

		inc	lvitem.iSubItem
		call	ZeroBuffer
		invoke	wsprintf, edi, addr template, lppe.th32ParentProcessID
		call	ebx
	; -----------------------------
	; Obtener el siguiente proceso
	; -----------------------------
		invoke	Process32Next, hSnapshot, addr lppe
		test	eax,eax
		je	r1
		inc	lvitem.iItem
		jmp	r0
	; --------------------------------------------------
	; Si es refrescar, cerrar el manejador del snapshot
	; --------------------------------------------------
r1:		invoke	CloseHandle, hSnapshot
		ret
RefreshListview	endp

; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

include PartialDump.asm
include SectInf.asm
include general.asm

; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

end entry

; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


