; ******************************************************************
;
;                       SelectAndMapFile procedure
;                         ----------------------
;
; Este procedimiento permite al usuario seleccionar un archivo, y 
; crea y proyecta este archivo en memoria.
; Devuelve en eax la direccin donde fue proyectado y en ecx el
; tamao del archivo.
; 
; parmeteros: uFileSize: DWORD - [ebp+08h]
;              FLAG:      DWORD - [ebp+0Ch]
; 
; El parmetro FLAG debe ser NULL para abrir el archivo y TRUE para
; salvarlo.
;
; ******************************************************************


	.data?
	ofn OPENFILENAME <?>

; =========================================================================

	.data
FilterStr  db   "*.*", 0, "*.*", 0, 0
Msg100	   db	"No se pudo abrir el archivo", 0
Msg6	   db   "Ya existe un archivo con este nombre", 10, 13
           db   "Deseas sobreescribirlo?", 0

CapStr	   db   'Process Viewer', 0

; =========================================================================

	.code
SelectAndMapFile:
	push	ebp                
	mov	ebp, esp
	sub	esp, 0Ch

	pushad

; ----------------------------------
; Llenar la estructura OPENFILENAME
; ----------------------------------
	push	offset FilterStr ;  ->"All files (*.*)"
	pop	ofn.lpstrFilter
	lea	edi, buffer
	Call	ZeroBuffer
	mov	ofn.lpstrFile, edi
	; ----------
	; is abrir?
	; ----------
	cmp	dword ptr [ebp+0Ch], 0 ; IS_OPEN equ 0
	jne	is_save
	; ---------------------------------
	; es abrir: seleccionar un archivo
	; ---------------------------------
	push	offset ofn
	Call	GetOpenFileNameA
	test	eax, eax
	jne	@@seled
	popad
	xor	eax, eax
	leave
	ret 8

; -----------------
; Abrir el archivo
; -----------------
@@seled:
	push	0
	push	0
	push	3
	push	0
	push	3
	push	0C0000000h
	push	edi
	Call	CreateFileA
	cmp	eax, -1
	jne	@@created

	push	030h
	push	offset CapStr
	push	offset Msg100
	push	0
	Call	MessageBoxA
	popad
	xor	eax, eax
	leave
	ret 0008

	; -----------------------------
	; Es salvar datos en un archivo
	; -----------------------------
is_save:
	push	offset ofn
	Call	GetSaveFileNameA
	or	eax, eax
	jne	@@selected
	popad
	xor	eax, eax
	leave
	ret 8

@@selected:
	mov edi, 1
@@create:
	push	0
	push	0
	push	edi
	push	0
	push	3
	push	0C0000000h
	push	offset buffer
	Call	CreateFileA
	cmp	eax, -1
	jne	@@01

	push	034h
	push	offset CapStr
	push	offset Msg6
	push	0
	Call	MessageBoxA
	cmp	eax, 7
	je	@@ret01
	inc	edi
	jmp	@@create

@@ret01:
	popad
	xor	eax, eax
	leave
	ret 0008

@@created:
	cmp	dword ptr [ebp+08], 0
	jne	@@01

	push	eax
	
	push	0
	push	eax
	Call	GetFileSize
	mov	dword ptr [ebp+08], eax

	pop	eax

@@01:	mov	dword ptr [ebp-04], eax
	mov	edi, dword ptr [ebp+08]
	push	0
	push	edi
	push	0
	push	4
	push	0
	push	[ebp-04]
	Call	CreateFileMappingA
	push	eax
	push	[ebp-04]
	Call	CloseHandle
	pop	eax
	push	eax
	push	edi
	push	0
	push	0
	push	6
	push	eax
	Call	MapViewOfFile
	mov	dword ptr [ebp-04], eax
	pop	eax
	push	eax
	Call	CloseHandle
	popad
	mov	eax, dword ptr [ebp-04]
	mov	ecx, dword ptr [ebp+08]
	leave
	ret 8


; =========================================================================
; ZeroBuffer procedure: limpia un buffer de 256 bytes de tamao
; edi: puntero al buffer
; =========================================================================
ZeroBuffer:
	push	edi
	xor	eax, eax
	mov	ecx, 40h
	rep	stosd
	pop	edi
	ret

; ======================================================================
; DisableDlgItem and EnableDlgItem procedures
;
; =======================================================================

DisableDlgItem:
	push	ebx
	xor	ebx, ebx
	jmp	@e00

EnableDlgItem:
	push	ebx
	xor	ebx, ebx
	inc	bl
@e00:	push	esi
	push	edi
	call	GetDlgItem
	push	ebx
	push	eax
	call	EnableWindow
	pop	ebx
	ret

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

HexToInt PROC uses esi edi ebx StringOffset:DWORD
local n:dword
	invoke	lstrlen, StringOffset
	test 	eax, eax
	jz	EndHTI
; ----------------------------
; Convert from ascii to dword
; Convertir de ascii a dword
; ---------------------------
	mov	ebx, eax
	lea	eax, n
	push	eax
	push    StringOffset
	call	ascii2dword

	xor	esi, esi
@001:	mov	ecx, 4
	mov	eax, ebx
	dec	eax
	xor	edx, edx
	mul	ecx
	mov	ecx, eax

	mov	eax, n
	shr	eax, cl
	and	eax, 0000000Fh

	mov	ecx, ebx
	dec	ecx
	or	ecx, ecx
	je	@003

	push	eax
	mov	eax, 10
	mov	edi, eax
@002:	mul	edi
	loop	@002


	mov	ecx, 10
	div	ecx

	pop	ecx
	mul	ecx

@003:	add	esi, eax
	dec	ebx
	jne	@001

	mov	eax, esi

EndHTI:
	ret
	
HexToInt ENDP

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
; This procedure convert a string of 8 bytes maximun to a DWORD value
; Parameters:
;    pBuffer:DWORD - pointer to the buffer with the string
;    pdwordValue:DWORD - pointer to a DWORD variable that recives the data
; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

ascii2dword proc pBuffer:DWORD,pdwordValue:DWORD
        push	esi	 	; save these registers (0)
        push	edi	 	;	               (1)
	mov	esi, pBuffer
        mov	edi, pdwordValue
	mov	dword ptr [edi], 0
        invoke	lstrlen, esi    ; get the string size
	mov	ecx, eax 
        dec	eax
        add	esi, eax        ; point to the end of the string
        std	      		; move from the end of the string     
a0:     mov	edx, 2
a1:     lodsb	    		; move a character to al
        cmp	al,39h          ; is a number?
        jg	a2	        ; jump if is not number
        sub	al,30h          ; convert character to hex value
        jmp	a3		; move to the DWORD variable
a2:     sub	al,37h          ; letter hex ascii to hex byte       
a3:     cmp	dl,2	 	; is the second character?
        jl	a4	    	; yes, move to the DWORD variable
        mov	byte ptr [edi], al  ; move the hex value to the DWORD variable
        cmp	cl, 1	   	; is the last character
        jle	a5

        dec	dl
        loop	a1		; get next character

a4:     shl	al, 4
        xor	byte ptr [edi], al	; move the second hex value to variable  
        inc	edi 
        loop	a0	  	; get next two characters
; --------------------------------------------------------------
; Desplazar el dato a su posicin correcta en la variable DWORD
; --------------------------------------------------------------
a5:     cld
a6:     mov	eax, pdwordValue
	mov	eax, [eax]
        pop	edi	 	; recover the pushed registers (1)
        pop	esi	 	;		  (0)
        ret 
ascii2dword endp

; ======================================================================
;	            dword2ascii procedure
; ======================================================================

dword2ascii:  push ebp
	mov	ebp, esp
	pushad
	mov	eax, dword ptr [ebp+08h] ; DWORD
	mov	edi, dword ptr [ebp+0Ch] ; buffer

	push	eax

	shr	eax, 10h
	xor	edx, edx
	mov	dl, 4
	; ------------------------------------------------
	; Convert the high byte: the first two high values
	; ------------------------------------------------
i00:    mov	bl, ah
	mov	ecx, 2
	; ---------------------
	; Get the highest value
	; ---------------------
	shr	bl, 04
	; ----------
	; Is letter?
	; ----------
i01:    cmp	bl, 09
        jg	i02		
	; ------------------------------------------
	; Is not letter, is number; convert to ascii
	; ------------------------------------------
	add	bl, 30h
	jmp	i03
        ; ---------------------------
        ; Is letter; convert to ascii
        ; ---------------------------
i02:    add	bl, 37h
        ; --------------------------------
	; Move this value to string buffer
	; --------------------------------
i03:    mov	byte ptr [edi], bl
	inc	edi
        ; ----------
        ; next value
	; ----------
	mov	bl, ah
	and	bl, 0Fh
	loop	i01
	; -------------------
	; Has been converted?
	; -------------------
	dec	dl
	je	i05
	; -----------------------
	; No. Is the low word?
	; -----------------------
	cmp	dl, 02
	je	i04
	; -----------------------------------------
	; No. Convert the low byte of the high word
	; -----------------------------------------
	mov	ah, al
	jmp	i00
	; ------------------------------------------------------
	; The high word has been converted: convert the low word
	; ------------------------------------------------------
i04:    pop	eax
	push	eax
	jmp	i00

i05:    pop	eax
	mov	byte ptr [edi], 0
	popad
	; -----------
	; return true
	; -----------
	xor	eax, eax
	inc	eax
	leave
	ret 8


; *******************************************************************************
; Por este procedimiento pasarn todos los mensajes dirigidos a los controles de
; captura de bytes. Se encargar de filtrar los caracteres hexadecimales y pasarlos
; a maysculas. En caso de introducir un caracter no hexadecimal no se le pasa al 
; procedimiento original. 
; ********************************************************************************
Filtro proc hWindow:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM 
mov	eax, hWindow
.if eax==hwed
	mov	edx, _wndproc
.else
	mov	edx, wndproc
.endif
.if uMsg==WM_CHAR	 ; Se ha pulsado una tecla -> la filtro
    mov eax, wParam
    .if (eax>=30h && eax<=39h) || (eax>='a' && eax<='f') || (eax>='A' && eax<='F') || al==VK_BACK 
       .if (eax>='a' && eax<='f')   
           sub eax, 20h         ; Si es un caracter hexad. en minusculas lo paso a mayusculas
       .endif
       invoke CallWindowProc, edx, ; Llamo al procedimiento original con el caracter 
		  hWindow, ; filtrado.
		  uMsg,
		  eax,
		  lParam
   .endif      
.else	            ; Procesado del resto de mensajes -> no hago nada
    invoke CallWindowProc, edx,
	             hWindow,
	             uMsg,
	             wParam,
	             lParam
.endif
ret

Filtro endp

; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

DecFilter proc hW:DWORD, uM:DWORD, wP:DWORD, lP:DWORD
.if uM==WM_CHAR	 ; Se ha pulsado una tecla -> la filtro
    mov eax, wP
    .if (eax>=30h && eax<=39h) || al==VK_BACK 
	    mov wP, eax
    .else
	    ret
    .endif
.endif	            ; Procesado del resto de mensajes -> no hago nada
    invoke CallWindowProc, _wndproc, hW, uM, wP, lP
ret
DecFilter endp


