; =========================================================================
   TITLE LOADERGEN.ASM: Ejemplo de cargador que parchea un proceso remoto

; 			by  n u M I T_o r
; 		    numit_or@subdimension.com
; 	    http://members.nbci.com/numit_or/asm.html
; =========================================================================

	.386
	.model flat, stdcall

; =========================================================================

include windows.inc
include kernel32.inc
include user32.inc

includelib kernel32.lib
includelib user32.lib

; =========================================================================

	.code
start:
; ------------------------------------- 
; Obtener la direccin de LoadLibraryA 
; -------------------------------------
	; --------------------------------------
	; Obtener la direcccin de kernel32.dll
	; --------------------------------------
	lea  eax, @kernel32
	push eax
	call GetModuleHandle
	or   eax, eax
	je   @70
	mov  @krn32, eax
	push eax
	; ---------------------------------------------------
	; Escribir la direccin de LoadLibraryA en el parche 
	; ---------------------------------------------------
	mov  esi, GetProcAddress
	lea  ecx, @LoadLibrary
	push ecx
	push eax
	call esi
	or   eax, eax
	jne  _a

	pop  eax
	push 30h
	push offset capt
	push offset msg1
	push 0
	call MessageBox
	jmp  @70

_a:	mov @LoadLib, eax
; -------------------------------------
; Escribir la direccin de FreeLibrary
; -------------------------------------
	lea  ecx, @FreeLibraryStr
	pop  eax
	push ecx
	push eax
	call esi
	or   eax, eax
	jne  _b

	push 30h
	push offset capt
	push offset msg2
	push 0
	call MessageBox
	jmp  @70

_b:	mov  @FreeLibrary, eax
; ------------------------------------
; Escribir la direccin de MessageBox
; ------------------------------------
	mov  eax, MessageBox
	mov  eax, [eax+2]
	mov  eax, [eax]
	mov  @MessageBox, eax	
; -------------------------------------
; Escribir la direccin de ExitProcess
; -------------------------------------
	mov  eax, ExitProcess
	mov  eax, [eax+2]
	mov  eax, [eax]
	mov  @ExitProcess, eax
; ----------------------------------
; Reservar espacio para estructuras
; ----------------------------------
	mov eax, sizeof STARTUPINFO + sizeof PROCESS_INFORMATION + 16
	push eax
	push 0
	call GlobalAlloc
        mov  esi, eax
; ----------------------------------------------------------
; Proyectar la dll en la memoria para guardar en ella datos
; ----------------------------------------------------------
	lea eax, @DLLName
	invoke CreateFile, eax, GENERIC_READ or GENERIC_WRITE, 0, 0,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0
	cmp eax, -1
        je @6

	push eax
	invoke CreateFileMapping, eax, 0, PAGE_READWRITE, 0, 0, 0
	pop  ecx
	push eax
	push ecx
	call CloseHandle
	pop  eax
	push eax
	invoke MapViewOfFile, eax, FILE_MAP_ALL_ACCESS, 0, 0, 0
	test eax, eax
	jne  @7

	call CloseHandle
	jmp  @6

@7:     mov  pFile, eax
        call CloseHandle
; ----------------------------------------------
; Obtener el punto de entrada del proceso remoto
; ----------------------------------------------
	; ---------------------------------------------
	; Abrir y proyectar el archivo con el programa
	; ---------------------------------------------
	lea  eax, @FileName
	invoke CreateFile, eax, GENERIC_READ or GENERIC_WRITE, 0, 0,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0
	cmp eax, -1
        jne  _op
@no:	push pFile
	call UnmapViewOfFile
	jmp  @6

_op:	push eax
	invoke CreateFileMapping, eax, 0, PAGE_READWRITE, 0, 0, 0
	pop  ecx
	push eax
	push ecx
	call CloseHandle
	pop  eax
	push eax
	invoke MapViewOfFile, eax, FILE_MAP_ALL_ACCESS, 0, 0, 0
	test eax, eax
	jne  @7_

	call CloseHandle
	jmp  @no

@7_:	mov  edi, eax
	add  eax, [eax+3Ch]
	; ----------------------------
	; Obtener la base de la imagen
	; ----------------------------
	mov  edx, [eax+4+14h+1Ch]
	; ---------------------------------
	; Obtener RVA del punto de entrada
	; ---------------------------------
	mov  eax, [eax+4+14h+10h]
	; -----------------------
	; Convertir the RVA en VA
	; -----------------------
	add  eax, edx
	mov  @EntryPoint, eax
	; ------------------
	; Cerrar el archivo
	; ------------------
	call CloseHandle
	push edi
	call UnmapViewOfFile
; ------------------------------------------------
; Crear el nuevo proceso para extraer datos de l
; ------------------------------------------------
@8:	push esi
	call GetStartupInfo

	mov  edi, esi
	add  edi, sizeof STARTUPINFO

	xor  ebx, ebx

	push edi
	push esi
	push ebx
	push ebx
	push CREATE_SUSPENDED
	push ebx
	push ebx
	push ebx
	push offset @FileName
	push ebx
	call CreateProcess
	test eax, eax
	je   @6
; -------------------------------------------------------------
; Obtener el tamao del bloque a escribir en el proceso remoto
; -------------------------------------------------------------
@4:	mov  SnpSize, (offset @3 - offset @0)
; --------------------------------------------------------
; Obtener la direccin de la dll donde se guardarn datos
; --------------------------------------------------------
	mov  ecx, pFile
	; ----------------------------
	; Obtener la base de la imagen
	; ----------------------------
	push ecx
	add  ecx, [ecx+3Ch]
	mov  edx, [ecx+4+14h+1Ch]
	; ----------------------------------------------------
	; Obtener un puntero a la base de la seccin de datos
	; ----------------------------------------------------
	mov  eax, [ecx+4+14h+0E0h+50h+28h+14h]
	pop  ecx
	add  eax, ecx
; --------------------------------------------
; Revisar si la dll ya tiene los datos nuevos
; --------------------------------------------
;	cmp  byte ptr [eax], 0
;	jne  @ya
; -------------------------------------------------------------------
; Poner datos importantes al inicio de la seccin de datos de la dll
; -------------------------------------------------------------------
	; -----------------
	; Punto de entrada
	; -----------------
	push @EntryPoint
	pop  dword ptr [eax]
	; ---------------------------------------
	; Tamao del bloque de datos a modificar
	; ---------------------------------------
	push SnpSize
	pop  dword ptr [eax+4]
	; ------------------
	; Base de la imagen
	; ------------------
	push edx
	pop  dword ptr [eax+8]
  
	push eax

	push 12
	push eax
	call FlushViewOfFile
; -------------------------------------------------------------------------
; Salvar los datos originales del proceso a la dll para restaurarlos luego
; -------------------------------------------------------------------------
	; -----------------------------------------------------------------
	; Obtener un puntero a un espacio de la seccin de datos de la dll 
	; -----------------------------------------------------------------
	pop  ebx
	add  ebx, 0Fh
	; -------------------------------------------------
	; Mover los datos originales del programa a la dll 
	; -------------------------------------------------
	push offset temp_dword
	push SnpSize
	push ebx
	push @EntryPoint
	push dword ptr [edi]
	call ReadProcessMemory
	or   eax, eax
	jne  _yes

	push 0
	push offset capt
	push offset msg3
	push 0
	call MessageBox
	jmp  no_readed

_yes:	push SnpSize
	push ebx
	call FlushViewOfFile

@ya:	push pFile
	call UnmapViewOfFile
; -------------------------------------------------------------------
; Escribir en el proceso la llamada que cargar la dll en su espacio
; -------------------------------------------------------------------
@5:	push offset old_value
	push 40h
	push SnpSize
	push @EntryPoint
	push dword ptr [edi]
	call VirtualProtectEx

	lea  edx, @temp
        mov  ebx, SnpSize
	push edx
	push ebx
	lea  esi, @0
	push esi
	push @EntryPoint
	push dword ptr [edi]
	call WriteProcessMemory
	
	push ebx
	push dword ptr [edi]
	call FlushInstructionCache

	push offset old_value
	mov  eax, old_value
	push eax
	push SnpSize
	push @EntryPoint
	push dword ptr [edi]
	call VirtualProtectEx
; -----------------------------------------
; Reanudar el proceso y cerrar manejadores
; -----------------------------------------
no_readed:
	push dword ptr [edi+4]
	call ResumeThread

	push dword ptr [edi+4]
        call CloseHandle

	push dword ptr [edi]
        call CloseHandle

@6:	push esi
	call GlobalFree
; -------------------
; Cerrar el cargador
; -------------------
@70:	push 0
	call ExitProcess

; :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

@kernel32 	db 'kernel32.dll', 0
@user32		db 'user32.dll', 0
@LoadLibrary 	db 'LoadLibraryA', 0
@FreeLibraryStr db 'FreeLibrary', 0
@FileName       db 'NOTEPAD.EXE', 0
msg1		db 'Error al intentar obtener la dir. de LoadLibrary', 0
msg2		db 'Error al intentar obtener la dir. de FreeLibrary', 0
msg3		db 'Error al intentar leer en el proceso remoto',0
capt		db 'ERROR!!!', 0
@krn32		dd 0
temp_dword	dd 0
@EntryPoint     dd 0
pFile		dd 0
@temp		dd 0
old_value	dd 0
SnpSize		dd 0

; ======================== PARCHE ==========================

@0:   call @1
@1:   pop ebp
      sub ebp, offset @1
      jmp @2

; -------------------------- DATA ---------------------------

@DLLName	  db 'PATCHER.DLL', 0
@error		  db 'ERROR!', 0
@problem	  db 'Hubo un problema, gulp! (: - (', 0
@LoadLib	  dd 0
@FreeLibrary	  dd 0
@MessageBox	  dd 0
@ExitProcess	  dd 0

; -------------------------- CODE ---------------------------

@2:
	push esi
	push edi

; Cargar la DLL
	mov  eax, [ebp+@LoadLib]
	lea  edx, [ebp+@DLLName]
	push edx
	call eax
	or   eax, eax
	je   @out

; Restaurar instrucciones y arrancar programa al liberar la DLL	
	pop  esi
	pop  edi

	push eax
	mov  eax, [ebp+@FreeLibrary]
	call eax

; Si no se carg la dll, avisar y salir
@out:
	xor  eax, eax
	push eax
	push eax
	lea  ecx, [ebp+@error]
	push ecx
	lea  edx, [ebp+@problem]
	push edx
	push eax
	call [ebp+MessageBox]
	call [ebp+ExitProcess]
@3:

; ------------------------ END OF CODE -----------------------

end start

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
