
; ===============
; = Estructuras =
; ===============

; Encabezado DOS de la imagen. Conservado por compatibilidad con el
; antiguo formato de archivos ejecutables DOS.

_IMAGE_DOS_HEADER   STRUC   
e_magic             DW      ?
e_cblp              DW      ?
e_cp                DW      ?
e_crlc              DW      ?
e_cparhdr           DW      ?
e_minalloc          DW      ?
e_maxalloc          DW      ?
e_ss                DW      ?
e_sp                DW      ?
e_csum              DW      ?
e_ip                DW      ?
e_cs                DW      ?
e_lfarlc            DW      ?
e_ovno              DW      ?
e_res               DW      4 DUP ( ? )
e_oemid             DW      ?
e_oeminfo           DW      ?
e_res2              DW      10 DUP ( ? )
e_lfanew            DD      ?
_IMAGE_DOS_HEADER    ENDS
PIMAGE_DOS_HEADER   TYPEDEF NEAR PTR _IMAGE_DOS_HEADER

; --------------------------------------------------------------------------

; Directorio de secciones de la imagen.
;  

 _IMAGE_DATA_DIRECTORY      STRUC   
VirtualAddress      DD      ?
Size@               DD      ?
_IMAGE_DATA_DIRECTORY       ENDS
PIMAGE_DATA_DIRECTORY       TYPEDEF NEAR PTR _IMAGE_DATA_DIRECTORY

IMAGE_NUMBEROF_DIRECTORY_ENTRIES        EQU     16
IMAGE_SIZEOF_SHORT_NAME                 EQU     8

; --------------------------------------------------------------------------

; Encabezado de la imagen

_IMAGE_FILE_HEADER      STRUC   
Machine                 DW      ?
NumberOfSections        DW      ?       ; No. de secciones
TimeDateStamp           DD      ?
PointerToSymbolTable    DD      ?       ; Dir. de la tabla de simbolos
NumberOfSymbols         DD      ?       ; No. de simbolos
SizeOfOptionalHeader    DW      ?       ; Largo del proximo encabezado
Characteristics         DW      ?
_IMAGE_FILE_HEADER      ENDS
PIMAGE_FILE_HEADER  TYPEDEF NEAR PTR _IMAGE_FILE_HEADER

IMAGE_SIZEOF_FILE_HEADER EQU     20
SIZE_OF_NTSIGNATURE EQU 4

; --------------------------------------------------------------------------

; Encabezado opcional de la imagen

_IMAGE_OPTIONAL_HEADER      STRUC   
  Magic                         WORD       ?
  MajorLinkerVersion            BYTE       ?
  MinorLinkerVersion            BYTE       ?
  SizeOfCode                    DWORD      ?   ; Largo del cdigo
  SizeOfInitializedData         DWORD      ?   ; Largo de datos iniciados
  SizeOfUninitializedData       DWORD      ?   ; Largo de datos no iniciados
  AddressOfEntryPoint           DWORD      ?   ; Dir. del punto de entrada del prog.
  BaseOfCode                    DWORD      ?   ; Dir fisica de la base del cod.
  BaseOfData                    DWORD      ?   ; Dir fisica de los datos
  ImageBase                     DWORD      ?   ; Dir virtual de la base de la img.
  SectionAlignment              DWORD      ?   ; Alineamiento de secc.
  FileAlignment                 DWORD      ?   ; Alinamiento de archivo
  MajorOperatingSystemVersion   WORD       ?
  MinorOperatingSystemVersion   WORD       ?
  MajorImageVersion             WORD       ?
  MinorImageVersion             WORD       ?
  MajorSubsystemVersion         WORD       ?
  MinorSubsystemVersion         WORD       ?
  Win32VersionValue             DWORD      ?
  SizeOfImage                   DWORD      ?
  SizeOfHeaders                 DWORD      ?
  CheckSum                      DWORD      ?
  Subsystem                     WORD       ?
  DllCharacteristics            WORD       ?
  SizeOfStackReserve            DWORD      ?
  SizeOfStackCommit             DWORD      ?
  SizeOfHeapReserve             DWORD      ?
  SizeOfHeapCommit              DWORD      ?
  LoaderFlags                   DWORD      ?
  NumberOfRvaAndSizes           DWORD      ?
  DataDirectory                 IMAGE_DATA_DIRECTORY IMAGE_NUMBEROF_DIRECTORY_ENTRIES dup(<>)
_IMAGE_OPTIONAL_HEADER		ENDS
PIMAGE_OPTIONAL_HEADER      TYPEDEF NEAR PTR _IMAGE_OPTIONAL_HEADER

IMAGE_SIZEOF_ROM_OPTIONAL_HEADER       EQU     56
IMAGE_SIZEOF_STD_OPTIONAL_HEADER       EQU     28
IMAGE_SIZEOF_NT_OPTIONAL_HEADER        EQU     224

; --------------------------------------------------------------------------

; Banderas (flags)

IMAGE_FILE_RELOCS_STRIPPED              EQU     00001h
IMAGE_FILE_EXECUTABLE_IMAGE             EQU     00002h
IMAGE_FILE_LINE_NUMS_STRIPPED           EQU     00004h
IMAGE_FILE_LOCAL_SYMS_STRIPPED          EQU     00008h
IMAGE_FILE_AGGRESIVE_WS_TRIM            EQU     00010h
IMAGE_FILE_BYTES_REVERSED_LO            EQU     00080h
IMAGE_FILE_32BIT_MACHINE                EQU     00100h
IMAGE_FILE_DEBUG_STRIPPED               EQU     00200h
IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP      EQU     00400h
IMAGE_FILE_NET_RUN_FROM_SWAP            EQU     00800h
IMAGE_FILE_SYSTEM                       EQU     01000h
IMAGE_FILE_DLL                          EQU     02000h
IMAGE_FILE_UP_SYSTEM_ONLY               EQU     04000h
IMAGE_FILE_BYTES_REVERSED_HI            EQU     08000h
IMAGE_FILE_MACHINE_UNKNOWN              EQU     0
IMAGE_FILE_MACHINE_I386                 EQU     014ch
IMAGE_FILE_MACHINE_R3000                EQU     0162h
IMAGE_FILE_MACHINE_R4000                EQU     0166h
IMAGE_FILE_MACHINE_R10000               EQU     0168h
IMAGE_FILE_MACHINE_ALPHA                EQU     0184h
IMAGE_FILE_MACHINE_POWERPC              EQU     01F0h
IMAGE_SIZEOF_NT_OPTIONAL_HEADER         EQU     224
IMAGE_NT_OPTIONAL_HDR_MAGIC             EQU     010bh
IMAGE_ROM_OPTIONAL_HDR_MAGIC            EQU     0107h

; --------------------------------------------------------------------------

; Conjunto de encabezados NT

_IMAGE_NT_HEADERS   STRUC   
Signature           DD      ?
FileHeader          _IMAGE_FILE_HEADER          <>
OptionalHeader      _IMAGE_OPTIONAL_HEADER      <>
_IMAGE_NT_HEADERS   ENDS
PIMAGE_NT_HEADERS   TYPEDEF NEAR PTR _IMAGE_NT_HEADERS

; --------------------------------------------------------------------------
; -------------------------------
; Nmero de entrada de directorio
; -------------------------------
IMAGE_DIRECTORY_ENTRY_EXPORT            EQU     0
IMAGE_DIRECTORY_ENTRY_IMPORT            EQU     1
IMAGE_DIRECTORY_ENTRY_RESOURCE          EQU     2
IMAGE_DIRECTORY_ENTRY_EXCEPTION         EQU     3
IMAGE_DIRECTORY_ENTRY_SECURITY          EQU     4
IMAGE_DIRECTORY_ENTRY_BASERELOC         EQU     5
IMAGE_DIRECTORY_ENTRY_DEBUG             EQU     6
IMAGE_DIRECTORY_ENTRY_COPYRIGHT         EQU     7
IMAGE_DIRECTORY_ENTRY_GLOBALPTR         EQU     8
IMAGE_DIRECTORY_ENTRY_TLS               EQU     9
IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG       EQU     10

tag@                UNION   
PhysicalAddress     DD      ?
VirtualSize         DD      ?
tag@                ENDS

; --------------------------------------------------------------------
; Encabezado de seccion de la imagen
; Estructura de una entrada del directorio de secciones de la imagen 
; --------------------------------------------------------------------
IMAGE_SIZEOF_SYMBOL            EQU     18
IMAGE_SIZEOF_SHORT_NAME        EQU     8

_IMAGE_SECTION_HEADER       STRUCT  
Name1               DB      8 DUP ( ? )
VirtualSize         DD      ?
VirtualAddress      DD      ?
SizeOfRawData       DD      ?
PointerToRawData    DD      ?
PointerToRelocations        DD      ?
PointerToLinenumbers        DD      ?
NumberOfRelocations DW      ?
NumberOfLinenumbers DW      ?
Characteristics     DD      ?
_IMAGE_SECTION_HEADER       ENDS
PIMAGE_SECTION_HEADER       TYPEDEF NEAR PTR _IMAGE_SECTION_HEADER

IMAGE_SIZEOF_SECTION_HEADER             EQU     40

; ---------------------------------------
; Atributos de seccion de archivo imagen
; ---------------------------------------
IMAGE_SCN_TYPE_NO_PAD                   EQU     000000008h
IMAGE_SCN_CNT_CODE                      EQU     000000020h
IMAGE_SCN_CNT_INITIALIZED_DATA          EQU     000000040h
IMAGE_SCN_CNT_UNINITIALIZED_DATA        EQU     000000080h
IMAGE_SCN_LNK_OTHER                     EQU     000000100h
IMAGE_SCN_LNK_INFO                      EQU     000000200h
IMAGE_SCN_LNK_REMOVE                    EQU     000000800h
IMAGE_SCN_LNK_COMDAT                    EQU     000001000h
IMAGE_SCN_MEM_FARDATA                   EQU     000008000h
IMAGE_SCN_MEM_PURGEABLE                 EQU     000020000h
IMAGE_SCN_MEM_16BIT                     EQU     000020000h
IMAGE_SCN_MEM_LOCKED                    EQU     000040000h
IMAGE_SCN_MEM_PRELOAD                   EQU     000080000h
IMAGE_SCN_ALIGN_1BYTES                  EQU     000100000h
IMAGE_SCN_ALIGN_2BYTES                  EQU     000200000h
IMAGE_SCN_ALIGN_4BYTES                  EQU     000300000h
IMAGE_SCN_ALIGN_8BYTES                  EQU     000400000h
IMAGE_SCN_ALIGN_16BYTES                 EQU     000500000h
IMAGE_SCN_ALIGN_32BYTES                 EQU     000600000h
IMAGE_SCN_ALIGN_64BYTES                 EQU     000700000h
IMAGE_SCN_LNK_NRELOC_OVFL               EQU     001000000h
IMAGE_SCN_MEM_DISCARDABLE               EQU     002000000h
IMAGE_SCN_MEM_NOT_CACHED                EQU     004000000h
IMAGE_SCN_MEM_NOT_PAGED                 EQU     008000000h
IMAGE_SCN_MEM_SHARED                    EQU     010000000h
IMAGE_SCN_MEM_EXECUTE                   EQU     020000000h
IMAGE_SCN_MEM_READ                      EQU     040000000h
IMAGE_SCN_MEM_WRITE                     EQU     080000000h

; --------------------------------------------------------------------------

; ------------------------------------
; Directorio de recursos de la imagen
; ------------------------------------
_IMAGE_RESOURCE_DIRECTORY           STRUC   
Characteristics     	    DD      ?
TimeDateStamp               DD      ?
MajorVersion                DW      ?
MinorVersion                DW      ?
NumberOfNamedEntries        DW      ?
NumberOfIdEntries           DW      ?
_IMAGE_RESOURCE_DIRECTORY           ENDS
PIMAGE_RESOURCE_DIRECTORY           TYPEDEF NEAR PTR _IMAGE_RESOURCE_DIRECTORY

; ------------------------------------------------
; Estructura de entrada de directorio de recursos
; ------------------------------------------------
_IMAGE_RESOURCE_DIRECTORY_ENTRY         STRUC   
Name@               DD      ?
OffsetToData        DD      ?
_IMAGE_RESOURCE_DIRECTORY_ENTRY         ENDS
PIMAGE_RESOURCE_DIRECTORY_ENTRY         TYPEDEF NEAR PTR _IMAGE_RESOURCE_DIRECTORY_ENTRY


_IMAGE_RESOURCE_DATA_ENTRY              STRUC   
OffsetToData        DD      ?
Size_               DD      ?
CodePage            DD      ?
Reserved            DD      ?
_IMAGE_RESOURCE_DATA_ENTRY              ENDS
PIMAGE_RESOURCE_DATA_ENTRY              TYPEDEF NEAR PTR _IMAGE_RESOURCE_DATA_ENTRY


DIFFERENCE EQU 11  
      
RT_CURSOR  		EQU  	1  
RT_BITMAP  		EQU  	2 
RT_ICON   		EQU  	3 
RT_MENU  		EQU  	4 
RT_DIALOG     		EQU  	5 
RT_STRING   		EQU  	6 
RT_FONTDIR  		EQU  	7 
RT_FONT  		EQU  	8 
RT_ACCELERATOR  	EQU  	9 
RT_RCDATA  		EQU  	10 
RT_MESSAGETABLE   	EQU  	11 
RT_GROUP_CURSOR  	EQU  	RT_CURSOR + DIFFERENCE 
RT_GROUP_ICON  		EQU  	RT_ICON + DIFFERENCE 
RT_VERSION  		EQU  	16 
RT_DLGINCLUDE  		EQU  	17 
RT_PLUGPLAY  		EQU  	19 
RT_VXD  		EQU  	20 
RT_ANICURSOR  		EQU  	21 
RT_ANIICON  		EQU 	22 

_IMAGE_RESOURCE_DIR_STRING_U            STRUC   
Length@             DW      ?
NameString          DW      1 DUP ( ? )
_IMAGE_RESOURCE_DIR_STRING_U            ENDS
PIMAGE_RESOURCE_DIR_STRING_U            TYPEDEF NEAR PTR _IMAGE_RESOURCE_DIR_STRING_U

; --------------------------------------------------------------------------

; Directorio de nombres exportados

_IMAGE_EXPORT_DIRECTORY     STRUC   
Characteristics     DD      ?
TimeDateStamp       DD      ?
MajorVersion        DW      ?
MinorVersion        DW      ?
Name                DD      ?
Base                DD      ?
NumberOfFunctions   DD      ?
NumberOfNames       DD      ?
AddressOfFunctions  DW      NEAR PTR ?
AddressOfNames      DW      NEAR PTR ?
AddressOfNameOrdinals                   DW      NEAR PTR ?
_IMAGE_EXPORT_DIRECTORY     ENDS
PIMAGE_EXPORT_DIRECTORY     TYPEDEF NEAR PTR _IMAGE_EXPORT_DIRECTORY

MAXRESOURCENAME equ	13

; -------------------------------------------------------------------------

; Directorio de nombres importados

_IMAGE_IMPORT_DESCRIPTOR  STRUC   
;  union 
    Characteristics 	dd 	? 
;    OriginalFirstThunk 	dd 	? 
;  ends 
  TimeDateStamp 	dd 	? 
  ForwarderChain 	dd 	? 
  Name1 		dd 	? 
  FirstThunk 		dd 	? 
_IMAGE_IMPORT_DESCRIPTOR  ENDS

PIMAGEIMAGE_IMPORT_DESCRIPTOR          TYPEDEF NEAR PTR _IMAGE_IMPORT_DESCRIPTOR

_IMAGE_IMPORT_BY_NAME STRUCT 
  Hint 		dw 	? 
  Name1 	db 	? 
_IMAGE_IMPORT_BY_NAME ENDS 

; --------------------------------------------------------------------------

_IMAGE_DEBUG_DIRECTORY                  STRUC   
Characteristics     DD      ?
TimeDateStamp       DD      ?
MajorVersion        DW      ?
MinorVersion        DW      ?
Type@               DD      ?
SizeOfData          DD      ?
AddressOfRawData    DD      ?
PointerToRawData    DD      ?
_IMAGE_DEBUG_DIRECTORY      ENDS
PIMAGE_DEBUG_DIRECTORY      TYPEDEF NEAR PTR _IMAGE_DEBUG_DIRECTORY

; --------------------------------------------------------------------------

	; ==========
	; = MACROS =
	; ==========

	NTSIGNATURE MACRO pF
; Devuelve en eax el contenido del campo signatura.
; Pasar como parmetro el puntero a la vista proyectada.
	mov eax,pF
	movzx ebx,word ptr [eax+03Ch] ; eax = offset de la signatura
	add eax,ebx
	movzx eax,word ptr [eax]
	ENDM

	PEFHDROFFSET MACRO pF
; Devuelve en eax un puntero al encabezado PE
; Pasar como parmetro el puntero a la vista proyectada.
	mov eax, pF
	add eax, dword ptr [eax+03Ch] ; eax = offset de la signatura
	add eax, SIZE_OF_NTSIGNATURE ; eax = offset del inicio del encabezado PE
	ENDM

	OPTHDROFFSET MACRO pF
; Devuelve en eax un puntero al encabezado opcional PE
; Pasar como parmetro el puntero a la vista proyectada.
        PEFHDROFFSET pF ; devuelve eax = offset del inicio del encabezado PE
	add eax, IMAGE_SIZEOF_FILE_HEADER
	ENDM

	SECHDROFFSET MACRO pF
; Devuelve en eax un puntero a la tabla de secciones secciones
; Pasar como parmetro el puntero a la vista proyectada.
        OPTHDROFFSET pF ; devuelve eax = offset del inicio del encabezado op.
	add eax, IMAGE_SIZEOF_NT_OPTIONAL_HEADER 
	ENDM
