				TITLE IMPORT.ASM


.386
.model flat,stdcall

include C:\masm32\include\windows.inc
include C:\masm32\include\kernel32.inc
include C:\masm32\include\user32.inc
include C:\masm32\include\comctl32.inc
include C:\masm32\include\comdlg32.inc
include pefile.inc 

includelib kernel32.lib
includelib user32.lib
includelib comctl32.lib
includelib comdlg32.lib

DlgProc proto :HWND, :UINT, :WPARAM, :LPARAM

AddTreeParentItem proto :DWORD,:DWORD
AddTreeChildItem proto :DWORD,:DWORD,:DWORD,:DWORD

ImageDirectoryVA proto :DWORD,:DWORD
ImageDirectoryOffset proto :DWORD,:DWORD
ImageDirectoryPointer proto :LPVOID,:DWORD

	.data?
iibn			_IMAGE_IMPORT_BY_NAME    <?>
iid 			_IMAGE_IMPORT_DESCRIPTOR <?>

hInst 			dd	 	?
hTreeView 		dd 		?
pFile 			dd 		?
NumberOfSections 	dd 		?
ImageBase 		dd 		?
idataVA			dd 		?
idataOffset 		dd 		?
idataPointer 		dd 		?
pArrayFunct		dd 		?
FileName 		db 		256 dup (?)
buffer 			db 		256 dup (?)

	.data
OrdinalTemplate db "%u (ord.)",0
AddressTemplate db "Dir. virtual del thunk: %lX", 0
CaptionStr 	db 'Visor de funciones importadas',0
FilterStr 	db "Todos los archivos (*.*)",0,"*.*",0,0
strTitle 	db 'Dnde est el archivo?',0
SectionName	db '.idata',0

Msg0 		db 'No se pudo abrir el archivo',0
Msg1 		db 'No existe una seccin con ese nombre',0
Msg2 		db 'No se pudo encontrar la seccin de datos importados', 0
Msg6 		db 'No es un archivo con formato ejecutable', 0
Msg7 		db 'No es un archivo con formato pe',0


	.code
entry:
; Save instance handle
	invoke GetModuleHandle,0
	mov hInst, eax
	invoke DialogBoxParam, eax, 10000, 0, addr DlgProc, eax
	invoke ExitProcess,eax
	call InitCommonControls

; #########################################################################
; DlgProc procedure
; #########################################################################
DlgProc proc uses esi edi ebx hDlg:HWND, msg:UINT, wParam:WPARAM, lParam:LPARAM 
	local hFile:DWORD, hMapFile:DWORD, pSectionsTable:DWORD
	local OffsetOfDirEntry:DWORD
	local hTV:DWORD, hParentItem:DWORD, i:DWORD
	local temp[64]:BYTE
	local ofn:OPENFILENAME

	mov eax,msg
        .if eax==WM_INITDIALOG
; -------------------------------
; When the dialog box is created
; To fill the OPENFILENAME struct
; Llenar la estructura OPENFILENAME
; ---------------------------------
	push SIZEOF ofn
	lea  eax, ofn
	push eax
	call RtlZeroMemory
	mov  ofn.lStructSize,SIZEOF ofn
	push hDlg
	pop  ofn.hwndOwner
	push lParam
	pop  ofn.hInstance
	push offset FilterStr
	pop  ofn.lpstrFilter
	mov  ofn.lpstrFile,offset FileName
	mov  ofn.nMaxFile,256
	mov  ofn.Flags,OFN_EXPLORER or OFN_LONGNAMES or OFN_HIDEREADONLY
	mov  ofn.lpstrTitle,offset strTitle
; ---------------------------
; Select a file
; Seleccionar un archivo
; ---------------------------
Other:  invoke GetOpenFileNameA,ADDR ofn
	.if eax==0
; -------
; or exit
; -------
	     jmp _exit
         .endif
; ----------------
; Open the file
; Abrir el archivo
; -----------------
create_it:
	invoke CreateFile,addr FileName,GENERIC_READ or GENERIC_WRITE,\
		FILE_SHARE_READ or FILE_SHARE_WRITE,0,OPEN_EXISTING,0,0
	cmp eax, INVALID_HANDLE_VALUE
	jne opened
	; ---------------------------
        ; It could not open the file
	; No se pudo abrir el archivo
	; ---------------------------
	     jmp _exit
opened:
	mov hFile,eax
; ---------------------------
; Map the object file
; Proyectar el archivo objeto
; ---------------------------
	invoke GetFileSize,eax, 0
        mov edi, eax
	invoke CreateFileMappingA,hFile,0,PAGE_READWRITE,0,0,0 
	mov hMapFile,eax
	invoke CloseHandle, hFile
	invoke MapViewOfFile, hMapFile, 6, 0, 0, edi
	mov pFile, eax
	mov edi, eax
	invoke CloseHandle, hMapFile
; -------------------------
; Revise if is executable
; Revisar si es ejecutable
; -------------------------
y3:     cmp edi, 0
        je no_exe
	cmp word ptr [edi],"ZM"
	je exe@
no_exe:	    invoke  MessageBoxA,hDlg,addr Msg6,addr CaptionStr, MB_ICONWARNING ; -> no exe	
	    jmp _exit
; -----------------
; Revise if is pe
; Revisar si es pe
; -----------------
exe@:	NTSIGNATURE edi
	cmp ax,"EP"
	je pe@
            invoke  MessageBoxA,hDlg,addr Msg7,addr CaptionStr, MB_ICONWARNING ; -> no pe
            jmp _exit
; ----------------------------------------------------------
; Get the Virtual Address of the import section
; Obtener la direccin virtual de la seccin de importacin
; ----------------------------------------------------------
pe@:	invoke ImageDirectoryVA, edi, IMAGE_DIRECTORY_ENTRY_IMPORT
	.if eax == 0
            invoke MessageBoxA,0,ADDR Msg2,ADDR CaptionStr,MB_ICONWARNING
            jmp _exit
        .endif
	mov idataVA, eax
; ----------------------------------------------------------
; Get the offset of the import section
; Obtener el despazamiento de la seccin de importacin
; ----------------------------------------------------------
	invoke ImageDirectoryOffset, edi, IMAGE_DIRECTORY_ENTRY_IMPORT
	.if eax == 0
            invoke MessageBoxA,0,ADDR Msg2,ADDR CaptionStr,MB_ICONWARNING
	    jmp _exit
        .endif
	mov idataOffset, eax
        mov esi, eax
	add esi, pFile
	; ----------------------------------
	; Get the treeview handle
	; Obtener el manejador del treeview
	; ----------------------------------
	  invoke GetDlgItem, hDlg, 100
	  mov hTV, eax
	
	assume esi:ptr _IMAGE_IMPORT_DESCRIPTOR
	.while !(([esi].Characteristics==0) && ([esi].Name1==0) && ([esi].FirstThunk==0))
; ------------------------------
; Display the DLL name
; Desplegar el nombre de la DLL
; ------------------------------
	; Get the offset of the DLL name
	; Obtener el desplazamiento del nombre de la DLL
	  mov ecx, [esi].Name1
	    sub ecx, idataVA
	    add ecx, idataOffset
	    add ecx, pFile
	  invoke AddTreeParentItem, hTV, ecx
	  mov hParentItem, eax
; ---------------------------------------
; Display the functions names
; Desplegar los nombres de las funciones
; ---------------------------------------
		.if [esi].Characteristics==0
		    mov edi, [esi].FirstThunk
		.else
                    mov edi, [esi].Characteristics
		.endif
	; ---------------------------------------------------
	; Get the offset of the function name
	; Obtener el desplazamiento del nombre de la funcin
	; ---------------------------------------------------
	    mov edx, edi
	    sub edx, idataVA
	    add edx, idataOffset
	    add edx, pFile
	    assume edx:ptr IMAGE_IMPORT_BY_NAME
	    mov i, 0
	    .while dword ptr [edx]!=0
		; -------------------------------------------------
		; Is imported by ordilnal?
		; Verificar si la funcin es importada por ordinal
		; -------------------------------------------------
	       test dword ptr [edx], 80000000h
	       jne ImportByOrdinal
		; ----------------------------------
		; No: get the name and show it
		; No: obtener el nombre y mostrarlo
		; ----------------------------------
	       mov ecx, dword ptr [edx]
	       sub ecx, idataVA
	       add ecx, idataOffset
	       add ecx, pFile
	       add ecx, 2
               invoke AddTreeChildItem, hTV, hParentItem, i, ecx
	       push edx
	       push eax
		; --------------------------------------------------
		; Display the address where is the jump to function
		; Desplegar la direccin del salto a la funcin
		; --------------------------------------------------
	       mov  eax, pFile
	       add  eax, [eax+03Ch]
	       and  edi, 0FFFFh
	       add  edi, dword ptr [eax+4+14h+1Ch]
	       invoke wsprintf, addr buffer, addr AddressTemplate, edi
	       pop eax
               pop edx
               invoke AddTreeChildItem, hTV, eax, i, addr buffer
	       jmp NextFunction
; -----------------------------------------------------------
; The function is imported by ordinal: get it and show it
; La funcin es importada por ordinal: obtenerlo y mostrarlo
; -----------------------------------------------------------
ImportByOrdinal: 
	 	mov ecx, dword ptr [edx] 
	 	and ecx, 0FFFFh
	 	push edx
	 	invoke wsprintf, addr temp, addr OrdinalTemplate, ecx 
                invoke AddTreeChildItem, hTV, hParentItem, i, addr temp
	        push eax
		; --------------------------------------------------
		; Display the address where is the jump to function
		; Desplegar la direccin del salto a la funcin
		; --------------------------------------------------
	        mov  eax, pFile
	        add  eax, [eax+03Ch]
	        mov  eax, [eax+4+14h+1Ch]
		and  edi, 0FFFFh
	        add  edi, eax
	        invoke wsprintf, addr buffer, addr AddressTemplate, edi
	        pop eax
                pop edx
                invoke AddTreeChildItem, hTV, eax, i, addr buffer

NextFunction:
	 inc i
	 add edx, 4
	 add edi, 4
	    .endw
	  add esi, sizeof _IMAGE_IMPORT_DESCRIPTOR
	  mov i, 0
	.endw
	  invoke UnmapViewOfFile, pFile
	  assume esi:nothing
	  assume edx:nothing
	  mov eax, 1

.elseif eax==WM_COMMAND
	mov eax, wParam
	.if ax==IDCANCEL
_exit:	   invoke UnmapViewOfFile, pFile
	   invoke EndDialog,hDlg,0
	   xor eax, eax
	.endif
.else
	xor eax,eax
.endif
	ret
DlgProc endp
	



; **************************************************************************
; //////////////////////////////////////////////////////////////////////////
;***************************************************************************

; -------------------------------------------------------------------------
; #########################################################################
;  AddTreeParentItem procedure:
;  Add a parent item to the treeview control
;  Agrega un elemento padre al control treeview
;  	hTree: Treeview handle
;	pStr: address of the string
; #########################################################################
; -------------------------------------------------------------------------

AddTreeParentItem proc uses edx hTree:HWND, pStr:DWORD 
	local tvins:TV_INSERTSTRUCT

; ------------------------------------
; Fill the TV_INSERTSTRUCT structure
; Llenar la estructura TV_INSERTSTRUCT
; ------------------------------------
	mov tvins.item.imask, TVIF_TEXT
	mov tvins.hInsertAfter, TVI_ROOT
	mov tvins.hParent, 0
	push pStr
	pop tvins.item.pszText 
	invoke lstrlen, pStr
	mov tvins.item.cchTextMax, eax
; ---------------------------------
; Insert the parent item
; Insertar el elemento padre
; ---------------------------------
	invoke SendMessage, hTree, TVM_INSERTITEM, 0, addr tvins
	ret
AddTreeParentItem endp


; -------------------------------------------------------------------------
; #########################################################################
;  AddTreeChildItem procedure:
;  Add a child item to the treeview control
;  Agrega u elemento hijo a un control treeview
;  	hTree: Treeview handle
;       hParent: parent item handle
;  	iSI: child item index
;	pStr: address of the string
; #########################################################################
; -------------------------------------------------------------------------

AddTreeChildItem proc uses edx hTree:HWND, hParent:DWORD, iSI:DWORD, pStr:DWORD 
	local tvins:TV_INSERTSTRUCT

; ------------------------------------
; Fill the TV_INSERTSTRUCT structure
; Llenar la estructura TV_INSERTSTRUCT
; ------------------------------------
	mov tvins.item.imask, TVIF_TEXT
        mov tvins.hInsertAfter, TVI_SORT
	push hParent
	pop tvins.hParent
	push pStr
        pop tvins.item.pszText
	invoke lstrlen, pStr
	mov tvins.item.cchTextMax, eax
; -----------------------------------
; Insert the child items
; Insertar los elementos hijos
; -----------------------------------
       invoke SendMessage, hTree, TVM_INSERTITEM, 0, addr tvins
       ret
AddTreeChildItem endp


; -------------------------------------------------------------------------
; #########################################################################
; ImageDirectoryPointer procedure:
; Return in eax a pointer to a section
; Regresa en eax un puntero a una seccin 
;    lpF: Pointer to the memory maped PE file
;           Puntero al archivo PE proyectado en memoria
;    dwIMAGE_DIRECTORY: 
; #########################################################################
; -------------------------------------------------------------------------

ImageDirectoryPointer proc lpF:LPVOID,dwIMAGE_DIRECTORY:DWORD
invoke ImageDirectoryOffset, lpF, dwIMAGE_DIRECTORY
	.if eax!=0
		add eax, lpF
	.endif
	ret
ImageDirectoryPointer endp

; -------------------------------------------------------------------------
; #########################################################################
; ImageDirectoryVA procedure:
; Return in eax the virtual address of a section
; Regresa en eax la direccin virtual de una seccin
;    lpF: Pointer to the memory maped PE file
;           Puntero al archivo PE proyectado en memoria
;    dwIMAGE_DIRECTORY:
; #########################################################################
; -------------------------------------------------------------------------

ImageDirectoryVA proc lpF:DWORD, dwIMAGE_DIRECTORY:DWORD
     local poh:DWORD
     local psh:DWORD
     
      ; -------------------------------------------------
      ; Retrieve pointers to optional and section headers.
      ; ------------------------------------------------- 
     OPTHDROFFSET lpF
     mov poh, eax
     SECHDROFFSET lpF
     mov psh, eax
     ; ---------------------------------------
     ; Must be 0 thru (NumberOfRvaAndSizes-1).
     ; ---------------------------------------
     mov eax, poh
     assume eax:ptr IMAGE_OPTIONAL_HEADER
     mov ecx, dwIMAGE_DIRECTORY
     .if dword ptr [eax].NumberOfRvaAndSizes>ecx 
      ; --------------------------------------------------
      ; Locate image directory's relative virtual address. 
      ; --------------------------------------------------
   	mov eax, dwIMAGE_DIRECTORY
     	mov ecx, poh
      	mov eax, dword ptr [ecx+8*eax+60h]
     .else
     	xor eax, eax
     .endif
      ret
ImageDirectoryVA endp



; -------------------------------------------------------------------------
; #########################################################################
; ImageDirectoryOffset
; Return in eax the offset to raw data of a section
; Regresa en eax el desplazamiento a los daots brutos de una seccin
;    lpF: Pointer to the memory maped PE file
;           Puntero al archivo PE proyectado en memoria
;    dwIMAGE_DIRECTORY: 
; #########################################################################
; -------------------------------------------------------------------------
ImageDirectoryOffset proc lpF:DWORD, dwIMAGE_DIRECTORY:DWORD
     local ImgDirOffset:DWORD
	pushad
	mov ImgDirOffset, 0
	.if dwIMAGE_DIRECTORY<16
	    SECHDROFFSET lpF
	    mov esi, eax
	    invoke ImageDirectoryVA, lpF, dwIMAGE_DIRECTORY
	    .if eax!=0
	    xor edi, edi
	    assume esi:ptr _IMAGE_SECTION_HEADER
	      .while edi<=16
	        mov edx, [esi].SizeOfRawData
	 	add edx, [esi].VirtualAddress
	    	mov ecx, [esi].VirtualAddress
            	.if (eax>=ecx) && (eax<=edx)
			sub eax, [esi].VirtualAddress
	    		add eax, [esi].PointerToRawData
	    		mov ImgDirOffset, eax
			.break
            	.else	        
	    		add esi, IMAGE_SIZEOF_SECTION_HEADER
  	    		inc edi
		.endif
	      .endw
            .endif
	.endif
a3:	popad
	mov eax, ImgDirOffset
	ret
ImageDirectoryOffset endp

end entry


