.386
.model flat,stdcall
option casemap:none
include \masm32\include\windows.inc
include \masm32\include\wsock32.inc
include \masm32\include\comctl32.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comdlg32.inc
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\wsock32.lib
includelib \masm32\lib\comdlg32.lib

WinMain PROTO :DWORD,:DWORD,:DWORD,:DWORD
EnableControls PROTO
DisableControls PROTO
StrCpy PROTO :DWORD, :DWORD
StrLen PROTO :DWORD
InString PROTO :DWORD,:DWORD
InStringi PROTO :DWORD,:DWORD
TranslateErrorCode PROTO :DWORD, :DWORD
ParseURL PROTO :DWORD
String2Dword PROTO :DWORD
ParseHeader PROTO :DWORD
ConnectSocket PROTO
GetFileName PROTO :DWORd
ManageInitialization PROTO
ReconnectIfPossible PROTO
ShowErrorMessage PROTO
ShowSocketError PROTO
ShowProgress PROTO :DWORD
GetErrorString PROTO :DWORD
WriteInitialData PROTO 
CreateNewFile PROTO
ShowDownloadSpeed PROTO
WriteOutputFile PROTO :DWORD,:DWORD
CloseSock PROTO
SendRequest PROTO
ClearMessages PROTO :DWORD,:DWORD
CreateOutputFile PROTO
FillMultipartHeader PROTO
SetStatusText PROTO :DWORD, :DWORD
ReadSocket PROTO
ParseAllHeaders PROTO
CloseTheSock PROTO
ActualClose PROTO

.data
ClassName db "WINSOCKDLG",0
AppName  db "Win32asm HTTP Download version 1.5",0
MenuName db "WinSock",0
URLDialogName db "URLDialog",0
MainDialog db "MAINDLG",0
IconName db "http",0
;********************************************************************
;                               Error Messages
;********************************************************************
NoContent db "Document doesn't have any content",0
BadRequest db "Bad Request: The request header is not understandable by the server",0
OpenError db "Cannot Open Output File for write",0
Unauthorized db "You're not authorized to get this resource",0
Forbidden db "You're forbidden to access this resource",0
NotFound db "404: Object not found",0
NotAcceptable db "No resource in the form acceptable by this program",0
Gone db "The resource is no longer in this server",0
Undefined db "Undefined HTTP error",0
ServerError db "Server error",0
NetworkNotReady db "No network connection",0
InvalidVersion db "No winsock 1.1 support by current winsock dll",0
ServerBusy db "The server is busy. Retry later",0
CreateError db "Cannot Create the output file",0
WriteError db "Cannot Write to output file",0

;*********************************************************************
;                               Templates for wsprintfA
;*********************************************************************
Downloading db "Currently Downloaded: %lu bytes",0
FilePrompt db "%s already exists. Resume the download?",0
OverwritePrompt db "%s already exists. Overwrite the file?",0
GetTemplate db "GET %s HTTP/1.0",0dh,0ah
            db "Host: %s",0Dh,0Ah
            db "Range: bytes=%lu-",0Dh,0Ah
            db "User-Agent: IczelionDownLoad",0Dh,0Ah
            db "Connection: Close",0Dh,0Ah
            db "Accept: text/*,image/*,application/*,*/*",0Dh,0Ah,0dh,0ah,0
SpeedTemplate db "%lu.%.2lu kb/s",0
WaitingForReply db "Host: %s contacted. Waiting for reply...",0             
ResolvingServer db "Resolving URL: %s",0
Connecting db "Connecting to : %s",0
;****************************************************************
;                               Buffers
;****************************************************************
HostName db 100 dup(?),0
RelativeURL db 400 dup(?),0     
CommandString db 512 dup(?),0   ; The buffer to store the command to send to the web server
FileName db 256 dup(?),0        ; The name of the file to be downloaded
URLString db 512 dup(?),0
PortString db 10 dup(?),0       ; the string indicating HTTP port in the url
StatusCode db 3 dup(?),0        ; HTTP response code
ContentString db 10 dup(?),0    ; String containing the length of the file
HTTPHeader db 512 dup(?),0      ; HTTP response header
MultipartHeader db 512 dup(?),0 ; Buffer to store the multipart http header
ErrorString db 512 dup(?),0     ; The buffer to receive the error message

;*****************************************************************
;                       Reference strings
;*****************************************************************
Multipart db "multipart/",00
ContentRange db "Content-Range:",0
AcceptRanges db "accept-ranges:",0
Location db "location:",0
FilterString db "All Files",0,"*.*",0
             db "Text Files",0,"*.txt",0   
             db "HTML files",0,"*.html",0
             db "Zip Archive",0,"*.zip",0,0
AboutMessage db "Win32asm HTTP Download version 1.5",0Dh,0Ah
             db "Written by Iczelion",0Dh,0Ah
             db "Web page: http://win32asm.cjb.net",0Dh,0Ah
             db "Special thanks: hutch (wonderful include files)",0
HTTP db "http://",0
Content db "content-length:",0

;*****************************************************************
;                       Miscellaneous
;*****************************************************************
StartingOffset dd 0             ; file offset of the remote file to start download from
PartWidth dd 250,-1             ; dimension of the status panels
CloseString db "The connection is closed",0
DefaultName db "index.html",0           ; Default document name
Dots db "...",0                 ; used in case url is too long to display on the window

.data?
;****************************************************************
;                               Structures
;****************************************************************
ofn   OPENFILENAME <>
wsadata WSADATA <>
SocketAddress sockaddr_in <>
;**********************************************************************
;                               Handles
;**********************************************************************
hInstance DWORD ?               ; Instance handle
sock DWORD ?                    ; socket handle
hwndStatus dd ?                 ; The handle to the status window
hwndConnectButton dd ?          ; The handle to the connect button
hMenu dd ?                      ; The handle to the menu
hwnd dd ?                       ; handle to the main window
mHandle dd ?                    ; Handle to the memory block to store data read in from the socket
buffer dd ?                     ; Address of the above memory block
FileHandle dd ?                 ; output file handle

;**********************************************************************
;                               Flags
;**********************************************************************
WaitingForName db ?             ; 1= Waiting for the user to input the output file name
CloseConnection db ?            ; 1= the connection is already closed
Redirection db ?                ; 1= redirection on
MultipartHeaderParsed db ?      ; TRUE=multipart header is parsed
CanResume db ?                  ; FALSE=The server cannot resume download
MultipartPresent db ?           ; TRUE=multipart header is present
HeaderParsed db ?               ; FALSE==Http header is not accounted for
Resuming db ?                   ; FALSE=This connection is not for resuming

;***********************************************************************
;                               Other variables
;***********************************************************************
TimerID dd ?                    ; ID of the timer
FirstDataOffset dd ?            ; Address of the first byte of actual data in the buffer (immediately after http header)
sizetoread dd ?                 ; size of data available for read from the socket
OriginalTickCount dd ?          ; Number of tick counts at the start of download
ActualDataRead dd ?             ; Current tick counts
HTTPPort dd ?                   ; the port that's used to connect to HTTP server
StatusValue dw ?                ; The numeric value of StatusCode
ContentLength dd ?              ; the size of the file
MultipartIndex dd ?             ; Index of the first unused byte in MultipartHeader
HeaderIndex dd ?                ; Index of the first unused byte in HTTPHeader
CurrentDataSize dd ?            ; The amount of data read from the socket
BytesWritten dd ?               ; numbers of bytes actually written to the output file


.CONST
IDM_CONNECT equ 1003
IDM_EXIT equ 1002
IDM_ABOUT equ 1004

IDC_CONNECT equ 1000
IDC_EXIT equ 1001
IDC_NAME equ 1004
IDC_EDIT1 equ 3000
IDC_OK equ 3001
IDC_CANCEL equ 3002
IDC_PROGRESS equ 3003
IDC_STATUS equ 3004

WM_SOCKET equ WM_USER+100h

.code                           
start:
        invoke GetModuleHandle, NULL
        mov    hInstance,eax
        invoke WinMain, hInstance,NULL,NULL, SW_SHOWDEFAULT
        invoke ExitProcess,eax

WinMain proc hInst:DWORD,hPrevInst:DWORD,CmdLine:DWORD,CmdShow:DWORD
        LOCAL wc:WNDCLASSEX
        LOCAL msg:MSG
        mov   wc.cbSize,SIZEOF WNDCLASSEX
        mov   wc.style, CS_HREDRAW or CS_VREDRAW
        mov   wc.lpfnWndProc, OFFSET WndProc
        mov   wc.cbClsExtra,NULL
        mov   wc.cbWndExtra,DLGWINDOWEXTRA
        push  hInstance
        pop   wc.hInstance
        mov   wc.hbrBackground,COLOR_BTNFACE+1
        mov   wc.lpszMenuName,OFFSET MenuName
        mov   wc.lpszClassName,OFFSET ClassName
        invoke LoadIcon,hInstance,addr IconName
        mov   wc.hIcon,eax
        mov   wc.hIconSm,0
        invoke LoadCursor,NULL,IDC_ARROW
        mov   wc.hCursor,eax
        invoke RegisterClassEx, addr wc
        invoke CreateDialogParam,hInstance,addr MainDialog,NULL,NULL,NULL
        mov   hwnd,eax
        INVOKE ShowWindow, hwnd,SW_SHOWNORMAL
        INVOKE UpdateWindow, hwnd
        invoke InitCommonControls
        invoke GetDlgItem,hwnd,IDC_CONNECT
        mov hwndConnectButton,eax
        invoke SetFocus,eax
        invoke GetMenu,hwnd
        mov hMenu,eax
        mov eax,1000
        shl eax,16
        invoke SendDlgItemMessage,hwnd,IDC_PROGRESS,PBM_SETRANGE,NULL,eax
        invoke SendDlgItemMessage,hwnd,IDC_PROGRESS,PBM_SETPOS,0,NULL
        invoke WSAStartup,101h,ADDR wsadata   ; Initialize the window socket dll
        .if eax==NULL
                .WHILE TRUE
                        INVOKE GetMessage, ADDR msg,NULL,0,0
                        .BREAK .IF (!eax)
                        invoke IsDialogMessage,hwnd,addr msg
                        .if eax==FALSE
                                INVOKE TranslateMessage, ADDR msg
                                INVOKE DispatchMessage, ADDR msg
                       .endif
                .ENDW
                mov eax,TRUE
                .while eax==TRUE
                        invoke WSACleanup
                        .if eax==SOCKET_ERROR
                                invoke GetErrorString,addr ErrorString
                                .if eax!=WSANOTINITIALISED
                                        invoke MessageBox,NULL,addr ErrorString,addr AppName,MB_OK
                                .endif
                                .break
                        .endif
                        mov eax,TRUE                
                .endw
        .else
                .if eax==WSASYSNOTREADY
                        invoke MessageBox,hwnd,addr NetworkNotReady,addr AppName,MB_OK+MB_ICONERROR
                .else
                        invoke MessageBox,hwnd,addr InvalidVersion,addr AppName,MB_OK+MB_ICONERROR
                .endif                                                  
        .endif
        mov     eax,msg.wParam
        ret
WinMain endp

WndProc proc hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
        mov   eax,uMsg
        .IF eax==WM_DESTROY
                .if sock!=0         ; check if the socket was closed
                                    ; close it if it was not.
                        invoke CloseSock
                .endif
                invoke PostQuitMessage,NULL
        .ELSEIF eax==WM_TIMER
                invoke ShowDownloadSpeed
        .ELSEIF eax==WM_CREATE
                invoke CreateStatusWindow,WS_CHILD+WS_VISIBLE+SBARS_SIZEGRIP,NULL,hWnd,IDC_STATUS     ; Create the status bar
                mov hwndStatus,eax      ; Create the status bar
                invoke SendMessage,hwndStatus,SB_SETPARTS,2,addr PartWidth
        .ELSEIF eax==WM_SOCKET
                mov eax,lParam
                .if ax==FD_CONNECT      ; if the socket is connected
                        push eax
                        pop eax
                        shr eax,16      ; If there is an error during connect process, the error code is returned in the high word of lParam                        
                        .if ax==NULL    ; If there is no error, proceed to send the request
                                invoke SendRequest
                        .else
                                invoke ReconnectIfPossible
                        .endif                                
                .elseif ax==FD_READ
                        shr eax,16      ; Check if there is an error code in the high word of lParam
                        .if eax==0
                                invoke ReadSocket
                        .else
                                invoke ShowSocketError
                        .endif
                .elseif ax==FD_CLOSE    ; When the connection is closed from the other end, it marks the end of the file
                        shr eax,16
                        .if eax==0      ; Check if there is some error
                                invoke CloseTheSock
                        .else
                                .if eax==WSAECONNRESET || eax==WSAECONNABORTED
                                        invoke CloseTheSock
                                .else
                                        invoke ShowSocketError
                                .endif
                        .endif
               .endif                                
        .ELSEIF eax==WM_COMMAND
                mov eax,wParam
                .if lParam==0
                        .if ax==IDM_CONNECT     ; When the user presses connect button or connect menu item.
                                mov Resuming,FALSE      ; Assume that the server cannot resume download
                                mov FileHandle,0        ; We use the value of FileHandle to check whether the file was closed
                                mov TimerID,0           ; We use the value of TimerID in the same manner as FileHandle
                                mov eax,OFFSET URLProc
                                invoke DialogBoxParam,hInstance,addr URLDialogName,hWnd,eax,0
                                .if eax==TRUE           ; If the user types in a url
                                        invoke ConnectSocket
                                .endif
                        .elseif ax==IDM_EXIT
                                invoke DestroyWindow,hWnd
                        .else
                                invoke MessageBox,hWnd, addr AboutMessage, addr AppName,MB_OK or MB_ICONINFORMATION
                        .endif
                .else
                        .if ax==IDC_CONNECT
                                invoke SendMessage,hWnd,WM_COMMAND,IDM_CONNECT,0
                        .elseif ax==IDC_EXIT
                                invoke DestroyWindow,hWnd
                        .endif
                .endif
        .ELSE
                invoke DefWindowProc,hWnd,uMsg,wParam,lParam
                ret
        .ENDIF
        xor eax,eax
        ret
WndProc endp
;======================================================================
;                       ShowSocketError
;======================================================================
; This procedure is called to display the error message on the screen in
; case of FD_CONNECT, FD_READ and FD_CLOSE notification.
;======================================================================
ShowSocketError PROC
        invoke TranslateErrorCode,eax,addr ErrorString
        invoke MessageBox,NULL,addr ErrorString,addr AppName,MB_OK+MB_ICONERROR
        invoke CloseSock
        invoke EnableControls
        ret
ShowSocketError ENDP

;========================================================================
;                           URLProc
;========================================================================
;  This is the dialog procedure of the dialog that receives url from the 
;  user
;========================================================================
URLProc PROC hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
        .if uMsg==WM_CLOSE
                invoke EndDialog,hDlg,0
        .elseif uMsg==WM_INITDIALOG
                mov wParam,IDC_EDIT1       ; Set the focus to the edit control
        .elseif uMsg==WM_COMMAND
                mov eax,wParam
                .if ax==IDC_OK
                        shr eax,16
                        .if ax==BN_CLICKED      ; If the user clicks ok button
                                invoke GetDlgItemText,hDlg,IDC_EDIT1,addr URLString,512
                                .if eax!=0   ; If the user doesn't type in some string, don't close the dialog box
                                        invoke EndDialog,hDlg,1
                                .else
                                        invoke GetDlgItem,hDlg,IDC_EDIT1
                                        invoke SetFocus,eax
                                .endif
                        .endif
                .elseif ax==IDC_CANCEL
                        shr eax,16
                        .if ax==BN_CLICKED
                                invoke SendMessage,hDlg,WM_CLOSE,0,0
                        .endif
                .endif
        .else
                mov eax,FALSE
                ret
        .endif
        mov eax,TRUE
        ret
URLProc ENDP
;======================================================================
;                               String2Dword
;======================================================================
; This procedure takes an address of a string and converts it to a dword
; value which it returns in eax
;======================================================================
String2Dword proc uses ecx edi edx esi String:DWORD
        xor ecx,ecx
        mov edi,String
        invoke lstrlen,String
        .while eax!=0
                xor edx,edx
                mov dl,byte ptr [edi]
                sub dl,"0"      ; subtrack each digit with "0" to convert it to hex value
                mov esi,eax
                dec esi
                push eax
                mov eax,edx
                push ebx
                mov ebx,10
                .while esi > 0
                        mul ebx
                        dec esi
                .endw
                pop ebx
                add ecx,eax
                pop eax
                inc edi
                dec eax
        .endw
        mov eax,ecx
        ret
String2Dword endp

;======================================================================
;                               ParseHeader
;======================================================================
; This procedure takes the address of HTTP header and finds the file size
;======================================================================
ParseHeader PROC uses esi ecx edi Header:DWORD
        LOCAL MyHeader[512]:BYTE
        invoke lstrcpy,addr MyHeader,Header
        invoke CharLower,addr MyHeader ; Convert the http header to lower case
        .if Resuming==FALSE     ; in the case that we resume download, we don't have to
                                ; search the header for content length again
                invoke lstrlen,addr MyHeader
                mov ecx,eax
                lea edi,MyHeader          ; begin searching for "content-length:"
Rescan:
                mov al,"c"              ;   by scanning for its first char, "c"
                repne scasb
                jne  NoLength           ; If not found, something is wrong
                push ecx                ; If "c" is found, it's still not certain
                                ;   that it's the start of the
                                ;   "content-length:" string. So we must
                                ;   save all registers so that we can
                                ;   resume scanning.
                push edi
                dec  edi                ; move back to the "c" character
                mov ecx,15              ; 15 --> the length of "content-length:"
                mov esi,offset Content
                repe cmpsb              ; compare if the string that starts with "c"
                                ; is identical to "content-length"
                mov  esi,edi            ; save edi which points to the first byte
                                ; of the length (if it's "content-length")
                pop  edi
                pop  ecx
                jne  Rescan             ; if the strings didn't match, rescan the http header
                mov edi,offset ContentString
                .while (byte ptr [esi]!=0Dh)
                        .if byte ptr [esi]!=20h
                                mov al,byte ptr [esi]
                                mov byte ptr [edi],al
                                inc edi
                        .endif
                        inc esi
                .endw
                mov byte ptr [edi],0
                invoke String2Dword,addr ContentString
                mov ContentLength,eax
        .endif
Find_status_code:
        invoke lstrlen,addr MyHeader
        mov ecx,eax
        lea edi,MyHeader
        mov al," "
        repne scasb
        .if byte ptr [edi]==" "
                repe scasb
                dec edi
        .endif
        mov ecx,3
        mov esi,edi
        mov edi,offset StatusCode
        rep movsb
        mov eax,TRUE
        ret
NoLength:
        mov  ContentLength,0
        jmp  Find_status_code
Unsuccessful:
        mov eax,FALSE
        ret
ParseHeader endp

;=========================================================================
;                               ParseURL
;=========================================================================
; This function parses the url string for host name, relative URL and http
; port
;-------------------------------------------------------------------------
ParseURL PROC uses esi edi URL:DWORD
        LOCAL MyURL[512]:BYTE
        LOCAL URLLength:DWORD

        invoke lstrlen,URL
        mov URLLength,eax
        mov ecx,eax             ; Trim the spaces at the start of the url string, if any
        mov edi,URL
        mov al,20h
        repe scasb
        dec edi
        invoke lstrcpy,addr MyURL,edi           ; We don't want to modify the original url string since we have to modify the cases of the url
        invoke lstrcpy,URL,addr MyURL
        invoke lstrlen,URL
        mov URLLength,eax
        invoke RtlFillMemory,addr HostName,501,0   ; fill HostName and RelativeURL with zeroes
        invoke CharLower,addr MyURL             ; change to lower case for ease of comparison
        lea edi,MyURL
        mov esi,offset HTTP             ; check if the url starts with "http://"
        mov ecx,7
        repe cmpsb
        jne No_HTTP
        mov eax,URLLength       ; if it is, substract the length of url string by 7 to
        sub eax,7               ; account for the length of "http://" string
        mov URLLength,eax
        jmp Common_parse
No_HTTP:
        lea edi,MyURL
Common_parse:
        push edi
        invoke lstrcpy,addr MyURL,URL
        pop edi
        xor ecx,ecx
        mov esi,offset HostName
        mov HTTPPort,80         ; Default port =80
        .while ecx < URLLength
                .if byte ptr [edi]=="/"         ; if "/" is found, it denotes the end of the host name string
                        invoke lstrcpy,addr RelativeURL,edi     ; and the start of the relative url string
                        .break
                .elseif byte ptr [edi]==":"     ; if ":" is found, it means an HTTP port is specified in the url
                        inc ecx
                        inc edi
                        invoke RtlFillMemory,addr PortString,10,0
                        mov eax,offset PortString
                        .while (byte ptr [edi]!="/") && (byte ptr [edi]!=0)
                                mov dl,byte ptr [edi]
                                mov byte ptr [eax],dl
                                inc eax
                                inc ecx
                                inc edi
                        .endw
                        invoke String2Dword,addr PortString
                        mov HTTPPort,eax
                .else
                        mov al,byte ptr [edi]
                        mov byte ptr [esi],al
                        inc edi
                        inc esi
                        inc ecx
                .endif
        .endw
        .if ecx==URLLength      ; if there's no relative URL , we must add "/" to it.
                mov byte ptr [RelativeURL],"/"
        .endif
        ret
ParseURL endp
;==========================================================================
;                                GetFileName
;==========================================================================
; This function searches the url string for the last "/" character. If "/"
; is found, it's assumed that the file name follows "/" character.
;--------------------------------------------------------------------------
GetFileName proc URL:DWORD
        invoke RtlFillMemory,addr FileName,256,0
        invoke lstrlen,URL
        std               ; We will search for "/" in reverse direction
        mov edi,URL
        add edi,eax
        dec edi
        mov ecx,eax
        mov al,"/"
        repne scasb
        cld
        jne No_name
        cmp byte ptr [edi],"/"
        je  No_name
        inc edi
        inc edi
        invoke lstrcpy,addr FileName,edi
No_name:
        ret
GetFileName endp
;=====================================================================
;                               ShowProgress
;=====================================================================
; This procedure updates the progress bar and displays the number
; of bytes downloaded so far on the status bar
;=====================================================================
ShowProgress proc uses ebx edx hWnd:DWORD
        LOCAL temp[100]:BYTE
       .if ContentLength!=0
                xor edx,edx
                mov eax,CurrentDataSize
                mov ebx,1000
                mul ebx
                mov ebx,ContentLength
                div ebx
                invoke SendDlgItemMessage,hWnd,IDC_PROGRESS,PBM_SETPOS,eax,NULL
        .endif
        push CurrentDataSize
        push offset Downloading
        lea eax,temp
        push eax
        call wsprintfA
        add esp,12
        invoke SetStatusText,addr temp,NULL
        ret
ShowProgress endp
;====================================================================
;                               TranslateErrorCode
;====================================================================
; This function takes the error code and an address of a buffer and
; looks up the error string in the string resource.
;====================================================================
TranslateErrorCode proc ErrCode:DWORD, pErrString:DWORD
        invoke LoadString,hInstance,ErrCode,pErrString,512
        .if eax==0
                invoke LoadString,hInstance,1,pErrString,512
        .endif
        ret
TranslateErrorCode endp
;====================================================================
;                               GetErrorString
;====================================================================
; This function calls WSAGetLastError to retrieve the error code of 
; the last socket operation and looks up the error string in
; the string resource.
;====================================================================
GetErrorString proc pErrString:DWORD
        invoke WSAGetLastError
        push eax
        invoke TranslateErrorCode,eax,pErrString
        pop eax
        ret
GetErrorString endp
;====================================================================
;                               CloseSock
;====================================================================
; This function performs winsock library shutdown. It closes socket,
; output file, kills timer,and calls WSACleanup. It also clears the
; status bar and resets the progress bar control.
;====================================================================
CloseSock proc
        .if sock!=0
                invoke closesocket,sock
                mov sock,0
        .endif                
        .if FileHandle!=0
                invoke CloseHandle,FileHandle
        .endif
        .if TimerID!=0
                invoke KillTimer,hwnd,TimerID
                invoke ClearMessages,hwnd,WM_SOCKET
                invoke ClearMessages,hwndStatus,SB_SETTEXT
                invoke SendMessage,hwndStatus,SB_SETTEXT,1,NULL
        .endif
        invoke SendDlgItemMessage,hwnd,IDC_PROGRESS,PBM_SETPOS,0,0
        invoke SetWindowText,hwndStatus,NULL
        invoke SetDlgItemText,hwnd,IDC_NAME,NULL
        ret
CloseSock endp
SetStatusText PROC Text:DWORD, Text1:DWORD
        push Text1
        push Text
        push offset ErrorString
        call wsprintfA
        add esp,12
        invoke SetWindowText,hwndStatus,addr ErrorString
        ret
SetStatusText ENDP
EnableControls PROC
        invoke EnableWindow,hwndConnectButton,TRUE
        invoke EnableMenuItem,hMenu,IDM_CONNECT,MF_ENABLED
        ret 
EnableControls ENDP
DisableControls PROC
        invoke EnableWindow,hwndConnectButton,FALSE
        invoke EnableMenuItem,hMenu,IDM_CONNECT,MF_GRAYED
        ret
DisableControls ENDP
ConnectSocket PROC
        invoke DisableControls
        mov sock,0      ; We use the value of sock to check if the socket is closed so we must initialize it to 0
                                      ;  which means "closed or not created yet"
        invoke ParseURL,addr URLString  ; Parse the URL into host name, relative url and the http port
        invoke lstrlen,addr URLString
        .if eax>40
                invoke lstrcpyn,addr CommandString,addr URLString,20
                invoke lstrcat,addr CommandString,addr Dots
                invoke lstrlen,addr URLString
                sub eax,20
                push edi
                mov edi,offset URLString
                add edi,eax
                invoke lstrcat,addr CommandString,edi
                pop edi
        .else
                invoke lstrcpy,addr CommandString,addr URLString
        .endif        
        invoke SetDlgItemText,hwnd,IDC_NAME,\
                addr CommandString
        invoke socket,PF_INET,SOCK_STREAM,0     ; Create a stream socket
        .if eax!=INVALID_SOCKET
                mov sock,eax
                .if Resuming==FALSE
                        invoke SetStatusText,addr ResolvingServer,addr HostName
                        invoke inet_addr,addr HostName  ; Assume that the host name is not an ip address. If the host name is really an ip address,
                                                        ; the function will fail with eax==INADDR_NONE
                        .if eax==INADDR_NONE
                                invoke gethostbyname,addr HostName     ; Use this function to get the host ip address from host name.
                                .if eax==NULL
                                        invoke ShowErrorMessage
                                        ret
                                .endif
                                mov eax,[eax+12]
                                mov eax,[eax]
                                mov eax,[eax]
                                mov SocketAddress.sin_addr,eax
                        .else
                                mov SocketAddress.sin_addr,eax
                        .endif
                        mov SocketAddress.sin_family,AF_INET
                .endif
                invoke htons,HTTPPort   ; We must convert host byte order to network byte order
                mov SocketAddress.sin_port,ax
                invoke WSAAsyncSelect,sock,hwnd,WM_SOCKET,\     ; We choose to receive notification about successful connection,
                        FD_CONNECT or FD_READ or FD_CLOSE ; incoming data, and when the socket is closed
                .if eax==NULL
                        invoke SetStatusText,addr Connecting,addr HostName
                        invoke connect,sock,addr SocketAddress,sizeof SocketAddress     ; Make a connection with the remote host
                                                                        ; Since we operate in non-blocking mode, we wait for the window socket to call us when
                                                                        ; the events we are interested in occur.
                        .if eax==SOCKET_ERROR
                                invoke WSAGetLastError
                                .if eax!=WSAEWOULDBLOCK
                                        invoke ShowErrorMessage
                                .endif        
                        .endif
                .else
                        invoke ShowErrorMessage
                .endif
        .else
                invoke SetWindowText,hwndStatus,NULL
                invoke ShowErrorMessage
        .endif
        ret
ConnectSocket ENDP
ShowErrorMessage PROC
        invoke GetErrorString,addr ErrorString
        invoke MessageBox,hwnd,addr ErrorString,addr AppName,MB_OK+MB_ICONERROR
        invoke CloseSock
        invoke EnableControls
        ret
ShowErrorMessage ENDP
WriteOutputFile PROC buffer1:DWORD, BytesToWrite:DWORD
        .if ContentLength!=0
                mov eax,BytesToWrite
                add eax,CurrentDataSize
                .if eax>ContentLength
                        mov eax,ContentLength
                        sub eax,CurrentDataSize
                        mov BytesToWrite,eax
                .endif
        .endif
        invoke WriteFile,FileHandle,buffer1,\
                BytesToWrite,\
                addr BytesWritten,NULL                        
        push eax                
        .if eax==TRUE
                mov eax,BytesWritten                
                add CurrentDataSize,eax
                add ActualDataRead,eax
                invoke ShowProgress,hwnd
        .else
                invoke MessageBox,hwnd,addr WriteError,addr AppName,MB_OK+MB_ICONERROR
                invoke SetDlgItemText,hwnd,IDC_NAME,NULL
                invoke SetWindowText,hwndStatus,NULL                
        .endif
        pop eax
        ret
WriteOutputFile endp
;=====================================================================
;                               StrLen
;=====================================================================
; This procedure takes an address of a string as its parameter and
; returns the length of the string in eax
;=====================================================================
StrLen PROC uses edi String:DWORD
        mov edi,String
        mov al,0
        mov ecx,0FFFFFFFFh
        repne scasb
        sub ecx,0FFFFFFFFh
        neg ecx
        dec ecx
        mov eax,ecx
        ret
StrLen ENDP
;=====================================================================
;                               StrCpy
;=====================================================================
; This procedure copies a string into a buffer. If the buffer is smaller
; than the string to copy, it returns 0.
;=====================================================================
StrCpy PROC uses edi esi StrBuffer:DWORD,String:DWORD
        invoke StrLen,String
        mov ecx,eax
        mov edi,StrBuffer
        mov esi,String
        rep movsb
        ret
StrCpy ENDP
;=========================================================================
;                               InString
;=========================================================================
; Search for a substring in one string. Case Sensitive
; Return Value: -1 if substring not found, offset of the first byte
; of the substring if successful
;=========================================================================
InString PROC uses ebx edi esi StrMain:DWORD, StrSub:DWORD
        invoke StrLen,StrMain
        mov ecx,eax
        push ecx
        invoke StrLen,StrSub
        pop ecx
        mov ebx,eax
        .if ecx<eax
                mov eax,FALSE
        .elseif ecx==eax
                mov esi,StrMain
                mov edi,StrSub
                repe cmpsb
                je Equal
                mov eax,FALSE
                jmp GetOut
Equal:
                xor eax,eax
GetOut:                
        .else
                sub ecx,eax
                inc ecx
                mov eax,ecx
                xor edx,edx
                push eax                
                .while eax!=0
                        mov edi,StrMain
                        add edi,edx
                        mov esi,StrSub
                        mov ecx,ebx
                        repe cmpsb
                        je Found
                        jmp DontFind
Found:
                        .break        
DontFind:
                        inc edx
                        dec eax
                .endw
                pop ecx
                .if eax!=0
                        sub ecx,eax
                        mov eax,ecx 
                .else
                        mov eax,-1
                .endif
        .endif
        ret
InString ENDP
;=====================================================================
;                               InStringi
;=====================================================================
; Search for a substring in one string. Case insensitive
; Return Value: -1 if substring not found, offset of the first byte
; of the substring if successful
;=========================================================================
InStringi PROC StrMain:DWORD,StrSub:DWORD
        LOCAL hMemory1:DWORD
        LOCAL pMemory1:DWORD
        LOCAL hMemory2:DWORD
        LOCAL pMemory2:DWORD
        invoke StrLen,StrMain
        inc eax
        invoke GlobalAlloc,GHND,eax
        .if eax==NULL
                mov eax,-1
        .else
                mov hMemory1,eax
                invoke GlobalLock,eax
                .if eax==NULL
                        invoke GlobalFree,hMemory1
                        mov eax,-1
                .else
                        mov pMemory1,eax
                        invoke StrLen,StrSub
                        inc eax
                        invoke GlobalAlloc,GHND,eax
                        .if eax==NULL
                                invoke GlobalUnlock,pMemory1
                                invoke GlobalFree,hMemory1
                                mov eax,-1
                        .else
                                mov hMemory2,eax
                                invoke GlobalLock,eax
                                .if eax==NULL
                                        invoke GlobalUnlock,pMemory1
                                        invoke GlobalFree,hMemory1
                                        invoke GlobalFree,hMemory2
                                        mov eax,-1
                                .else
                                        mov pMemory2,eax
                                        invoke StrCpy,pMemory1,StrMain
                                        invoke StrCpy,pMemory2,StrSub
                                        invoke CharLower,pMemory1
                                        invoke CharLower,pMemory2
                                        invoke InString,pMemory1,pMemory2
                                        push eax
                                        invoke GlobalUnlock,pMemory1
                                        invoke GlobalFree,hMemory1
                                        invoke GlobalUnlock,pMemory2
                                        invoke GlobalFree,hMemory2
                                        pop eax
                                .endif
                        .endif
                .endif
        .endif
        ret
InStringi ENDP 
ReadSocket PROC
        .if WaitingForName==0   ; if the SaveAs dialog box is diplayed, we don't want to read the data from the socket 
                                    ; yet because the file is not created yet. So we jump over the read until the file is created
                invoke ioctlsocket,sock,FIONREAD,addr sizetoread  ; Check the number of bytes available to read from the socket
                invoke GlobalAlloc,GHND,sizetoread      ; allocate memory enough for the data to read from the socket
                mov mHandle,eax
                invoke GlobalLock,eax
                mov buffer,eax
                invoke recv,sock,buffer,sizetoread,0    ; Read the data from the socket
                .if eax==SOCKET_ERROR
                        invoke ShowErrorMessage
                .else
                        mov sizetoread,eax              ; Save the actual number of bytes read from the socket
                                                        ; BEWARE! The value returned from ioctlsocket and the actual number of bytes
                                                        ; read in from the socket are not always equal.
                        .if HeaderParsed==FALSE         ; If the HTTP header is not received and parsed, store the data in HTTPHeader
                                invoke ParseAllHeaders
                        .else           ; when the http header is out of the way, what follows is the actual data
                                .if MultipartPresent==FALSE || (MultipartPresent==TRUE && MultipartHeaderParsed==TRUE)
                                        invoke WriteOutputFile,buffer,sizetoread
                                .else
                                        invoke FillMultipartHeader
                                .endif
                        .endif
                        invoke GlobalUnlock,buffer
                        invoke GlobalFree,mHandle
                .endif
        .endif
        ret
ReadSocket ENDP
FillMultipartHeader PROC uses edi
        mov edi,offset MultipartHeader
        add edi,MultipartIndex
        mov eax,FirstDataOffset
        sub eax,buffer
        mov ecx,sizetoread
        sub ecx,eax
        mov eax,FirstDataOffset
        .while ecx>0
                .if byte ptr [eax]==0Ah && byte ptr [eax+2]==0Ah
                        mov dl,byte ptr [eax]
                        mov byte ptr [edi],dl
                        add eax,3
                        mov FirstDataOffset,eax
                        .if Resuming==FALSE
                                invoke ParseHeader,addr MultipartHeader
                        .endif
                        mov MultipartHeaderParsed,TRUE
                        invoke CreateOutputFile
                        .break
                .else
                        mov dl,byte ptr [eax]
                        mov byte ptr [edi],dl
                        inc eax
                        inc edi
                        inc MultipartIndex
                        dec ecx
                .endif
        .endw
        ret
FillMultipartHeader ENDP
ParseAllHeaders PROC uses edi esi
        mov edi,offset HTTPHeader
        add edi,HeaderIndex      ; the address of the first empty space in HTTPHeader
        mov esi,buffer
        .while eax!=0
                .if (byte ptr [esi]==0Ah) && (byte ptr [esi-2]==0Ah)  ; if there are two 0Ah, that's the end of http header
                        mov cl,byte ptr [esi]
                        mov byte ptr [edi],cl
                        inc esi
                        inc edi
                        mov byte ptr [edi],0
                        mov HeaderParsed,TRUE   ; Set the flag to show that the http header is received. what follows will be actual data
                        mov FirstDataOffset,esi     ; Address of the first byte of the real data    
                        invoke ParseHeader,addr HTTPHeader
                        invoke String2Dword,addr StatusCode     ;Convert status code string to number
                        mov StatusValue,ax
                        .if byte ptr [StatusCode]=="3"          ; If the status code starts with "3", it means we have to go to the url specified by "location:" field.
                                mov Redirection,1      ; Set the flag that redirection is in progress
                                invoke lstrcpy,addr ErrorString,addr HTTPHeader       ; We will convert the HTTP header to lower case so we must copy it to another buffer  
                                invoke CharLower,addr ErrorString
                                invoke lstrlen,addr ErrorString
                                mov ecx,eax
                                mov  edi,offset ErrorString
Find_l_again:
                                mov  al,"l"             ; Search for "l" which is the first char of "location:"
                                repne scasb
                                push edi
                                push ecx
                                dec edi
                                mov  esi,offset Location  ; if "l" is found, check if it's the first char of "location:"
                                mov  ecx,9
                                repe cmpsb
                                mov esi,edi
                                pop  ecx
                                pop  edi
                                jne  Find_l_again
                                invoke RtlFillMemory,addr URLString,512,0
                                mov edi,esi
                                mov esi,offset URLString
                                .if byte ptr [edi]==20h ; skip spaces before url (if any)
                                        mov al,20h
                                        mov ecx,512
                                        repe scasb
                                        dec edi
                                .endif
                                .while (byte ptr [edi]!=0) && (byte ptr [edi]!=0dh) && (byte ptr [edi]!=0Ah)
                                        mov al,byte ptr [edi]
                                        mov byte ptr [esi],al
                                        inc edi
                                        inc esi
                                .endw
                                invoke CloseSock        ; Close the socket
                                invoke ClearMessages,hwnd,WM_SOCKET
                                mov FileHandle,0
                                invoke ConnectSocket    ; Connect again with the new url
                        .elseif StatusValue==503       ; Server is busy
                                invoke MessageBox,hwnd,addr ServerBusy,addr AppName,MB_OK+MB_ICONERROR
                                invoke CloseSock
                                invoke EnableControls
                        .elseif byte ptr [StatusCode]=="5"
                                invoke MessageBox,hwnd,addr ServerError,addr AppName,MB_OK+MB_ICONERROR
                                invoke CloseSock
                                invoke EnableControls
                        .elseif StatusValue==204
                                invoke MessageBox,hwnd,addr NoContent,addr AppName,MB_OK+MB_ICONERROR
                                invoke CloseSock
                                invoke EnableControls
                        .elseif StatusValue==400
                                invoke MessageBox,hwnd,addr BadRequest,addr AppName,MB_OK+MB_ICONERROR
                                invoke CloseSock
                                invoke EnableControls
                        .elseif StatusValue==401
                                invoke MessageBox,hwnd,addr Unauthorized,addr AppName,MB_OK+MB_ICONERROR
                                invoke CloseSock
                                invoke EnableControls
                        .elseif StatusValue==403
                                invoke MessageBox,hwnd,addr Forbidden,addr AppName,MB_OK+MB_ICONERROR
                                invoke CloseSock
                                invoke EnableControls
                        .elseif StatusValue==404
                                invoke MessageBox,hwnd,addr NotFound,addr AppName,MB_OK+MB_ICONERROR
                                invoke CloseSock
                                invoke EnableControls
                        .elseif StatusValue==406
                                invoke MessageBox,hwnd,addr NotAcceptable,addr AppName,MB_OK+MB_ICONERROR
                                invoke CloseSock
                                invoke EnableControls
                        .elseif StatusValue==410
                                invoke MessageBox,hwnd,addr Gone,addr AppName,MB_OK+MB_ICONERROR
                                invoke CloseSock
                                invoke EnableControls
                        .elseif byte ptr [StatusCode]=="2"
                                invoke InStringi,addr HTTPHeader,addr Multipart
                                .if eax!=-1
                                        mov CanResume,TRUE
                                        mov MultipartPresent,TRUE
                                        invoke FillMultipartHeader
                                .else
                                        invoke InStringi,addr HTTPHeader,addr AcceptRanges
                                        .if eax!=-1 || StatusValue==206
                                                mov CanResume,TRUE
                                        .else
                                                invoke InStringi,addr HTTPHeader,addr ContentRange
                                                .if eax!=-1
                                                        mov CanResume,TRUE
                                                .endif
                                        .endif
                                        invoke CreateOutputFile
;                                        invoke MessageBox,NULL,addr HTTPHeader,addr AppName,MB_OK
                                .endif
                        .else
                                invoke MessageBox,hwnd,addr Undefined,addr AppName,MB_OK+MB_ICONERROR
                                invoke CloseSock
                                invoke EnableControls
                        .endif                                       
                        .break
                .else
                        mov cl,byte ptr [esi]
                        mov byte ptr [edi],cl
                        inc edi
                        inc esi
                        inc HeaderIndex
                        dec eax                                                        
                .endif                                        
        .endw
        ret
ParseAllHeaders ENDP
ManageInitialization PROC
        invoke SetTimer,hwnd,1,2000,NULL
        mov TimerID,eax
        push 0
        push 0
        push offset SpeedTemplate
        push offset CommandString
        call wsprintfA
        add esp,16
        invoke GetTickCount
        mov OriginalTickCount,eax
        invoke SendMessage,hwndStatus,SB_SETTEXT,1,addr CommandString
        ret
ManageInitialization ENDP
CreateNewFile PROC
        invoke CreateFile,addr FileName,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE,NULL
        .if eax!=INVALID_HANDLE_VALUE
                mov FileHandle,eax
                invoke ManageInitialization
                invoke WriteInitialData
        .else
                invoke MessageBox,hwnd,addr CreateError,addr AppName,MB_OK+MB_ICONERROR
                invoke CloseSock
                invoke EnableControls
        .endif
        ret
CreateNewFile ENDP
CreateOutputFile PROC
        .if Resuming==FALSE
                mov WaitingForName,1    ; We don't want to read data from the socket until the output file is created
                mov Redirection,0               ; If we are here, it means the status code is not "3" so if there were redirection before, we are now at the final location of the file
                invoke GetFileName,addr URLString       ; Get the file name from the url 
                invoke lstrlen,addr FileName
                .if eax==0      ; If there is no file name in the url, assume it is "index.html"
                        invoke lstrcpy,addr FileName,addr DefaultName
                .endif
                mov ofn.lStructSize,SIZEOF ofn
                push hwnd
                pop  ofn.hwndOwner
                push hInstance
                pop  ofn.hInstance
                mov  ofn.lpstrFilter, OFFSET FilterString
                mov  ofn.lpstrFile, OFFSET FileName
                mov  ofn.nMaxFile,sizeof FileName
                mov ofn.Flags,OFN_LONGNAMES or\
                        OFN_EXPLORER or OFN_HIDEREADONLY
                invoke GetSaveFileName, ADDR ofn
                .if eax==TRUE
                        mov CurrentDataSize,0   ; The number of bytes downloaded so far
                        invoke CreateFile,addr FileName,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_NEW,FILE_ATTRIBUTE_ARCHIVE,NULL
                        .if eax!=INVALID_HANDLE_VALUE
                                mov FileHandle,eax
                                invoke ManageInitialization
                                invoke WriteInitialData
                        .else
                                .if CanResume==TRUE
                                        push offset FileName
                                        push offset FilePrompt
                                        push offset CommandString
                                        call wsprintfA
                                        add esp,12
                                        invoke MessageBox,hwnd,addr CommandString,addr AppName,MB_YESNOCANCEL+MB_ICONINFORMATION
                                        .if eax==IDCANCEL       ; Cancel download
                                                invoke CloseSock
                                                invoke EnableControls
                                        .elseif eax==IDNO         ; Create new file
                                                invoke CreateNewFile
                                        .else
                                                invoke CreateFile,addr FileName,GENERIC_WRITE,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE,NULL
                                                .if eax!=INVALID_HANDLE_VALUE
                                                        mov FileHandle,eax                                                        
                                                        invoke SetFilePointer,eax,0,0,FILE_END
                                                        mov CurrentDataSize,eax
                                                        mov WaitingForName,0
                                                        invoke ManageInitialization
                                                        invoke ShowProgress,hwnd
                                                        invoke CloseTheSock
                                                .else
                                                        invoke MessageBox,hwnd,addr OpenError,addr AppName,MB_OK
                                                        invoke CloseSock
                                                        invoke EnableControls
                                                .endif
                                        .endif
                                .else
                                        push offset FileName
                                        push offset OverwritePrompt
                                        push offset CommandString
                                        call wsprintfA
                                        add esp,12
                                        invoke MessageBox,hwnd,addr CommandString,addr AppName,MB_YESNO+MB_ICONINFORMATION
                                        .if eax==IDYES
                                                invoke CreateNewFile
                                        .else
                                                invoke CloseSock
                                                invoke EnableControls
                                        .endif
                                .endif
                        .endif
                .else
                        invoke CloseSock
                        invoke EnableControls
                .endif
                mov WaitingForName,0     ; The waiting is over. We created the output file
        .else
                invoke WriteInitialData
        .endif
        ret
CreateOutputFile ENDP
CloseTheSock PROC
        .if ContentLength!=0
                mov eax,CurrentDataSize
                .if ((eax!=ContentLength) && CanResume==TRUE) && WaitingForName==0
                        .if sock!=0
                                invoke closesocket,sock
                                mov sock,0
                        .endif                
                        mov Resuming,TRUE
                        mov eax,CurrentDataSize
                        mov StartingOffset,eax
                        invoke ClearMessages,hwnd,WM_SOCKET
                        invoke ConnectSocket
                .else
                        invoke ActualClose
                .endif
        .else
                invoke ActualClose
        .endif
        ret
CloseTheSock ENDP
ActualClose PROC
        .if WaitingForName==1   ; If we're waiting for the output filename, don't close the socket from our side yet.
                mov CloseConnection,1     ; just set a flag to indicate that the opposite end had disconnected.
        .else
                invoke CloseSock
                invoke EnableControls
                .if Redirection==0       ; If redirection is in progress, close the socket but don't display the message
                        invoke MessageBox,NULL, addr CloseString,addr AppName,MB_OK
                .endif                                        
        .endif
        ret
ActualClose ENDP
ClearMessages PROC hWnd:DWORD,Message:DWORD
        LOCAL MyMSG:MSG
        mov eax,TRUE
        .while eax==TRUE        ; Since there may be WM_SOCKET messages left in the message queues,
                                ; we must get rid of them before we create new socket.
                invoke PeekMessage,addr MyMSG,hWnd,Message,Message,PM_REMOVE
        .endw
       ret
ClearMessages ENDP
WriteInitialData PROC
        mov eax,FirstDataOffset       ;Find the size of the actual data remaining in the buffer
        sub eax,buffer
        mov ecx,sizetoread
        sub ecx,eax
        invoke WriteOutputFile,FirstDataOffset,ecx ; Write the data to output file                          
        .if eax==TRUE
                push eax
                invoke ioctlsocket,sock,FIONREAD,addr sizetoread        ; Check the socket if some data remains
                pop eax
                .if sizetoread!=0          ; If data remains to be read, read it
                        invoke GlobalReAlloc,mHandle,sizetoread,GHND
                        mov mHandle,eax
                        invoke GlobalLock,eax
                        mov buffer,eax
                        invoke recv,sock,buffer,sizetoread,0
                        .if eax==SOCKET_ERROR
                                invoke ShowErrorMessage
                                mov eax,FALSE
                        .else
                                mov sizetoread,eax
                                invoke WriteOutputFile,buffer,eax                                                                                                
                        .endif                                                                                                        
                .endif
                .if eax==TRUE
                        .if CloseConnection==1
                                invoke CloseSock
                                invoke EnableControls
                                invoke MessageBox,NULL, addr CloseString,addr AppName,MB_OK
                        .endif
                .endif
        .endif     
        ret
WriteInitialData ENDP
SendRequest PROC
        push StartingOffset
        push offset HostName
        push offset RelativeURL
        push offset GetTemplate
        push offset CommandString
        call wsprintfA        ; Create the GET or HEAD request
        add esp,20
        invoke lstrlen,addr CommandString
        invoke send,sock,addr CommandString,eax,0       ; Send GET command to the web server
        .if eax==SOCKET_ERROR
                invoke ShowErrorMessage
        .else                 ; if the send is successful, display a message saying so            
                push offset HostName
                push offset WaitingForReply
                push offset CommandString
                call wsprintfA
                add esp,12
                invoke SetStatusText,addr CommandString,NULL
                mov HeaderIndex,0     ; We will use this variable as index into the httpheader buffer
                mov HeaderParsed,FALSE  ; A flag to indicate if the HTTP header is received and parsed
                mov WaitingForName,0    ; A flag to indicate if the SaveAs common dialog box is active
                mov CloseConnection,0   ; A flag to indicate if the connection was closed
                mov Redirection,0       ; A flag to indicate if indirection of url is in progress
                mov StatusValue,0       ; No status code read in yet
                invoke RtlFillMemory,addr MultipartHeader,512,0
                mov MultipartIndex,0
                mov MultipartHeaderParsed,FALSE
                mov CanResume,FALSE
                mov MultipartPresent,FALSE
                mov ActualDataRead,0
        .endif
        ret
SendRequest ENDP
ShowDownloadSpeed PROC        
        .if HeaderParsed==TRUE
                invoke GetTickCount
                mov ecx,OriginalTickCount
                sub eax,ecx
                xor edx,edx
                mov ecx,1000
                div ecx
                push eax
                mov eax,ActualDataRead
                xor edx,edx
                mov ecx,1024
                div ecx
                xor edx,edx
                pop ecx
                div ecx
                push eax
                mov eax,edx
                xor edx,edx
                mov ecx,100
                mul ecx
                mov ecx,1024
                div ecx
                mov edx,eax
                pop eax                
                push edx
                push eax
                push offset SpeedTemplate
                push offset CommandString
                call wsprintfA
                add esp,16
                invoke SendMessage,hwndStatus,SB_SETTEXT,1,addr CommandString
        .endif
        ret
ShowDownloadSpeed ENDP
ReconnectIfPossible PROC
        .if eax==WSAECONNREFUSED || eax==WSAENETUNREACH || eax==WSAETIMEDOUT
                invoke ConnectSocket
        .else
                invoke ShowSocketError
        .endif
        ret
ReconnectIfPossible ENDP
end start
