;/--------------------------------------------------------------------------\;
;|      E-Mail options proc                                                 |;
;\--------------------------------------------------------------------------/;
.data
c_serverID      dd 0

error_10        db 'You must select something first!', 0
error_0a        db 'Maximum of 10 POP3 servers in this version.', 0
.code


        PUBLIC DlgProc2

DlgProc2 proc STDCALL, __hwnd:DWORD, wmsg:DWORD, _wparam:DWORD, _lparam:DWORD
        USES ebx, edi, esi
        mov eax, wmsg
        cmp ax, WM_DESTROY              ; Destroy
         je _wmdestroy2
        cmp ax, WM_CLOSE                ; Close
         je _wmdestroy2
        cmp ax, WM_COMMAND              ; Command
         je _wmcommand2
        cmp ax, WM_INITDIALOG           ; Init Dialog
         je _initdlg2
        cmp ax, WM_PAINT                ; Paint
         je _paint                      ; *** Subclassed Pah! ***
        xor eax, eax
        ret
;---------------------------------------;
_wmdestroy2:
        call EndDialog, __hwnd, 0       ; End the Dialog
        ret
;---------------------------------------;
_wmcommand2:
        cmp _wparam, IDC_OK             ; OK button pressed
         jne noexn
        jmp _wmdestroy2                 ; Exit
noexn:  cmp _wparam, IDC_IADD
         jne noiad
        cmp POP3_servers, 10            ; [... Max POP3 servers ...]
         jb canadd
        call MessageBox, __hwnd, offset error_0a, offset header_00, MB_OK
        xor eax, eax
        ret
canadd:
        mov eax, POP3_servers
        mov c_serverID, eax
        imul eax, size POP3S
        mov byte ptr POP3_s[eax].Server_name, 0         ; Clear fields
        mov byte ptr POP3_s[eax].User_name, 0
        mov byte ptr POP3_s[eax].Password, 0
        mov byte ptr POP3_s[eax].Email_Address, 0
        mov byte ptr POP3_s[eax].InboxPath, 0
        mov byte ptr POP3_s[eax].Flags, 0
        call DialogBoxParamA, h_inst, IDD_DIALOG2, __hwnd, offset DlgProc3, 0        
        mov eax, c_serverID
        cmp eax, -1
         je cancel1
        inc POP3_servers
        imul eax, size POP3S
        lea ebx, POP3_s[eax].Email_Address
        call SendDlgItemMessage, __hwnd, IDC_ISERVERS, LB_ADDSTRING, 0, ebx
        mov eax, POP3_servers
        dec eax
        call SendDlgItemMessage, __hwnd, IDC_ISERVERS, LB_SETCURSEL, eax, 0
cancel1:xor eax, eax
        ret

noiad:  cmp _wparam, IDC_IEDIT
         jne noied
medit:  call SendDlgItemMessage, __hwnd, IDC_ISERVERS, LB_GETCURSEL, 0, 0
        cmp eax, -1
         jne issel
        call MessageBox, __hwnd, offset error_10, offset header_00, MB_OK
        xor eax, eax
        ret
issel:  mov c_serverID, eax
        call DialogBoxParamA, h_inst, IDD_DIALOG2, __hwnd, offset DlgProc3, 0
        cmp c_serverID, -1
         je cancel2
        call SendDlgItemMessage, __hwnd, IDC_ISERVERS, LB_DELETESTRING, c_serverID, 0
        mov eax, c_serverID
        imul eax, size POP3S
        lea ebx, POP3_s[eax].Email_Address
        call SendDlgItemMessage, __hwnd, IDC_ISERVERS, LB_INSERTSTRING, c_serverID, ebx
        call SendDlgItemMessage, __hwnd, IDC_ISERVERS, LB_SETCURSEL, c_serverID, 0
cancel2:xor eax, eax
        ret
noied:  cmp _wparam, IDC_IREMOVE
         jne noire
        call SendDlgItemMessage, __hwnd, IDC_ISERVERS, LB_GETCURSEL, 0, 0
        cmp eax, -1
         jne isse2
        call MessageBox, __hwnd, offset error_10, offset header_00, MB_OK
        xor eax, eax
        ret
isse2:  mov c_serverID, eax
        call RemoveServer
        xor eax, eax
        ret
noire:  cmp word ptr [offset _wparam], IDC_ISERVERS
         jne nolb1
        cmp word ptr [offset _wparam + 2], LBN_DBLCLK
         jne nolb1
        jmp medit
nolb1:
        xor eax, eax
        ret
;---------------------------------------;
_initdlg2:
        mov esi, offset POP3_s          ; *** Show POP3 servers ***
        mov ecx, POP3_servers
        or ecx, ecx
         jz nodef1
loplb1: push ecx
         push esi
        lea ebx, [esi].Email_Address
        call SendDlgItemMessage, __hwnd, IDC_ISERVERS, LB_ADDSTRING, 0, ebx
         pop esi
        pop ecx
        add esi, SIZE POP3S
        loop loplb1
nodef1:
        call GetWindowRect, __hwnd, offset DlgRect
        call GetDesktopWindow
        call GetWindowRect, eax, offset DesktopRect

        mov eax, DlgRect.rc_bottom
        sub eax, DlgRect.rc_top
        mov DlgHeight, eax              ; Dialog box height
        mov eax, DlgRect.rc_right
        sub eax, DlgRect.rc_left
        mov DlgWidth, eax               ; Dialog box width
        mov ebx, DesktopRect.rc_bottom
        sub ebx, DlgHeight
        shr ebx, 1                      ; ebx = Start y
        mov ecx, DesktopRect.rc_right
        sub ecx, DlgWidth
        shr ecx, 1                      ; ecx = Start x
        call MoveWindow, __hwnd, ecx, ebx, DlgWidth, DlgHeight, 0   ; Centre
        ret
;---------------------------------------;
DlgProc2 endp
;/--------------------------------------------------------------------------\;
;|      E-Mail options proc - POP3 details                                  |;
;\--------------------------------------------------------------------------/;

        PUBLIC DlgProc3

DlgProc3 proc STDCALL, __hwnd:DWORD, wmsg:DWORD, _wparam:DWORD, _lparam:DWORD
        USES ebx, edi, esi
        mov eax, wmsg
        cmp ax, WM_DESTROY              ; Destroy
         je _wmdestroy2
        cmp ax, WM_CLOSE                ; Close
         je _wmdestroy2
        cmp ax, WM_COMMAND              ; Command
         je _wmcommand3
        cmp ax, WM_INITDIALOG           ; Init Dialog
         je _initdlg3
        cmp ax, WM_PAINT                ; Paint
         je _paint
        xor eax, eax
        ret
;---------------------------------------;
_wmcommand3:
        cmp _wparam, IDC_OK2            ; OK button pressed
         jne noexo

        mov esi, c_serverID
        imul esi, SIZE POP3S

        lea ebx, POP3_s[esi].Server_name
        call GetDlgItemText, __hwnd, IDC_SERVERNAME, ebx, 63
        lea ebx, POP3_s[esi].User_name
        call GetDlgItemText, __hwnd, IDC_USERNAME, ebx, 63
        lea ebx, POP3_s[esi].Password
        call GetDlgItemText, __hwnd, IDC_PASSWORD, ebx, 63
        lea ebx, POP3_s[esi].Email_Address
        call GetDlgItemText, __hwnd, IDC_EMAILADDRESS, ebx, 63
        lea ebx, POP3_s[esi].InboxPath
        call GetDlgItemText, __hwnd, IDC_INBOXPATH, ebx, 63

        jmp _wmdestroy2
noexo:  cmp _wparam, IDC_CANCEL         ; CANCEL button pressed
         jne nocan
        mov c_serverID, -1
        jmp _wmdestroy2
nocan:  xor eax, eax
        ret
;---------------------------------------;
_initdlg3:
        mov esi, c_serverID
        imul esi, SIZE POP3S

        lea ebx, POP3_s[esi].Server_name
        call SetDlgItemText, __hwnd, IDC_SERVERNAME, ebx
        lea ebx, POP3_s[esi].User_name
        call SetDlgItemText, __hwnd, IDC_USERNAME, ebx
        lea ebx, POP3_s[esi].Password
        call SetDlgItemText, __hwnd, IDC_PASSWORD, ebx
        lea ebx, POP3_s[esi].Email_Address
        call SetDlgItemText, __hwnd, IDC_EMAILADDRESS, ebx
        lea ebx, POP3_s[esi].InboxPath
        call SetDlgItemText, __hwnd, IDC_INBOXPATH, ebx

        call GetWindowRect, __hwnd, offset DlgRect
        call GetDesktopWindow
        call GetWindowRect, eax, offset DesktopRect

        mov eax, DlgRect.rc_bottom
        sub eax, DlgRect.rc_top
        mov DlgHeight, eax              ; Dialog box height
        mov eax, DlgRect.rc_right
        sub eax, DlgRect.rc_left
        mov DlgWidth, eax               ; Dialog box width
        mov ebx, DesktopRect.rc_bottom
        sub ebx, DlgHeight
        shr ebx, 1                      ; ebx = Start y
        mov ecx, DesktopRect.rc_right
        sub ecx, DlgWidth
        shr ecx, 1                      ; ecx = Start x
        call MoveWindow, __hwnd, ecx, ebx, DlgWidth, DlgHeight, 0   ; Centre
        ret
;---------------------------------------;
DlgProc3 endp

RemoveServer proc
        mov esi, c_serverID
        imul esi, SIZE POP3S

        mov ecx, POP3_servers
        imul ecx, SIZE POP3S

loopm1: mov eax, dword ptr [offset POP3_s + esi + SIZE POP3S]
        mov dword ptr [offset POP3_s + esi], eax

        add esi, 4
        mov eax, esi
        add eax, SIZE POP3S
        cmp eax, ecx
         jb loopm1

        call SendDlgItemMessage, __hwnd, IDC_ISERVERS, LB_DELETESTRING, c_serverID, 0

        dec POP3_servers

        mov eax, c_serverID
        cmp eax, POP3_servers
         jb okhere              ; is current selection still valid?
        dec eax
         js noselm
okhere: call SendDlgItemMessage, __hwnd, IDC_ISERVERS, LB_SETCURSEL, eax, 0
noselm:
        ret
RemoveServer endp

