;+==========================================================================+;
;|                                                                          |;
;| XXXXX X   X   X   XXX X        X   X   X   X   X   X    XXX  XXXXX XXXX  |;
;| X     XX XX  X X   X  X        XX XX  X X  XX  X  X X  X     X     X   X |;
;| XXX   X X X X   X  X  X        X X X X   X X X X X   X X  XX XXX   XXXX  |;
;| X     X   X XXXXX  X  X        X   X XXXXX X  XX XXXXX X   X X     X   X |;
;| XXXXX X   X X   X XXX XXXXX    X   X X   X X   X X   X  XXX  XXXXX X   X |;
;|                                                                          |;
;+==========================================================================+;
;| Name:        mail.asm                                                    |;
;| Author:      Jimmy Moore                                                 |;
;| Date:        22/03/1999                                                  |;
;| Description: E-Mail manager                                              |;
;|                                                                          |;
;| 30/03/1999   Rewritten much of the E-Mail checking part. Now much better |;
;|              code, more flexible, and easier to expand.                  |;
;|                                                                          |;
;| 23/03/1999   Got Asyncronous E-Mail checking working, over multiple POP3 |;
;|              accounts. Also added E-Mail options, to setup, edit, remove |;
;|              POP3 servers.                                               |;
;|                                                                          |;
;+==========================================================================+;

                .386
                .MODEL FLAT,STDCALL
                locals
                jumps

                UNICODE = 0                     ; Not Unicode

                include \w32\w32.inc            ; Standard WIN32 stuff

;-----------------------------------------------; [..Resource info..]

        IDC_STATIC      equ     -1

        IDD_DIALOG1     equ     100       ; Main window
        IDC_BACK        equ     3000
        IDC_NEXT        equ     3002
        IDC_MAINTEXT    equ     3001

        IDC_GETMAIL     equ     3100
        IDC_SENDMAIL    equ     3101
        IDC_REPLY       equ     3102
        IDC_FORWARD     equ     3103

        IDM_EXIT        equ     32000
        IDM_EMAILO      equ     32002

        IDD_DIALOG2     equ     102     ; POP3 server details
        IDC_SERVERNAME  equ     3200    ;
        IDC_USERNAME    equ     3201
        IDC_PASSWORD    equ     3202
        IDC_EMAILADDRESS equ    3205
        IDC_INBOXPATH   equ     3206
        IDC_OK2         equ     3203
        IDC_CANCEL      equ     3204

        IDD_DIALOG3     equ     103
        IDC_ISERVERS    equ     3300
        IDC_IADD        equ     3301
        IDC_IEDIT       equ     3302
        IDC_IREMOVE     equ     3303
        IDC_OSERVER     equ     3304
        IDC_OK          equ     3399

        IDB_TOOLBAR     equ     109
        ID_TOOLBAR      equ     110

        IDD_DIALOG4     equ     104
        ID_4OK          equ    3000
        ID_4CANCEL      equ    3008

        ID_SERVERSTAT   equ    4000

;.....DATA..........................................................DATA.....;
.DATA

h_inst          dd 0
hstatus         dd 0

DlgRect         RECT    <>
DlgWidth        dd      ?
DlgHeight       dd      ?
DesktopRect     RECT    <>

_pnt            PAINTSTRUCT     <?>

tb              TBBUTTON <0, IDC_GETMAIL,  TBSTATE_ENABLED, TBSTYLE_BUTTON, ?, 0, 0>
tb1             TBBUTTON <1, IDC_SENDMAIL, TBSTATE_ENABLED, TBSTYLE_BUTTON, ?, 0, 0>
                TBBUTTON <2, IDC_REPLY,    TBSTATE_ENABLED, TBSTYLE_BUTTON, ?, 0, 0>
                TBBUTTON <3, IDC_FORWARD,  TBSTATE_ENABLED, TBSTYLE_BUTTON, ?, 0, 0>
tblen           dd offset tb1 - offset tb


wsadata         db 1024 dup(0)

nullstr         db 0

messaged        db 256 dup(0)
messagef        db 'Windows message = %X  wparam = %X  lparam = %X', 0

openbuff        db 1024 dup(0)
writelen        dd 0

;.....CODE..........................................................CODE.....;
.CODE

main:

        call InitCommonControls
        call GetModuleHandle, NULL          ; Get the handle to our app
        mov h_inst, eax
                                
        call DialogBoxParamA, h_inst, IDD_DIALOG1, 0, offset DlgProc, 0
        call ExitProcess                    ; Exit the main process

;/--------------------------------------------------------------------------\;
;|      Main Window Proc                                                    |;
;\--------------------------------------------------------------------------/;

        PUBLIC DlgProc

DlgProc proc STDCALL, __hwnd:DWORD, wmsg:DWORD, _wparam:DWORD, _lparam:DWORD
        USES ebx, edi, esi
        mov eax, wmsg

        push eax
         push _lparam
         push _wparam
         push eax
         push offset messagef
         push offset messaged
         call _wsprintf
         add esp, 20
 
         call SendMessage, hstatus, SB_SETTEXT, 0, offset messaged
        pop eax

        cmp ax, WM_DESTROY              ; Destroy
         je _wmdestroy
        cmp ax, WM_CLOSE                ; Close
         je _wmdestroy
        cmp ax, WM_COMMAND              ; Command
         je _wmcommand
        cmp ax, WM_INITDIALOG           ; Init Dialog
         je _initdlg
        cmp ax, WM_PAINT                ; Paint
         je _paint
        cmp ax, WM_SIZE                 ; Size
         je _wmsize
        xor eax, eax
        ret
;---------------------------------------;
_wmsize:call SendDlgItemMessage, __hwnd, ID_TOOLBAR, TB_AUTOSIZE, 0, 0
        call MoveWindow, hstatus, 0, 0, 0, 0, TRUE
        call GetWindowRect, __hwnd, offset DlgRect
        call GetDlgItem, __hwnd, IDC_MAINTEXT
        mov ecx, DlgRect.rc_bottom
        sub ecx, DlgRect.rc_top
        sub ecx, 212
        mov edx, DlgRect.rc_right
        sub edx, DlgRect.rc_left
        sub edx, 24
        call MoveWindow, eax, 8, 142, edx, ecx, TRUE
        xor eax, eax
        ret
;---------------------------------------;
_wmdestroy:
        call WSACleanup
        call EndDialog, __hwnd, 0       ; End the Dialog
        call ExitProcess                ; Exit Process
        ret
;---------------------------------------;
_wmcommand:

        cmp _wparam, IDM_EXIT           ; Exit menu item clicked
         jne noexm
        jmp _wmdestroy
noexm:  cmp _wparam, IDC_GETMAIL
         jne nogetm
        call DialogBoxParamA, h_inst, IDD_DIALOG4, __hwnd, offset DlgProc4, 0
        xor eax, eax
        ret
nogetm:
        cmp _wparam, IDM_EMAILO
         jne nemo
        call DialogBoxParamA, h_inst, IDD_DIALOG3, __hwnd, offset DlgProc2, 0
        xor eax, eax
        ret
nemo:
        xor eax, eax
        ret

;---------------------------------------;
_initdlg:
        call WSAStartup, 0101h, offset wsadata
        or eax, eax
         jz gofine
        call MessageBox, 0, offset error_00, offset header_00, 0
        jmp _wmdestroy
gofine:

        push tblen                      ; Struct size
        push 42                         ; Bitmap height
        push 53                         ; Bitmap width
        push 42                         ; Button height
        push 53                         ; Button width
        push 4                          ; # buttons
        push offset tb                  ; -> buttons
        push IDB_TOOLBAR
        push h_inst
        push 4                          ; # bitmaps
        push ID_TOOLBAR
        push WS_CHILD + WS_VISIBLE + WS_BORDER + TBSTYLE_FLAT
        push __hwnd
        call CreateToolbarEx

        call CreateStatusWindow, WS_CHILD + WS_VISIBLE + SBS_SIZEGRIP, NULL, __hwnd, 200
        mov hstatus, eax

        call GetWindowRect, __hwnd, offset DlgRect
        call GetDesktopWindow
        call GetWindowRect, eax, offset DesktopRect

        mov eax, DlgRect.rc_bottom
        sub eax, DlgRect.rc_top
        mov DlgHeight, eax              ; Dialog box height
        mov eax, DlgRect.rc_right
        sub eax, DlgRect.rc_left
        mov DlgWidth, eax               ; Dialog box width
        mov ebx, DesktopRect.rc_bottom
        sub ebx, DlgHeight
        shr ebx, 1                      ; ebx = Start y
        mov ecx, DesktopRect.rc_right
        sub ecx, DlgWidth
        shr ecx, 1                      ; ecx = Start x
        call MoveWindow, __hwnd, ecx, ebx, DlgWidth, DlgHeight, 0   ; Centre
        jmp _wmsize                     ; Init other parts
;---------------------------------------;
_paint: call BeginPaint, __hwnd, offset _pnt
        call EndPaint, __hwnd, offset _pnt
        ret
DlgProc endp

;============================================================================;

jprintf proc p1:dword, p2:dword, p3:dword
        push p3
        push p2
        push p1
        call _wsprintf
        add esp, 12
        ret
jprintf endp

        include getmail.inc
        include optionem.inc

ends
        end main
