;                                 +------------------------------------+
;+--------------------------------|                                    |----+;
;+- Get E-Mail Include File ------| Last update: 07/04/1999            |----+;
;+- ======================= ------| Author:      Jimmy Moore           |----+;
;+-                         ------| E-Mail:      jimmy@bigwig.net      |----+;
;+-                         ------|                                    |----+;
;+-                         ------|                                    |----+;
;+--------------------------------|                                    |----+;
;                                 +------------------------------------+

;+--------------------------------------------------------------------------+;
;+- XXXX --- X -- XXXXX -- X -----------------------------------------------+;
;+- X - X - X X --- X --- X X ----------------------------------------------+;
;+- X - X  X - X -- X -- X - X ---------------------------------------------+;
;+- X - X  XXXXX -- X -- XXXXX ---------------------------------------------+;
;+- XXXX - X - X -- X -- X - X ---------------------------------------------+;
;+--------------------------------------------------------------------------+;
.data

POP3S struc                                             ; Server STRUCTURE
        Server_name     db 64 dup(0)    ; Server name / IP
        User_name       db 64 dup(0)    ; User name
        Password        db 64 dup(0)    ; Password
        Email_Address   db 128 dup(0)   ; E-Mail address
        InboxPath       db 128 dup(0)   ; Path to put new messages
        Flags           dd 0            ;
        Stage           dd 0            ; Stage of getting mail
        SocketH         dd 0            ;
        Recv_buff       db 512 dup(0)   ;
        ConnectData     db 16 dup(0)    ;
        Messages        dd 0            ; Number of messages on server
        CMessage        dd 0            ; Current message downloading
        CurrentFH       dd 0            ; File handle used to save messages
POP3S ends

POP3_active     dd 0
POP3_servers    dd 0
POP3_s:
 ; If you want to add a default server,
 ; put it here and change POP3_servers
 ; POP3S <'servername','username','password','emailaddress','folder',0,0,0,?,?,?,?>
  POP3S 10 dup(<>)

EMM_0000        equ 28000       ; Resolved Host Name Messages
EMM_0019        equ 28019       ; /
EMM_1000        equ 28100       ; Connected Messages
EMM_1019        equ 28119       ; /
EMM_2000        equ 28200       ; Ready To Read Messages
EMM_2019        equ 28219       ; /

CommandString   db 128 dup(0)
outmsg_00       db 'USER %s', 0dh, 0ah, 0
outmsg_01       db 'PASS %s', 0dh, 0ah, 0
outmsg_02       db 'STAT', 0dh, 0ah, 0
outmsg_03       db 'RETR %u', 0dh, 0ah, 0

header_00       db 'Q:E-Mail v1.00', 0

error_00        db 'Cannot start WinSock.', 0

mainhwnd        dd 0

inboxname       db '%s\'
mailname        db 'EMAILMSG.'
mailno          db '000', 0

stat_0          db 'Resolving hostname...', 0
 stat_00        db 'Could not resolve hostname.', 0
 stat_01        db 'Could not create a socket.', 0
stat_1          db 'Connecting...', 0
 stat_10        db 'Could not connect to host.', 0
stat_2          db 'Waiting for server status data...', 0
stat_3          db 'Logging into server...', 0
 stat_30        db 'Server error. Please try again later.', 0
 stat_31        db 'A network error occurred when loggin in.', 0
stat_4          db 'Providing Password...', 0
 stat_40        db 'User is not known on this server.', 0
 stat_41        db 'A network error occurred when providing password.', 0
stat_5          db 'Checking Mail...', 0
 stat_50        db 'Password incorrect.', 0
 stat_51        db 'A network error occurred when checking mail.', 0
stat_6          db 'Recieving message %u of %u...', 0
 stat_60        db 'Server error after STAT command', 0
 stat_61        db 'A network error occurred after checking mail.', 0
 stat_62        db 'No new messages on server.', 0
 stat_71        db 'A network error occurred whilst recieving mail.', 0
 stat_72        db 'File error whilst downloading message.', 0
stat_new        db 'You have mail!', 0

;+--------------------------------------------------------------------------+;
;+-- XXX -- XXX - XXXX - XXXXX ---------------------------------------------+;
;+- X - X  X - X  X - X  X -------------------------------------------------+;
;+- X ---- X - X  X - X  XXX -----------------------------------------------+;
;+- X - X  X - X  X - X  X -------------------------------------------------+;
;+-- XXX -- XXX - XXXX - XXXXX ---------------------------------------------+;
;+--------------------------------------------------------------------------+;
.code

        PUBLIC DlgProc4

DlgProc4 proc STDCALL, __hwnd:DWORD, wmsg:DWORD, _wparam:DWORD, _lparam:DWORD
        USES ebx, edi, esi
        mov eax, __hwnd
        mov mainhwnd, eax
        mov eax, wmsg

        cmp ax, WM_DESTROY
         je _wmdestroy4
        cmp ax, WM_CLOSE
         je _wmdestroy4
        cmp ax, WM_INITDIALOG
         je _wminit4
        cmp ax, WM_COMMAND
         je _wmcommand4
        cmp ax, EMM_0000
         jb notH1
        cmp ax, EMM_0019
         ja notH1
        call s1_getmail
        add POP3_active, eax    ; -1 for an error
         jnz nofini
enok:   call GetDlgItem, __hwnd, ID_4OK
        call EnableWindow, eax, TRUE            ; Enable OK button
nofini: xor eax, eax
        ret
notH1:  cmp ax, EMM_1000
         jb notH2
        cmp ax, EMM_1019
         ja notH2
        call s2_getmail
        add POP3_active, eax    ; -1 for an error
         jz enok
        xor eax, eax
        ret
notH2:  cmp ax, EMM_2000
         jb notH3
        cmp ax, EMM_2019
         ja notH3
        push eax
        call s3_getmail
        pop ebx        
        cmp eax, -1
         jne nofin
        push eax
        mov eax, ebx
        sub eax, EMM_2000
        mov esi, eax
        imul esi, SIZE POP3S
        cmp POP3_s[esi].SocketH, 0
         je notall1
        call closesocket, POP3_s[esi].SocketH
notall1:pop eax
nofin:
        add POP3_active, eax    ; -1 for an error
         jz enok
        xor eax, eax
        ret
notH3:  xor eax, eax
        ret
;----------------------------------------------------------------------------;
_wmcommand4:
        cmp _wparam, ID_4OK
         je _wmdestroy4
        xor eax, eax
        ret
;----------------------------------------------------------------------------;
_wmdestroy4:
        call EndDialog, __hwnd, 0
        xor eax, eax
        ret
;----------------------------------------------------------------------------;
_wminit4:
        call GetDlgItem, __hwnd, ID_4OK
        call EnableWindow, eax, FALSE           ; Disable OK button

        mov POP3_active, 0
        cmp POP3_servers, 0
         jne gogo1
        xor eax, eax                    ; No servers
        ret
gogo1:  xor ecx, ecx
        xor esi, esi
loophn: push ecx
         push esi
        mov eax, ecx
        add eax, EMM_0000
        lea ebx, POP3_s[esi].Server_name
        lea edx, POP3_s[esi].Recv_buff
        mov POP3_s[esi].SocketH, 0
        inc POP3_active
        push eax
        call WSAAsyncGetHostByName, __hwnd, eax, ebx, edx, 512
        pop eax
        add eax, ID_SERVERSTAT - EMM_0000
        call SetDlgItemText, __hwnd, eax, offset stat_0
         pop esi
        pop ecx
        add esi, SIZE POP3S
        inc ecx
        cmp ecx, POP3_servers
         jb loophn
        xor eax, eax
        ret
DlgProc4 endp
;============================================================================;
s1_getmail proc
        cmp word ptr [_lparam + 2], 0           ; Was there an error?
         je noerr1
        add eax, ID_SERVERSTAT - EMM_0000
        call SetDlgItemText, __hwnd, eax, offset stat_00
        mov eax, -1
        ret
noerr1: sub eax, EMM_0000
        mov edx, eax
        imul eax, SIZE POP3S
        mov esi, eax
        mov eax, dword ptr POP3_s[esi].Recv_buff[12]
        mov eax, dword ptr [eax]
        mov eax, dword ptr [eax]
        mov word ptr POP3_s[esi].Connectdata, AF_INET
        mov word ptr POP3_s[esi].Connectdata[2], 6e00h
        mov dword ptr POP3_s[esi].Connectdata[4], eax
        mov dword ptr POP3_s[esi].Connectdata[8], 0
        mov dword ptr POP3_s[esi].Connectdata[12], 0
        push edx
         push esi
        call socket, AF_INET, Sock_stream, 0    ; Create a socket
         pop esi
        pop edx
        cmp eax, -1
         je errid
        mov dword ptr POP3_s[esi].SocketH, eax

        add edx, EMM_1000
        push esi
         push edx
        call WSAAsyncSelect, eax, __hwnd, edx, FD_CONNECT
         pop edx
        pop esi
        lea ebx, POP3_s[esi].Connectdata

        add edx, ID_SERVERSTAT - EMM_1000
        call SetDlgItemText, __hwnd, edx, offset stat_1

        call connect, dword ptr POP3_s[esi].SocketH, ebx, 16
        xor eax, eax
        ret
errid:  add edx, ID_SERVERSTAT
        call SetDlgItemText, __hwnd, edx, offset stat_01
        mov eax, -1
        ret
s1_getmail endp
;============================================================================;
s2_getmail proc
        cmp word ptr [_lparam + 2], 0           ; Was there an error?
         je noerr2
        sub eax, EMM_1000
        push eax
        imul eax, SIZE POP3S
        call closesocket, POP3_s[eax].SocketH
        pop eax
        add eax, ID_SERVERSTAT
        call SetDlgItemText, __hwnd, edx, offset stat_10
        mov eax, -1
        ret
noerr2: sub eax, EMM_1000
        mov edx, eax
        imul eax, SIZE POP3S
        mov ecx, edx
        add ecx, ID_SERVERSTAT
        push eax
         push edx
        call SetDlgItemText, __hwnd, ecx, offset stat_2
         pop edx
        pop eax
        mov POP3_s[eax].Stage, offset stage_00  ; Stage of transfer
        add edx, EMM_2000
        call WSAAsyncSelect, POP3_s[eax].SocketH, __hwnd, edx, FD_READ
        xor eax, eax
        ret
s2_getmail endp
;============================================================================;
s3_getmail proc
        sub eax, EMM_2000
        mov esi, eax
        imul esi, SIZE POP3S
        push esi
        call POP3_s[esi].Stage                  ; Call the stage
        pop esi
        or eax, eax
         jz okfine
        mov POP3_s[esi].Stage, offset stage_09
        mov eax, -1
okfine: ret
s3_getmail endp

;============================================================================;
;|| Stage 00    AUTHORIZATION STARTS                                       ||;
;||             Check recieved server state                                ||;
;||             Send USER xxx command                                      ||;
;============================================================================;
stage_00 proc
        LOCAL LServerPT0:DWORD, LServerID0:DWORD
        mov LServerPT0, esi
        add eax, ID_SERVERSTAT
        mov LServerID0, eax

        lea ebx, POP3_s[esi].Recv_buff
        call recv, POP3_s[esi].SocketH, ebx, 512, NULL
        cmp eax, 0
         jle shoWSE0
        mov esi, LServerPT0
        lea ebx, POP3_s[esi].Recv_buff
        cmp byte ptr [ebx], '+'
         jne ServeE0
        mov POP3_s[esi].Stage, offset stage_01

        push esi
        call SetDlgItemText, mainhwnd, LServerID0, offset stat_3
        pop esi

        lea ebx, POP3_s[esi].User_name
        push ebx
        push offset outmsg_00
        push offset CommandString
        call _wsprintfA
        add esp, 12
        call lstrlen, offset CommandString
        call send, POP3_s[esi].SocketH, offset CommandString, eax, NULL
        cmp eax, -1
         je shoWSE0
        xor eax, eax
        ret
ServeE0:call SetDlgItemText, mainhwnd, LServerID0, offset stat_30
        mov eax, -1
        ret        
shoWSE0:call SetDlgItemText, mainhwnd, LServerID0, offset stat_31
        mov eax, -1
        ret
stage_00 endp

;============================================================================;
;|| Stage 01    AUTHORIZATION 02                                           ||;
;||             Check recieved user state                                  ||;
;||             Send PASS xxx command                                      ||;
;============================================================================;
stage_01 proc
        LOCAL LServerPT1:DWORD, LServerID1:DWORD
        mov LServerPT1, esi
        add eax, ID_SERVERSTAT
        mov LServerID1, eax

        lea ebx, POP3_s[esi].Recv_buff
        call recv, POP3_s[esi].SocketH, ebx, 512, NULL
        cmp eax, 0
         jle shoWSE1
        mov esi, LServerPT1
        lea ebx, POP3_s[esi].Recv_buff
        cmp byte ptr [ebx], '+'
         jne ServeE1
        mov POP3_s[esi].Stage, offset stage_02

        push esi
        call SetDlgItemText, mainhwnd, LServerID1, offset stat_4
        pop esi

        lea ebx, POP3_s[esi].Password
        push ebx
        push offset outmsg_01
        push offset CommandString
        call _wsprintfA
        add esp, 12
        call lstrlen, offset CommandString
        call send, POP3_s[esi].SocketH, offset CommandString, eax, NULL
        cmp eax, -1
         je shoWSE1
        xor eax, eax
        ret
ServeE1:call SetDlgItemText, mainhwnd, LServerID1, offset stat_40
        mov eax, -1
        ret        
shoWSE1:call SetDlgItemText, mainhwnd, LServerID1, offset stat_41
        mov eax, -1
        ret
stage_01 endp

;============================================================================;
;|| Stage 02    AUTHORIZATION 03                                           ||;
;||             Check recieved pass state                                  ||;
;||             Send STAT command                                          ||;
;============================================================================;
stage_02 proc
        LOCAL LServerPT2:DWORD, LServerID2:DWORD
        mov LServerPT2, esi
        add eax, ID_SERVERSTAT
        mov LServerID2, eax

        lea ebx, POP3_s[esi].Recv_buff
        call recv, POP3_s[esi].SocketH, ebx, 512, NULL
        cmp eax, 0
         jle shoWSE2
        mov esi, LServerPT2
        lea ebx, POP3_s[esi].Recv_buff
        cmp byte ptr [ebx], '+'
         jne ServeE2
        mov POP3_s[esi].Stage, offset stage_03

        push esi
         call SetDlgItemText, mainhwnd, LServerID2, offset stat_5
        pop esi

        call lstrlen, offset outmsg_02
        call send, POP3_s[esi].SocketH, offset outmsg_02, eax, NULL
        cmp eax, -1
         je shoWSE2
        xor eax, eax
        ret
ServeE2:call SetDlgItemText, mainhwnd, LServerID2, offset stat_50
        mov eax, -1
        ret        
shoWSE2:call SetDlgItemText, mainhwnd, LServerID2, offset stat_51
        mov eax, -1
        ret
stage_02 endp

;============================================================================;
;|| Stage 03    TRANSFER 00                                                ||;
;||             Check recieved STAT state                                  ||;
;||             Send RECV command if mail there                            ||;
;============================================================================;
stage_03 proc
        LOCAL LServerPT3:DWORD, LServerID3:DWORD
        mov LServerPT3, esi
        add eax, ID_SERVERSTAT
        mov LServerID3, eax

        lea ebx, POP3_s[esi].Recv_buff
        call recv, POP3_s[esi].SocketH, ebx, 512, NULL
        cmp eax, 0
         jle shoWSE3
        mov esi, LServerPT2
        mov byte ptr POP3_s[esi].Recv_buff[eax], 0      ; Asciiz the string
        lea ebx, POP3_s[esi].Recv_buff
        cmp byte ptr [ebx], '+'
         jne ServeE3
        mov POP3_s[esi].Stage, offset stage_04

        lea ebx, POP3_s[esi].Recv_buff[3]
        call readnumebx                                 ; Get # of messages
        or eax, eax
         jz nomsgs

        mov POP3_s[esi].Messages, eax
        mov POP3_s[esi].CMessage, 1

        mov POP3_s[esi].CurrentFH, 0                    ; FileHandle not set

        push esi
         push POP3_s[esi].Messages
         push POP3_s[esi].CMessage
         push offset stat_6
         push offset CommandString
         call _wsprintfA
         add esp, 16
         call SetDlgItemText, mainhwnd, LServerID3, offset CommandString
        pop esi

        push esi
         push POP3_s[esi].CMessage
         push offset outmsg_03
         push offset CommandString
         call _wsprintfA
         add esp, 12
        pop esi

        call lstrlen, offset CommandString
        call Send, POP3_s[esi].SocketH, offset CommandString, eax, NULL
        cmp eax, -1
         je shoWSE3
        xor eax, eax
        ret
nomsgs: lea ebx, POP3_s[esi].Server_Name
        push esi
        call SetDlgItemText, mainhwnd, LServerID3, offset stat_62
        pop esi        
        mov eax, -1
        ret
ServeE3:call SetDlgItemText, mainhwnd, LServerID3, offset stat_60
        mov eax, -1
        ret        
shoWSE3:call SetDlgItemText, mainhwnd, LServerID3, offset stat_61
        mov eax, -1
        ret
stage_03 endp

;============================================================================;
;|| Stage 04    TRANSFER 01                                                ||;
;||             Download Mail                                              ||;
;||             Close connection                                           ||;
;============================================================================;
stage_04 proc
        LOCAL LServerPT4:DWORD, LServerID4:DWORD
        mov LServerPT4, esi
        add eax, ID_SERVERSTAT
        mov LServerID4, eax

        cmp POP3_s[esi].CurrentFH, 0
         jne alreFH
        mov dword ptr [offset mailno], 00303030h
lffree:
        mov esi, LServerPT4

        lea ebx, POP3_s[esi].InboxPath
        push ebx
        push offset inboxname
        push offset CommandString
        call _wsprintfA
        add esp, 12

        call OpenFile, offset CommandString, offset openbuff, OF_EXIST
        cmp eax, -1
         je ffreef
        inc byte ptr [offset mailno + 2]
        cmp byte ptr [offset mailno + 2], '9'
         jbe lffree
        mov byte ptr [offset mailno + 2], '0'
        inc byte ptr [offset mailno + 1]
        cmp byte ptr [offset mailno + 1], '9'
         jbe lffree
        mov byte ptr [offset mailno + 1], '0'
        inc byte ptr [offset mailno + 0]
        cmp byte ptr [offset mailno + 0], '9'
         jbe lffree
        jmp FileE4                              ; Too many messages in folder.
ffreef:

        call OpenFile, offset CommandString, offset openbuff, OF_CREATE
        cmp eax, -1
         je FileE4
        mov esi, LServerPT4
        mov POP3_s[esi].CurrentFH, eax          ; Save Handle...
alreFH:

        lea ebx, POP3_s[esi].Recv_buff
        call recv, POP3_s[esi].SocketH, ebx, 512, NULL
        cmp eax, 0
         jle shoWSE3
        mov esi, LServerPT4
        mov byte ptr POP3_s[esi].Recv_buff[eax], 0      ; Asciiz the string

        push eax
        lea ebx, POP3_s[esi].Recv_buff
        call WriteFile, POP3_s[esi].CurrentFH, ebx, eax, offset writelen, NULL
        pop ecx
        cmp eax, TRUE
         jne FileE4

        mov esi, LServerPT4
        cmp dword ptr POP3_s[esi].Recv_buff[ecx - 5], 0d2e0a0dh
         jne nend1
        cmp byte ptr POP3_s[esi].Recv_buff[ecx - 1], 0ah
         jne nend1
        call CloseHandle, POP3_s[esi].CurrentFH

        mov esi, LServerPT4
        inc POP3_s[esi].CMessage
        mov eax, POP3_s[esi].Messages
        cmp POP3_s[esi].CMessage, eax
         ja finiad

        mov POP3_s[esi].CurrentFH, 0                    ; FileHandle not set

        push esi
         push POP3_s[esi].Messages
         push POP3_s[esi].CMessage
         push offset stat_6
         push offset CommandString
         call _wsprintfA
         add esp, 16
         call SetDlgItemText, mainhwnd, LServerID4, offset CommandString
        pop esi

        push esi
         push POP3_s[esi].CMessage
         push offset outmsg_03
         push offset CommandString
         call _wsprintfA
         add esp, 12
        pop esi

        call lstrlen, offset CommandString
        call Send, POP3_s[esi].SocketH, offset CommandString, eax, NULL
        cmp eax, -1
         je shoWSE4
        xor eax, eax
        ret
finiad: lea ebx, POP3_s[esi].Server_Name
        call SetDlgItemText, mainhwnd, LServerID4, offset stat_new
        mov eax, -1
        ret
nend1:  xor eax, eax
        ret

FileE4: mov esi, LServerPT4
        cmp POP3_s[esi].CurrentFH, 0
         je nonde1
        call CloseHandle, POP3_s[esi].CurrentFH
nonde1: call SetDlgItemText, mainhwnd, LServerID4, offset stat_72
        mov eax, -1
        ret
shoWSE4:mov esi, LServerPT4
        cmp POP3_s[esi].CurrentFH, 0
         je nonde3
        call CloseHandle, POP3_s[esi].CurrentFH
nonde3: call SetDlgItemText, mainhwnd, LServerID4, offset stat_71
        mov eax, -1
        ret
stage_04 endp
;============================================================================;
stage_09 proc
        lea ebx, POP3_s[esi].Recv_buff
        call recv, POP3_s[esi].SocketH, ebx, 512, NULL
        xor eax, eax
        ret
stage_09 endp
;============================================================================;
;| Converts the ascii number at [ebx] into eax.
;| can be prefixed by spaces, halts at first non-digit character.
;============================================================================;
readnumebx proc
lfn1:   mov al, byte ptr [ebx]
        cmp al, '0'
         jb nnum1
        cmp al, '9'
         ja nnum1
        jmp foundi
nnum1:  cmp al, ' '
         jne erris
        inc ebx
        jmp lfn1
foundi: xor eax, eax
        xor ecx, ecx
lmn1:   mov cl, byte ptr [ebx]
        inc ebx
        cmp cl, '0'
         jb nnum2
        cmp cl, '9'
         ja nnum2
        sub cl, '0'
        imul eax, 10
        add eax, ecx
        jmp lmn1
nnum2:  ret
erris:  xor eax, eax
        ret
readnumebx endp
;============================================================================;
