/*
    (C) 2001 Anders Holmberg

    This file is part of PocketClive.

    PocketClive is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    PocketClive is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with PocketClive; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Author contact information : aagholmberg@yahoo.se

    PocketClive uses code and inspiration from the following sources 
    (see AUTHORS.TXT for more details) :

    FUSE - The Free Unix Spectrum Emulator - (C) 1999-2001 Philip Kendall
		
    EasyCE - PocketPC game programming library - (C) 2001 Jacco Bikker

    MESS - Multi-Emulator Super System - (C) 1998-2001 MESS Team

    Note : Source code files present in the sub directory PocketClive\EasyCE
           does not comply with the GPL license. These files are (C) Jacco Bikker
           with the following attachment : 

           "If you want to use EasyCE for commercial applications
            you should let me know. I will ask you a small fee,
            since I spend a lot of time developing this software.
            For freeware products, EasyCE can be used freely."
*/


#include "pocket_clive.h"
#include "spectrum_48k.h"
#include "FUSE\keyboard.h"
#include "FUSE\Z80\z80.h"

unsigned int left_flank_tstates = 0;
unsigned int speaker_activated = 0;

BYTE spectrum_48k_read_port(WORD port)
{
	if( ( port & 0x0001 ) == 0 )
		return keyboard_read( port >> 8 );
	else if( ( port & 0x00e0 ) == 0 )
		return joystick;
  else
		return 0x01;
}

void spectrum_48k_write_port(WORD port, BYTE b)
{
  if( ( port & 0x0001 ) == 0 )
	{
		/* --- Speaker ---
		 *
		 * The speaker is actived by a "0" in bit 4 of port 0xf3. 
		 *
		 * The purpose of the following lines of code is to establish
		 * how many tstates there are between two activations of the
		 * speaker (i.e. the frequency of the sound). 
		 *
		 */
		if( !( b & 0x10 ) && !( speaker_activated ) )
		{
			if( !sound_interval )
				left_flank_tstates = 0;

			sound_interval     = tstates - left_flank_tstates;
			left_flank_tstates = tstates;

			speaker_activated = 1;
		}
		else if( ( b & 0x10 ) && ( speaker_activated ) )
		{
			speaker_activated = 0;
		}
	}
}

BYTE spectrum_48k_read_memory(WORD address)
{
	WORD bank;
	WORD offset;

	if( address < 0x4000 )
		return rom[0][address];

	bank    = address / 0x4000;
	offset  = address - (bank * 0x4000);

	switch( bank )
	{
		case 1 : bank = 5; break;
		case 2 : bank = 2; break;
		case 3 : bank = 0; break;
	}
	return ram[ bank ][ offset ];
}

void spectrum_48k_write_memory(WORD address, BYTE b)
{
	WORD bank;
	WORD offset;

	if( address >= 0x4000 )
	{
		bank   = address / 0x4000;
  	offset = address - (bank * 0x4000);
		switch( bank )
		{
			case 1 : bank = 5; break;
			case 2 : bank = 2; break;
			case 3 : bank = 0; break;
		}
		ram[ bank ][ offset ] = b;
	}
}