/*
    (C) 2001 Anders Holmberg

    This file is part of PocketClive.

    PocketClive is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    PocketClive is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with PocketClive; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Author contact information : aagholmberg@yahoo.se

    PocketClive uses code and inspiration from the following sources 
    (see AUTHORS.TXT for more details) :

    FUSE - The Free Unix Spectrum Emulator - (C) 1999-2001 Philip Kendall
		
    EasyCE - PocketPC game programming library - (C) 2001 Jacco Bikker

    MESS - Multi-Emulator Super System - (C) 1998-2001 MESS Team

    Note : Source code files present in the sub directory PocketClive\EasyCE
           does not comply with the GPL license. These files are (C) Jacco Bikker
           with the following attachment : 

           "If you want to use EasyCE for commercial applications
            you should let me know. I will ask you a small fee,
            since I spend a lot of time developing this software.
            For freeware products, EasyCE can be used freely."
*/


#ifndef POCKET_EMULATOR_TYPES_H
#define POCKET_EMULATOR_TYPES_H

#define CLICK_TYPE 1
#define PENDOWN_TYPE 2

typedef signed char     SBYTE;
typedef unsigned char   BYTE;
typedef signed short    SWORD;
typedef unsigned short  WORD;
typedef signed long      SDWORD;
typedef unsigned long    DWORD;
typedef unsigned int UINT;
typedef signed int SINT;

typedef BYTE (*read_memory_t)( WORD address );
typedef void (*write_memory_t)( WORD address, BYTE value );
typedef BYTE (*read_port_t)( WORD port );
typedef void (*write_port_t)( WORD port, BYTE value );

typedef void (*area_clicked_t)( int xpos, int ypos, int xchar, int ychar );


#endif	