/*
    (C) 2001 Anders Holmberg

    This file is part of PocketClive.

    PocketClive is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    PocketClive is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with PocketClive; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Author contact information : aagholmberg@yahoo.se

    PocketClive uses code and inspiration from the following sources 
    (see AUTHORS.TXT for more details) :

    FUSE - The Free Unix Spectrum Emulator - (C) 1999-2001 Philip Kendall
		
    EasyCE - PocketPC game programming library - (C) 2001 Jacco Bikker

    MESS - Multi-Emulator Super System - (C) 1998-2001 MESS Team

    Note : Source code files present in the sub directory PocketClive\EasyCE
           does not comply with the GPL license. These files are (C) Jacco Bikker
           with the following attachment : 

           "If you want to use EasyCE for commercial applications
            you should let me know. I will ask you a small fee,
            since I spend a lot of time developing this software.
            For freeware products, EasyCE can be used freely."
*/

#include "EasyCE\EasyCE.h"
#include "pocket_clive.h"
#include "pocket_clive_display.h"

#undef  WHITE
#define WHITE 0xffff
#define LBLACK 0
#define LRED   ( 0x1f << 11 )
#define LBLUE  ( 0x1f )
#define LGREEN ( 0x3f << 5 )

#ifdef _X86_

#define BLACK 0
#define RED   ( 0x1f << 11 )
#define BLUE  ( 0x1f )
#define GREEN ( 0x3f << 5 )

#else

#define BLACK 0
#define RED   ( 0x1b << 11 )
#define BLUE  ( 0x1b )
#define GREEN ( 0x37 << 5 )

#endif

#define GREY_20 0xce59

int color[ 16 ] = {
	BLACK, 
	BLUE, 
	RED, 
	BLUE + RED,
	GREEN, 
	BLUE + GREEN, 
	RED + GREEN, 
	BLUE + RED + GREEN, 
	LBLACK, 
	LBLUE, 
	LRED, 
	LBLUE + LRED,
	LGREEN, 
	LBLUE + LGREEN, 
	LRED + LGREEN, 
	LBLUE + LRED + LGREEN 
};

DWORD dirty_rec[ 24 ][ 32 ];

void all_is_dirty( void )
{
	WORD col, row;

	for( row=0; row<24; row++ )
		for( col=0; col<32; col++ )
			dirty_rec[ row ][ col ] = 1;
}

void flash_is_dirty( void )
{
	WORD col, row;
	BYTE attribute_byte;

	for( row=0; row<24; row++ )
	{
		for( col=0; col<32; col++ )
		{
			attribute_byte = ram[ machine.screen_page ][ ( col | ( row << 5 ) ) | 0x1800 ];
			
			if( attribute_byte >> 8 )
				dirty_rec[ row ][ col ];
		}
	}
}

/* --- show_spectrum_display ---
 *
 * Write the Spectrum screen to the EasyCE screen buffer
 *
 * ---
 */
void show_spectrum_display( void )
{
	WORD pixel, pixel_row, pixel_byte, row, col;
	WORD f_color, b_color, temp_color;
	WORD base_pixel_address;
	WORD left_xpos = 0;
	WORD nr_pixels = 8;
	BYTE attribute_byte;

  for( row=0; row<24; row++ )
	{
		left_xpos = 0;
		nr_pixels = 8;

		for( col=0; col<32; col++ )
		{
			if( dirty_rec[ row ][ col ] )
			{
				base_pixel_address = ( col & 0x001f ) | ( ( row & 0x0007 ) << 5 ) | ( ( row & 0x0018 ) << 8 );
				attribute_byte     = ram[ machine.screen_page ][ ( col | ( row << 5 ) ) | 0x1800 ];

				f_color = color[ ( attribute_byte & 0x07 ) + ( ( attribute_byte & 0x40 ) >> 3 ) ]; 
				b_color = color[ ( ( attribute_byte >> 3 ) & 0x07 ) + ( ( attribute_byte & 0x40 ) >> 3 ) ]; 

				if( ( attribute_byte >> 7 ) && ( flash ) )
				{
					temp_color = f_color;
					f_color    = b_color;
					b_color		 = temp_color;
				}

				for( pixel_row=0; pixel_row<8; pixel_row++ )
				{
					pixel_byte = ram[ machine.screen_page ][ ( base_pixel_address | ( pixel_row << 8 ) ) ];				
					
					for( pixel=0; pixel<nr_pixels; pixel++ )
					{
						if( pixel_byte & ( 0x01 << ( 7 - pixel ) ) )
							plot( left_xpos + pixel, row * 8 + pixel_row, f_color );
						else
							plot( left_xpos + pixel, row * 8 + pixel_row, b_color );
					}
				}

				dirty_rec[ row ][ col ] = 0;
			}

			if( col & 0x0001 )
			{
				left_xpos += 7;
				nr_pixels = 8;
			}
			else
			{
				left_xpos += 8;
				nr_pixels = 7;
			}		
		}
	}
}

/* --- show_spectrum_display_landscape_right ---
 *
 * Write the Spectrum screen to the EasyCE screen buffer
 *
 * 16 pixels from top (i.e. 16 pixels border "left" and "right")
 * 24 pixels from left (i.e. 24 pixels border "over" and "under")
 * 
 * ---
 */
void show_spectrum_display_landscape_right( void )
{
	WORD pixel, pixel_row, pixel_byte, row, col;
	WORD f_color, b_color, temp_color;
	WORD base_pixel_address;
	WORD left_xpos = 0;
	WORD nr_pixels = 8;
	BYTE attribute_byte;

  for( row=0; row<24; row++ )
	{
		left_xpos = 0;
		nr_pixels = 8;

		for( col=0; col<32; col++ )
		{
			if( dirty_rec[ row ][ col ] )
			{
				base_pixel_address = ( col & 0x001f ) | ( ( row & 0x0007 ) << 5 ) | ( ( row & 0x0018 ) << 8 );
				attribute_byte     = ram[ machine.screen_page ][ ( col | ( row << 5 ) ) | 0x1800 ];

				f_color = color[ ( attribute_byte & 0x07 ) + ( ( attribute_byte & 0x40 ) >> 3 ) ]; 
				b_color = color[ ( ( attribute_byte >> 3 ) & 0x07 ) + ( ( attribute_byte & 0x40 ) >> 3 ) ]; 

				if( ( attribute_byte >> 7 ) && ( flash ) )
				{
					temp_color = f_color;
					f_color    = b_color;
					b_color		 = temp_color;
				}

				for( pixel_row=0; pixel_row<8; pixel_row++ )
				{
					pixel_byte = ram[ machine.screen_page ][ ( base_pixel_address | ( pixel_row << 8 ) ) ];				
					
					for( pixel=0; pixel<nr_pixels; pixel++ )
					{
						if( pixel_byte & ( 0x01 << ( 7 - pixel ) ) )
							plot( 215 - row * 8 - pixel_row, 16 + left_xpos + pixel, f_color );
						else
							plot( 215 - row * 8 - pixel_row, 16 + left_xpos + pixel, b_color );
					}
				}

				dirty_rec[ row ][ col ] = 0;
			}

			if( col & 0x0001 )
			{
				left_xpos += 7;
				nr_pixels = 8;
			}
			else
			{
				left_xpos += 8;
				nr_pixels = 7;
			}		
		}
	}
}
