/*
    (C) 2001 Anders Holmberg

    This file is part of PocketClive.

    PocketClive is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    PocketClive is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with PocketClive; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Author contact information : aagholmberg@yahoo.se

    PocketClive uses code and inspiration from the following sources 
    (see AUTHORS.TXT for more details) :

    FUSE - The Free Unix Spectrum Emulator - (C) 1999-2001 Philip Kendall
		
    EasyCE - PocketPC game programming library - (C) 2001 Jacco Bikker

    MESS - Multi-Emulator Super System - (C) 1998-2001 MESS Team

    Note : Source code files present in the sub directory PocketClive\EasyCE
           does not comply with the GPL license. These files are (C) Jacco Bikker
           with the following attachment : 

           "If you want to use EasyCE for commercial applications
            you should let me know. I will ask you a small fee,
            since I spend a lot of time developing this software.
            For freeware products, EasyCE can be used freely."
*/


#ifndef POCKET_EMULATOR_H 
#define POCKET_EMULATOR_H

#include "pocket_clive_types.h"

#define SPECTRUM_16K   0
#define SPECTRUM_48K   1
#define SPECTRUM_128K  2
#define SPECTRUM_PLUS2 3
#define SPECTRUM_PLUS3 4

#define JOYSTICK_NONE     0
#define JOYSTICK_KEMPSTON 1
#define JOYSTICK_SINCLAIR 2

typedef struct area_t 
{
	int            type;
	int            x1, y1, x2, y2;
	area_clicked_t area_clicked;
	int            clicktype;  /* Does this area react when pendown or clicked? */
	int						 x_offset, x_mult;
	int						 y_offset, y_mult;
} area_t;

typedef struct area_t *area_ptr;

struct machine_t
{
	int machine;

	int ram_page, rom_page;
	int screen_page;

	read_port_t    read_port;
	write_port_t   write_port;
	read_memory_t  read_memory;
	write_memory_t write_memory;
};



typedef area_ptr (*get_area_t)( int xpos, int ypos );

extern int flash_cntr; 
extern int flash;

extern BYTE rom[][0x4000];
extern BYTE ram[][0x4000];

extern machine_t machine;

extern unsigned int sound_freq, sound_interval;

extern BYTE readport(WORD port);
extern void writeport(WORD port, BYTE b);
extern BYTE readbyte(WORD address);
extern void writebyte(WORD address, BYTE b);
extern int tape_trap(void);
void setup_machine( int choice );
void show_error_dialog( char *error_text );
void show_dialog( char *title_text, char *text );

#endif